/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.Process;
import com.eg.apm.ProcessList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProcessList
implements ProcessList {
    HashMap<String, Process> processes = null;

    public JavaProcessList(HashMap<String, Process> hashMap) {
        this.processes = hashMap;
    }

    public HashMap<String, Process> getProcesses() {
        return this.processes;
    }

    @Override
    public Process getProcess(String string) {
        return this.processes.get(string);
    }

    @Override
    public boolean isAlreadyDiscovered(String string, String string2) {
        try {
            String string3;
            Process process;
            if (this.processes != null && (process = this.processes.get(string)) != null && (string3 = process.getExecutable()).equalsIgnoreCase(string2)) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} [JavaProcessList]Exception occurred ", (Throwable)exception);
        }
        return false;
    }

    public boolean isAlreadyDiscovered(String string, long l) {
        try {
            long l2;
            Process process;
            if (this.processes != null && (process = this.processes.get(string)) != null && (l2 = process.getUptime()) == l) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} [JavaProcessList] Exception occurred ", (Throwable)exception);
        }
        return false;
    }

    @Override
    public void addAll(Map map) {
        if (map != null && map.size() > 0 && this.processes != null) {
            this.processes.putAll(map);
        }
    }

    public boolean dataAvailable() {
        if (this.processes != null) {
            return this.processes.size() > 0;
        }
        return false;
    }

    public boolean isEmpty() {
        if (this.processes != null) {
            return this.processes.isEmpty();
        }
        return false;
    }

    public void clear() {
        if (this.processes != null) {
            this.processes.clear();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" JavaProcessList=");
        stringBuilder.append(this.processes);
        return stringBuilder.toString();
    }
}

