/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgSSL;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ContainerInfo;
import com.eg.apm.ContainersService;
import com.eg.apm.K8sServiceInfo;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.minidev.json.JSONArray;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class KubernetesAPI {
    private boolean isSsl = false;
    private String serviceToken = "";
    private String ip = "";
    private int kuberPortNo = 443;
    String isKuberSslBased = "";
    private static final String logPrefix = "[KubernetesAPI]";
    HashMap servicData = new HashMap();
    HashMap serviceNameWithDetails = new HashMap();
    private static boolean isContainerClusterMasterReachable = true;

    KubernetesAPI() {
    }

    public static KubernetesAPI createInstance() {
        ContainersService containersService = ContainersService.getInstance();
        return new KubernetesAPI(containersService.getIp(), containersService.getPort(), containersService.getServiceToken(), containersService.isSSL());
    }

    public KubernetesAPI(String string, int n, String string2, boolean bl) {
        this.ip = string;
        this.kuberPortNo = n;
        this.serviceToken = string2;
        this.isSsl = bl;
        this.init();
    }

    private void init() {
        if (this.isSsl) {
            this.isKuberSslBased = "https";
            this.installSSL();
        } else {
            this.isKuberSslBased = "http";
        }
    }

    public void installSSL() {
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var3_4 = null;
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing installSSL() : {}", (Object)logPrefix, (Object)exception);
        }
    }

    public String executeCommands(String string) {
        String string2;
        block14: {
            string2 = "";
            try {
                HttpResponse httpResponse = null;
                CloseableHttpClient closeableHttpClient = null;
                HttpGet httpGet = null;
                HttpHost httpHost = null;
                String string3 = this.ip;
                if (string3 == null || string3.trim().length() == 0) {
                    return string2;
                }
                try {
                    httpHost = new HttpHost(string3, this.kuberPortNo, this.isKuberSslBased);
                    HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
                    Object object = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                        public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) {
                            return true;
                        }
                    }).build();
                    httpClientBuilder.setSslcontext((SSLContext)object);
                    Object object2 = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                    Object object3 = new SSLConnectionSocketFactory((SSLContext)object, (X509HostnameVerifier)object2);
                    Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", object3).build();
                    PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
                    httpClientBuilder.setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
                    RequestConfig.Builder builder = RequestConfig.custom();
                    int n = 2000;
                    builder.setConnectTimeout(n);
                    builder.setConnectionRequestTimeout(n);
                    builder.setSocketTimeout(n);
                    httpClientBuilder.setDefaultRequestConfig(builder.build());
                    closeableHttpClient = httpClientBuilder.build();
                    httpGet = new HttpGet(string);
                    httpGet.setHeader("Authorization", "Bearer " + this.serviceToken);
                    httpResponse = closeableHttpClient.execute(httpHost, (HttpRequest)httpGet);
                    if (string != null && string.trim().length() > 0 && string.indexOf("namespaces") > -1) {
                        int n2 = httpResponse.getStatusLine().getStatusCode();
                    }
                    if ((httpClientBuilder = httpResponse.getEntity()) == null) break block14;
                    object = httpClientBuilder.getContent();
                    object2 = null;
                    try {
                        object2 = new BufferedReader(new InputStreamReader((InputStream)object));
                        object3 = "";
                        while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                            object3 = ((String)object3).trim();
                            string2 = string2 + "" + (String)object3;
                        }
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (RuntimeException runtimeException) {
                        httpGet.abort();
                        throw runtimeException;
                    }
                    finally {
                        ((BufferedReader)object2).close();
                        ((InputStream)object).close();
                        closeableHttpClient.getConnectionManager().shutdown();
                    }
                }
                catch (Exception exception) {
                    isContainerClusterMasterReachable = false;
                    APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing executeCommands() : {}", (Object)logPrefix, (Object)exception);
                }
            }
            catch (Exception exception) {
                String string4 = "You are not giving correct Ip address for Kubernetes. Please give correct Ip address..";
                APMDiscoveryLogger.discoveryLogger.warn("{} {} : ", new Object[]{logPrefix, string4, exception});
                isContainerClusterMasterReachable = false;
            }
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "";
        }
        string2 = string2.trim();
        return string2;
    }

    public boolean isKubeMasterReachable() {
        return isContainerClusterMasterReachable;
    }

    public ArrayList getJsonPathsValue(String string, String string2) {
        Configuration configuration = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
        ArrayList arrayList = null;
        if (string != null && string.length() > 4) {
            try {
                arrayList = (ArrayList)JsonPath.using((Configuration)configuration).parse(string).read(string2, new Predicate[0]);
            }
            catch (PathNotFoundException pathNotFoundException) {
                APMDiscoveryLogger.discoveryLogger.debug("{} No path found : {}", (Object)logPrefix, (Object)string2);
                return arrayList;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get JSON paths from JSON Data {}:{}", new Object[]{logPrefix, exception.getMessage(), exception.getCause()});
                return arrayList;
            }
        }
        return arrayList;
    }

    public Object getJsonValue(String string, String string2) {
        Object object = null;
        if (string != null && string.length() > 4) {
            try {
                object = JsonPath.read((String)string, (String)string2, (Predicate[])new Predicate[0]);
                object.toString();
            }
            catch (PathNotFoundException pathNotFoundException) {
                APMDiscoveryLogger.discoveryLogger.debug("{} No path found : {}", (Object)logPrefix, (Object)string2);
                return object;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get JSON paths[{}] from JSON Data {}:{}", new Object[]{logPrefix, string2, exception.getMessage(), exception.getCause()});
                return object;
            }
        }
        return object;
    }

    public String getServicename(String string, String string2) {
        String string3 = null;
        try {
            String string4 = "/api/v1/namespaces/" + string + "/services";
            String string5 = this.executeCommands(string4);
            APMDiscoveryLogger.discoveryLogger.trace("{}  serviceCmd : {}", (Object)logPrefix, (Object)string4);
            APMDiscoveryLogger.discoveryLogger.trace("{}  serviceCmdOutputs : {}", (Object)logPrefix, (Object)string5);
            ArrayList arrayList = this.getJsonPathsValue(string5, "$.items[*]");
            APMDiscoveryLogger.discoveryLogger.trace("{}  paths : {}", (Object)logPrefix, (Object)arrayList);
            HashMap hashMap = this.processServiceApiData(string, arrayList, string5);
            this.servicData.put(string, hashMap);
            APMDiscoveryLogger.discoveryLogger.trace("{}  tempserviceData : {}", (Object)logPrefix, (Object)hashMap);
            string3 = (String)hashMap.get(string2);
            APMDiscoveryLogger.discoveryLogger.trace("{}  labelKeyValue : {} , servicename : {}", new Object[]{logPrefix, string2, string3});
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getServicename() : {}", (Object)logPrefix, (Object)exception);
        }
        return string3;
    }

    public HashMap getCachedServiceCopy(String string) {
        return (HashMap)this.servicData.get(string);
    }

    public HashMap getCachedServiceInfoDetails(String string) {
        return (HashMap)this.serviceNameWithDetails.get(string);
    }

    private HashMap processServiceApiData(String string, ArrayList arrayList, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, K8sServiceInfo> hashMap2 = new HashMap<String, K8sServiceInfo>();
        if (arrayList != null && arrayList.size() > 0) {
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        Object object4;
                        Object object2;
                        Object object32;
                        String string3 = (String)arrayList.get(i);
                        String string4 = (String)this.getJsonValue(string2, string3 + "['metadata']['name']");
                        if (string4 == null || string4.length() <= 0) continue;
                        K8sServiceInfo k8sServiceInfo = new K8sServiceInfo(string4);
                        LinkedHashMap linkedHashMap = (LinkedHashMap)this.getJsonValue(string2, string3 + "['spec']['selector']");
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        if (linkedHashMap != null) {
                            for (Object object32 : linkedHashMap.keySet()) {
                                object2 = (String)linkedHashMap.get(object32);
                                hashMap.put((String)object32 + ":" + (String)object2, string4);
                                arrayList2.add((String)object32 + ":" + (String)object2);
                            }
                        }
                        k8sServiceInfo.setSelectorLabelList(arrayList2);
                        LinkedHashMap linkedHashMap2 = (LinkedHashMap)this.getJsonValue(string2, string3 + "['metadata']['labels']");
                        object32 = new ArrayList();
                        if (linkedHashMap2 != null) {
                            for (Object object4 : linkedHashMap2.keySet()) {
                                String string5 = (String)linkedHashMap2.get(object4);
                                ((ArrayList)object32).add((String)object4 + ":" + string5);
                            }
                        }
                        k8sServiceInfo.setLabelList((ArrayList)object32);
                        object2 = (JSONArray)this.getJsonValue(string2, string3 + "['spec']['ports']");
                        object4 = new ArrayList();
                        if (object2 != null) {
                            ((ArrayList)object4).addAll(object2);
                        }
                        k8sServiceInfo.setPorts((ArrayList)object4);
                        hashMap2.put(string4, k8sServiceInfo);
                        continue;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing processServiceApiData() : {}", (Object)logPrefix, (Object)exception);
                    }
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing processServiceApiData() : {}", (Object)logPrefix, (Object)exception);
            }
        }
        if (hashMap2.size() > 0) {
            this.serviceNameWithDetails.put(string, hashMap2);
        }
        return hashMap;
    }

    public ArrayList getLabelNameFromPod(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = "/api/v1/namespaces/" + string + "/pods/" + string2;
            String string4 = this.executeCommands(string3);
            Object object = this.getJsonValue(string4, "$.metadata.labels");
            APMDiscoveryLogger.discoveryLogger.trace("{}  podCommand : {}", (Object)logPrefix, (Object)string3);
            APMDiscoveryLogger.discoveryLogger.trace("{}  podCmdOutputs : {}", (Object)logPrefix, (Object)string4);
            APMDiscoveryLogger.discoveryLogger.trace("{}  value : {}", (Object)logPrefix, object);
            if (object != null && object instanceof LinkedHashMap) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)object;
                for (String string5 : linkedHashMap.keySet()) {
                    String string6 = (String)linkedHashMap.get(string5);
                    arrayList.add(string5 + ":" + string6);
                }
                APMDiscoveryLogger.discoveryLogger.trace("{}  Map : {}", (Object)logPrefix, linkedHashMap.keySet());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getLabelNameFromPod() : {}", (Object)logPrefix, (Object)exception);
        }
        return arrayList;
    }

    public HashMap getContainerInfoFromPod(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Object object;
            Object object2;
            String string3 = "/api/v1/namespaces/" + string + "/pods/" + string2;
            String string4 = this.executeCommands(string3);
            APMDiscoveryLogger.discoveryLogger.trace("{} podCommand : {}, podCmdOutputs : {}", new Object[]{logPrefix, string3, string4});
            ArrayList arrayList = this.getLabelList(string4);
            if (!arrayList.isEmpty()) {
                hashMap.put("labelsList", arrayList);
            }
            if ((object2 = this.getJsonValue(string4, "$.metadata.name")) != null) {
                hashMap.put("deploymentName", APMUtils.subStringLastTwoOccurrence(object2.toString(), "-"));
            }
            if ((object = this.getJsonValue(string4, "$.status.containerStatuses")) != null && object instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)object;
                hashMap.put("containersList", this.getAsContainerInfoObjMap(jSONArray));
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getLabelNameFromPod() : {}", (Object)logPrefix, (Object)exception);
        }
        return hashMap;
    }

    public String getPodIp(String string, String string2) {
        String string3 = "";
        try {
            String string4 = "/api/v1/namespaces/" + string + "/pods/" + string2;
            String string5 = this.executeCommands(string4);
            APMDiscoveryLogger.discoveryLogger.trace("{} getPodIp() podCommand : {}, podCmdOutputs : {}", new Object[]{logPrefix, string4, string5});
            Object object = this.getJsonValue(string5, "$['status']['podIP']");
            if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                APMDiscoveryLogger.discoveryLogger.trace("{} getPodIp() $['status']['podIP'] : {}", (Object)logPrefix, object);
            }
            if (object != null && object instanceof String) {
                string3 = object.toString();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getLabelNameFromPod() : {}", (Object)logPrefix, (Object)exception);
        }
        return string3;
    }

    public String getNodeIp(String string, String string2) {
        String string3 = "";
        try {
            String string4 = "/api/v1/namespaces/" + string + "/pods/" + string2;
            String string5 = this.executeCommands(string4);
            APMDiscoveryLogger.discoveryLogger.trace("{} podCommand : {}, podCmdOutputs : {}", new Object[]{logPrefix, string4, string5});
            Object object = this.getJsonValue(string5, "$['status']['hostIP']");
            if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                APMDiscoveryLogger.discoveryLogger.trace("{}  $['status']['hostIP'] : {} - {}", new Object[]{logPrefix, object.getClass(), object});
            }
            if (object != null && object instanceof String) {
                string3 = object.toString();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getNodeIp() : {}", (Object)logPrefix, (Object)exception);
        }
        return string3;
    }

    public String getNodeName(String string, String string2) {
        String string3 = "";
        try {
            String string4 = "/api/v1/namespaces/" + string + "/pods/" + string2;
            String string5 = this.executeCommands(string4);
            APMDiscoveryLogger.discoveryLogger.trace("{} podCommand : {}, podCmdOutputs : {}", new Object[]{logPrefix, string4, string5});
            Object object = this.getJsonValue(string5, "$['spec']['nodeName']");
            if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                APMDiscoveryLogger.discoveryLogger.trace("{}  $['spec']['nodeName'] : {} - {}", new Object[]{logPrefix, object.getClass(), object});
            }
            if (object != null && object instanceof String) {
                string3 = object.toString();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getNodeName() : {}", (Object)logPrefix, (Object)exception);
        }
        return string3;
    }

    private ArrayList getLabelList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object = this.getJsonValue(string, "$.metadata.labels");
            if (object != null && object instanceof LinkedHashMap) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)object;
                for (String string2 : linkedHashMap.keySet()) {
                    String string3 = (String)linkedHashMap.get(string2);
                    arrayList.add(string2 + ":" + string3);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getLabelList() : {}", (Object)logPrefix, (Object)exception);
        }
        return arrayList;
    }

    private HashMap getAsContainerInfoObjMap(JSONArray jSONArray) {
        HashMap<String, ContainerInfo> hashMap = new HashMap<String, ContainerInfo>();
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.size(); ++i) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)jSONArray.get(i);
                if (linkedHashMap == null) continue;
                String string = (String)linkedHashMap.get("name");
                String string2 = (String)linkedHashMap.get("containerID");
                string2 = APMUtils.getShortContainerId(string2);
                ContainerInfo containerInfo = new ContainerInfo(string2);
                containerInfo.setName(string);
                containerInfo.setIndex(i);
                hashMap.put(string2, containerInfo);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileContentAsString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {} - File Not found exception : ", (Object)logPrefix, (Object)string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing readFileContentAsString() : {}", (Object)logPrefix, (Object)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString();
    }

    private static String findKubeServiceToken() {
        String string = KubernetesAPI.readFileContentAsString("/var/run/secrets/kubernetes.io/serviceaccount/token");
        if (string != null && string.length() > 0) {
            return string;
        }
        return "";
    }

    public String getK8sServiceName(String string, String string2, String string3) {
        try {
            ArrayList arrayList = this.getLabelNameFromPod(string, string2);
            return this.getServiceName(string, arrayList, string3);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getK8sServiceName() : {}", (Object)logPrefix, (Object)exception);
            return "";
        }
    }

    public String getServiceName(String string, ArrayList arrayList, String string2) {
        HashMap hashMap = this.getCachedServiceInfoDetails(string);
        APMDiscoveryLogger.discoveryLogger.trace("{} Using Cached svcInfoMap for service discovery: {}", (Object)logPrefix, (Object)hashMap);
        String string3 = this.getServiceName(string, arrayList, string2, hashMap);
        if (string3 != null && string3.length() > 1) {
            return string3;
        }
        this.getServiceApiData(string);
        hashMap = this.getCachedServiceInfoDetails(string);
        APMDiscoveryLogger.discoveryLogger.trace("{} Using Updated svcInfoMap for service discovery : {}", (Object)logPrefix, (Object)hashMap);
        return this.getServiceName(string, arrayList, string2, hashMap);
    }

    public String getServiceApiData(String string) {
        String string2 = null;
        try {
            String string3 = "/api/v1/namespaces/" + string + "/services";
            String string4 = this.executeCommands(string3);
            APMDiscoveryLogger.discoveryLogger.trace("{}  serviceCmd : {}", (Object)logPrefix, (Object)string3);
            APMDiscoveryLogger.discoveryLogger.trace("{}  serviceCmdOutputs : {}", (Object)logPrefix, (Object)string4);
            ArrayList arrayList = this.getJsonPathsValue(string4, "$.items[*]");
            APMDiscoveryLogger.discoveryLogger.trace("{}  paths : {}", (Object)logPrefix, (Object)arrayList);
            HashMap hashMap = this.processServiceApiData(string, arrayList, string4);
            this.servicData.put(string, hashMap);
            APMDiscoveryLogger.discoveryLogger.trace("{}  tempserviceData : {}", (Object)logPrefix, (Object)hashMap);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getServicename() : {}", (Object)logPrefix, (Object)exception);
        }
        return string2;
    }

    public String getServiceName(String string, ArrayList arrayList, String string2, HashMap hashMap) {
        if (hashMap == null) {
            return "";
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Object object = "";
        try {
            ArrayList arrayList2;
            Object object2;
            Object object3;
            Object object4;
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                try {
                    object4 = (String)iterator.next();
                    object3 = (K8sServiceInfo)hashMap.get(object4);
                    object2 = ((K8sServiceInfo)object3).getSelectorLabelList();
                    if (object2 == null || ((ArrayList)object2).size() <= 0 || !arrayList.containsAll((Collection<?>)object2)) continue;
                    linkedHashMap.put(object4, (K8sServiceInfo)object3);
                    object = object4;
                    APMDiscoveryLogger.discoveryLogger.debug("{}  Servicename : [{}] decided by selector labels : {}", new Object[]{logPrefix, object, object2});
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} #1 Exception while processing getServicenName() : {}", (Object)logPrefix, (Object)exception);
                }
            }
            APMDiscoveryLogger.discoveryLogger.debug("{}  Matched service name map  : {}", (Object)logPrefix, linkedHashMap);
            if (linkedHashMap.size() == 1 && object != null && ((String)object).length() > 0) {
                return object;
            }
            if (linkedHashMap.size() > 1) {
                object4 = linkedHashMap.keySet().iterator();
                while (object4.hasNext()) {
                    try {
                        object3 = (String)object4.next();
                        object2 = (K8sServiceInfo)hashMap.get(object3);
                        object = object3;
                        arrayList2 = ((K8sServiceInfo)object2).getLabelList();
                        if (arrayList2 == null || arrayList2.size() <= 0 || !arrayList.containsAll(arrayList2) || object == null || ((String)object).length() <= 0) continue;
                        APMDiscoveryLogger.discoveryLogger.debug("{}  Servicename : [{}] decided by labels : {}", new Object[]{logPrefix, object, arrayList2});
                        return object;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} #2 Exception while processing getServicenName() : {}", (Object)logPrefix, (Object)exception);
                    }
                }
            }
            if (linkedHashMap.size() > 1 && string2 != null) {
                object4 = linkedHashMap.keySet().iterator();
                while (object4.hasNext()) {
                    try {
                        object3 = (String)object4.next();
                        object2 = (K8sServiceInfo)hashMap.get(object3);
                        object = object3;
                        arrayList2 = ((K8sServiceInfo)object2).getPorts();
                        if (arrayList2 == null) continue;
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            LinkedHashMap linkedHashMap2 = (LinkedHashMap)arrayList2.get(i);
                            String string3 = new String(linkedHashMap2.get("targetPort") + "");
                            if (string3 == null || !string2.equalsIgnoreCase(string3)) continue;
                            APMDiscoveryLogger.discoveryLogger.debug("{}  Servicename : [{}] decided by port : {}", new Object[]{logPrefix, object, string3});
                            return object;
                        }
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} #3 Exception while processing getServicenName() : {}", (Object)logPrefix, (Object)exception);
                    }
                }
            }
            if (linkedHashMap.size() > 1 && string2 != null) {
                object4 = linkedHashMap.keySet().iterator();
                while (object4.hasNext()) {
                    try {
                        object3 = (String)object4.next();
                        object2 = (K8sServiceInfo)hashMap.get(object3);
                        object = object3;
                        if (object == null || ((String)object).length() <= 0) continue;
                        APMDiscoveryLogger.discoveryLogger.debug("{}  Servicename : [{}] decided by first occurrence ", (Object)logPrefix, object);
                        return object;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} #4 Exception while processing getServicenName() : {}", (Object)logPrefix, (Object)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getServicenName() : {}", (Object)logPrefix, (Object)exception);
        }
        return object;
    }

    public static void main2(String[] stringArray) {
        String string = "/api/v1/namespaces";
        String string2 = "eyJhbGciOiJSUzI1NiIsImtpZCI6IldJX3prV1BuNFpJLUFwYzlhblR2M3VXbS1PeHBia2dGOVlETjg2MkFfeUkifQ.eyJpc3MiOiJrdWJlcm5ldGVzL3NlcnZpY2VhY2NvdW50Iiwia3ViZXJuZXRlcy5pby9zZXJ2aWNlYWNjb3VudC9uYW1lc3BhY2UiOiJlZ2FnZW50Iiwia3ViZXJuZXRlcy5pby9zZXJ2aWNlYWNjb3VudC9zZWNyZXQubmFtZSI6ImVnYWdlbnQtdG9rZW4tMm02N2giLCJrdWJlcm5ldGVzLmlvL3NlcnZpY2VhY2NvdW50L3NlcnZpY2UtYWNjb3VudC5uYW1lIjoiZWdhZ2VudCIsImt1YmVybmV0ZXMuaW8vc2VydmljZWFjY291bnQvc2VydmljZS1hY2NvdW50LnVpZCI6IjBlMzNkZGNhLTQ4NGItNGQ3ZC1hZDQyLWEwYTg3ZDg5ZTM4MSIsInN1YiI6InN5c3RlbTpzZXJ2aWNlYWNjb3VudDplZ2FnZW50OmVnYWdlbnQifQ.6nbxnTCxtFmjT8-AKf2a0KSDIHWDsj31Cqw7wkPPuYHSQjPw0hL3PIzp38YBuwkl6_cokBGCYscgdlvwiGfGOvkQ7KG_TnhMThMlcPJpYNTGWbSieh5AdzPTH3OTUrNX7BsgFwu5bqGF4JNAMJyufWnlngGkt7btZBy_m2kkp2wt_jVzZtWYbyCcMR7NGObof8YHU0v6aUWpzZ8Z-iJwJsCUqkik0n7A1aUA_TDHT2njMOVwFUc2wU34BBZDfV3wpkjAVJ1ywidq0JTHxXdbO-3EXIKvKmSS0VXYZJTNir4gt3DN911py8YClpse-WOmVmMDbu65RDWNGbObG0WTvg";
        int n = 443;
        String string3 = "172.30.0.1";
        String string4 = "443";
        if (string4 != null && string4.length() > 0) {
            n = Integer.parseInt(string4.trim());
        }
        System.out.println();
        System.out.println("k8ServiceHost:-  " + string3);
        System.out.println("port:-  " + n);
        System.out.println("token:-  " + string2);
        System.out.println();
        KubernetesAPI kubernetesAPI = new KubernetesAPI(string3, n, string2, true);
        String string5 = "/api/v1/namespaces/default/services";
        long l = System.currentTimeMillis();
        String string6 = kubernetesAPI.executeCommands(string5);
        System.out.println("\n\n serviceCmdOutputs:- " + string6);
        System.out.println("Diff " + (System.currentTimeMillis() - l));
    }

    public static void main3(String[] stringArray) {
        String string = "{ \t\t\t\"metadata\": { \t\t\t\t\"name\": \"sonarqube-backrest-shared-repo\", \t\t\t\t\"namespace\": \"crunchydatadv\", \t\t\t\t\"selfLink\": \"/api/v1/namespaces/crunchydatadv/services/sonarqube-backrest-shared-repo\", \t\t\t\t\"uid\": \"e89c1af5-2cd6-4b38-a879-119aca618bdd\", \t\t\t\t\"resourceVersion\": \"107165666\", \t\t\t\t\"creationTimestamp\": \"2021-03-25T20:37:20Z\", \t\t\t\t\"labels\": { \t\t\t\t\t\"name\": \"sonarqube-backrest-shared-repo\", \t\t\t\t\t\"pg-cluster\": \"sonarqube\", \t\t\t\t\t\"pgo-backrest-repo\": \"true\", \t\t\t\t\t\"vendor\": \"crunchydata\" \t\t\t\t}, \t\t\t\t\"managedFields\": [ \t\t\t\t\t{ \t\t\t\t\t\t\"manager\": \"postgres-operator\", \t\t\t\t\t\t\"operation\": \"Update\", \t\t\t\t\t\t\"apiVersion\": \"v1\", \t\t\t\t\t\t\"time\": \"2021-03-25T20:37:20Z\", \t\t\t\t\t\t\"fieldsType\": \"FieldsV1\", \t\t\t\t\t\t\"fieldsV1\": { \t\t\t\t\t\t\t\"f:metadata\": { \t\t\t\t\t\t\t\t\"f:labels\": { \t\t\t\t\t\t\t\t\t\".\": {}, \t\t\t\t\t\t\t\t\t\"f:name\": {}, \t\t\t\t\t\t\t\t\t\"f:pg-cluster\": {}, \t\t\t\t\t\t\t\t\t\"f:pgo-backrest-repo\": {}, \t\t\t\t\t\t\t\t\t\"f:vendor\": {} \t\t\t\t\t\t\t\t} \t\t\t\t\t\t\t}, \t\t\t\t\t\t\t\"f:spec\": { \t\t\t\t\t\t\t\t\"f:ports\": { \t\t\t\t\t\t\t\t\t\".\": {}, \t\t\t\t\t\t\t\t\t\"k:{\\\"port\\\":2022,\\\"protocol\\\":\\\"TCP\\\"}\": { \t\t\t\t\t\t\t\t\t\t\".\": {}, \t\t\t\t\t\t\t\t\t\t\"f:port\": {}, \t\t\t\t\t\t\t\t\t\t\"f:protocol\": {}, \t\t\t\t\t\t\t\t\t\t\"f:targetPort\": {} \t\t\t\t\t\t\t\t\t} \t\t\t\t\t\t\t\t}, \t\t\t\t\t\t\t\t\"f:selector\": { \t\t\t\t\t\t\t\t\t\".\": {}, \t\t\t\t\t\t\t\t\t\"f:name\": {} \t\t\t\t\t\t\t\t}, \t\t\t\t\t\t\t\t\"f:sessionAffinity\": {}, \t\t\t\t\t\t\t\t\"f:type\": {} \t\t\t\t\t\t\t} \t\t\t\t\t\t} \t\t\t\t\t} \t\t\t\t] \t\t\t}, \t\t\t\"spec\": { \t\t\t\t\"ports\": [ \t\t\t\t\t{ \t\t\t\t\t\t\"protocol\": \"TCP\", \t\t\t\t\t\t\"port\": 2022, \t\t\t\t\t\t\"targetPort\": 2022 \t\t\t\t\t}, \t\t\t\t\t{ \t\t\t\t\t\t\"protocol\": \"TCP\", \t\t\t\t\t\t\"port\": 2023, \t\t\t\t\t\t\"targetPort\": 2023 \t\t\t\t\t} \t\t\t\t], \t\t\t\t\"selector\": { \t\t\t\t\t\"name\": \"sonarqube-backrest-shared-repo\" \t\t\t\t}, \t\t\t\t\"clusterIP\": \"172.30.229.219\", \t\t\t\t\"type\": \"ClusterIP\", \t\t\t\t\"sessionAffinity\": \"None\" \t\t\t}, \t\t\t\"status\": { \t\t\t\t\"loadBalancer\": {} \t\t\t} \t\t}, \t\t";
        KubernetesAPI kubernetesAPI = new KubernetesAPI();
        JSONArray jSONArray = (JSONArray)kubernetesAPI.getJsonValue(string, "$['spec']['ports']");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll((Collection<String>)jSONArray);
        arrayList.add("eeee");
        System.out.println(arrayList.get(0));
        System.out.println(arrayList.get(1).getClass());
        System.out.println(arrayList.get(2).getClass());
    }

    public static void main(String[] stringArray) {
        KubernetesAPI kubernetesAPI = new KubernetesAPI();
        String string = KubernetesAPI.readFileContentAsString("D:\\workspace\\eclipse-workspace\\BTM_ZeroTouch_Agent_718_OpenShiftIP_MountPath\\data-set\\service details.json");
        ArrayList arrayList = kubernetesAPI.getJsonPathsValue(string, "$.items[*]");
        HashMap hashMap = kubernetesAPI.processServiceApiData("crunchydatadv", arrayList, string);
        System.out.println(kubernetesAPI.serviceNameWithDetails);
        String string2 = "{\"kind\":\"Pod\",\"apiVersion\":\"v1\",\"metadata\":{\"name\":\"smbcclusterdv01-68c987b9b8-5v6cm\",\"generateName\":\"smbcclusterdv01-68c987b9b8-\",\"namespace\":\"crunchydatadv\",\"selfLink\":\"/api/v1/namespaces/crunchydatadv/pods/smbcclusterdv01-68c987b9b8-5v6cm\",\"uid\":\"8b745251-dacc-47b9-bbbe-063d6b0b786b\",\"resourceVersion\":\"143039853\",\"creationTimestamp\":\"2021-04-14T19:16:18Z\",\"labels\":{\"crunchy-pgha-scope\":\"smbcclusterdv01\",\"crunchy-postgres-exporter\":\"true\",\"deployment-name\":\"smbcclusterdv01\",\"name\":\"smbcclusterdv01\",\"pg-cluster\":\"smbcclusterdv01\",\"pg-pod-anti-affinity\":\"\",\"pgo-pg-database\":\"true\",\"pgo-version\":\"4.6.0\",\"pgouser\":\"admin\",\"pod-template-hash\":\"68c987b9b8\",\"role\":\"master\",\"service-name\":\"smbcclusterdv01\",\"vendor\":\"crunchydata\",\"workflowid\":\"0b2182f2-6af3-4bc0-9468-30132566546c\"},\"annotations\":{\"k8s.v1.cni.cncf.io/network-status\":\"[{\\n    \\\"name\\\": \\\"openshift-sdn\\\",\\n    \\\"interface\\\": \\\"eth0\\\",\\n    \\\"ips\\\": [\\n        \\\"192.169.2.35\\\"\\n    ],\\n    \\\"default\\\": true,\\n    \\\"dns\\\": {}\\n}]\",\"k8s.v1.cni.cncf.io/networks-status\":\"[{\\n    \\\"name\\\": \\\"openshift-sdn\\\",\\n    \\\"interface\\\": \\\"eth0\\\",\\n    \\\"ips\\\": [\\n        \\\"192.169.2.35\\\"\\n    ],\\n    \\\"default\\\": true,\\n    \\\"dns\\\": {}\\n}]\",\"kubectl.kubernetes.io/restartedAt\":\"2021-04-14T15:16:18-04:00\",\"openshift.io/scc\":\"restricted\",\"status\":\"{\\\"conn_url\\\":\\\"postgres://192.169.2.35:5432/postgres\\\",\\\"api_url\\\":\\\"http://192.169.2.35:8009/patroni\\\",\\\"state\\\":\\\"running\\\",\\\"role\\\":\\\"master\\\",\\\"version\\\":\\\"2.0.1\\\",\\\"xlog_location\\\":569083239096,\\\"timeline\\\":44}\"},\"ownerReferences\":[{\"apiVersion\":\"apps/v1\",\"kind\":\"ReplicaSet\",\"name\":\"smbcclusterdv01-68c987b9b8\",\"uid\":\"7d671c98-4052-4980-ac3b-8978d518a8f3\",\"controller\":true,\"blockOwnerDeletion\":true}],\"managedFields\":[{\"manager\":\"kube-controller-manager\",\"operation\":\"Update\",\"apiVersion\":\"v1\",\"time\":\"2021-04-14T19:16:18Z\",\"fieldsType\":\"FieldsV1\",\"fieldsV1\":{\"f:metadata\":{\"f:annotations\":{\".\":{},\"f:kubectl.kubernetes.io/restartedAt\":{}},\"f:generateName\":{},\"f:labels\":{\".\":{},\"f:crunchy-pgha-scope\":{},\"f:crunchy-postgres-exporter\":{},\"f:deployment-name\":{},\"f:name\":{},\"f:pg-cluster\":{},\"f:pg-pod-anti-affinity\":{},\"f:pgo-pg-database\":{},\"f:pgo-version\":{},\"f:pgouser\":{},\"f:pod-template-hash\":{},\"f:vendor\":{},\"f:workflowid\":{}},\"f:ownerReferences\":{\".\":{},\"k:{\\\"uid\\\":\\\"7d671c98-4052-4980-ac3b-8978d518a8f3\\\"}\":{\".\":{},\"f:apiVersion\":{},\"f:blockOwnerDeletion\":{},\"f:controller\":{},\"f:kind\":{},\"f:name\":{},\"f:uid\":{}}}},\"f:spec\":{\"f:affinity\":{\".\":{},\"f:podAntiAffinity\":{\".\":{},\"f:preferredDuringSchedulingIgnoredDuringExecution\":{}}},\"f:containers\":{\"k:{\\\"name\\\":\\\"database\\\"}\":{\".\":{},\"f:env\":{\".\":{},\"k:{\\\"name\\\":\\\"BACKREST_SKIP_CREATE_STANZA\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"ENABLE_SSHD\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"MODE\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PATRONI_KUBERNETES_LABELS\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PATRONI_KUBERNETES_NAMESPACE\\\"}\":{\".\":{},\"f:name\":{},\"f:valueFrom\":{\".\":{},\"f:fieldRef\":{\".\":{},\"f:apiVersion\":{},\"f:fieldPath\":{}}}},\"k:{\\\"name\\\":\\\"PATRONI_KUBERNETES_SCOPE_LABEL\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PATRONI_LOG_LEVEL\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PATRONI_POSTGRESQL_DATA_DIR\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PATRONI_SCOPE\\\"}\":{\".\":{},\"f:name\":{},\"f:valueFrom\":{\".\":{},\"f:fieldRef\":{\".\":{},\"f:apiVersion\":{},\"f:fieldPath\":{}}}},\"k:{\\\"name\\\":\\\"PGBACKREST_DB_PATH\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGBACKREST_LOG_PATH\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGBACKREST_PG1_PORT\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGBACKREST_PG1_SOCKET_PATH\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGBACKREST_REPO1_HOST\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGBACKREST_REPO1_PATH\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGBACKREST_REPO1_TYPE\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGBACKREST_STANZA\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_DATABASE\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_INIT\\\"}\":{\".\":{},\"f:name\":{},\"f:valueFrom\":{\".\":{},\"f:configMapKeyRef\":{\".\":{},\"f:key\":{},\"f:name\":{}}}},\"k:{\\\"name\\\":\\\"PGHA_PGBACKREST\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_PGBACKREST_LOCAL_S3_STORAGE\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_PG_PORT\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_REPLICA_REINIT_ON_START_FAIL\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_STANDBY\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_SYNC_REPLICATION\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_TLS_ENABLED\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_TLS_ONLY\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHA_USER\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGHOST\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGMONITOR_PASSWORD\\\"}\":{\".\":{},\"f:name\":{},\"f:valueFrom\":{\".\":{},\"f:secretKeyRef\":{\".\":{},\"f:key\":{},\"f:name\":{}}}}},\"f:image\":{},\"f:imagePullPolicy\":{},\"f:livenessProbe\":{\".\":{},\"f:exec\":{\".\":{},\"f:command\":{}},\"f:failureThreshold\":{},\"f:initialDelaySeconds\":{},\"f:periodSeconds\":{},\"f:successThreshold\":{},\"f:timeoutSeconds\":{}},\"f:name\":{},\"f:ports\":{\".\":{},\"k:{\\\"containerPort\\\":5432,\\\"protocol\\\":\\\"TCP\\\"}\":{\".\":{},\"f:containerPort\":{},\"f:protocol\":{}},\"k:{\\\"containerPort\\\":8009,\\\"protocol\\\":\\\"TCP\\\"}\":{\".\":{},\"f:containerPort\":{},\"f:protocol\":{}}},\"f:readinessProbe\":{\".\":{},\"f:exec\":{\".\":{},\"f:command\":{}},\"f:failureThreshold\":{},\"f:initialDelaySeconds\":{},\"f:periodSeconds\":{},\"f:successThreshold\":{},\"f:timeoutSeconds\":{}},\"f:resources\":{\".\":{},\"f:limits\":{\".\":{},\"f:cpu\":{},\"f:memory\":{}},\"f:requests\":{\".\":{},\"f:cpu\":{},\"f:memory\":{}}},\"f:terminationMessagePath\":{},\"f:terminationMessagePolicy\":{},\"f:volumeMounts\":{\".\":{},\"k:{\\\"mountPath\\\":\\\"/dev/shm\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}},\"k:{\\\"mountPath\\\":\\\"/etc/pgbackrest/conf.d\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}},\"k:{\\\"mountPath\\\":\\\"/etc/podinfo\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}},\"k:{\\\"mountPath\\\":\\\"/pgconf\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}},\"k:{\\\"mountPath\\\":\\\"/pgconf/pgreplicator\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}},\"k:{\\\"mountPath\\\":\\\"/pgconf/pgsuper\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}},\"k:{\\\"mountPath\\\":\\\"/pgconf/pguser\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}},\"k:{\\\"mountPath\\\":\\\"/pgdata\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}},\"k:{\\\"mountPath\\\":\\\"/sshd\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{},\"f:readOnly\":{}}}},\"k:{\\\"name\\\":\\\"exporter\\\"}\":{\".\":{},\"f:env\":{\".\":{},\"k:{\\\"name\\\":\\\"EXPORTER_PG_DATABASE\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"EXPORTER_PG_HOST\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"EXPORTER_PG_PARAMS\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"EXPORTER_PG_PASSWORD\\\"}\":{\".\":{},\"f:name\":{},\"f:valueFrom\":{\".\":{},\"f:secretKeyRef\":{\".\":{},\"f:key\":{},\"f:name\":{}}}},\"k:{\\\"name\\\":\\\"EXPORTER_PG_PORT\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"EXPORTER_PG_USER\\\"}\":{\".\":{},\"f:name\":{},\"f:valueFrom\":{\".\":{},\"f:secretKeyRef\":{\".\":{},\"f:key\":{},\"f:name\":{}}}},\"k:{\\\"name\\\":\\\"JOB_NAME\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"POSTGRES_EXPORTER_PORT\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}}},\"f:image\":{},\"f:imagePullPolicy\":{},\"f:name\":{},\"f:ports\":{\".\":{},\"k:{\\\"containerPort\\\":9187,\\\"protocol\\\":\\\"TCP\\\"}\":{\".\":{},\"f:containerPort\":{},\"f:protocol\":{}}},\"f:resources\":{\".\":{},\"f:requests\":{\".\":{},\"f:memory\":{}}},\"f:terminationMessagePath\":{},\"f:terminationMessagePolicy\":{}},\"k:{\\\"name\\\":\\\"pgbadger\\\"}\":{\".\":{},\"f:env\":{\".\":{},\"k:{\\\"name\\\":\\\"BADGER_TARGET\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}},\"k:{\\\"name\\\":\\\"PGBADGER_SERVICE_PORT\\\"}\":{\".\":{},\"f:name\":{},\"f:value\":{}}},\"f:image\":{},\"f:imagePullPolicy\":{},\"f:name\":{},\"f:ports\":{\".\":{},\"k:{\\\"containerPort\\\":10000,\\\"protocol\\\":\\\"TCP\\\"}\":{\".\":{},\"f:containerPort\":{},\"f:protocol\":{}}},\"f:readinessProbe\":{\".\":{},\"f:failureThreshold\":{},\"f:initialDelaySeconds\":{},\"f:periodSeconds\":{},\"f:successThreshold\":{},\"f:tcpSocket\":{\".\":{},\"f:port\":{}},\"f:timeoutSeconds\":{}},\"f:resources\":{\".\":{},\"f:limits\":{\".\":{},\"f:cpu\":{},\"f:memory\":{}},\"f:requests\":{\".\":{},\"f:cpu\":{},\"f:memory\":{}}},\"f:terminationMessagePath\":{},\"f:terminationMessagePolicy\":{},\"f:volumeMounts\":{\".\":{},\"k:{\\\"mountPath\\\":\\\"/pgdata\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{},\"f:readOnly\":{}},\"k:{\\\"mountPath\\\":\\\"/report\\\"}\":{\".\":{},\"f:mountPath\":{},\"f:name\":{}}}}},\"f:dnsPolicy\":{},\"f:enableServiceLinks\":{},\"f:restartPolicy\":{},\"f:schedulerName\":{},\"f:securityContext\":{},\"f:serviceAccount\":{},\"f:serviceAccountName\":{},\"f:terminationGracePeriodSeconds\":{},\"f:volumes\":{\".\":{},\"k:{\\\"name\\\":\\\"dshm\\\"}\":{\".\":{},\"f:emptyDir\":{\".\":{},\"f:medium\":{}},\"f:name\":{}},\"k:{\\\"name\\\":\\\"pgbackrest-config\\\"}\":{\".\":{},\"f:name\":{},\"f:projected\":{\".\":{},\"f:defaultMode\":{},\"f:sources\":{}}},\"k:{\\\"name\\\":\\\"pgconf-volume\\\"}\":{\".\":{},\"f:name\":{},\"f:projected\":{\".\":{},\"f:defaultMode\":{},\"f:sources\":{}}},\"k:{\\\"name\\\":\\\"pgdata\\\"}\":{\".\":{},\"f:name\":{},\"f:persistentVolumeClaim\":{\".\":{},\"f:claimName\":{}}},\"k:{\\\"name\\\":\\\"podinfo\\\"}\":{\".\":{},\"f:downwardAPI\":{\".\":{},\"f:defaultMode\":{},\"f:items\":{}},\"f:name\":{}},\"k:{\\\"name\\\":\\\"primary-volume\\\"}\":{\".\":{},\"f:name\":{},\"f:secret\":{\".\":{},\"f:defaultMode\":{},\"f:secretName\":{}}},\"k:{\\\"name\\\":\\\"report\\\"}\":{\".\":{},\"f:emptyDir\":{\".\":{},\"f:medium\":{},\"f:sizeLimit\":{}},\"f:name\":{}},\"k:{\\\"name\\\":\\\"root-volume\\\"}\":{\".\":{},\"f:name\":{},\"f:secret\":{\".\":{},\"f:defaultMode\":{},\"f:secretName\":{}}},\"k:{\\\"name\\\":\\\"sshd\\\"}\":{\".\":{},\"f:name\":{},\"f:secret\":{\".\":{},\"f:defaultMode\":{},\"f:secretName\":{}}},\"k:{\\\"name\\\":\\\"user-volume\\\"}\":{\".\":{},\"f:name\":{},\"f:secret\":{\".\":{},\"f:defaultMode\":{},\"f:secretName\":{}}}}}}},{\"manager\":\"postgres-operator\",\"operation\":\"Update\",\"apiVersion\":\"v1\",\"time\":\"2021-04-14T19:16:18Z\",\"fieldsType\":\"FieldsV1\",\"fieldsV1\":{\"f:metadata\":{\"f:labels\":{\"f:service-name\":{}}}}},{\"manager\":\"multus\",\"operation\":\"Update\",\"apiVersion\":\"v1\",\"time\":\"2021-04-14T19:16:23Z\",\"fieldsType\":\"FieldsV1\",\"fieldsV1\":{\"f:metadata\":{\"f:annotations\":{\"f:k8s.v1.cni.cncf.io/network-status\":{},\"f:k8s.v1.cni.cncf.io/networks-status\":{}}}}},{\"manager\":\"kubelet\",\"operation\":\"Update\",\"apiVersion\":\"v1\",\"time\":\"2021-04-14T19:16:53Z\",\"fieldsType\":\"FieldsV1\",\"fieldsV1\":{\"f:status\":{\"f:conditions\":{\"k:{\\\"type\\\":\\\"ContainersReady\\\"}\":{\".\":{},\"f:lastProbeTime\":{},\"f:lastTransitionTime\":{},\"f:status\":{},\"f:type\":{}},\"k:{\\\"type\\\":\\\"Initialized\\\"}\":{\".\":{},\"f:lastProbeTime\":{},\"f:lastTransitionTime\":{},\"f:status\":{},\"f:type\":{}},\"k:{\\\"type\\\":\\\"Ready\\\"}\":{\".\":{},\"f:lastProbeTime\":{},\"f:lastTransitionTime\":{},\"f:status\":{},\"f:type\":{}}},\"f:containerStatuses\":{},\"f:hostIP\":{},\"f:phase\":{},\"f:podIP\":{},\"f:podIPs\":{\".\":{},\"k:{\\\"ip\\\":\\\"192.169.2.35\\\"}\":{\".\":{},\"f:ip\":{}}},\"f:startTime\":{}}}},{\"manager\":\"Patroni\",\"operation\":\"Update\",\"apiVersion\":\"v1\",\"time\":\"2021-04-30T13:10:13Z\",\"fieldsType\":\"FieldsV1\",\"fieldsV1\":{\"f:metadata\":{\"f:annotations\":{\"f:status\":{}},\"f:labels\":{\"f:role\":{}}}}}]},\"spec\":{\"volumes\":[{\"name\":\"pgdata\",\"persistentVolumeClaim\":{\"claimName\":\"smbcclusterdv01\"}},{\"name\":\"user-volume\",\"secret\":{\"secretName\":\"smbcclusterdv01-testuser-secret\",\"defaultMode\":420}},{\"name\":\"primary-volume\",\"secret\":{\"secretName\":\"smbcclusterdv01-primaryuser-secret\",\"defaultMode\":420}},{\"name\":\"sshd\",\"secret\":{\"secretName\":\"smbcclusterdv01-backrest-repo-config\",\"defaultMode\":420}},{\"name\":\"root-volume\",\"secret\":{\"secretName\":\"smbcclusterdv01-postgres-secret\",\"defaultMode\":420}},{\"name\":\"report\",\"emptyDir\":{\"medium\":\"Memory\",\"sizeLimit\":\"64Mi\"}},{\"name\":\"dshm\",\"emptyDir\":{\"medium\":\"Memory\"}},{\"name\":\"pgbackrest-config\",\"projected\":{\"sources\":[{\"configMap\":{\"name\":\"smbcclusterdv01-config-backrest\",\"optional\":true}},{\"secret\":{\"name\":\"smbcclusterdv01-config-backrest\",\"optional\":true}}],\"defaultMode\":420}},{\"name\":\"pgconf-volume\",\"projected\":{\"sources\":[{\"configMap\":{\"name\":\"smbcclusterdv01-pgha-config\",\"optional\":true}}],\"defaultMode\":420}},{\"name\":\"podinfo\",\"downwardAPI\":{\"items\":[{\"path\":\"cpu_limit\",\"resourceFieldRef\":{\"containerName\":\"database\",\"resource\":\"limits.cpu\",\"divisor\":\"1m\"}},{\"path\":\"cpu_request\",\"resourceFieldRef\":{\"containerName\":\"database\",\"resource\":\"requests.cpu\",\"divisor\":\"1m\"}},{\"path\":\"mem_limit\",\"resourceFieldRef\":{\"containerName\":\"database\",\"resource\":\"limits.memory\",\"divisor\":\"0\"}},{\"path\":\"mem_request\",\"resourceFieldRef\":{\"containerName\":\"database\",\"resource\":\"requests.memory\",\"divisor\":\"0\"}},{\"path\":\"labels\",\"fieldRef\":{\"apiVersion\":\"v1\",\"fieldPath\":\"metadata.labels\"}},{\"path\":\"annotations\",\"fieldRef\":{\"apiVersion\":\"v1\",\"fieldPath\":\"metadata.annotations\"}}],\"defaultMode\":420}},{\"name\":\"pgo-pg-token-jhdmw\",\"secret\":{\"secretName\":\"pgo-pg-token-jhdmw\",\"defaultMode\":420}}],\"containers\":[{\"name\":\"database\",\"image\":\"sonatypenxpr01.smbcgroup.com:18443/repository/crunchydata/crunchy-postgres-ha:ubi8-12.5-4.6.0\",\"ports\":[{\"containerPort\":5432,\"protocol\":\"TCP\"},{\"containerPort\":8009,\"protocol\":\"TCP\"}],\"env\":[{\"name\":\"MODE\",\"value\":\"postgres\"},{\"name\":\"PGHA_PG_PORT\",\"value\":\"5432\"},{\"name\":\"PGHA_USER\",\"value\":\"postgres\"},{\"name\":\"PGHA_INIT\",\"valueFrom\":{\"configMapKeyRef\":{\"name\":\"smbcclusterdv01-pgha-config\",\"key\":\"init\"}}},{\"name\":\"PATRONI_POSTGRESQL_DATA_DIR\",\"value\":\"/pgdata/smbcclusterdv01\"},{\"name\":\"PGBACKREST_STANZA\",\"value\":\"db\"},{\"name\":\"PGBACKREST_REPO1_HOST\",\"value\":\"smbcclusterdv01-backrest-shared-repo\"},{\"name\":\"BACKREST_SKIP_CREATE_STANZA\",\"value\":\"true\"},{\"name\":\"PGHA_PGBACKREST\",\"value\":\"true\"},{\"name\":\"PGBACKREST_REPO1_PATH\",\"value\":\"/backrestrepo/smbcclusterdv01-backrest-shared-repo\"},{\"name\":\"PGBACKREST_DB_PATH\",\"value\":\"/pgdata/smbcclusterdv01\"},{\"name\":\"ENABLE_SSHD\",\"value\":\"true\"},{\"name\":\"PGBACKREST_LOG_PATH\",\"value\":\"/tmp\"},{\"name\":\"PGBACKREST_PG1_SOCKET_PATH\",\"value\":\"/tmp\"},{\"name\":\"PGBACKREST_PG1_PORT\",\"value\":\"5432\"},{\"name\":\"PGBACKREST_REPO1_TYPE\",\"value\":\"posix\"},{\"name\":\"PGHA_PGBACKREST_LOCAL_S3_STORAGE\",\"value\":\"false\"},{\"name\":\"PGMONITOR_PASSWORD\",\"valueFrom\":{\"secretKeyRef\":{\"name\":\"smbcclusterdv01-exporter-secret\",\"key\":\"password\"}}},{\"name\":\"PGHA_DATABASE\",\"value\":\"smbcclusterdv01\"},{\"name\":\"PGHA_REPLICA_REINIT_ON_START_FAIL\",\"value\":\"true\"},{\"name\":\"PGHA_SYNC_REPLICATION\",\"value\":\"false\"},{\"name\":\"PGHA_TLS_ENABLED\",\"value\":\"false\"},{\"name\":\"PGHA_TLS_ONLY\",\"value\":\"false\"},{\"name\":\"PGHA_STANDBY\",\"value\":\"false\"},{\"name\":\"PATRONI_KUBERNETES_NAMESPACE\",\"valueFrom\":{\"fieldRef\":{\"apiVersion\":\"v1\",\"fieldPath\":\"metadata.namespace\"}}},{\"name\":\"PATRONI_KUBERNETES_SCOPE_LABEL\",\"value\":\"crunchy-pgha-scope\"},{\"name\":\"PATRONI_SCOPE\",\"valueFrom\":{\"fieldRef\":{\"apiVersion\":\"v1\",\"fieldPath\":\"metadata.labels['crunchy-pgha-scope']\"}}},{\"name\":\"PATRONI_KUBERNETES_LABELS\",\"value\":\"{vendor: \\\"crunchydata\\\"}\"},{\"name\":\"PATRONI_LOG_LEVEL\",\"value\":\"INFO\"},{\"name\":\"PGHOST\",\"value\":\"/tmp\"}],\"resources\":{\"limits\":{\"cpu\":\"200m\",\"memory\":\"512Mi\"},\"requests\":{\"cpu\":\"100m\",\"memory\":\"256Mi\"}},\"volumeMounts\":[{\"name\":\"pgdata\",\"mountPath\":\"/pgdata\"},{\"name\":\"user-volume\",\"mountPath\":\"/pgconf/pguser\"},{\"name\":\"primary-volume\",\"mountPath\":\"/pgconf/pgreplicator\"},{\"name\":\"root-volume\",\"mountPath\":\"/pgconf/pgsuper\"},{\"name\":\"sshd\",\"readOnly\":true,\"mountPath\":\"/sshd\"},{\"name\":\"pgconf-volume\",\"mountPath\":\"/pgconf\"},{\"name\":\"dshm\",\"mountPath\":\"/dev/shm\"},{\"name\":\"pgbackrest-config\",\"mountPath\":\"/etc/pgbackrest/conf.d\"},{\"name\":\"podinfo\",\"mountPath\":\"/etc/podinfo\"},{\"name\":\"pgo-pg-token-jhdmw\",\"readOnly\":true,\"mountPath\":\"/var/run/secrets/kubernetes.io/serviceaccount\"}],\"livenessProbe\":{\"exec\":{\"command\":[\"/opt/crunchy/bin/postgres-ha/health/pgha-liveness.sh\"]},\"initialDelaySeconds\":30,\"timeoutSeconds\":10,\"periodSeconds\":15,\"successThreshold\":1,\"failureThreshold\":3},\"readinessProbe\":{\"exec\":{\"command\":[\"/opt/crunchy/bin/postgres-ha/health/pgha-readiness.sh\"]},\"initialDelaySeconds\":15,\"timeoutSeconds\":1,\"periodSeconds\":10,\"successThreshold\":1,\"failureThreshold\":3},\"terminationMessagePath\":\"/dev/termination-log\",\"terminationMessagePolicy\":\"File\",\"imagePullPolicy\":\"IfNotPresent\",\"securityContext\":{\"capabilities\":{\"drop\":[\"KILL\",\"MKNOD\",\"SETGID\",\"SETUID\"]},\"runAsUser\":1000640000}},{\"name\":\"exporter\",\"image\":\"sonatypenxpr01.smbcgroup.com:18443/repository/crunchydata/crunchy-postgres-exporter:ubi8-4.6.0\",\"ports\":[{\"containerPort\":9187,\"protocol\":\"TCP\"}],\"env\":[{\"name\":\"EXPORTER_PG_HOST\",\"value\":\"127.0.0.1\"},{\"name\":\"EXPORTER_PG_PORT\",\"value\":\"5432\"},{\"name\":\"EXPORTER_PG_DATABASE\",\"value\":\"postgres\"},{\"name\":\"EXPORTER_PG_PARAMS\",\"value\":\"sslmode=disable\"},{\"name\":\"JOB_NAME\",\"value\":\"smbcclusterdv01\"},{\"name\":\"POSTGRES_EXPORTER_PORT\",\"value\":\"9187\"},{\"name\":\"EXPORTER_PG_USER\",\"valueFrom\":{\"secretKeyRef\":{\"name\":\"smbcclusterdv01-exporter-secret\",\"key\":\"username\"}}},{\"name\":\"EXPORTER_PG_PASSWORD\",\"valueFrom\":{\"secretKeyRef\":{\"name\":\"smbcclusterdv01-exporter-secret\",\"key\":\"password\"}}}],\"resources\":{\"requests\":{\"memory\":\"24Mi\"}},\"volumeMounts\":[{\"name\":\"pgo-pg-token-jhdmw\",\"readOnly\":true,\"mountPath\":\"/var/run/secrets/kubernetes.io/serviceaccount\"}],\"terminationMessagePath\":\"/dev/termination-log\",\"terminationMessagePolicy\":\"File\",\"imagePullPolicy\":\"IfNotPresent\",\"securityContext\":{\"capabilities\":{\"drop\":[\"KILL\",\"MKNOD\",\"SETGID\",\"SETUID\"]},\"runAsUser\":1000640000}},{\"name\":\"pgbadger\",\"image\":\"sonatypenxpr01.smbcgroup.com:18443/repository/crunchydata/crunchy-pgbadger:ubi8-12.5-4.6.0\",\"ports\":[{\"containerPort\":10000,\"protocol\":\"TCP\"}],\"env\":[{\"name\":\"BADGER_TARGET\",\"value\":\"smbcclusterdv01\"},{\"name\":\"PGBADGER_SERVICE_PORT\",\"value\":\"10000\"}],\"resources\":{\"limits\":{\"cpu\":\"500m\",\"memory\":\"64Mi\"},\"requests\":{\"cpu\":\"500m\",\"memory\":\"64Mi\"}},\"volumeMounts\":[{\"name\":\"pgdata\",\"readOnly\":true,\"mountPath\":\"/pgdata\"},{\"name\":\"report\",\"mountPath\":\"/report\"},{\"name\":\"pgo-pg-token-jhdmw\",\"readOnly\":true,\"mountPath\":\"/var/run/secrets/kubernetes.io/serviceaccount\"}],\"readinessProbe\":{\"tcpSocket\":{\"port\":10000},\"initialDelaySeconds\":20,\"timeoutSeconds\":1,\"periodSeconds\":10,\"successThreshold\":1,\"failureThreshold\":3},\"terminationMessagePath\":\"/dev/termination-log\",\"terminationMessagePolicy\":\"File\",\"imagePullPolicy\":\"IfNotPresent\",\"securityContext\":{\"capabilities\":{\"drop\":[\"KILL\",\"MKNOD\",\"SETGID\",\"SETUID\"]},\"runAsUser\":1000640000}}],\"restartPolicy\":\"Always\",\"terminationGracePeriodSeconds\":30,\"dnsPolicy\":\"ClusterFirst\",\"nodeSelector\":{\"node-role.kubernetes.io/worker\":\"\"},\"serviceAccountName\":\"pgo-pg\",\"serviceAccount\":\"pgo-pg\",\"nodeName\":\"ocp04worker02.ocp04.smbcgroup.com\",\"securityContext\":{\"seLinuxOptions\":{\"level\":\"s0:c25,c20\"},\"fsGroup\":1000640000},\"imagePullSecrets\":[{\"name\":\"postgres-operator-dockercfg-j5jf6\"},{\"name\":\"pgo-pg-dockercfg-j2x9p\"}],\"affinity\":{\"podAntiAffinity\":{\"preferredDuringSchedulingIgnoredDuringExecution\":[{\"weight\":1,\"podAffinityTerm\":{\"labelSelector\":{\"matchExpressions\":[{\"key\":\"vendor\",\"operator\":\"In\",\"values\":[\"crunchydata\"]},{\"key\":\"pg-pod-anti-affinity\",\"operator\":\"Exists\"},{\"key\":\"pg-cluster\",\"operator\":\"In\",\"values\":[\"smbcclusterdv01\"]}]},\"topologyKey\":\"kubernetes.io/hostname\"}}]}},\"schedulerName\":\"default-scheduler\",\"tolerations\":[{\"key\":\"node.kubernetes.io/not-ready\",\"operator\":\"Exists\",\"effect\":\"NoExecute\",\"tolerationSeconds\":300},{\"key\":\"node.kubernetes.io/unreachable\",\"operator\":\"Exists\",\"effect\":\"NoExecute\",\"tolerationSeconds\":300},{\"key\":\"node.kubernetes.io/memory-pressure\",\"operator\":\"Exists\",\"effect\":\"NoSchedule\"}],\"priority\":0,\"enableServiceLinks\":true},\"status\":{\"phase\":\"Running\",\"conditions\":[{\"type\":\"Initialized\",\"status\":\"True\",\"lastProbeTime\":null,\"lastTransitionTime\":\"2021-04-14T19:16:18Z\"},{\"type\":\"Ready\",\"status\":\"True\",\"lastProbeTime\":null,\"lastTransitionTime\":\"2021-04-14T19:16:53Z\"},{\"type\":\"ContainersReady\",\"status\":\"True\",\"lastProbeTime\":null,\"lastTransitionTime\":\"2021-04-14T19:16:53Z\"},{\"type\":\"PodScheduled\",\"status\":\"True\",\"lastProbeTime\":null,\"lastTransitionTime\":\"2021-04-14T19:16:18Z\"}],\"hostIP\":\"10.124.251.58\",\"podIP\":\"192.169.2.35\",\"podIPs\":[{\"ip\":\"192.169.2.35\"}],\"startTime\":\"2021-04-14T19:16:18Z\",\"containerStatuses\":[{\"name\":\"database\",\"state\":{\"running\":{\"startedAt\":\"2021-04-14T19:16:24Z\"}},\"lastState\":{},\"ready\":true,\"restartCount\":0,\"image\":\"sonatypenxpr01.smbcgroup.com:18443/repository/crunchydata/crunchy-postgres-ha:ubi8-12.5-4.6.0\",\"imageID\":\"sonatypenxpr01.smbcgroup.com:18443/repository/crunchydata/crunchy-postgres-ha@sha256:b94fb3c00cbc51614f3d7ab0d298b5dfdec694818c8679819f11488079423f17\",\"containerID\":\"cri-o://7bd31eeb77eb7f13a9ae85490f897fcc4a4955a5e94698910edae1061c27b956\",\"started\":true},{\"name\":\"exporter\",\"state\":{\"running\":{\"startedAt\":\"2021-04-14T19:16:24Z\"}},\"lastState\":{},\"ready\":true,\"restartCount\":0,\"image\":\"registry.connect.redhat.com/crunchydata/crunchy-postgres-exporter:ubi8-4.6.0\",\"imageID\":\"registry.connect.redhat.com/crunchydata/crunchy-postgres-exporter@sha256:ee036f1a1ca55ec4e1edfa4ccbc5286cbfa387d6650a431c2bf00fd56c3eaf63\",\"containerID\":\"cri-o://f60a47030106264397f15a8ad12808302909ebd6424a41ce68ce66ccaaa02440\",\"started\":true},{\"name\":\"pgbadger\",\"state\":{\"running\":{\"startedAt\":\"2021-04-14T19:16:24Z\"}},\"lastState\":{},\"ready\":true,\"restartCount\":0,\"image\":\"sonatypenxpr01.smbcgroup.com:18443/repository/crunchydata/crunchy-pgbadger:ubi8-12.5-4.6.0\",\"imageID\":\"sonatypenxpr01.smbcgroup.com:18443/repository/crunchydata/crunchy-pgbadger@sha256:88ec199de9c47977f9a6ad8b14ec6a321b3b7320cc8103bda9ca44f3c47832a1\",\"containerID\":\"cri-o://b6f379d252fd407a60b5ef8d9ebdfa37c792de4a0004f30b2354ed14dd691c93\",\"started\":true}],\"qosClass\":\"Burstable\"}}";
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Object object = kubernetesAPI.getJsonValue(string2, "$.metadata.labels");
        if (object != null && object instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            for (String string3 : linkedHashMap.keySet()) {
                String string4 = (String)linkedHashMap.get(string3);
                arrayList2.add(string3 + ":" + string4);
            }
        }
        System.out.println(arrayList2);
        System.out.println(kubernetesAPI.getServiceName("crunchydatadv", arrayList2, "5432"));
    }
}

