/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.ClientSocketHandler;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.MessageHandler;
import com.eg.jtm.BTMConstants;

public class LogPathMessageHandler
implements MessageHandler {
    private final String logPrefix = " [" + this.getClass().getName() + "] ";

    @Override
    public boolean handleMessage(String messageString, Object outputStream, ClientSocketHandler clientSocketHandler) {
        String[] logPathData = messageString.split("!;-;!");
        if (logPathData != null && logPathData.length == 4) {
            String componentGuid = logPathData[1];
            if (APMComponentIDRepository.getRepository().isSiteIdAvailable(componentGuid)) {
                String logPathCOde = logPathData[2];
                String logPath = logPathData[3];
                this.updateAPMCleanUpIniFile("LOG_PATHS", componentGuid, String.valueOf(logPathCOde) + "^" + logPath);
                clientSocketHandler.sendResponseToProfiler("LogPath_OK", outputStream, "");
            }
        }
        return true;
    }

    private void updateAPMCleanUpIniFile(String subject, String variable, String value) {
        try {
            try {
                JavaTransactionFlowUtility.addToIniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_CLEANUP, subject, variable, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JavaBTMOffloadLogger.btmOffLoadLogger.info("{}  Adding log path {}={}  details under subject {} ", new Object[]{this.logPrefix, variable, value, subject});
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Unable to update {} {} ", new Object[]{this.logPrefix, BTMConstants.APM_DISCOVERY_CLEANUP, e});
        }
    }
}

