/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.AckMessageHandler;
import com.eg.apm.DiscoverMessageHandler;
import com.eg.apm.HeartBeatMessageHandler;
import com.eg.apm.LogPathMessageHandler;
import com.eg.apm.MessageHandler;
import com.eg.apm.PingMessageHandler;
import java.util.HashMap;
import java.util.Map;

public final class MessageHandlerFactory {
    private static final MessageHandlerFactory instance = new MessageHandlerFactory();
    private final Map<String, MessageHandler> handlerMap = new HashMap<String, MessageHandler>();

    private MessageHandlerFactory() {
        this.handlerMap.put("OFFLOAD - PING", new PingMessageHandler());
        this.handlerMap.put("HeartBeatCheck", new HeartBeatMessageHandler());
        this.handlerMap.put("LogPath", new LogPathMessageHandler());
        this.handlerMap.put("ACK4BTM_", new AckMessageHandler());
        this.handlerMap.put("DISCOVER_ME", new DiscoverMessageHandler());
    }

    public static MessageHandlerFactory getInstance() {
        return instance;
    }

    public MessageHandler getMessageHandler(String keyString) {
        return this.handlerMap.get(keyString);
    }
}

