/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.NodeBTMLogger;
import com.eg.apm.NodeBlockedAt;
import com.eg.apm.NodeDumpCluster;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeMeasureTime;
import com.eg.org.slf4j.Logger;
import java.util.HashMap;
import java.util.Hashtable;

public class NodeDataRepository {
    protected static final Logger logger = NodeBTMLogger.nodeLogger;
    private static NodeDataRepository nodeDataRepository = null;
    private static HashMap<String, NodeMeasureTime> MeasureTimeMap = new HashMap();
    private static Hashtable<String, NodeInfraCluster> infraClusterTable = new Hashtable();
    private static Hashtable<String, NodeDumpCluster> dumpClusterTable = new Hashtable();

    private NodeDataRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeDataRepository getRepository() {
        if (nodeDataRepository != null) return nodeDataRepository;
        Class<NodeDataRepository> clazz = NodeDataRepository.class;
        synchronized (NodeDataRepository.class) {
            if (nodeDataRepository != null) return nodeDataRepository;
            nodeDataRepository = new NodeDataRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return nodeDataRepository;
        }
    }

    public boolean isInfraIdExists(String siteID) {
        return infraClusterTable.containsKey(siteID);
    }

    public NodeInfraCluster getInfraById(String siteID) {
        return infraClusterTable.get(siteID);
    }

    public void setInfraById(String siteID, NodeInfraCluster nodeInfraCluster) {
        infraClusterTable.put(siteID, nodeInfraCluster);
    }

    public boolean isDumpIdExists(String siteID) {
        return dumpClusterTable.containsKey(siteID);
    }

    public NodeDumpCluster getDumpById(String siteID) {
        return dumpClusterTable.get(siteID);
    }

    public void setDumpById(String siteId, NodeDumpCluster nodeDumpCluster) {
        dumpClusterTable.put(siteId, nodeDumpCluster);
    }

    public boolean isMeasureTimeExists(String siteID) {
        return MeasureTimeMap.containsKey(siteID);
    }

    public long getMeasureTimeByID(String siteID) {
        NodeMeasureTime timeMeasure = MeasureTimeMap.get(siteID);
        return timeMeasure.getMeasureTime();
    }

    public void setMeasureTimeByID(String siteID, Long measurePeriod, boolean isChanged) {
        NodeMeasureTime timePeriod = new NodeMeasureTime();
        timePeriod.setMeasureTime(measurePeriod);
        timePeriod.setChanged(isChanged);
        MeasureTimeMap.put(siteID, timePeriod);
    }

    public void setMeasureStatus(String siteID, boolean isChanged) {
        if (this.isMeasureTimeExists(siteID)) {
            NodeMeasureTime timeMeasure = MeasureTimeMap.get(siteID);
            timeMeasure.setChanged(isChanged);
            MeasureTimeMap.put(siteID, timeMeasure);
        }
    }

    public boolean isMeasureChanged(String siteID) {
        NodeMeasureTime timeMeasure = MeasureTimeMap.get(siteID);
        return timeMeasure.isChanged();
    }

    public void deleteMeasureTimeByID(String siteID) {
        MeasureTimeMap.remove(siteID);
    }

    public static NodeBlockedAt[] merge(NodeBlockedAt[] a, NodeBlockedAt[] b) {
        NodeBlockedAt[] c = new NodeBlockedAt[a.length + b.length];
        int count = 0;
        int i = 0;
        while (i < a.length) {
            c[i] = a[i];
            ++count;
            ++i;
        }
        int j = 0;
        while (j < b.length) {
            c[count++] = b[j];
            ++j;
        }
        return c;
    }
}

