/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.Discovery;
import com.eg.apm.JavaProcessDiscoveryController;
import java.util.LinkedHashSet;

public class ProcessBasedDiscoveryManager {
    private static final ProcessBasedDiscoveryManager INSTANCE = new ProcessBasedDiscoveryManager();
    LinkedHashSet<Discovery> processDiscoverySet = new LinkedHashSet();
    private volatile boolean isRunning = false;

    private ProcessBasedDiscoveryManager() {
        this.initDiscovery();
    }

    public static ProcessBasedDiscoveryManager getInstance() {
        return INSTANCE;
    }

    public void initDiscovery() {
        if (ApmConfigManager.getInstance().isJavaProcessDiscoveryEnabled()) {
            this.processDiscoverySet.add(JavaProcessDiscoveryController.getController());
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void resetSettings() {
        for (Discovery discovery : this.processDiscoverySet) {
            discovery.resetSettings();
        }
    }

    public void clearData() {
        for (Discovery discovery : this.processDiscoverySet) {
            discovery.clearData();
        }
    }

    public void clearData(boolean bl) {
        if (!this.isRunning) {
            this.clearData();
        }
    }

    private void applySettings() {
        this.generalSettings();
        for (Discovery discovery : this.processDiscoverySet) {
            discovery.loadSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDiscovery() {
        this.applySettings();
        try {
            try {
                this.isRunning = true;
                for (Discovery discovery : this.processDiscoverySet) {
                    discovery.startDiscovery();
                }
                Object var4_4 = null;
                this.isRunning = false;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} [ProcessBasedDiscoveryManager] Exception occurred ", (Throwable)exception);
                Object var4_5 = null;
                this.isRunning = false;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.isRunning = false;
            throw throwable;
        }
        this.resetSettings();
    }

    public void startDiscovery(boolean bl) {
        if (!this.isRunning) {
            this.startDiscovery();
        }
    }

    private void generalSettings() {
    }
}

