/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMLanguage;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.Status;
import com.eg.jtm.BTMDiscovery;
import java.util.TimerTask;

final class SnapShotTaker
extends TimerTask {
    private static final String loggerDispStr = "[SnapShotTaker]";
    private String componentGUID;

    SnapShotTaker(String guid) {
        this.componentGUID = guid;
    }

    public void run() {
        try {
            this.doSnapShot();
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do SnapShotTaker for - {}: {}", new Object[]{loggerDispStr, this.componentGUID, e});
        }
    }

    private void doSnapShot() {
        if (this.componentGUID != null) {
            APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(this.componentGUID);
            if (component.getStatus() != Status.MANAGED_OFFLOAD) {
                return;
            }
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Doing snapshot for - {} , APMComponent & Language  - {} -> {} ", new Object[]{loggerDispStr, this.componentGUID, component, component.getAPMLanguage()});
            if (component != null) {
                component.updateSnapShot();
            }
            if (component.getAPMLanguage() == APMLanguage.JAVA) {
                try {
                    BTMDiscovery btmDiscoveryWithNodeId = JavaTransactionFlowUtility.getBTMDiscoveryObject(this.componentGUID);
                    if (btmDiscoveryWithNodeId != null) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.trace(" updating transaction flow test data for {}", (Object)this.componentGUID);
                        btmDiscoveryWithNodeId.updateTransmitCopy();
                    }
                }
                catch (Exception e) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} exception while updating transaction flow test data {}", (Object)loggerDispStr, (Object)e);
                }
            }
        }
    }
}

