/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.SnapShotTaker;
import java.util.Timer;
import java.util.TimerTask;

public final class SnapShotTakerWatcher {
    static final long trackingPeriod = 30000L;
    private static final String loggerDispStr = "[SnapShotTakerTracker]";

    private SnapShotTakerWatcher() {
    }

    private static final void scheduleTracking(String guid, APMComponent component, SnapShotTaker snapTaker) {
        snapTaker = new SnapShotTaker(guid);
        Timer SnapShotTakerTimer = component.getSnapShotTakerTimer();
        if (SnapShotTakerTimer == null) {
            SnapShotTakerTimer = new Timer("APMSnapShotTaker_" + guid, true);
        }
        SnapShotTakerTimer.schedule((TimerTask)snapTaker, 30000L, 30000L);
        component.setSnapShotTaker(snapTaker);
        component.setSnapShotTakerTimer(SnapShotTakerTimer);
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} eG APM - BTM Snapshot Taker tracking started for {}", (Object)loggerDispStr, (Object)guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWatcherNull(boolean start, String guid) {
        APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(guid);
        if (component == null) {
            return true;
        }
        SnapShotTaker snapTaker = component.getSnapShotTaker();
        if (snapTaker != null) return false;
        if (!start) return true;
        Class<SnapShotTakerWatcher> clazz = SnapShotTakerWatcher.class;
        synchronized (SnapShotTakerWatcher.class) {
            block5: {
                if (snapTaker != null) break block5;
                SnapShotTakerWatcher.scheduleTracking(guid, component, snapTaker);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return true;
        }
    }
}

