/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.AgentStartupLogger;
import com.eg.org.slf4j.Logger;

public class SocketIpSelectorUtil {
    private static final String loggerPrefix = "[SocketIpSelectorUtil]";
    private static final String LOOP_BACK_ADDRESS = "127.0.0.1";
    private boolean isAgentIPAssignedAsBindIp = false;
    private boolean isContainerZHost = false;
    private boolean isConstainerHostIpAvailable = false;
    private boolean isServerSocketIpListening = false;
    private String containerIp = "127.0.0.1";
    private String currentListeningIp = "127.0.0.1";
    private static SocketIpSelectorUtil INSTANCE = null;

    private SocketIpSelectorUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketIpSelectorUtil getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SocketIpSelectorUtil> clazz = SocketIpSelectorUtil.class;
        synchronized (SocketIpSelectorUtil.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SocketIpSelectorUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void setAgentIpAsBindIp(boolean bl) {
        this.isAgentIPAssignedAsBindIp = bl;
    }

    public boolean isAgentIPAssignedAsBindIp() {
        return this.isAgentIPAssignedAsBindIp;
    }

    public void setIsContainerZHost(boolean bl) {
        this.isContainerZHost = bl;
    }

    public boolean isContainerzHost() {
        return this.isContainerZHost;
    }

    public void setContainerHostIp(String string, Logger logger) {
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("localhost") && !string.equalsIgnoreCase(LOOP_BACK_ADDRESS)) {
            this.containerIp = string;
            this.isConstainerHostIpAvailable = true;
            AgentStartupLogger.logger.info("{} Assigned container Host IP {} ", (Object)loggerPrefix, (Object)string);
        } else {
            logger.info("{} {} not a valid Docker host internal IP. ", (Object)loggerPrefix, (Object)string);
        }
    }

    public boolean isContainerHostIpAvailable() {
        return this.isConstainerHostIpAvailable;
    }

    public String getContainerHostIp() {
        return this.containerIp;
    }

    public String getCurrentListeningIp() {
        return this.currentListeningIp;
    }

    public boolean isServerSocketIpListening() {
        return this.isServerSocketIpListening;
    }

    void setListeningIp(String string) {
        if (string != null && string.length() > 0) {
            this.isServerSocketIpListening = true;
            this.currentListeningIp = string;
        }
    }
}

