/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.AgentStartupLogger;
import com.eg.jtm.DatabaseInfo;
import com.eg.jtm.PropertyTokenizer;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class BaseDatabaseInfo
implements DatabaseInfo {
    protected String jdbcUrl;
    protected String dbType;
    protected String databaseName;
    protected String hostName;
    protected String portNo;
    protected String informixServer;
    protected boolean isParsingFailure = false;
    protected Logger logger;
    protected static final String LOCAL_HOST = "localhost";
    protected static final String INFORMIXSERVER = "informixserver";
    protected static final String ALTERNATESERVERS = "alternateservers";

    public BaseDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        this.jdbcUrl = jdbcUrl;
        this.dbType = dbType;
        this.logger = logger != null ? logger : AgentStartupLogger.logger;
    }

    protected void parseProperty(String propertyString, String defaultPort, String instanceName) {
        if (propertyString == null) {
            this.logger.warn("[" + this.dbType + " - parseProperty] propertyString is null for the URL :" + this.jdbcUrl);
            return;
        }
        PropertyTokenizer propertyTokenizer = new PropertyTokenizer(propertyString, this.logger);
        propertyTokenizer.parse();
        ArrayList<String> propertyList = propertyTokenizer.getPropertyNames();
        if (propertyList != null && propertyList.size() > 0) {
            Hashtable<String, String> properties = propertyTokenizer.getAllPropertyKeyValues();
            int i = 0;
            while (i < propertyList.size()) {
                String propertyName = propertyList.get(i);
                if (propertyName.equals("databasename") || propertyName.equals("database") || propertyName.equals("locationname") || propertyName.equals("servicename") || propertyName.equals("sid")) {
                    this.databaseName = properties.get(propertyName);
                } else if (propertyName.equals("portnumber")) {
                    this.portNo = properties.get(propertyName);
                } else if (propertyName.equals("servername")) {
                    this.hostName = properties.get(propertyName);
                } else if (propertyName.equals(INFORMIXSERVER)) {
                    this.informixServer = properties.get(propertyName);
                }
                ++i;
            }
        }
        if (this.hostName == null) {
            this.hostName = LOCAL_HOST;
        }
        if (this.portNo == null) {
            this.portNo = instanceName != null ? instanceName : defaultPort;
        }
    }

    protected void parseWeblogicConnectionUrl(StringMaker maker, String defaultPort) {
        this.logger.debug("[" + this.dbType + " - parseWeblogicConnectionUrl] :" + maker.toString());
        maker.after("//").value().trim();
        String ipPortString = maker.before(";").value().trim();
        this.logger.debug("[" + this.dbType + " - parseWeblogicConnectionUrl] ipPortString :" + ipPortString);
        String instanceName = null;
        if (ipPortString != null && ipPortString.length() > 0) {
            if (ipPortString.indexOf("\\") > 0) {
                instanceName = ipPortString.substring(ipPortString.indexOf("\\") + 1);
                ipPortString = ipPortString.substring(0, ipPortString.indexOf("\\"));
                this.assignHostNameAndPort(ipPortString, instanceName);
            } else {
                this.assignHostNameAndPort(ipPortString, defaultPort);
            }
        }
        String propertyString = maker.next().value().trim();
        this.logger.debug("[" + this.dbType + " - parseWeblogicConnectionUrl] propertyString :" + propertyString);
        this.parseProperty(propertyString, defaultPort, instanceName);
        this.logger.info("[" + this.dbType + " - parseWeblogicConnectionUrl]  hostName :" + this.hostName + " PORT : " + this.portNo + " DB : " + this.databaseName);
    }

    protected void assignHostNameAndPort(String ipPortString, String defaultPort) {
        if (ipPortString.length() == 0) {
            this.logger.debug("[" + this.dbType + " -assignHostNameAndPort] ipPortString length is zero");
            return;
        }
        if (ipPortString.startsWith("[")) {
            this.logger.debug("[" + this.dbType + " -assignHostNameAndPort] Host name is specified using IPv6 :" + ipPortString);
            this.hostName = ipPortString.substring(0, ipPortString.indexOf("]") + 1);
            String portString = ipPortString.substring(ipPortString.indexOf("]") + 1);
            if (portString != null && portString.startsWith(":") && (portString = portString.substring(1)).length() > 0) {
                this.portNo = portString;
            }
        } else {
            this.logger.debug("[" + this.dbType + " - assignHostNameAndPort] Host name is specified using IPv4 :" + ipPortString);
            int colon_index = ipPortString.indexOf(":");
            if (colon_index == 0) {
                this.portNo = ipPortString.substring(1);
            } else if (colon_index > 0) {
                this.hostName = ipPortString.substring(0, ipPortString.indexOf(":"));
                this.portNo = ipPortString.substring(ipPortString.indexOf(":") + 1);
                if (this.portNo != null && this.portNo.length() == 0) {
                    this.portNo = defaultPort;
                }
            } else {
                this.hostName = ipPortString;
                this.portNo = defaultPort;
            }
            if (this.hostName != null && this.hostName.indexOf("\\") > 0) {
                this.hostName = this.hostName.substring(0, this.hostName.indexOf("\\"));
            }
        }
    }
}

