/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.Token;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyTokenizer {
    private static final char SAP_TOKEN_KEY_START = '&';
    private static final char SAP_TOKEN_KEY_END = '=';
    private static final char TOKEN_KEY_START = ';';
    private static final char TOKEN_KEY_END = '=';
    public static final char TOKEN_BRACE_START = '(';
    public static final char TOKEN_BRACE_END = ')';
    public static final int TYPE_KEY_START = 0;
    public static final Token TOKEN_KEY_START_OBJECT = new Token(String.valueOf(';'), 0);
    public static final int TYPE_KEY_END = 1;
    public static final Token TOKEN_KEY_END_OBJECT = new Token(String.valueOf('='), 1);
    public static final int TYPE_BRACE_START = 4;
    public static final Token TOKEN_BRACE_START_OBJECT = new Token(String.valueOf('('), 4);
    public static final int TYPE_BRACE_END = 5;
    public static final Token TOKEN_BRACE_END_OBJECT = new Token(String.valueOf(')'), 5);
    public static final Token SAP_TOKEN_KEY_START_OBJECT = new Token(String.valueOf('&'), 0);
    public static final Token SAP_TOKEN_KEY_END_OBJECT = new Token(String.valueOf('='), 1);
    public static final int TYPE_LITERAL = 3;
    public static final int TYPE_EOF = -1;
    public static final Token TOKEN_EOF_OBJECT = new Token("EOF", -1);
    private static final char TOKEN_COMMA = ',';
    private static final char TOKEN_BKSLASH = '\\';
    private static final char TOKEN_DQUOTE = '\"';
    private static final char TOKEN_SQUOTE = '\'';
    private final List<Token> tokenList = new ArrayList<Token>();
    private int tokenPosition = 0;
    private String propertyString;
    private int position = 0;
    private Logger logger;
    private ArrayList<String> propertyList = null;
    private Hashtable<String, String> propertyKeyValue = null;

    public PropertyTokenizer(String propertyString, Logger logger) {
        if (propertyString == null) {
            throw new NullPointerException("propertyString");
        }
        this.propertyString = propertyString;
        this.logger = logger;
    }

    public void parse() {
        int length = this.propertyString.length();
        while (this.position < length) {
            char ch = this.propertyString.charAt(this.position);
            if (!this.isWhiteSpace(ch)) {
                switch (ch) {
                    case ';': {
                        this.tokenList.add(TOKEN_KEY_START_OBJECT);
                        break;
                    }
                    case '=': {
                        this.tokenList.add(TOKEN_KEY_END_OBJECT);
                        break;
                    }
                    case '(': {
                        this.tokenList.add(TOKEN_BRACE_START_OBJECT);
                        break;
                    }
                    case ')': {
                        this.tokenList.add(TOKEN_BRACE_END_OBJECT);
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case ',': 
                    case '\\': {
                        break;
                    }
                    default: {
                        String literal = this.parseLiteral();
                        this.addToken(literal, 3);
                    }
                }
            }
            ++this.position;
        }
        this.tokenList.add(TOKEN_EOF_OBJECT);
        this.logger.debug("[PropertyTokenizer - parse]: tokenList :" + this.tokenList);
        this.parseTokenDetails();
    }

    public void parse(boolean saphana) {
        int length = this.propertyString.length();
        while (this.position < length) {
            char ch = this.propertyString.charAt(this.position);
            if (!this.isWhiteSpace(ch)) {
                switch (ch) {
                    case '&': {
                        this.tokenList.add(SAP_TOKEN_KEY_START_OBJECT);
                        break;
                    }
                    case '=': {
                        this.tokenList.add(SAP_TOKEN_KEY_END_OBJECT);
                        break;
                    }
                    case '(': {
                        this.tokenList.add(TOKEN_BRACE_START_OBJECT);
                        break;
                    }
                    case ')': {
                        this.tokenList.add(TOKEN_BRACE_END_OBJECT);
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case ',': 
                    case '\\': {
                        break;
                    }
                    default: {
                        String literal = this.parseLiteral(saphana);
                        this.addToken(literal, 3);
                    }
                }
            }
            ++this.position;
        }
        this.tokenList.add(TOKEN_EOF_OBJECT);
        this.logger.debug("[PropertyTokenizer - parse]: tokenList :" + this.tokenList);
        this.parseTokenDetails();
    }

    private String parseLiteral() {
        Token lastToken;
        String lastLiteral = null;
        boolean isBrace = false;
        int size = this.tokenList.size();
        if (size > 0 && (lastLiteral = (lastToken = this.tokenList.get(size - 1)).getToken()).equals("(")) {
            isBrace = true;
        }
        int start = this.trimLeft();
        int innerbrace = 0;
        this.position = start;
        while (this.position < this.propertyString.length()) {
            char ch = this.propertyString.charAt(this.position);
            if (isBrace) {
                switch (ch) {
                    case '(': {
                        ++innerbrace;
                        break;
                    }
                    case ')': {
                        if (innerbrace == 0) {
                            int end = this.trimRight(this.position);
                            --this.position;
                            return this.propertyString.substring(start, end);
                        }
                        --innerbrace;
                    }
                }
            } else {
                switch (ch) {
                    case ';': 
                    case '=': {
                        int end = this.trimRight(this.position);
                        --this.position;
                        return this.propertyString.substring(start, end);
                    }
                }
            }
            ++this.position;
        }
        int end = this.trimRight(this.position);
        return this.propertyString.substring(start, end);
    }

    private String parseLiteral(boolean saphana) {
        Token lastToken;
        String lastLiteral = null;
        boolean isBrace = false;
        int size = this.tokenList.size();
        if (size > 0 && (lastLiteral = (lastToken = this.tokenList.get(size - 1)).getToken()).equals("(")) {
            isBrace = true;
        }
        int start = this.trimLeft();
        int innerbrace = 0;
        this.position = start;
        while (this.position < this.propertyString.length()) {
            char ch = this.propertyString.charAt(this.position);
            if (isBrace) {
                switch (ch) {
                    case '(': {
                        ++innerbrace;
                        break;
                    }
                    case ')': {
                        if (innerbrace == 0) {
                            int end = this.trimRight(this.position);
                            --this.position;
                            return this.propertyString.substring(start, end);
                        }
                        --innerbrace;
                    }
                }
            } else {
                switch (ch) {
                    case '&': 
                    case '=': {
                        int end = this.trimRight(this.position);
                        --this.position;
                        return this.propertyString.substring(start, end);
                    }
                }
            }
            ++this.position;
        }
        int end = this.trimRight(this.position);
        return this.propertyString.substring(start, end);
    }

    private int trimRight(int index) {
        int end = index;
        while (end > 0) {
            char ch = this.propertyString.charAt(end - 1);
            if (!this.isWhiteSpace(ch)) {
                return end;
            }
            --end;
        }
        return end;
    }

    private int trimLeft() {
        int length = this.propertyString.length();
        int start = this.position;
        while (start < length) {
            char ch = this.propertyString.charAt(start);
            if (!this.isWhiteSpace(ch)) {
                return start;
            }
            ++start;
        }
        return start;
    }

    private void addToken(String tokenString, int type) {
        Token token = new Token(tokenString, type);
        this.tokenList.add(token);
    }

    private boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    public ArrayList<String> getPropertyNames() {
        return this.propertyList;
    }

    public Hashtable<String, String> getAllPropertyKeyValues() {
        return this.propertyKeyValue;
    }

    private void parseTokenDetails() {
        if (this.tokenList != null && this.tokenList.size() > 0) {
            int size = this.tokenList.size();
            int count = 0;
            Token token = null;
            String keyString = "";
            String valueString = "";
            boolean equalsymbol = false;
            this.propertyList = new ArrayList();
            this.propertyKeyValue = new Hashtable();
            while (count < size) {
                token = this.tokenList.get(count);
                int type = token.getType();
                String literalString = token.getToken();
                switch (type) {
                    case -1: {
                        if (keyString.length() > 0 && valueString.length() > 0) {
                            this.logger.debug("[PropertyTokenizer - parseTokenDetails ] Key :" + keyString + " = " + valueString);
                            this.propertyList.add(keyString);
                            this.propertyKeyValue.put(keyString, valueString);
                        }
                        return;
                    }
                    case 0: {
                        if (keyString.length() > 0 && valueString.length() > 0) {
                            this.logger.debug("[PropertyTokenizer - parseTokenDetails ] Key :" + keyString + " = " + valueString);
                            this.propertyList.add(keyString);
                            this.propertyKeyValue.put(keyString, valueString);
                        }
                        equalsymbol = false;
                        keyString = "";
                        valueString = "";
                        break;
                    }
                    case 1: {
                        equalsymbol = true;
                        break;
                    }
                    case 3: {
                        if (equalsymbol) {
                            valueString = String.valueOf(valueString) + literalString;
                            break;
                        }
                        keyString = literalString;
                        break;
                    }
                    case 4: 
                    case 5: {
                        valueString = String.valueOf(valueString) + literalString;
                    }
                }
                ++count;
            }
        }
    }
}

