/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.PropertyTokenizer;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SybaseDatabaseInfo
extends BaseDatabaseInfo {
    private static final String URL_PREFIX = "jdbc:sybase:Tds:";
    private static final String JTDS_URL_PREFIX = "jdbc:jtds:sybase://";
    private static final String WEBLOGIC_URL_PREFIX = "jdbc:weblogic:sybase://";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:sybase://";
    private static final String DEFAULT_PORT = "5000";
    private static final String TDS_DEFAULT_PORT = "7100";
    private static final String SYBASE = "Sybase";

    public SybaseDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> sybaseDataBaseDetails = new Hashtable<String, String>();
        if (this.isParsingFailure) {
            sybaseDataBaseDetails.put("SERVERTYPE", SYBASE);
            sybaseDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            sybaseDataBaseDetails.put("DATABASENAME", "-");
            sybaseDataBaseDetails.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            sybaseDataBaseDetails.put("SERVERTYPE", SYBASE);
            sybaseDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            sybaseDataBaseDetails.put("DATABASENAME", "-");
            sybaseDataBaseDetails.put("PORTNUMBER", "-");
        } else {
            sybaseDataBaseDetails.put("SERVERTYPE", this.dbType);
            sybaseDataBaseDetails.put("SERVERNAME", this.hostName);
            sybaseDataBaseDetails.put("DATABASENAME", this.databaseName);
            sybaseDataBaseDetails.put("PORTNUMBER", this.portNo);
        }
        return sybaseDataBaseDetails;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + " - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String normalizedUrl = this.jdbcUrl.toLowerCase();
            StringMaker maker = new StringMaker(normalizedUrl);
            if (normalizedUrl.startsWith(URL_PREFIX)) {
                this.isParsingFailure = true;
            } else if (normalizedUrl.startsWith(JTDS_URL_PREFIX)) {
                maker.after(JTDS_URL_PREFIX);
                this.parseJtdsUrl(maker, TDS_DEFAULT_PORT);
            } else if (normalizedUrl.startsWith(WEBLOGIC_URL_PREFIX)) {
                maker.after(WEBLOGIC_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else if (normalizedUrl.startsWith(DATADIRECT_URL_PREFIX)) {
                maker.after(DATADIRECT_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.dbType + " - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
        this.logger.debug("[" + this.dbType + " -parseUrl] hostName :" + this.hostName + " portNo :" + this.portNo + " databaseName :" + this.databaseName);
    }

    private void parseJtdsUrl(StringMaker maker, String defaultPort) {
        StringMaker before = maker.after("//").before(';');
        String hostAndPortAndDataBaseString = before.value();
        String propertyString = maker.next().value();
        this.logger.debug("[" + this.dbType + " - parseJtdsUrl] hostAndPortAndDataBaseString : " + hostAndPortAndDataBaseString + "  maker :" + maker + " PropertyString :" + propertyString);
        String hostAndPortString = null;
        int databaseIdIndex = hostAndPortAndDataBaseString.indexOf(47);
        if (databaseIdIndex != -1) {
            hostAndPortString = hostAndPortAndDataBaseString.substring(0, databaseIdIndex);
            this.databaseName = hostAndPortAndDataBaseString.substring(databaseIdIndex + 1, hostAndPortAndDataBaseString.length());
        } else {
            hostAndPortString = hostAndPortAndDataBaseString;
        }
        if (hostAndPortString != null && hostAndPortString.length() > 0) {
            this.assignHostNameAndPort(hostAndPortString, TDS_DEFAULT_PORT);
        }
        if (propertyString != null && propertyString.length() > 1) {
            PropertyTokenizer propertyTokenizer = new PropertyTokenizer(propertyString, this.logger);
            propertyTokenizer.parse();
            ArrayList<String> propertyList = propertyTokenizer.getPropertyNames();
            if (propertyList != null && propertyList.size() > 0) {
                Hashtable<String, String> properties = propertyTokenizer.getAllPropertyKeyValues();
                int i = 0;
                while (i < propertyList.size()) {
                    String propertyName = propertyList.get(i);
                    if (propertyName.equals("databasename")) {
                        this.databaseName = properties.get(propertyName);
                    }
                    ++i;
                }
            }
        }
        if (this.portNo == null) {
            this.portNo = defaultPort;
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
    }

    public static void main(String[] a) {
        String jdbcUrl = "jdbc:jtds:sybase://neptune.acme.com:7100/test";
        jdbcUrl = "jdbc:jtds:sybase://neptune.acme.com/test";
        jdbcUrl = "jdbc:jtds:sybase://[::1]/SAMPLE";
        SybaseDatabaseInfo databaseInfo = new SybaseDatabaseInfo(jdbcUrl, "SybaseDb_Server", null);
        Hashtable<String, String> result = databaseInfo.getDBInfo();
        System.out.println(" result :" + result);
    }
}

