/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.URLPatternData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public final class URLPatternMeasure {
    boolean modified = false;
    private String pName;
    private Hashtable pMeasureHT;
    private static final Double defaultMeasure = new Double(0.0);
    private final List<Double> defaultPatternData = new ArrayList<Double>();
    private double averageResponseTime = 0.0;
    private static final String ERROR_URL_EXISTS = "ERROR_URL_EXISTS";
    private int old_measure_count = 18;
    private static final String PATTERN_DATA = "patternData";
    private static final String SLOW_URL_LISTS = "SlowURLLists";
    private static final String ERROR_URL_LISTS = "ErrorURLLists";
    private static final String ALL_URL_LISTS = "AllURLLists";
    private static final String STALLED_URL_LISTS = "StalledURLLists";
    private static final String SLOWURL_THREAD_LISTS = "SlowURLThreadLists";
    private static final String ERRORURL_THREAD_LISTS = "ErrorURLThreadLists";
    private static final String STALLEDURL_THREAD_LISTS = "StalledURLThreadLists";
    private static final String HEALTHYURL_THREAD_LISTS = "HealthyURLThreadLists";
    private static final String HYPEN_STRING = "-";
    protected static String logPrefix = "URLPatternMeasure";
    protected static String loggerDispStr = "[" + logPrefix + "]";
    PropsManager propsManager;

    public URLPatternMeasure(PropsManager propsManager) {
        this.propsManager = propsManager;
        this.pName = "SUMMARY_PATTERN";
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(this.pName, this.defaultPatternData);
        for (int i = 0; i < propsManager.getSubCompNameLength(); ++i) {
            this.defaultPatternData.add(defaultMeasure);
            this.defaultPatternData.add(defaultMeasure);
        }
    }

    public URLPatternMeasure(String string, PropsManager propsManager) {
        this.propsManager = propsManager;
        this.pName = string;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(PATTERN_DATA, this.defaultPatternData);
        this.pMeasureHT.put(SLOW_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERROR_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ALL_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLED_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(SLOWURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERRORURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, HYPEN_STRING);
    }

    public Hashtable getMeasureTbl() {
        Hashtable hashtable = (Hashtable)this.pMeasureHT.clone();
        this.modified = false;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put(PATTERN_DATA, this.defaultPatternData);
        this.pMeasureHT.put(SLOW_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERROR_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ALL_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLED_URL_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(SLOWURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(ERRORURL_THREAD_LISTS, HYPEN_STRING);
        this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, HYPEN_STRING);
        return hashtable;
    }

    private void getBackWardCompatibalityResult(ArrayList arrayList) {
        int n = arrayList.size();
        if (n > this.old_measure_count) {
            for (int i = n - 1; i >= this.old_measure_count; --i) {
                arrayList.remove(i);
            }
        }
    }

    public Hashtable getSummaryMeasures() {
        Hashtable hashtable = (Hashtable)this.pMeasureHT.clone();
        this.modified = false;
        this.pMeasureHT = new Hashtable();
        this.pMeasureHT.put("SUMMARY_PATTERN", this.defaultPatternData);
        return hashtable;
    }

    public boolean isErrorURLExists() {
        boolean bl = false;
        if (this.pMeasureHT != null) {
            bl = this.pMeasureHT.containsKey(ERROR_URL_EXISTS);
        }
        return bl;
    }

    public void update(URLPatternData uRLPatternData, URLPatternMeasure uRLPatternMeasure, boolean bl) {
        this.modified = true;
        ArrayList arrayList = (ArrayList)uRLPatternMeasure.pMeasureHT.get("SUMMARY_PATTERN");
        if (this.pMeasureHT.containsKey(PATTERN_DATA)) {
            ArrayList arrayList2 = (ArrayList)this.pMeasureHT.get(PATTERN_DATA);
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            for (int i = 0; i < uRLPatternData.numOf.length; ++i) {
                double d = uRLPatternData.numOf[i];
                double d2 = uRLPatternData.sumOf[i];
                double d3 = 0.0;
                double d4 = 0.0;
                try {
                    d3 = (Double)arrayList2.get(i * 2);
                    d4 = (Double)arrayList2.get(i * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                arrayList3.add(new Double(d3 + d));
                arrayList3.add(new Double(d4 + d2));
                double d5 = 0.0;
                double d6 = 0.0;
                try {
                    d5 = (Double)arrayList.get(i * 2);
                    d6 = (Double)arrayList.get(i * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                arrayList4.add(new Double(d5 + d));
                arrayList4.add(new Double(d6 + d2));
            }
            this.pMeasureHT.put(PATTERN_DATA, arrayList3);
            uRLPatternMeasure.pMeasureHT.put("SUMMARY_PATTERN", arrayList4);
            if (bl) {
                this.calculateAverage(arrayList3);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Counter: {} {}  Avg.Response : {} ", new Object[]{loggerDispStr, this.pName, arrayList3, this.averageResponseTime});
            }
        } else {
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            ArrayList<Double> arrayList6 = new ArrayList<Double>();
            for (int i = 0; i < uRLPatternData.numOf.length; ++i) {
                double d = uRLPatternData.numOf[i];
                double d7 = uRLPatternData.sumOf[i];
                arrayList5.add(d);
                arrayList5.add(d7);
                double d8 = 0.0;
                double d9 = 0.0;
                try {
                    d8 = (Double)arrayList.get(i * 2);
                    d9 = (Double)arrayList.get(i * 2 + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                arrayList6.add(new Double(d8 + d));
                arrayList6.add(new Double(d9 + d7));
            }
            this.pMeasureHT.put(PATTERN_DATA, arrayList5);
            uRLPatternMeasure.pMeasureHT.put("SUMMARY_PATTERN", arrayList6);
            if (bl) {
                this.calculateAverage(arrayList5);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Counter: {} {}  Avg.Response : {} ", new Object[]{loggerDispStr, this.pName, arrayList5, this.averageResponseTime});
            }
        }
        this.calculateSlowURLDetails(uRLPatternData);
        this.calculateErrorURLDetails(uRLPatternData);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} update() URL - {}   Avg. Response time {}ms & Node ID : {}, PropsManager.isTraceHealthyURL() {}", new Object[]{loggerDispStr, this.pName, this.averageResponseTime, this.propsManager.getNodeID(), this.propsManager.isTraceHealthyURL()});
        if (this.propsManager.isTraceHealthyURL()) {
            this.calculateAllURLDetails(uRLPatternData);
        }
        this.calculateStalledURLDetails(uRLPatternData);
    }

    private void calculateAverage(ArrayList arrayList) {
        double d = (Double)arrayList.get(0);
        if (d > 0.0) {
            double d2 = (Double)arrayList.get(1);
            this.averageResponseTime = d2 / d;
        }
    }

    private void calculateStalledURLDetails(URLPatternData uRLPatternData) {
        ArrayList<MethodInfo> arrayList = null;
        boolean bl = false;
        Object v = this.pMeasureHT.get(STALLED_URL_LISTS);
        if (v != null && v instanceof ArrayList && (arrayList = (ArrayList<MethodInfo>)v) != null && arrayList.size() > 0) {
            bl = true;
        }
        ArrayList arrayList2 = null;
        int n = 0;
        if (uRLPatternData.getStalledURLsList() != null) {
            int n2;
            if (arrayList == null) {
                arrayList = new ArrayList<MethodInfo>();
            }
            arrayList2 = (ArrayList)uRLPatternData.getStalledURLsList().clone();
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList2.get(n2);
                    arrayList.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating stalledUrlList {} ", (Object)loggerDispStr, (Object)exception);
                    break;
                }
            }
            if (bl) {
                Collections.sort(arrayList, new BTMUrlComparator());
                n2 = arrayList.size();
                int n3 = this.propsManager.getMaxStalledURLs();
                if (n2 > n3) {
                    for (int i = n2 - 1; i >= n3; --i) {
                        arrayList.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(STALLED_URL_LISTS, arrayList);
        }
        arrayList2 = null;
        uRLPatternData.cleanStalledURLsList();
        ArrayList<MethodInfo> arrayList3 = null;
        boolean bl2 = false;
        Object v2 = this.pMeasureHT.get(STALLEDURL_THREAD_LISTS);
        if (v2 != null && v2 instanceof ArrayList && (arrayList3 = (ArrayList<MethodInfo>)v2) != null && arrayList3.size() > 0) {
            bl2 = true;
        }
        ArrayList arrayList4 = null;
        int n4 = 0;
        if (uRLPatternData.getStalledTHREADsList() != null) {
            int n5;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<MethodInfo>();
            }
            arrayList4 = (ArrayList)uRLPatternData.getStalledTHREADsList().clone();
            n4 = arrayList4.size();
            for (n5 = 0; n5 < n4; ++n5) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList4.get(n5);
                    arrayList3.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating stalledThreadList {}", (Object)loggerDispStr, (Object)exception);
                    break;
                }
            }
            if (bl2) {
                Collections.sort(arrayList3, new BTMUrlComparator());
                n5 = arrayList3.size();
                int n6 = this.propsManager.getMaxSlowURLs();
                if (n5 > n6) {
                    for (int i = n5 - 1; i >= n6; --i) {
                        arrayList3.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(STALLEDURL_THREAD_LISTS, arrayList3);
        }
        arrayList4 = null;
        uRLPatternData.cleanStalledTHREADsList();
    }

    private void calculateSlowURLDetails(URLPatternData uRLPatternData) {
        ArrayList<MethodInfo> arrayList = null;
        boolean bl = false;
        Object v = this.pMeasureHT.get(SLOW_URL_LISTS);
        if (v != null && v instanceof ArrayList && (arrayList = (ArrayList<MethodInfo>)v) != null && arrayList.size() > 0) {
            bl = true;
        }
        ArrayList arrayList2 = null;
        int n = 0;
        if (uRLPatternData.getSlowURLsList() != null) {
            int n2;
            if (arrayList == null) {
                arrayList = new ArrayList<MethodInfo>();
            }
            arrayList2 = (ArrayList)uRLPatternData.getSlowURLsList().clone();
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList2.get(n2);
                    arrayList.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating slowUrlList{} ", (Object)loggerDispStr, (Object)exception);
                    break;
                }
            }
            arrayList2 = null;
            uRLPatternData.cleanSlowURLsList();
            if (bl) {
                Collections.sort(arrayList, new BTMUrlComparator());
                n2 = arrayList.size();
                int n3 = this.propsManager.getMaxSlowURLs();
                if (n2 > n3) {
                    for (int i = n2 - 1; i >= n3; --i) {
                        arrayList.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(SLOW_URL_LISTS, arrayList);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} calculateSlowURLDetails- SLOW_URL_LISTS : ", (Object)loggerDispStr);
        }
        ArrayList<MethodInfo> arrayList3 = null;
        boolean bl2 = false;
        Object v2 = this.pMeasureHT.get(SLOWURL_THREAD_LISTS);
        if (v2 != null && v2 instanceof ArrayList && (arrayList3 = (ArrayList<MethodInfo>)v2) != null && arrayList3.size() > 0) {
            bl2 = true;
        }
        ArrayList arrayList4 = null;
        int n4 = 0;
        if (uRLPatternData.getSlowTHREADsList() != null) {
            int n5;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<MethodInfo>();
            }
            arrayList4 = (ArrayList)uRLPatternData.getSlowTHREADsList().clone();
            n4 = arrayList4.size();
            for (n5 = 0; n5 < n4; ++n5) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList4.get(n5);
                    arrayList3.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating slowUrlList {} ", (Object)loggerDispStr, (Object)exception);
                    break;
                }
            }
            if (bl2) {
                Collections.sort(arrayList3, new BTMUrlComparator());
                n5 = arrayList3.size();
                int n6 = this.propsManager.getMaxSlowURLs();
                if (n5 > n6) {
                    for (int i = n5 - 1; i >= n6; --i) {
                        arrayList3.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(SLOWURL_THREAD_LISTS, arrayList3);
        }
        arrayList4 = null;
        uRLPatternData.cleanSlowTHREADsList();
    }

    private void calculateErrorURLDetails(URLPatternData uRLPatternData) {
        ArrayList<MethodInfo> arrayList = null;
        boolean bl = false;
        Object v = this.pMeasureHT.get(ERROR_URL_LISTS);
        if (v != null && v instanceof ArrayList && (arrayList = (ArrayList<MethodInfo>)v) != null && arrayList.size() > 0) {
            bl = true;
        }
        ArrayList arrayList2 = null;
        int n = 0;
        if (uRLPatternData.getErrorURLsList() != null) {
            int n2;
            if (arrayList == null) {
                arrayList = new ArrayList<MethodInfo>();
            }
            arrayList2 = (ArrayList)uRLPatternData.getErrorURLsList().clone();
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList2.get(n2);
                    arrayList.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating errorUrlList {}", (Object)loggerDispStr, (Object)exception);
                    break;
                }
            }
            if (bl) {
                Collections.sort(arrayList, new BTMUrlComparator());
                n2 = arrayList.size();
                int n3 = this.propsManager.getMaxErrorURLs();
                if (n2 > n3) {
                    for (int i = n2 - 1; i >= n3; --i) {
                        arrayList.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(ERROR_URL_LISTS, arrayList);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} calculateErrorURLDetails - ERROR_URL_LISTS : ", (Object)loggerDispStr);
            if (arrayList.size() > 0) {
                this.pMeasureHT.put(ERROR_URL_EXISTS, ERROR_URL_EXISTS);
            }
        }
        arrayList2 = null;
        uRLPatternData.cleanErrorURLsList();
        ArrayList<MethodInfo> arrayList3 = null;
        boolean bl2 = false;
        Object v2 = this.pMeasureHT.get(ERRORURL_THREAD_LISTS);
        if (v2 != null && v2 instanceof ArrayList && (arrayList3 = (ArrayList<MethodInfo>)v2) != null && arrayList3.size() > 0) {
            bl2 = true;
        }
        ArrayList arrayList4 = null;
        int n4 = 0;
        if (uRLPatternData.getErrorTHREADsList() != null) {
            int n5;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<MethodInfo>();
            }
            arrayList4 = (ArrayList)uRLPatternData.getErrorTHREADsList().clone();
            n4 = arrayList4.size();
            for (n5 = 0; n5 < n4; ++n5) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList4.get(n5);
                    arrayList3.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating errorThreadList {}", (Object)loggerDispStr, (Object)exception);
                    break;
                }
            }
            if (bl2) {
                Collections.sort(arrayList3, new BTMUrlComparator());
                n5 = arrayList3.size();
                int n6 = this.propsManager.getMaxErrorURLs();
                if (n5 > n6) {
                    for (int i = n5 - 1; i >= n6; --i) {
                        arrayList3.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(ERRORURL_THREAD_LISTS, arrayList3);
        }
        arrayList4 = null;
        uRLPatternData.cleanErrorTHREADsList();
    }

    private void calculateAllURLDetails(URLPatternData uRLPatternData) {
        ArrayList<MethodInfo> arrayList = null;
        boolean bl = false;
        Object v = this.pMeasureHT.get(ALL_URL_LISTS);
        if (v != null && v instanceof ArrayList && (arrayList = (ArrayList<MethodInfo>)v) != null && arrayList.size() > 0) {
            bl = true;
        }
        ArrayList arrayList2 = null;
        int n = 0;
        if (uRLPatternData.getAllURLsList() != null) {
            int n2;
            if (arrayList == null) {
                arrayList = new ArrayList<MethodInfo>();
            }
            arrayList2 = (ArrayList)uRLPatternData.getAllURLsList().clone();
            n = arrayList2.size();
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList2.get(n2);
                    arrayList.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating AllUrlList {}", (Object)loggerDispStr, (Object)exception);
                    break;
                }
            }
            if (bl) {
                Collections.sort(arrayList, new BTMUrlComparator());
                n2 = arrayList.size();
                int n3 = this.propsManager.getHelathyURLs();
                if (n2 > n3) {
                    int n4 = 0;
                    while (arrayList.size() > n3) {
                        arrayList.remove(0);
                        ++n4;
                    }
                }
            }
            this.pMeasureHT.put(ALL_URL_LISTS, arrayList);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} calculateAllURLDetails - ALL_URL_LISTS : ", (Object)loggerDispStr);
        }
        arrayList2 = null;
        uRLPatternData.cleanAllURLsList();
        ArrayList<MethodInfo> arrayList3 = null;
        boolean bl2 = false;
        Object v2 = this.pMeasureHT.get(HEALTHYURL_THREAD_LISTS);
        if (v2 != null && v2 instanceof ArrayList && (arrayList3 = (ArrayList<MethodInfo>)v2) != null && arrayList3.size() > 0) {
            bl2 = true;
        }
        ArrayList arrayList4 = null;
        int n5 = 0;
        if (uRLPatternData.getHealthyThreadList() != null) {
            int n6;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<MethodInfo>();
            }
            arrayList4 = (ArrayList)uRLPatternData.getHealthyThreadList().clone();
            n5 = arrayList4.size();
            for (n6 = 0; n6 < n5; ++n6) {
                try {
                    MethodInfo methodInfo = (MethodInfo)arrayList4.get(n6);
                    arrayList3.add(methodInfo);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while iterating helathyThreadList {}", (Object)loggerDispStr, (Object)exception);
                    break;
                }
            }
            if (bl2) {
                Collections.sort(arrayList3, new BTMUrlComparator());
                n6 = arrayList3.size();
                int n7 = this.propsManager.getHelathyURLs();
                if (n6 > n7) {
                    for (int i = n6 - 1; i >= n7; --i) {
                        arrayList3.remove(i);
                    }
                }
            }
            this.pMeasureHT.put(HEALTHYURL_THREAD_LISTS, arrayList3);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} calculateAllURLDetails - HEALTHYURL_THREAD_LISTS : ", (Object)loggerDispStr);
        }
        arrayList4 = null;
        uRLPatternData.cleanHealthyThreadList();
    }

    public String toString() {
        ArrayList arrayList;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("URLPatternMeasure for pattern ").append(this.pName).append("\n");
        stringBuilder.append("'modified' flag is  ").append(this.modified).append("\n");
        ArrayList arrayList2 = (ArrayList)this.pMeasureHT.get(PATTERN_DATA);
        if (arrayList2 != null) {
            stringBuilder.append(arrayList2.toString()).append("\n");
        } else {
            stringBuilder.append("No measures\n");
        }
        ArrayList arrayList3 = (ArrayList)this.pMeasureHT.get(ALL_URL_LISTS);
        int n = 0;
        if (arrayList3 != null) {
            n = arrayList3.size();
            stringBuilder.append("All URL List Size: ").append(n).append(" \n");
        } else {
            stringBuilder.append("No All URLs for this pattern.\n");
        }
        ArrayList arrayList4 = (ArrayList)this.pMeasureHT.get(SLOW_URL_LISTS);
        if (arrayList4 != null) {
            if (arrayList4.size() > 0) {
                stringBuilder.append("Slow URL List: \n");
                for (int i = 0; i < arrayList4.size(); ++i) {
                    ArrayList arrayList5 = (ArrayList)arrayList4.get(i);
                    stringBuilder.append("Slow URL ").append(i).append(" : ").append(arrayList5.toString());
                }
            } else {
                stringBuilder.append("No Slow URLs for this pattern.\n");
            }
        }
        if ((arrayList = (ArrayList)this.pMeasureHT.get(ERROR_URL_LISTS)) != null) {
            if (arrayList.size() > 0) {
                stringBuilder.append("Error URL List: \n");
                for (int i = 0; i < arrayList.size(); ++i) {
                    ArrayList arrayList6 = (ArrayList)arrayList.get(i);
                    stringBuilder.append("Error URL ").append(i).append(" : ").append(arrayList6.toString());
                }
            } else {
                stringBuilder.append("No Error URLs for this pattern.\n");
            }
        }
        stringBuilder.append("*******************************************************************************************");
        return stringBuilder.toString();
    }

    public double getAverageResponseTime() {
        return this.averageResponseTime;
    }

    void modifyDefaultPatternData() {
        int n = this.defaultPatternData.size();
        if (n > this.old_measure_count) {
            for (int i = n - 1; i >= this.old_measure_count; --i) {
                this.defaultPatternData.remove(i);
            }
        }
    }

    void updateDefaultPatternData() {
        int n = this.defaultPatternData.size();
        URLPatternMeasure uRLPatternMeasure = this;
        int n2 = uRLPatternMeasure.propsManager.getSubCompNameLength() * 2 - n;
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                this.defaultPatternData.add(defaultMeasure);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BTMUrlComparator
    implements Comparator<MethodInfo> {
        BTMUrlComparator() {
        }

        @Override
        public int compare(MethodInfo methodInfo, MethodInfo methodInfo2) {
            Long l = new Long(0L);
            if (methodInfo != null) {
                l = methodInfo.getExecutionTime();
            }
            Long l2 = new Long(0L);
            if (methodInfo2 != null) {
                l2 = methodInfo2.getExecutionTime();
            }
            return l2.compareTo(l);
        }
    }
}

