/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm.sampling;

import java.util.HashMap;

public class SamplingFilter {
    private String[] includeMethods;
    private String[] excludeMethods;
    private boolean baseMethodVisited = false;
    private static HashMap<String, Boolean> packageConfig = new HashMap();

    public SamplingFilter(String[] stringArray, String[] stringArray2) {
        this.includeMethods = stringArray;
        this.excludeMethods = stringArray2;
        SamplingFilter.compileConfig(this.includeMethods, true);
        SamplingFilter.compileConfig(this.excludeMethods, false);
    }

    public static void compileConfig(String[] stringArray, boolean bl) {
        for (String string : stringArray) {
            if (string.equals("")) continue;
            if (string.endsWith(".*")) {
                string = string.substring(0, string.length() - 1);
                packageConfig.put(string, bl);
                continue;
            }
            if (string.startsWith("*.")) {
                string = string.substring(1, string.length());
                packageConfig.put(string, bl);
                continue;
            }
            if (string.startsWith("*:")) {
                string = string.substring(1, string.length());
                packageConfig.put(string, bl);
                continue;
            }
            packageConfig.put(string, bl);
        }
    }

    void doneBaseMethodVisited() {
        this.baseMethodVisited = false;
    }

    boolean filter(String string, StackTraceElement stackTraceElement) {
        if (!this.baseMethodVisited) {
            String string2 = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
            if (string2.trim().equals(string.trim())) {
                this.baseMethodVisited = true;
                return true;
            }
            return false;
        }
        return this.matchPackages(stackTraceElement);
    }

    boolean matchPackages(StackTraceElement stackTraceElement) {
        int n;
        String string = stackTraceElement.getClassName();
        String string2 = stackTraceElement.getMethodName();
        String string3 = string + ":" + string2;
        if (packageConfig.get(string3) != null) {
            return packageConfig.get(string3);
        }
        if (packageConfig.get(string) != null) {
            return packageConfig.get(string);
        }
        if (packageConfig.get(":" + string2) != null) {
            return packageConfig.get(":" + string2);
        }
        String[] stringArray = string.split("\\.");
        String string4 = "";
        for (n = 0; n < stringArray.length; ++n) {
            string4 = string4 + stringArray[n];
            if (n < stringArray.length - 1) {
                string4 = string4 + ".";
            }
            if (packageConfig.get(string4) == null) continue;
            return packageConfig.get(string4);
        }
        string4 = "";
        for (n = stringArray.length - 1; n >= 0; --n) {
            string4 = string4 + ".";
            if (packageConfig.get(string4 = string4 + stringArray[n]) == null) continue;
            return packageConfig.get(string4);
        }
        if (packageConfig.get(string4 = string4 + ":" + string2) != null) {
            return packageConfig.get(string4);
        }
        return true;
    }

    boolean matchMethodEquals(String[] stringArray, StackTraceElement stackTraceElement) {
        for (String string : stringArray) {
            if (!stackTraceElement.getMethodName().equals(string)) continue;
            return true;
        }
        return false;
    }
}

