/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.ireasoning.protocol.snmp.MibUtil;
import com.ireasoning.util.MibParseException;
import com.ireasoning.util.MibTreeNode;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class mibparser {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: \njava mibparser mibFileName\njava mibparser mibFileNamesSeparatedByComma");
            return;
        }
        String string = stringArray[0];
        String[] stringArray2 = mibparser.parseFileNames(string);
        MibTreeNode mibTreeNode = null;
        try {
            mibTreeNode = MibUtil.parseMibs((String[])stringArray2, (boolean)false);
        }
        catch (MibParseException mibParseException) {
            System.out.println((Object)mibParseException);
            mibParseException.printStackTrace();
            System.out.println("error module name:" + mibParseException.getMibModuleName());
            return;
        }
        catch (Exception exception) {
            System.out.println("Error occurs when loading MIB:" + string);
            System.out.println(exception);
            exception.printStackTrace();
            return;
        }
        ToolTipTreeNode toolTipTreeNode = mibparser.convertToJTreeNode(mibTreeNode);
        JTree jTree = new JTree(toolTipTreeNode){

            public String getToolTipText(MouseEvent mouseEvent) {
                if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) == -1) {
                    return null;
                }
                TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                return ((ToolTipTreeNode)treePath.getLastPathComponent()).getToolTipText();
            }
        };
        jTree.setToolTipText("");
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MibTreeNode mibTreeNode = ((ToolTipTreeNode)treeSelectionEvent.getPath().getLastPathComponent()).getMibTreeNode();
                jTextArea.setText(mibTreeNode.toString());
                jTextArea.setCaretPosition(0);
            }
        };
        jTree.addTreeSelectionListener(treeSelectionListener);
        JSplitPane jSplitPane = new JSplitPane(0, new JScrollPane(jTree), new JScrollPane(jTextArea));
        jSplitPane.setDividerSize(3);
        jSplitPane.setDividerLocation(400);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)jSplitPane, "Center");
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public static ToolTipTreeNode convertToJTreeNode(MibTreeNode mibTreeNode) {
        return mibparser.buildTree(mibTreeNode, null);
    }

    private static ToolTipTreeNode buildTree(MibTreeNode mibTreeNode, ToolTipTreeNode toolTipTreeNode) {
        if (mibTreeNode == null) {
            return null;
        }
        if (toolTipTreeNode == null) {
            toolTipTreeNode = new ToolTipTreeNode(mibTreeNode.getName().toString(), mibTreeNode, mibparser.getNodeTip(mibTreeNode));
        }
        for (MibTreeNode mibTreeNode2 = (MibTreeNode)mibTreeNode.getFirstChild(); mibTreeNode2 != null; mibTreeNode2 = (MibTreeNode)mibTreeNode2.getNextSibling()) {
            ToolTipTreeNode toolTipTreeNode2 = new ToolTipTreeNode(mibTreeNode2.getName().toString(), mibTreeNode2, mibparser.getNodeTip(mibTreeNode2));
            toolTipTreeNode.add(toolTipTreeNode2);
            mibparser.buildTree(mibTreeNode2, toolTipTreeNode2);
        }
        return toolTipTreeNode;
    }

    private static String getNodeTip(MibTreeNode mibTreeNode) {
        String string = mibTreeNode.getOID().toString();
        String string2 = mibTreeNode.getSyntaxType();
        if (string2 != null) {
            string = string + ", type:" + string2;
        } else if (mibTreeNode.isSnmpV2TrapNode()) {
            string = string + ", SNMPv2 Trap Node";
        }
        return string;
    }

    static String[] parseFileNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    static class ToolTipTreeNode
    extends DefaultMutableTreeNode {
        private String toolTipText;
        private MibTreeNode mibTreeNode;

        public ToolTipTreeNode(String string, MibTreeNode mibTreeNode, String string2) {
            super(string);
            this.mibTreeNode = mibTreeNode;
            this.toolTipText = string2;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public MibTreeNode getMibTreeNode() {
            return this.mibTreeNode;
        }
    }
}

