/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.selector;

import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.joran.JoranConfigurator;
import com.eg.ch.qos.logback.classic.selector.ContextSelector;
import com.eg.ch.qos.logback.classic.util.ContextInitializer;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.status.InfoStatus;
import com.eg.ch.qos.logback.core.status.StatusManager;
import com.eg.ch.qos.logback.core.status.StatusUtil;
import com.eg.ch.qos.logback.core.status.WarnStatus;
import com.eg.ch.qos.logback.core.util.JNDIUtil;
import com.eg.ch.qos.logback.core.util.Loader;
import com.eg.ch.qos.logback.core.util.OptionHelper;
import com.eg.ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextJNDISelector
implements ContextSelector {
    private final Map<String, LoggerContext> synchronizedContextMap = Collections.synchronizedMap(new HashMap());
    private final LoggerContext defaultContext;
    private static final ThreadLocal<LoggerContext> threadLocal = new ThreadLocal();

    public ContextJNDISelector(LoggerContext loggerContext) {
        this.defaultContext = loggerContext;
    }

    @Override
    public LoggerContext getDefaultLoggerContext() {
        return this.defaultContext;
    }

    @Override
    public LoggerContext detachLoggerContext(String string) {
        return this.synchronizedContextMap.remove(string);
    }

    @Override
    public LoggerContext getLoggerContext() {
        String string = null;
        Context context = null;
        LoggerContext loggerContext = threadLocal.get();
        if (loggerContext != null) {
            return loggerContext;
        }
        try {
            context = JNDIUtil.getInitialContext();
            string = JNDIUtil.lookup(context, "java:comp/env/logback/context-name");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (OptionHelper.isEmpty(string)) {
            return this.defaultContext;
        }
        LoggerContext loggerContext2 = this.synchronizedContextMap.get(string);
        if (loggerContext2 == null) {
            loggerContext2 = new LoggerContext();
            loggerContext2.setName(string);
            this.synchronizedContextMap.put(string, loggerContext2);
            URL uRL = this.findConfigFileURL(context, loggerContext2);
            if (uRL != null) {
                this.configureLoggerContextByURL(loggerContext2, uRL);
            } else {
                try {
                    new ContextInitializer(loggerContext2).autoConfig();
                }
                catch (JoranException joranException) {
                    // empty catch block
                }
            }
            if (!StatusUtil.contextHasStatusListener(loggerContext2)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings(loggerContext2);
            }
        }
        return loggerContext2;
    }

    private String conventionalConfigFileName(String string) {
        return "logback-" + string + ".xml";
    }

    private URL findConfigFileURL(Context context, LoggerContext loggerContext) {
        StatusManager statusManager = loggerContext.getStatusManager();
        String string = null;
        try {
            string = JNDIUtil.lookup(context, "java:comp/env/logback/configuration-resource");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (string != null) {
            statusManager.add(new InfoStatus("Searching for [" + string + "]", this));
            URL uRL = this.urlByResourceName(statusManager, string);
            if (uRL == null) {
                String string2 = "The jndi resource [" + string + "] for context [" + loggerContext.getName() + "] does not lead to a valid file";
                statusManager.add(new WarnStatus(string2, this));
            }
            return uRL;
        }
        String string3 = this.conventionalConfigFileName(loggerContext.getName());
        return this.urlByResourceName(statusManager, string3);
    }

    private URL urlByResourceName(StatusManager statusManager, String string) {
        statusManager.add(new InfoStatus("Searching for [" + string + "]", this));
        URL uRL = Loader.getResource(string, Loader.getTCL());
        if (uRL != null) {
            return uRL;
        }
        return Loader.getResourceBySelfClassLoader(string);
    }

    private void configureLoggerContextByURL(LoggerContext loggerContext, URL uRL) {
        try {
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            loggerContext.reset();
            joranConfigurator.setContext(loggerContext);
            joranConfigurator.doConfigure(uRL);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings(loggerContext);
    }

    @Override
    public List<String> getContextNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.synchronizedContextMap.keySet());
        return arrayList;
    }

    @Override
    public LoggerContext getLoggerContext(String string) {
        return this.synchronizedContextMap.get(string);
    }

    public int getCount() {
        return this.synchronizedContextMap.size();
    }

    public void setLocalContext(LoggerContext loggerContext) {
        threadLocal.set(loggerContext);
    }

    public void removeLocalContext() {
        threadLocal.remove();
    }
}

