/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.BsonTypeInfo;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoFunctions;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonInt32;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;

@AutoLoggable
public abstract class MongoDatabaseMetaData
implements DatabaseMetaData,
LoggingAspect$ajcMightHaveAspect {
    protected static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    protected static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    protected static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    protected static final String PROCEDURE_TYPE = "PROCEDURE_TYPE";
    protected static final String REMARKS = "REMARKS";
    protected static final String SPECIFIC_NAME = "SPECIFIC_NAME";
    protected static final String FUNCTION_CAT = "FUNCTION_CAT";
    protected static final String FUNCTION_SCHEM = "FUNCTION_SCHEM";
    protected static final String FUNCTION_NAME = "FUNCTION_NAME";
    protected static final String FUNCTION_TYPE = "FUNCTION_TYPE";
    protected static final String AUTO_INCREMENT = "AUTO_INCREMENT";
    protected static final String CASE_SENSITIVE = "CASE_SENSITIVE";
    protected static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    protected static final String COLUMN_DEF = "COLUMN_DEF";
    protected static final String COLUMN_NAME = "COLUMN_NAME";
    protected static final String COLUMN_TYPE = "COLUMN_TYPE";
    protected static final String CREATE_PARAMS = "CREATE_PARAMS";
    protected static final String DATA_TYPE = "DATA_TYPE";
    protected static final String DEFAULT_VALUE = "DEFAULT_VALUE";
    protected static final String DESCRIPTION = "DESCRIPTION";
    protected static final String FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    protected static final String FIX_PREC_SCALE = "FIX_PREC_SCALE";
    protected static final String IS_NULLABLE = "IS_NULLABLE";
    protected static final String LENGTH = "LENGTH";
    protected static final String LITERAL_PREFIX = "LITERAL_PREFIX";
    protected static final String LITERAL_SUFFIX = "LITERAL_SUFFIX";
    protected static final String LOCAL_TYPE_NAME = "LOCAL_TYPE_NAME";
    protected static final String MAXIMUM_SCALE = "MAXIMUM_SCALE";
    protected static final String MAX_LEN = "MAX_LEN";
    protected static final String MINIMUM_SCALE = "MINIMUM_SCALE";
    protected static final String NAME = "NAME";
    protected static final String NULLABLE = "NULLABLE";
    protected static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    protected static final String PRECISION = "PRECISION";
    protected static final String RADIX = "RADIX";
    protected static final String SCALE = "SCALE";
    protected static final String SEARCHABLE = "SEARCHABLE";
    protected static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    protected static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    protected static final String TABLE_TYPE = "TABLE_TYPE";
    protected static final String TYPE_NAME = "TYPE_NAME";
    protected static final String UNSIGNED_ATTRIBUTE = "UNSIGNED_ATTRIBUTE";
    protected static final String TABLE_SCHEM = "TABLE_SCHEM";
    protected static final String TABLE_CATALOG = "TABLE_CATALOG";
    protected static final String SCOPE = "SCOPE";
    protected static final String COLUMN_SIZE = "COLUMN_SIZE";
    protected static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    protected static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    protected static final String PSEUDO_COLUMN = "PSEUDO_COLUMN";
    protected static final String PKTABLE_CAT = "PKTABLE_CAT";
    protected static final String PKTABLE_SCHEM = "PKTABLE_SCHEM";
    protected static final String PKTABLE_NAME = "PKTABLE_NAME";
    protected static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    protected static final String FKTABLE_CAT = "FKTABLE_CAT";
    protected static final String FKTABLE_SCHEM = "FKTABLE_SCHEM";
    protected static final String FKTABLE_NAME = "FKTABLE_NAME";
    protected static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    protected static final String KEY_SEQ = "KEY_SEQ";
    protected static final String UPDATE_RULE = "UPDATE_RULE";
    protected static final String DELETE_RULE = "DELETE_RULE";
    protected static final String FK_NAME = "FK_NAME";
    protected static final String PK_NAME = "PK_NAME";
    protected static final String DEFERRABILITY = "DEFERRABILITY";
    protected static final String TYPE_CAT = "TYPE_CAT";
    protected static final String TYPE_SCHEM = "TYPE_SCHEM";
    protected static final String CLASS_NAME = "CLASS_NAME";
    protected static final String BASE_TYPE = "BASE_TYPE";
    protected static final String SUPERTYPE_CAT = "SUPERTYPE_CAT";
    protected static final String SUPERTYPE_SCHEM = "SUPERTYPE_SCHEM";
    protected static final String SUPERTYPE_NAME = "SUPERTYPE_NAME";
    protected static final String TABLE_CAT = "TABLE_CAT";
    protected static final String TABLE_NAME = "TABLE_NAME";
    protected static final String SUPERTABLE_NAME = "SUPERTABLE_NAME";
    protected static final String ATTR_NAME = "ATTR_NAME";
    protected static final String ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    protected static final String ATTR_SIZE = "ATTR_SIZE";
    protected static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    protected static final String ATTR_DEF = "ATTR_DEF";
    protected static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    protected static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    protected static final String SCOPE_TABLE = "SCOPE_TABLE";
    protected static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    protected static final String COLUMN_USAGE = "COLUMN_USAGE";
    protected static final String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
    protected static final String IS_GENERATEDCOLUMN = "IS_GENERATEDCOLUMN";
    protected static final String SELF_REFERENCING_COL_NAME = "SELF_REFERENCING_COL_NAME";
    protected static final String REF_GENERATION = "REF_GENERATION";
    protected static final String GRANTOR = "GRANTOR";
    protected static final String GRANTEE = "GRANTEE";
    protected static final String PRIVILEGE = "PRIVILEGE";
    protected static final String IS_GRANTABLE = "IS_GRANTABLE";
    protected static final String NON_UNIQUE = "NON_UNIQUE";
    protected static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    protected static final String INDEX_NAME = "INDEX_NAME";
    protected static final String TYPE = "TYPE";
    protected static final String ASC_OR_DESC = "ASC_OR_DESC";
    protected static final String CARDINALITY = "CARDINALITY";
    protected static final String PAGES = "PAGES";
    protected static final String FILTER_CONDITION = "FILTER_CONDITION";
    protected MongoConnection conn;
    protected String serverVersion;
    protected MongoLogger logger;
    protected static final String FUNC_DEFAULT_CATALOG = "def";
    private static final String YES = "YES";
    static final int APPROXIMATE_DOC_SIZE = 0xFFFF28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_82;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_83;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_84;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_85;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_86;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_87;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_88;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_89;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_90;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_91;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_92;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_93;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_94;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_95;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_96;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_97;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_98;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_99;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_100;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_101;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_102;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_103;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_104;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_105;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_106;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_107;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_108;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_109;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_110;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_111;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_112;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_113;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_114;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_115;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_116;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_117;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_118;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_119;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_120;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_121;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_122;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_123;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_124;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_125;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_126;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_127;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_128;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_129;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_130;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_131;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_132;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_133;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_134;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_135;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_136;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_137;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_138;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_139;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_140;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_141;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_142;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_143;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_144;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_145;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_146;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_147;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MongoDatabaseMetaData(MongoConnection conn) {
        LoggingAspect.ajc$perObjectBind(this);
        this.conn = conn;
        MongoLogger mongoLogger = new MongoLogger(this.getClass().getCanonicalName(), conn.getLogger());
        MongoDatabaseMetaData mongoDatabaseMetaData = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoDatabaseMetaData.logger_aroundBody1$advice(this, mongoDatabaseMetaData, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoDatabaseMetaData.logger = mongoLogger;
        }
    }

    public static String escapeString(String value) {
        String escaped = value.replace("'", "''");
        return escaped.replace("\\", "\\\\");
    }

    public static Pattern toJavaPattern(String sqlPattern) {
        return sqlPattern == null ? null : Pattern.compile(sqlPattern.replaceAll("%", ".*").replaceAll("_", "."));
    }

    protected Map<String, BsonValue> getFunctionParameterValues(MongoFunctions.MongoFunction func, int i, String argName, String argType, boolean isReturnColumn) throws SQLException {
        try {
            LinkedHashMap<String, BsonValue> info = new LinkedHashMap<String, BsonValue>();
            BsonTypeInfo bsonTypeInfo = argType == null ? BsonTypeInfo.BSON_UNDEFINED : BsonTypeInfo.getBsonTypeInfoByName(argType);
            info.put(FUNCTION_CAT, new BsonString(FUNC_DEFAULT_CATALOG));
            info.put(FUNCTION_SCHEM, BsonNull.VALUE);
            info.put(FUNCTION_NAME, new BsonString(func.name));
            info.put(COLUMN_NAME, new BsonString(argName));
            info.put(COLUMN_TYPE, this.asBsonIntOrNull(isReturnColumn ? 4 : 1));
            info.put(DATA_TYPE, this.asBsonIntOrNull(bsonTypeInfo.getJdbcType()));
            info.put(TYPE_NAME, new BsonString(bsonTypeInfo == BsonTypeInfo.BSON_UNDEFINED ? "" : bsonTypeInfo.getBsonName()));
            info.put(PRECISION, this.asBsonIntOrNull(bsonTypeInfo.getPrecision()));
            info.put(LENGTH, this.asBsonIntOrDefault(bsonTypeInfo.getFixedBytesLength(), 0));
            info.put(SCALE, this.asBsonIntOrNull(bsonTypeInfo.getDecimalDigits()));
            info.put(RADIX, new BsonInt32(bsonTypeInfo.getNumPrecRadix()));
            info.put(NULLABLE, new BsonInt32(1));
            info.put(REMARKS, new BsonString(func.comment));
            info.put(CHAR_OCTET_LENGTH, this.asBsonIntOrNull(bsonTypeInfo.getCharOctetLength()));
            info.put(ORDINAL_POSITION, new BsonInt32(i));
            info.put(IS_NULLABLE, new BsonString(YES));
            info.put(SPECIFIC_NAME, new BsonString(func.name));
            return info;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_1, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_2, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_3, this, this));
            }
            return this.conn.getURL();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_4, this, this));
            }
            return this.conn.getUser();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_5, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_6, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_7, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_8, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_9, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_10, this, this));
            }
            return "MongoDB Atlas";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_11, this, this));
            }
            if (this.serverVersion != null) {
                return this.serverVersion;
            }
            this.serverVersion = this.conn.getServerVersion();
            return this.serverVersion;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_12, this, this));
            }
            return "MongoDB Atlas SQL interface JDBC Driver";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_13, this, this));
            }
            return MongoDriver.VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    @Override
    public int getDriverMajorVersion() {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_14, this, this));
            }
            return MongoDriver.MAJOR_VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    @Override
    public int getDriverMinorVersion() {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_15, this, this));
            }
            return MongoDriver.MINOR_VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_16, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_17, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_18, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_19, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_20, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_21, this, this));
            }
            return this.supportsMixedCaseIdentifiers();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_22, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_23, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_24, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_25, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_26, this, this));
            }
            return "`";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_26);
            }
            throw exception;
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_27, this, this));
            }
            return "\\";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_27);
            }
            throw exception;
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_28, this, this));
            }
            return "";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_28);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_29, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_29);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_30, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_30);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_31, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_31);
            }
            throw exception;
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_32, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_32);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_33, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_33);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        int n = fromType;
        int n2 = toType;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_34, this, this, Conversions.intObject(n), Conversions.intObject(n2)));
            }
            switch (toType) {
                case 2003: {
                    return false;
                }
                case -7: 
                case -2: 
                case -1: 
                case 0: 
                case 3: 
                case 4: 
                case 8: 
                case 93: 
                case 2004: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_34);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_35, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_35);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_36, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_36);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_37, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_37);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_38, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_38);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_39, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_39);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_40, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_40);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_41, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_41);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_42, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_42);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_43, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_43);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_44, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_44);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_45, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_45);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_46, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_46);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_47, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_47);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_48, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_48);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_49, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_49);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_50, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_50);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_51, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_51);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_52, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_52);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_53, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_53);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_54, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_54);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_55, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_55);
            }
            throw exception;
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_56, this, this));
            }
            return "schema";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_56);
            }
            throw exception;
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_57, this, this));
            }
            return "procedure";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_57);
            }
            throw exception;
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_58, this, this));
            }
            return "database";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_58);
            }
            throw exception;
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_59, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_59);
            }
            throw exception;
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_60, this, this));
            }
            return ".";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_60);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_61, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_61);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_62, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_62);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_63, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_63);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_64, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_64);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_65, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_65);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_66, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_66);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_67, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_67);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_68, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_68);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_69, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_69);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_70, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_70);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_71, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_71);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_72, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_72);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_73, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_73);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_74, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_74);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_75, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_75);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_76, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_76);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_77, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_77);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_78, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_78);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_79, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_79);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_80, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_80);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_81, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_81);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_82, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_82);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_83, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_83);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_84, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_84);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_85, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_85);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_86, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_86);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_87, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_87);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_88, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_88);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_89, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_89);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_90, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_90);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_91, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_91);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_92, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_92);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_93, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_93);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_94, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_94);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_95, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_95);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_96, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_96);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_97, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_97);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_98, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_98);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_99, this, this));
            }
            return 255;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_99);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_100, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_100);
            }
            throw exception;
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_101, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_101);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_102, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_102);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_103, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_103);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_104, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_104);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_105, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_105);
            }
            throw exception;
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_106, this, this));
            }
            return 0xFFFF28;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_106);
            }
            throw exception;
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_107, this, this));
            }
            return 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_107);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_108, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_108);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        int n = level;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_109, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return level == 0;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_109);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_110, this, this));
            }
            return true;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_110);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_111, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_111);
            }
            throw exception;
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_112, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_112);
            }
            throw exception;
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_113, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_113);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_114, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return type == 1003;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_114);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        int n = type;
        int n2 = concurrency;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_115, this, this, Conversions.intObject(n), Conversions.intObject(n2)));
            }
            return type == 1003 && concurrency == 1007;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_115);
            }
            throw exception;
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_116, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_116);
            }
            throw exception;
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_117, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_117);
            }
            throw exception;
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_118, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_118);
            }
            throw exception;
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_119, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_119);
            }
            throw exception;
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_120, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_120);
            }
            throw exception;
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_121, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_121);
            }
            throw exception;
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_122, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_122);
            }
            throw exception;
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_123, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_123);
            }
            throw exception;
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        int n = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_124, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_124);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_125, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_125);
            }
            throw exception;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_126, this, this));
            }
            return this.conn;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_126);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_127, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_127);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_128, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_128);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_129, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_129);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_130, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_130);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        int n = holdability;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_131, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_131);
            }
            throw exception;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_132, this, this));
            }
            return 1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_132);
            }
            throw exception;
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_133, this, this));
            }
            return MongoDriver.MAJOR_VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_133);
            }
            throw exception;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_134, this, this));
            }
            return MongoDriver.MINOR_VERSION;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_134);
            }
            throw exception;
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_135, this, this));
            }
            return 4;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_135);
            }
            throw exception;
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_136, this, this));
            }
            return 2;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_136);
            }
            throw exception;
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_137, this, this));
            }
            return 2;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_137);
            }
            throw exception;
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_138, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_138);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_139, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_139);
            }
            throw exception;
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_140, this, this));
            }
            return RowIdLifetime.ROWID_UNSUPPORTED;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_140);
            }
            throw exception;
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_141, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_141);
            }
            throw exception;
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_142, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_142);
            }
            throw exception;
        }
    }

    protected BsonValue asBsonIntOrNull(Integer i) {
        try {
            return this.asBsonIntOrDefault(i, null);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_143);
            }
            throw exception;
        }
    }

    protected BsonValue asBsonIntOrDefault(Integer i, Integer defaultVal) {
        try {
            if (i == null) {
                return defaultVal == null ? new BsonNull() : new BsonInt32(defaultVal);
            }
            return new BsonInt32(i);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_144);
            }
            throw exception;
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_145, this, this));
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_145);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Class<?> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_146, (Object)this, (Object)this, clazz));
            }
            return iface.isInstance(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_146);
            }
            throw exception;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Class<T> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_147, (Object)this, (Object)this, clazz));
            }
            return (T)this;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_147);
            }
            throw exception;
        }
    }

    static {
        MongoDatabaseMetaData.ajc$preClinit();
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoDatabaseMetaData ajc$this, MongoDatabaseMetaData target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoDatabaseMetaData.java", MongoDatabaseMetaData.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getFunctionParameterValues", "com.mongodb.jdbc.MongoDatabaseMetaData", "com.mongodb.jdbc.MongoFunctions$MongoFunction:int:java.lang.String:java.lang.String:boolean", "func:i:argName:argType:isReturnColumn", "java.sql.SQLException", "java.util.Map"), 190);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "allProceduresAreCallable", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 236);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabaseProductName", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 281);
        ajc$tjp_100 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxRowSize", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 781);
        ajc$tjp_101 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "doesMaxRowSizeIncludeBlobs", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 786);
        ajc$tjp_102 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxStatementLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 791);
        ajc$tjp_103 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxStatements", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 796);
        ajc$tjp_104 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxTableNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 801);
        ajc$tjp_105 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxTablesInSelect", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 806);
        ajc$tjp_106 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxUserNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 811);
        ajc$tjp_107 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultTransactionIsolation", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 818);
        ajc$tjp_108 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsTransactions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 823);
        ajc$tjp_109 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsTransactionIsolationLevel", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "level", "java.sql.SQLException", "boolean"), 828);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabaseProductVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 286);
        ajc$tjp_110 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsDataDefinitionAndDataManipulationTransactions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 833);
        ajc$tjp_111 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsDataManipulationTransactionsOnly", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 839);
        ajc$tjp_112 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dataDefinitionCausesTransactionCommit", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 844);
        ajc$tjp_113 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "dataDefinitionIgnoredInTransactions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 849);
        ajc$tjp_114 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsResultSetType", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 855);
        ajc$tjp_115 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsResultSetConcurrency", "com.mongodb.jdbc.MongoDatabaseMetaData", "int:int", "type:concurrency", "java.sql.SQLException", "boolean"), 860);
        ajc$tjp_116 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ownUpdatesAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 865);
        ajc$tjp_117 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ownDeletesAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 871);
        ajc$tjp_118 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "ownInsertsAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 877);
        ajc$tjp_119 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "othersUpdatesAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 883);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDriverName", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 295);
        ajc$tjp_120 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "othersDeletesAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 889);
        ajc$tjp_121 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "othersInsertsAreVisible", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 895);
        ajc$tjp_122 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updatesAreDetected", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 901);
        ajc$tjp_123 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deletesAreDetected", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 907);
        ajc$tjp_124 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertsAreDetected", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "type", "java.sql.SQLException", "boolean"), 913);
        ajc$tjp_125 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsBatchUpdates", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 919);
        ajc$tjp_126 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConnection", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.sql.Connection"), 925);
        ajc$tjp_127 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSavepoints", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 932);
        ajc$tjp_128 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsNamedParameters", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 937);
        ajc$tjp_129 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMultipleOpenResults", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 942);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDriverVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 300);
        ajc$tjp_130 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsGetGeneratedKeys", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 947);
        ajc$tjp_131 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsResultSetHoldability", "com.mongodb.jdbc.MongoDatabaseMetaData", "int", "holdability", "java.sql.SQLException", "boolean"), 954);
        ajc$tjp_132 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getResultSetHoldability", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 959);
        ajc$tjp_133 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabaseMajorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 964);
        ajc$tjp_134 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabaseMinorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 969);
        ajc$tjp_135 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJDBCMajorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 974);
        ajc$tjp_136 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJDBCMinorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 979);
        ajc$tjp_137 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSQLStateType", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 984);
        ajc$tjp_138 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "locatorsUpdateCopy", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 990);
        ajc$tjp_139 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsStatementPooling", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 997);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDriverMajorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "", "int"), 305);
        ajc$tjp_140 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRowIdLifetime", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.sql.RowIdLifetime"), 1004);
        ajc$tjp_141 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsStoredFunctionsUsingCallSyntax", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 1009);
        ajc$tjp_142 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "autoCommitFailureClosesAllResultSets", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 1015);
        ajc$tjp_143 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "asBsonIntOrNull", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.Integer", "i", "", "org.bson.BsonValue"), 1020);
        ajc$tjp_144 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "asBsonIntOrDefault", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.Integer:java.lang.Integer", "i:defaultVal", "", "org.bson.BsonValue"), 1024);
        ajc$tjp_145 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generatedKeyAlwaysReturned", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 1034);
        ajc$tjp_146 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWrapperFor", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.Class", "iface", "java.sql.SQLException", "boolean"), 1041);
        ajc$tjp_147 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unwrap", "com.mongodb.jdbc.MongoDatabaseMetaData", "java.lang.Class", "iface", "java.sql.SQLException", "java.lang.Object"), 1047);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDriverMinorVersion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "", "int"), 310);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "usesLocalFiles", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 315);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "usesLocalFilePerTable", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 321);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMixedCaseIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 327);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesUpperCaseIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 332);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "allTablesAreSelectable", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 241);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesLowerCaseIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 337);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesMixedCaseIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 342);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMixedCaseQuotedIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 347);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesUpperCaseQuotedIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 352);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesLowerCaseQuotedIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 357);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storesMixedCaseQuotedIdentifiers", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 362);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIdentifierQuoteString", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 367);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSearchStringEscape", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 372);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExtraNameCharacters", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 377);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsAlterTableWithAddColumn", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 386);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getURL", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 246);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsAlterTableWithDropColumn", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 391);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsColumnAliasing", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 396);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullPlusNonNullIsNull", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 401);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsConvert", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 406);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsConvert", "com.mongodb.jdbc.MongoDatabaseMetaData", "int:int", "fromType:toType", "java.sql.SQLException", "boolean"), 411);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsTableCorrelationNames", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 430);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsDifferentTableCorrelationNames", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 435);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsExpressionsInOrderBy", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 440);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOrderByUnrelated", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 445);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsGroupBy", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 450);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserName", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 251);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsGroupByUnrelated", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 455);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsGroupByBeyondSelect", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 460);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsLikeEscapeClause", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 465);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMultipleResultSets", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 470);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMultipleTransactions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 475);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsNonNullableColumns", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 481);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsMinimumSQLGrammar", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 486);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCoreSQLGrammar", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 492);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsExtendedSQLGrammar", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 498);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsANSI92EntryLevelSQL", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 503);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isReadOnly", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 256);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsANSI92IntermediateSQL", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 509);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsANSI92FullSQL", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 515);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsIntegrityEnhancementFacility", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 520);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOuterJoins", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 525);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsFullOuterJoins", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 530);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsLimitedOuterJoins", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 535);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemaTerm", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 540);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProcedureTerm", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 546);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalogTerm", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 552);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCatalogAtStart", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 557);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullsAreSortedHigh", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 261);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalogSeparator", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "java.lang.String"), 562);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInDataManipulation", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 567);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInProcedureCalls", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 572);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInTableDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 577);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInIndexDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 582);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSchemasInPrivilegeDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 587);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInDataManipulation", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 592);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInProcedureCalls", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 598);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInTableDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 604);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInIndexDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 610);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullsAreSortedLow", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 266);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCatalogsInPrivilegeDefinitions", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 616);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsPositionedDelete", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 622);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsPositionedUpdate", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 627);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSelectForUpdate", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 632);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsStoredProcedures", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 637);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSubqueriesInComparisons", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 642);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSubqueriesInExists", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 647);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSubqueriesInIns", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 652);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsSubqueriesInQuantifieds", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 657);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsCorrelatedSubqueries", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 662);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullsAreSortedAtStart", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 271);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsUnion", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 667);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsUnionAll", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 672);
        ajc$tjp_82 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOpenCursorsAcrossCommit", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 677);
        ajc$tjp_83 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOpenCursorsAcrossRollback", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 683);
        ajc$tjp_84 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOpenStatementsAcrossCommit", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 689);
        ajc$tjp_85 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "supportsOpenStatementsAcrossRollback", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 695);
        ajc$tjp_86 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxBinaryLiteralLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 706);
        ajc$tjp_87 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxCharLiteralLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 711);
        ajc$tjp_88 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 716);
        ajc$tjp_89 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInGroupBy", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 721);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "nullsAreSortedAtEnd", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "boolean"), 276);
        ajc$tjp_90 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInIndex", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 727);
        ajc$tjp_91 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInOrderBy", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 734);
        ajc$tjp_92 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInSelect", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 740);
        ajc$tjp_93 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxColumnsInTable", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 746);
        ajc$tjp_94 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxConnections", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 751);
        ajc$tjp_95 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxCursorNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 756);
        ajc$tjp_96 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxIndexLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 761);
        ajc$tjp_97 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxSchemaNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 766);
        ajc$tjp_98 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxProcedureNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 771);
        ajc$tjp_99 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxCatalogNameLength", "com.mongodb.jdbc.MongoDatabaseMetaData", "", "", "java.sql.SQLException", "int"), 776);
    }
}

