/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class MongoFunctions
implements LoggingAspect$ajcMightHaveAspect {
    public MongoFunction[] functions;
    public String numericFunctionsString;
    public String stringFunctionsString;
    public String dateFunctionsString;
    public String systemFunctionsString;
    protected static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    protected static final String SUBSTRING = "SUBSTRING";
    protected static final String COALESCE = "COALESCE";
    protected static final String EXTRACT = "EXTRACT";
    protected static final String NULLIF = "NULLIF";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    protected MongoFunctions(MongoFunction[] functions) {
        LoggingAspect.ajc$perObjectBind(this);
        this.functions = functions;
        this.initCategorizedFunctionsList();
    }

    private void initCategorizedFunctionsList() {
        try {
            StringBuilder numericFunctionsBuilder = new StringBuilder();
            StringBuilder stringFunctionsBuilder = new StringBuilder();
            StringBuilder dateTimeFunctionsBuilder = new StringBuilder();
            StringBuilder systemFunctionsBuilder = new StringBuilder();
            StringBuilder currBuilder = null;
            MongoFunction[] mongoFunctionArray = this.functions;
            int n = this.functions.length;
            int n2 = 0;
            while (n2 < n) {
                MongoFunction currFunc = mongoFunctionArray[n2];
                switch (currFunc.functionCategory) {
                    case NUM_FUNC: {
                        currBuilder = numericFunctionsBuilder;
                        break;
                    }
                    case STRING_FUNC: {
                        currBuilder = stringFunctionsBuilder;
                        break;
                    }
                    case SYSTEM_FUNC: {
                        currBuilder = systemFunctionsBuilder;
                        break;
                    }
                    case TIME_DATE_FUNC: {
                        currBuilder = dateTimeFunctionsBuilder;
                        break;
                    }
                    default: {
                        currBuilder = null;
                    }
                }
                if (currBuilder != null) {
                    if (currBuilder.length() > 0) {
                        currBuilder.append(',');
                    }
                    currBuilder.append(currFunc.name);
                }
                ++n2;
            }
            this.numericFunctionsString = numericFunctionsBuilder.toString();
            this.stringFunctionsString = stringFunctionsBuilder.toString();
            this.dateFunctionsString = dateTimeFunctionsBuilder.toString();
            this.systemFunctionsString = systemFunctionsBuilder.toString();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    static {
        MongoFunctions.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoFunctions.java", MongoFunctions.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initCategorizedFunctionsList", "com.mongodb.jdbc.MongoFunctions", "", "", "", "void"), 77);
    }

    public static enum FunctionCategory {
        STRING_FUNC,
        NUM_FUNC,
        TIME_DATE_FUNC,
        SYSTEM_FUNC,
        CONV_FUNC,
        UNCATEGORIZED_FUNC;

    }

    public static class MongoFunction {
        public String name;
        public String returnType;
        public String comment;
        public String[] argTypes;
        public FunctionCategory functionCategory;

        protected MongoFunction(String name, String returnType, String comment, String[] argTypes, FunctionCategory category) {
            this.name = name;
            this.returnType = returnType;
            this.comment = comment;
            this.argTypes = argTypes;
            this.functionCategory = category;
        }

        protected MongoFunction(String name, String returnType, String comment, String[] argTypes) {
            this.name = name;
            this.returnType = returnType;
            this.comment = comment;
            this.argTypes = argTypes;
            this.functionCategory = FunctionCategory.UNCATEGORIZED_FUNC;
        }
    }
}

