/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.google.common.base.Preconditions;
import com.mongodb.client.MongoCursor;
import com.mongodb.jdbc.MongoResultSetMetaData;
import com.mongodb.jdbc.MongoStatement;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonValue;

@AutoLoggable
public abstract class MongoResultSet<T>
implements ResultSet,
LoggingAspect$ajcMightHaveAspect {
    private static final TimeZone UTC;
    protected SimpleDateFormat dateFormat;
    protected final String ARRAY = "array";
    protected final String BINARY = "binary";
    protected final String BOOLEAN = "boolean";
    protected final String BSON = "bson";
    protected final String DATE = "date";
    protected final String DB_POINTER = "db_pointer";
    protected final String DECIMAL128 = "decimal128";
    protected final String DOCUMENT = "document";
    protected final String DOUBLE = "double";
    protected final String END_OF_DOCUMENT = "end_of_document";
    protected final String INT32 = "int32";
    protected final String INT64 = "int64";
    protected final String JAVASCRIPT = "javascript";
    protected final String JAVASCRIPT_WITH_CODE = "javascript_with_code";
    protected final String MAX_KEY = "max_key";
    protected final String MIN_KEY = "min_key";
    protected final String OBJECT_ID = "objectId";
    protected final String OBJECT = "object";
    protected final String REGEX = "regex";
    protected final String STRING = "string";
    protected final String SYMBOL = "symbol";
    protected final String TIMESTAMP = "timestamp";
    protected T current;
    protected MongoCursor<T> cursor;
    protected int rowNum;
    protected boolean closed;
    protected MongoStatement statement;
    protected boolean wasNull;
    protected MongoResultSetMetaData rsMetaData;
    protected MongoLogger logger;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_75;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_76;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_77;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_78;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_79;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_80;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_81;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_82;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_83;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_84;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_85;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_86;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_87;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_88;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_89;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_90;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_91;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_92;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_93;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_94;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_95;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_96;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_97;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_98;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_99;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_100;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_101;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_102;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_103;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_104;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_105;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_106;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_107;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_108;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_109;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_110;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_111;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_112;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_113;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_114;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_115;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_116;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_117;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_118;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_119;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_120;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_121;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_122;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_123;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_124;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_125;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_126;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_127;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_128;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_129;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_130;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_131;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_132;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_133;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_134;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_135;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_136;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_137;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_138;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_139;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_140;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_141;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_142;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_143;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_144;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_145;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_146;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_147;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_148;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_149;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_150;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_151;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_152;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_153;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_154;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_155;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_156;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_157;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_158;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_159;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_160;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_161;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_162;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_163;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_164;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_165;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_166;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_167;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_168;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_169;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_170;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_171;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_172;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_173;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_174;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_175;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_176;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_177;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_178;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_179;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_180;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_181;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_182;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_183;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_184;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_185;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_186;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_187;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_188;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_189;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_190;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_191;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_192;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_193;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_194;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_195;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_196;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_197;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_198;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_199;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_200;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoResultSet.ajc$preClinit();
        UTC = TimeZone.getTimeZone("UTC");
    }

    public MongoResultSet(MongoStatement statement) {
        LoggingAspect.ajc$perObjectBind(this);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.ARRAY = "array";
        this.BINARY = "binary";
        this.BOOLEAN = "boolean";
        this.BSON = "bson";
        this.DATE = "date";
        this.DB_POINTER = "db_pointer";
        this.DECIMAL128 = "decimal128";
        this.DOCUMENT = "document";
        this.DOUBLE = "double";
        this.END_OF_DOCUMENT = "end_of_document";
        this.INT32 = "int32";
        this.INT64 = "int64";
        this.JAVASCRIPT = "javascript";
        this.JAVASCRIPT_WITH_CODE = "javascript_with_code";
        this.MAX_KEY = "max_key";
        this.MIN_KEY = "min_key";
        this.OBJECT_ID = "objectId";
        this.OBJECT = "object";
        this.REGEX = "regex";
        this.STRING = "string";
        this.SYMBOL = "symbol";
        this.TIMESTAMP = "timestamp";
        this.rowNum = 0;
        this.closed = false;
        this.wasNull = false;
        Preconditions.checkNotNull(statement);
        this.statement = statement;
        MongoLogger mongoLogger = new MongoLogger(this.getClass().getCanonicalName(), statement.getParentLogger(), statement.getStatementId());
        MongoResultSet mongoResultSet = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoResultSet.logger_aroundBody1$advice(this, mongoResultSet, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoResultSet.logger = mongoLogger;
        }
        this.dateFormat.setTimeZone(UTC);
    }

    public MongoResultSet(MongoLogger parentLogger) {
        LoggingAspect.ajc$perObjectBind(this);
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.ARRAY = "array";
        this.BINARY = "binary";
        this.BOOLEAN = "boolean";
        this.BSON = "bson";
        this.DATE = "date";
        this.DB_POINTER = "db_pointer";
        this.DECIMAL128 = "decimal128";
        this.DOCUMENT = "document";
        this.DOUBLE = "double";
        this.END_OF_DOCUMENT = "end_of_document";
        this.INT32 = "int32";
        this.INT64 = "int64";
        this.JAVASCRIPT = "javascript";
        this.JAVASCRIPT_WITH_CODE = "javascript_with_code";
        this.MAX_KEY = "max_key";
        this.MIN_KEY = "min_key";
        this.OBJECT_ID = "objectId";
        this.OBJECT = "object";
        this.REGEX = "regex";
        this.STRING = "string";
        this.SYMBOL = "symbol";
        this.TIMESTAMP = "timestamp";
        this.rowNum = 0;
        this.closed = false;
        this.wasNull = false;
        MongoLogger mongoLogger = new MongoLogger(this.getClass().getCanonicalName(), parentLogger);
        MongoResultSet mongoResultSet = this;
        if (LoggingAspect.hasAspect(this)) {
            MongoResultSet.logger_aroundBody3$advice(this, mongoResultSet, mongoLogger, LoggingAspect.aspectOf(this), mongoLogger, null);
        } else {
            mongoResultSet.logger = mongoLogger;
        }
        this.dateFormat.setTimeZone(UTC);
    }

    T getCurrent() {
        try {
            return this.current;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    protected void checkBounds(int i) throws SQLException {
        try {
            this.checkClosed();
            if (this.current == null) {
                throw new SQLException("No current row in the result set. Make sure to call next().");
            }
            if (i > this.rsMetaData.getColumnCount()) {
                throw new SQLException("Index out of bounds: '" + i + "'.");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_2, this, this));
            }
            this.checkClosed();
            boolean result = this.cursor.hasNext();
            if (result) {
                this.current = this.cursor.next();
                ++this.rowNum;
            }
            return result;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_3, this, this));
            }
            if (this.closed) {
                return;
            }
            this.cursor.close();
            this.closed = true;
            if (this.statement != null && this.statement.isCloseOnCompletion()) {
                this.statement.close();
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_4, this, this));
            }
            this.checkClosed();
            return !this.cursor.hasNext();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    protected abstract BsonValue getBsonValue(int var1) throws SQLException;

    protected abstract BsonValue getBsonValue(String var1) throws SQLException;

    protected void checkClosed() throws SQLException {
        try {
            if (this.closed) {
                throw new SQLException("MongoResultSet is closed.");
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_6, this, this));
            }
            this.checkClosed();
            return this.wasNull;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    protected abstract boolean checkNull(BsonValue var1);

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        int n = columnIndex;
        int n2 = scale;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_7, this, this, Conversions.intObject(n), Conversions.intObject(n2)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    protected abstract byte[] handleBytesConversionFailure(String var1) throws SQLException;

    protected abstract byte[] getBytes(BsonValue var1) throws SQLException;

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_8, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getBytes(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getBytes(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    protected static ByteArrayInputStream getNewByteArrayInputStream(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_10, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            try {
                return MongoResultSet.getNewByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("The JVM claims not to support the encoding: ASCII.");
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_11, (Object)this, (Object)this, string));
            }
            try {
                return MongoResultSet.getNewByteArrayInputStream(this.getString(columnLabel).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("The JVM claims not to support the encoding: ASCII.");
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_12, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            try {
                return MongoResultSet.getNewByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("The JVM claims not to support the encoding: UTF-8.");
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_13, (Object)this, (Object)this, string));
            }
            try {
                return MongoResultSet.getNewByteArrayInputStream(this.getString(columnLabel).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("The JVM claims not to support the encoding: UTF-8.");
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_14, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return MongoResultSet.getNewByteArrayInputStream(this.getBytes(columnIndex));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_15, (Object)this, (Object)this, string));
            }
            return MongoResultSet.getNewByteArrayInputStream(this.getBytes(columnLabel));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    protected abstract String handleStringConversionFailure(String var1) throws SQLException;

    protected abstract String getString(BsonValue var1) throws SQLException;

    @Override
    public String getString(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_16, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getString(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_17, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getString(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    protected abstract boolean handleBooleanConversionFailure(String var1) throws SQLException;

    protected abstract boolean getBoolean(BsonValue var1) throws SQLException;

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_18, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getBoolean(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_19, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getBoolean(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    protected byte getByte(BsonValue o) throws SQLException {
        try {
            return (byte)this.getLong(o);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_21, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getByte(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_22, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getByte(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    protected short getShort(BsonValue o) throws SQLException {
        try {
            return (short)this.getLong(o);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_24, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getShort(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_25, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getShort(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    protected int getInt(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return 0;
            }
            return (int)this.getLong(o);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_26);
            }
            throw exception;
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_27, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getInt(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_27);
            }
            throw exception;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_28, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getInt(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_28);
            }
            throw exception;
        }
    }

    protected abstract long handleLongConversionFailure(String var1) throws SQLException;

    protected abstract long getLong(BsonValue var1) throws SQLException;

    @Override
    public long getLong(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_29, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getLong(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_29);
            }
            throw exception;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_30, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getLong(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_30);
            }
            throw exception;
        }
    }

    protected float getFloat(BsonValue o) throws SQLException {
        try {
            return (float)this.getDouble(o);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_31);
            }
            throw exception;
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_32, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getFloat(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_32);
            }
            throw exception;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_33, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getFloat(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_33);
            }
            throw exception;
        }
    }

    protected abstract double handleDoubleConversionFailure(String var1) throws SQLException;

    protected abstract double getDouble(BsonValue var1) throws SQLException;

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_34, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getDouble(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_34);
            }
            throw exception;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_35, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getDouble(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_35);
            }
            throw exception;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        String string = columnLabel;
        int n = scale;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_36, this, this, string, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_36);
            }
            throw exception;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_37, this, this));
            }
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_37);
            }
            throw exception;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_38, this, this));
            }
            this.checkClosed();
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_38);
            }
            throw exception;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_39, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_39);
            }
            throw exception;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_40, this, this));
            }
            this.checkClosed();
            return this.rsMetaData;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_40);
            }
            throw exception;
        }
    }

    protected abstract Object getObject(BsonValue var1, int var2) throws SQLException;

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_41, (Object)this, (Object)this, string));
            }
            this.checkClosed();
            if (!this.rsMetaData.hasColumnWithLabel(columnLabel)) {
                throw new SQLException("No such column: '" + columnLabel + "'.");
            }
            return this.rsMetaData.getColumnPositionFromLabel(columnLabel) + 1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_41);
            }
            throw exception;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_42, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_42);
            }
            throw exception;
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_43, (Object)this, (Object)this, string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_43);
            }
            throw exception;
        }
    }

    protected abstract BigDecimal handleBigDecimalConversionFailure(String var1) throws SQLException;

    protected abstract BigDecimal getBigDecimal(BsonValue var1) throws SQLException;

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_44, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getBigDecimal(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_44);
            }
            throw exception;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_45, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getBigDecimal(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_45);
            }
            throw exception;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_46, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_46);
            }
            throw exception;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_47, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_47);
            }
            throw exception;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_48, this, this));
            }
            this.checkClosed();
            return this.rowNum == 1;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_48);
            }
            throw exception;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_49, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_49);
            }
            throw exception;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_50, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_50);
            }
            throw exception;
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_51, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_51);
            }
            throw exception;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_52, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_52);
            }
            throw exception;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_53, this, this));
            }
            this.checkClosed();
            return this.rowNum;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_53);
            }
            throw exception;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        int n = row;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_54, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_54);
            }
            throw exception;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int n = rows;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_55, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_55);
            }
            throw exception;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_56, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_56);
            }
            throw exception;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        int n = direction;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_57, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_57);
            }
            throw exception;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_58, this, this));
            }
            this.checkClosed();
            return 1000;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_58);
            }
            throw exception;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        int n = rows;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_59, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_59);
            }
            throw exception;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_60, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_60);
            }
            throw exception;
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_61, this, this));
            }
            this.checkClosed();
            return 1003;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_61);
            }
            throw exception;
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_62, this, this));
            }
            this.checkClosed();
            return 1007;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_62);
            }
            throw exception;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_63, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_63);
            }
            throw exception;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_64, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_64);
            }
            throw exception;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_65, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_65);
            }
            throw exception;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_66, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_66);
            }
            throw exception;
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        int n = columnIndex;
        boolean bl = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_67, this, this, Conversions.intObject(n), Conversions.booleanObject(bl)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_67);
            }
            throw exception;
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        int n = columnIndex;
        byte by = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_68, this, this, Conversions.intObject(n), Conversions.byteObject(by)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_68);
            }
            throw exception;
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        int n = columnIndex;
        short s2 = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_69, this, this, Conversions.intObject(n), Conversions.shortObject(s2)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_69);
            }
            throw exception;
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        int n = columnIndex;
        int n2 = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_70, this, this, Conversions.intObject(n), Conversions.intObject(n2)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_70);
            }
            throw exception;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        int n = columnIndex;
        long l = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_71, this, this, Conversions.intObject(n), Conversions.longObject(l)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_71);
            }
            throw exception;
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        int n = columnIndex;
        float f = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_72, this, this, Conversions.intObject(n), Conversions.floatObject(f)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_72);
            }
            throw exception;
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        int n = columnIndex;
        double d = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_73, this, this, Conversions.intObject(n), Conversions.doubleObject(d)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_73);
            }
            throw exception;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        int n = columnIndex;
        BigDecimal bigDecimal = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_74, this, this, Conversions.intObject(n), bigDecimal));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_74);
            }
            throw exception;
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        int n = columnIndex;
        String string = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_75, this, this, Conversions.intObject(n), string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_75);
            }
            throw exception;
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        int n = columnIndex;
        byte[] byArray = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_76, this, this, Conversions.intObject(n), byArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_76);
            }
            throw exception;
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        int n = columnIndex;
        Date date = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_77, this, this, Conversions.intObject(n), date));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_77);
            }
            throw exception;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        int n = columnIndex;
        Time time = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_78, this, this, Conversions.intObject(n), time));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_78);
            }
            throw exception;
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        int n = columnIndex;
        Timestamp timestamp = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_79, this, this, Conversions.intObject(n), timestamp));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_79);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        int n2 = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), inputStream, Conversions.intObject(n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_80, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_80);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        int n2 = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), inputStream, Conversions.intObject(n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_81, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_81);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        int n2 = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), reader, Conversions.intObject(n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_82, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_82);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        int n = columnIndex;
        Object object = x;
        int n2 = scaleOrLength;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), object, Conversions.intObject(n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_83, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_83);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        int n = columnIndex;
        Object object = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_84, this, this, Conversions.intObject(n), object));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_84);
            }
            throw exception;
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_85, (Object)this, (Object)this, string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_85);
            }
            throw exception;
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        String string = columnLabel;
        boolean bl = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_86, this, this, string, Conversions.booleanObject(bl)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_86);
            }
            throw exception;
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        String string = columnLabel;
        byte by = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_87, this, this, string, Conversions.byteObject(by)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_87);
            }
            throw exception;
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        String string = columnLabel;
        short s2 = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_88, this, this, string, Conversions.shortObject(s2)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_88);
            }
            throw exception;
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        String string = columnLabel;
        int n = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_89, this, this, string, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_89);
            }
            throw exception;
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        String string = columnLabel;
        long l = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_90, this, this, string, Conversions.longObject(l)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_90);
            }
            throw exception;
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        String string = columnLabel;
        float f = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_91, this, this, string, Conversions.floatObject(f)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_91);
            }
            throw exception;
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        String string = columnLabel;
        double d = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_92, this, this, string, Conversions.doubleObject(d)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_92);
            }
            throw exception;
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        String string = columnLabel;
        BigDecimal bigDecimal = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_93, this, this, string, bigDecimal));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_93);
            }
            throw exception;
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        String string = columnLabel;
        String string2 = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_94, this, this, string, string2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_94);
            }
            throw exception;
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        String string = columnLabel;
        byte[] byArray = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_95, this, this, string, byArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_95);
            }
            throw exception;
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        String string = columnLabel;
        Date date = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_96, this, this, string, date));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_96);
            }
            throw exception;
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        String string = columnLabel;
        Time time = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_97, this, this, string, time));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_97);
            }
            throw exception;
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        String string = columnLabel;
        Timestamp timestamp = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_98, this, this, string, timestamp));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_98);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        int n = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream, Conversions.intObject(n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_99, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_99);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        int n = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream, Conversions.intObject(n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_100, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_100);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        int n = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.intObject(n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_101, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_101);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        String string = columnLabel;
        Object object = x;
        int n = scaleOrLength;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, object, Conversions.intObject(n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_102, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_102);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        String string = columnLabel;
        Object object = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_103, this, this, string, object));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_103);
            }
            throw exception;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_104, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_104);
            }
            throw exception;
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_105, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_105);
            }
            throw exception;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_106, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_106);
            }
            throw exception;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_107, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_107);
            }
            throw exception;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_108, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_108);
            }
            throw exception;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_109, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_109);
            }
            throw exception;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_110, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_110);
            }
            throw exception;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_111, this, this));
            }
            this.checkClosed();
            return this.statement;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_111);
            }
            throw exception;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_112, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_112);
            }
            throw exception;
        }
    }

    protected Blob getNewBlob(byte[] bytes) throws SQLException {
        try {
            if (bytes == null) {
                return null;
            }
            try {
                return new SerialBlob(bytes);
            }
            catch (SerialException e) {
                throw new SQLException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_113);
            }
            throw exception;
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_114, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getNewBlob(this.getBytes(out));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_114);
            }
            throw exception;
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_115, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getNewBlob(this.getBytes(out));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_115);
            }
            throw exception;
        }
    }

    protected Clob getClob(BsonValue o) throws SQLException {
        try {
            return new SerialClob(this.getString(o).toCharArray());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_116);
            }
            throw exception;
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_117, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getClob(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_117);
            }
            throw exception;
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_118, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getClob(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_118);
            }
            throw exception;
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_119, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_119);
            }
            throw exception;
        }
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_120, (Object)this, (Object)this, string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_120);
            }
            throw exception;
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_121, (Object)this, (Object)this, string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_121);
            }
            throw exception;
        }
    }

    protected abstract java.util.Date handleUtilDateConversionFailure(String var1) throws SQLException;

    protected abstract java.util.Date getUtilDate(BsonValue var1) throws SQLException;

    protected Date getDate(BsonValue o) throws SQLException {
        try {
            java.util.Date utilDate = this.getUtilDate(o);
            return utilDate == null ? null : new Date(utilDate.getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_122);
            }
            throw exception;
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_123, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getDate(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_123);
            }
            throw exception;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_124, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getDate(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_124);
            }
            throw exception;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        int n = columnIndex;
        Calendar calendar = cal;
        try {
            Date d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_125, this, this, Conversions.intObject(n), calendar));
            }
            if ((d = this.getDate(columnIndex)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Date(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_125);
            }
            throw exception;
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        String string = columnLabel;
        Calendar calendar = cal;
        try {
            Date d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_126, this, this, string, calendar));
            }
            if ((d = this.getDate(columnLabel)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Date(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_126);
            }
            throw exception;
        }
    }

    protected Time getTime(BsonValue o) throws SQLException {
        try {
            java.util.Date utilDate = this.getUtilDate(o);
            return utilDate == null ? null : new Time(utilDate.getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_127);
            }
            throw exception;
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_128, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getTime(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_128);
            }
            throw exception;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_129, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getTime(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_129);
            }
            throw exception;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        int n = columnIndex;
        Calendar calendar = cal;
        try {
            Time d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_130, this, this, Conversions.intObject(n), calendar));
            }
            if ((d = this.getTime(columnIndex)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Time(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_130);
            }
            throw exception;
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        String string = columnLabel;
        Calendar calendar = cal;
        try {
            Time d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_131, this, this, string, calendar));
            }
            if ((d = this.getTime(columnLabel)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Time(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_131);
            }
            throw exception;
        }
    }

    protected Timestamp getTimestamp(BsonValue o) throws SQLException {
        try {
            java.util.Date utilDate = this.getUtilDate(o);
            return utilDate == null ? null : new Timestamp(utilDate.getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_132);
            }
            throw exception;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_133, (Object)this, (Object)this, string));
            }
            BsonValue out = this.getBsonValue(columnLabel);
            return this.getTimestamp(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_133);
            }
            throw exception;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_134, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            return this.getTimestamp(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_134);
            }
            throw exception;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        int n = columnIndex;
        Calendar calendar = cal;
        try {
            Timestamp d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_135, this, this, Conversions.intObject(n), calendar));
            }
            if ((d = this.getTimestamp(columnIndex)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Timestamp(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_135);
            }
            throw exception;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        String string = columnLabel;
        Calendar calendar = cal;
        try {
            Timestamp d;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_136, this, this, string, calendar));
            }
            if ((d = this.getTimestamp(columnLabel)) == null) {
                return null;
            }
            cal.setTime(d);
            return new Timestamp(cal.getTime().getTime());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_136);
            }
            throw exception;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_137, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_137);
            }
            throw exception;
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_138, (Object)this, (Object)this, string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_138);
            }
            throw exception;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        int n = columnIndex;
        Ref ref = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_139, this, this, Conversions.intObject(n), ref));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_139);
            }
            throw exception;
        }
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        String string = columnLabel;
        Ref ref = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_140, this, this, string, ref));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_140);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        int n = columnIndex;
        Blob blob = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_141, this, this, Conversions.intObject(n), blob));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_141);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        String string = columnLabel;
        Blob blob = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_142, this, this, string, blob));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_142);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        int n = columnIndex;
        Clob clob = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_143, this, this, Conversions.intObject(n), clob));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_143);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        String string = columnLabel;
        Clob clob = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_144, this, this, string, clob));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_144);
            }
            throw exception;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        int n = columnIndex;
        Array array = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_145, this, this, Conversions.intObject(n), array));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_145);
            }
            throw exception;
        }
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        String string = columnLabel;
        Array array = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_146, this, this, string, array));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_146);
            }
            throw exception;
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_147, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_147);
            }
            throw exception;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_148, (Object)this, (Object)this, string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_148);
            }
            throw exception;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        int n = columnIndex;
        RowId rowId = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_149, this, this, Conversions.intObject(n), rowId));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_149);
            }
            throw exception;
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        String string = columnLabel;
        RowId rowId = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_150, this, this, string, rowId));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_150);
            }
            throw exception;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_151, this, this));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_151);
            }
            throw exception;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_152, this, this));
            }
            return this.closed;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_152);
            }
            throw exception;
        }
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        int n = columnIndex;
        String string = nString;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_153, this, this, Conversions.intObject(n), string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_153);
            }
            throw exception;
        }
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        String string = columnLabel;
        String string2 = nString;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_154, this, this, string, string2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_154);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        int n = columnIndex;
        NClob nClob2 = nClob;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_155, this, this, Conversions.intObject(n), nClob2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_155);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        String string = columnLabel;
        NClob nClob2 = nClob;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_156, this, this, string, nClob2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_156);
            }
            throw exception;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_157, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_157);
            }
            throw exception;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_158, (Object)this, (Object)this, string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_158);
            }
            throw exception;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_159, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_159);
            }
            throw exception;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_160, (Object)this, (Object)this, string));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_160);
            }
            throw exception;
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        int n = columnIndex;
        SQLXML sQLXML = xmlObject;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_161, this, this, Conversions.intObject(n), sQLXML));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_161);
            }
            throw exception;
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        String string = columnLabel;
        SQLXML sQLXML = xmlObject;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_162, this, this, string, sQLXML));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_162);
            }
            throw exception;
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_163, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return this.getString(columnIndex);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_163);
            }
            throw exception;
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_164, (Object)this, (Object)this, string));
            }
            return this.getString(columnLabel);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_164);
            }
            throw exception;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_165, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            return new StringReader(this.getString(columnIndex));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_165);
            }
            throw exception;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_166, (Object)this, (Object)this, string));
            }
            return new StringReader(this.getString(columnLabel));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_166);
            }
            throw exception;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), reader, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_167, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_167);
            }
            throw exception;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_168, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_168);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), inputStream, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_169, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_169);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), inputStream, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_170, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_170);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), reader, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_171, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_171);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_172, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_172);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_173, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_173);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_174, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_174);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        int n = columnIndex;
        InputStream inputStream2 = inputStream;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), inputStream2, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_175, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_175);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        String string = columnLabel;
        InputStream inputStream2 = inputStream;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, inputStream2, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_176, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_176);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        int n = columnIndex;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), reader2, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_177, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_177);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_178, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_178);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        int n = columnIndex;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), reader2, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_179, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_179);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        long l = length;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, reader2, Conversions.longObject(l)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_180, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_180);
            }
            throw exception;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_181, this, this, Conversions.intObject(n), reader));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_181);
            }
            throw exception;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_182, this, this, string, reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_182);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_183, this, this, Conversions.intObject(n), inputStream));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_183);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        int n = columnIndex;
        InputStream inputStream = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_184, this, this, Conversions.intObject(n), inputStream));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_184);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        int n = columnIndex;
        Reader reader = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_185, this, this, Conversions.intObject(n), reader));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_185);
            }
            throw exception;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_186, this, this, string, inputStream));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_186);
            }
            throw exception;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        String string = columnLabel;
        InputStream inputStream = x;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_187, this, this, string, inputStream));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_187);
            }
            throw exception;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_188, this, this, string, reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_188);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        int n = columnIndex;
        InputStream inputStream2 = inputStream;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_189, this, this, Conversions.intObject(n), inputStream2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_189);
            }
            throw exception;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        String string = columnLabel;
        InputStream inputStream2 = inputStream;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_190, this, this, string, inputStream2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_190);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        int n = columnIndex;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_191, this, this, Conversions.intObject(n), reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_191);
            }
            throw exception;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_192, this, this, string, reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_192);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        int n = columnIndex;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_193, this, this, Conversions.intObject(n), reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_193);
            }
            throw exception;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        String string = columnLabel;
        Reader reader2 = reader;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_194, this, this, string, reader2));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_194);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        int n = columnIndex;
        Object object = x;
        SQLType sQLType = targetSqlType;
        int n2 = scaleOrLength;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), object, sQLType, Conversions.intObject(n2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_195, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_195);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        String string = columnLabel;
        Object object = x;
        SQLType sQLType = targetSqlType;
        int n = scaleOrLength;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, object, sQLType, Conversions.intObject(n)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_196, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_196);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        int n = columnIndex;
        Object object = x;
        SQLType sQLType = targetSqlType;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{Conversions.intObject(n), object, sQLType};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_197, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_197);
            }
            throw exception;
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        String string = columnLabel;
        Object object = x;
        SQLType sQLType = targetSqlType;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, object, sQLType};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_198, (Object)this, (Object)this, objectArray));
            }
            throw new SQLFeatureNotSupportedException(Thread.currentThread().getStackTrace()[1].toString());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_198);
            }
            throw exception;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Class<?> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_199, (Object)this, (Object)this, clazz));
            }
            return iface.isInstance(this);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_199);
            }
            throw exception;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Class<T> clazz = iface;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_200, (Object)this, (Object)this, clazz));
            }
            return (T)this;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_200);
            }
            throw exception;
        }
    }

    private static final /* synthetic */ Object logger_aroundBody1$advice(MongoResultSet ajc$this, MongoResultSet target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    private static final /* synthetic */ Object logger_aroundBody3$advice(MongoResultSet ajc$this, MongoResultSet target, MongoLogger logger, LoggingAspect ajc$aspectInstance, MongoLogger arg, AroundClosure ajc$aroundClosure) {
        LoggingAspect.ajc$inlineAccessFieldSet$com_mongodb_jdbc_logging_LoggingAspect$com_mongodb_jdbc_logging_LoggingAspect$logger(ajc$aspectInstance, arg);
        AroundClosure aroundClosure = ajc$aroundClosure;
        MongoLogger mongoLogger = arg;
        target.logger = mongoLogger;
        return null;
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoResultSet.java", MongoResultSet.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getCurrent", "com.mongodb.jdbc.MongoResultSet", "", "", "", "java.lang.Object"), 128);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkBounds", "com.mongodb.jdbc.MongoResultSet", "int", "i", "java.sql.SQLException", "void"), 132);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAsciiStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.InputStream"), 223);
        ajc$tjp_100 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:int", "columnLabel:x:length", "java.sql.SQLException", "void"), 830);
        ajc$tjp_101 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:int", "columnLabel:reader:length", "java.sql.SQLException", "void"), 837);
        ajc$tjp_102 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Object:int", "columnLabel:x:scaleOrLength", "java.sql.SQLException", "void"), 844);
        ajc$tjp_103 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Object", "columnLabel:x", "java.sql.SQLException", "void"), 850);
        ajc$tjp_104 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 856);
        ajc$tjp_105 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 862);
        ajc$tjp_106 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 868);
        ajc$tjp_107 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 874);
        ajc$tjp_108 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "cancelRowUpdates", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 880);
        ajc$tjp_109 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "moveToInsertRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 886);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAsciiStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.InputStream"), 233);
        ajc$tjp_110 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "moveToCurrentRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 892);
        ajc$tjp_111 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStatement", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "java.sql.Statement"), 898);
        ajc$tjp_112 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRef", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Ref"), 904);
        ajc$tjp_113 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getNewBlob", "com.mongodb.jdbc.MongoResultSet", "[B", "bytes", "java.sql.SQLException", "java.sql.Blob"), 909);
        ajc$tjp_114 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBlob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Blob"), 921);
        ajc$tjp_115 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBlob", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Blob"), 927);
        ajc$tjp_116 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getClob", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.sql.Clob"), 932);
        ajc$tjp_117 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Clob"), 937);
        ajc$tjp_118 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClob", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Clob"), 943);
        ajc$tjp_119 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getArray", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Array"), 949);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnicodeStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.InputStream"), 244);
        ajc$tjp_120 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRef", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Ref"), 955);
        ajc$tjp_121 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getArray", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Array"), 961);
        ajc$tjp_122 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getDate", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.sql.Date"), 971);
        ajc$tjp_123 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Date"), 977);
        ajc$tjp_124 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Date"), 983);
        ajc$tjp_125 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.mongodb.jdbc.MongoResultSet", "int:java.util.Calendar", "columnIndex:cal", "java.sql.SQLException", "java.sql.Date"), 989);
        ajc$tjp_126 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDate", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.util.Calendar", "columnLabel:cal", "java.sql.SQLException", "java.sql.Date"), 999);
        ajc$tjp_127 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTime", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.sql.Time"), 1008);
        ajc$tjp_128 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTime", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Time"), 1014);
        ajc$tjp_129 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTime", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Time"), 1020);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnicodeStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.InputStream"), 255);
        ajc$tjp_130 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTime", "com.mongodb.jdbc.MongoResultSet", "int:java.util.Calendar", "columnIndex:cal", "java.sql.SQLException", "java.sql.Time"), 1026);
        ajc$tjp_131 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTime", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.util.Calendar", "columnLabel:cal", "java.sql.SQLException", "java.sql.Time"), 1036);
        ajc$tjp_132 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.sql.Timestamp"), 1045);
        ajc$tjp_133 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.Timestamp"), 1051);
        ajc$tjp_134 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.Timestamp"), 1057);
        ajc$tjp_135 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "int:java.util.Calendar", "columnIndex:cal", "java.sql.SQLException", "java.sql.Timestamp"), 1063);
        ajc$tjp_136 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimestamp", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.util.Calendar", "columnLabel:cal", "java.sql.SQLException", "java.sql.Timestamp"), 1073);
        ajc$tjp_137 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getURL", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.net.URL"), 1085);
        ajc$tjp_138 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getURL", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.net.URL"), 1091);
        ajc$tjp_139 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRef", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Ref", "columnIndex:x", "java.sql.SQLException", "void"), 1097);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBinaryStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.InputStream"), 265);
        ajc$tjp_140 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRef", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Ref", "columnLabel:x", "java.sql.SQLException", "void"), 1103);
        ajc$tjp_141 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Blob", "columnIndex:x", "java.sql.SQLException", "void"), 1109);
        ajc$tjp_142 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Blob", "columnLabel:x", "java.sql.SQLException", "void"), 1115);
        ajc$tjp_143 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Clob", "columnIndex:x", "java.sql.SQLException", "void"), 1121);
        ajc$tjp_144 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Clob", "columnLabel:x", "java.sql.SQLException", "void"), 1127);
        ajc$tjp_145 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateArray", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Array", "columnIndex:x", "java.sql.SQLException", "void"), 1133);
        ajc$tjp_146 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateArray", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Array", "columnLabel:x", "java.sql.SQLException", "void"), 1139);
        ajc$tjp_147 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRowId", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.RowId"), 1147);
        ajc$tjp_148 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRowId", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.RowId"), 1153);
        ajc$tjp_149 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRowId", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.RowId", "columnIndex:x", "java.sql.SQLException", "void"), 1159);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBinaryStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.InputStream"), 270);
        ajc$tjp_150 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateRowId", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.RowId", "columnLabel:x", "java.sql.SQLException", "void"), 1165);
        ajc$tjp_151 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getHoldability", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 1171);
        ajc$tjp_152 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 1177);
        ajc$tjp_153 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNString", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.String", "columnIndex:nString", "java.sql.SQLException", "void"), 1182);
        ajc$tjp_154 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNString", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.String", "columnLabel:nString", "java.sql.SQLException", "void"), 1188);
        ajc$tjp_155 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.NClob", "columnIndex:nClob", "java.sql.SQLException", "void"), 1194);
        ajc$tjp_156 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.NClob", "columnLabel:nClob", "java.sql.SQLException", "void"), 1200);
        ajc$tjp_157 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNClob", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.NClob"), 1206);
        ajc$tjp_158 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.NClob"), 1212);
        ajc$tjp_159 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSQLXML", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.sql.SQLXML"), 1218);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getString", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.lang.String"), 279);
        ajc$tjp_160 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSQLXML", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.sql.SQLXML"), 1224);
        ajc$tjp_161 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateSQLXML", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.SQLXML", "columnIndex:xmlObject", "java.sql.SQLException", "void"), 1230);
        ajc$tjp_162 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateSQLXML", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.SQLXML", "columnLabel:xmlObject", "java.sql.SQLException", "void"), 1236);
        ajc$tjp_163 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNString", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.lang.String"), 1242);
        ajc$tjp_164 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNString", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.lang.String"), 1247);
        ajc$tjp_165 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.Reader"), 1252);
        ajc$tjp_166 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.Reader"), 1257);
        ajc$tjp_167 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:long", "columnIndex:x:length", "java.sql.SQLException", "void"), 1262);
        ajc$tjp_168 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:long", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1269);
        ajc$tjp_169 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:long", "columnIndex:x:length", "java.sql.SQLException", "void"), 1276);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getString", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.lang.String"), 285);
        ajc$tjp_170 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:long", "columnIndex:x:length", "java.sql.SQLException", "void"), 1283);
        ajc$tjp_171 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:long", "columnIndex:x:length", "java.sql.SQLException", "void"), 1290);
        ajc$tjp_172 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:long", "columnLabel:x:length", "java.sql.SQLException", "void"), 1297);
        ajc$tjp_173 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:long", "columnLabel:x:length", "java.sql.SQLException", "void"), 1304);
        ajc$tjp_174 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:long", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1311);
        ajc$tjp_175 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:long", "columnIndex:inputStream:length", "java.sql.SQLException", "void"), 1318);
        ajc$tjp_176 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:long", "columnLabel:inputStream:length", "java.sql.SQLException", "void"), 1325);
        ajc$tjp_177 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:long", "columnIndex:reader:length", "java.sql.SQLException", "void"), 1332);
        ajc$tjp_178 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:long", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1338);
        ajc$tjp_179 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:long", "columnIndex:reader:length", "java.sql.SQLException", "void"), 1344);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBoolean", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "boolean"), 295);
        ajc$tjp_180 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader:long", "columnLabel:reader:length", "java.sql.SQLException", "void"), 1350);
        ajc$tjp_181 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader", "columnIndex:x", "java.sql.SQLException", "void"), 1358);
        ajc$tjp_182 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader", "columnLabel:reader", "java.sql.SQLException", "void"), 1364);
        ajc$tjp_183 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream", "columnIndex:x", "java.sql.SQLException", "void"), 1371);
        ajc$tjp_184 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream", "columnIndex:x", "java.sql.SQLException", "void"), 1377);
        ajc$tjp_185 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader", "columnIndex:x", "java.sql.SQLException", "void"), 1383);
        ajc$tjp_186 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream", "columnLabel:x", "java.sql.SQLException", "void"), 1389);
        ajc$tjp_187 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream", "columnLabel:x", "java.sql.SQLException", "void"), 1395);
        ajc$tjp_188 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader", "columnLabel:reader", "java.sql.SQLException", "void"), 1401);
        ajc$tjp_189 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream", "columnIndex:inputStream", "java.sql.SQLException", "void"), 1408);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBoolean", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "boolean"), 301);
        ajc$tjp_190 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBlob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream", "columnLabel:inputStream", "java.sql.SQLException", "void"), 1414);
        ajc$tjp_191 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader", "columnIndex:reader", "java.sql.SQLException", "void"), 1420);
        ajc$tjp_192 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader", "columnLabel:reader", "java.sql.SQLException", "void"), 1426);
        ajc$tjp_193 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader", "columnIndex:reader", "java.sql.SQLException", "void"), 1432);
        ajc$tjp_194 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNClob", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.Reader", "columnLabel:reader", "java.sql.SQLException", "void"), 1438);
        ajc$tjp_195 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Object:java.sql.SQLType:int", "columnIndex:x:targetSqlType:scaleOrLength", "java.sql.SQLException", "void"), 1446);
        ajc$tjp_196 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Object:java.sql.SQLType:int", "columnLabel:x:targetSqlType:scaleOrLength", "java.sql.SQLException", "void"), 1453);
        ajc$tjp_197 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Object:java.sql.SQLType", "columnIndex:x:targetSqlType", "java.sql.SQLException", "void"), 1460);
        ajc$tjp_198 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.Object:java.sql.SQLType", "columnLabel:x:targetSqlType", "java.sql.SQLException", "void"), 1466);
        ajc$tjp_199 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isWrapperFor", "com.mongodb.jdbc.MongoResultSet", "java.lang.Class", "iface", "java.sql.SQLException", "boolean"), 1474);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "next", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 143);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getByte", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "byte"), 306);
        ajc$tjp_200 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unwrap", "com.mongodb.jdbc.MongoResultSet", "java.lang.Class", "iface", "java.sql.SQLException", "java.lang.Object"), 1480);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getByte", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "byte"), 313);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getByte", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "byte"), 319);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getShort", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "short"), 324);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getShort", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "short"), 331);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getShort", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "short"), 337);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getInt", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "int"), 342);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getInt", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "int"), 350);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getInt", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "int"), 356);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLong", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "long"), 366);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 156);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getLong", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "long"), 372);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getFloat", "com.mongodb.jdbc.MongoResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "float"), 377);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFloat", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "float"), 382);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFloat", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "float"), 388);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDouble", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "double"), 398);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDouble", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "double"), 404);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:int", "columnLabel:scale", "java.sql.SQLException", "java.math.BigDecimal"), 411);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWarnings", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "java.sql.SQLWarning"), 419);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clearWarnings", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 425);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCursorName", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "java.lang.String"), 430);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isLast", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 168);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMetaData", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "java.sql.ResultSetMetaData"), 436);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findColumn", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "int"), 446);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.io.Reader"), 461);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCharacterStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.io.Reader"), 467);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "java.math.BigDecimal"), 478);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.math.BigDecimal"), 484);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isBeforeFirst", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 494);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAfterLast", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 500);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isFirst", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 506);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "beforeFirst", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 512);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkClosed", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 177);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterLast", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "void"), 518);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "first", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 524);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "last", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 530);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRow", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 536);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "absolute", "com.mongodb.jdbc.MongoResultSet", "int", "row", "java.sql.SQLException", "boolean"), 542);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "relative", "com.mongodb.jdbc.MongoResultSet", "int", "rows", "java.sql.SQLException", "boolean"), 548);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "previous", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 554);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchDirection", "com.mongodb.jdbc.MongoResultSet", "int", "direction", "java.sql.SQLException", "void"), 564);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchDirection", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 570);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchSize", "com.mongodb.jdbc.MongoResultSet", "int", "rows", "java.sql.SQLException", "void"), 576);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "wasNull", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 182);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchSize", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 582);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 588);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConcurrency", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "int"), 594);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rowUpdated", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 604);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rowInserted", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 610);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rowDeleted", "com.mongodb.jdbc.MongoResultSet", "", "", "java.sql.SQLException", "boolean"), 616);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNull", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "void"), 622);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBoolean", "com.mongodb.jdbc.MongoResultSet", "int:boolean", "columnIndex:x", "java.sql.SQLException", "void"), 628);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateByte", "com.mongodb.jdbc.MongoResultSet", "int:byte", "columnIndex:x", "java.sql.SQLException", "void"), 634);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateShort", "com.mongodb.jdbc.MongoResultSet", "int:short", "columnIndex:x", "java.sql.SQLException", "void"), 640);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBigDecimal", "com.mongodb.jdbc.MongoResultSet", "int:int", "columnIndex:scale", "java.sql.SQLException", "java.math.BigDecimal"), 194);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateInt", "com.mongodb.jdbc.MongoResultSet", "int:int", "columnIndex:x", "java.sql.SQLException", "void"), 646);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLong", "com.mongodb.jdbc.MongoResultSet", "int:long", "columnIndex:x", "java.sql.SQLException", "void"), 652);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateFloat", "com.mongodb.jdbc.MongoResultSet", "int:float", "columnIndex:x", "java.sql.SQLException", "void"), 658);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDouble", "com.mongodb.jdbc.MongoResultSet", "int:double", "columnIndex:x", "java.sql.SQLException", "void"), 664);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBigDecimal", "com.mongodb.jdbc.MongoResultSet", "int:java.math.BigDecimal", "columnIndex:x", "java.sql.SQLException", "void"), 670);
        ajc$tjp_75 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateString", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.String", "columnIndex:x", "java.sql.SQLException", "void"), 676);
        ajc$tjp_76 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBytes", "com.mongodb.jdbc.MongoResultSet", "int:[B", "columnIndex:x", "java.sql.SQLException", "void"), 682);
        ajc$tjp_77 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDate", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Date", "columnIndex:x", "java.sql.SQLException", "void"), 688);
        ajc$tjp_78 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTime", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Time", "columnIndex:x", "java.sql.SQLException", "void"), 694);
        ajc$tjp_79 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTimestamp", "com.mongodb.jdbc.MongoResultSet", "int:java.sql.Timestamp", "columnIndex:x", "java.sql.SQLException", "void"), 700);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBytes", "com.mongodb.jdbc.MongoResultSet", "int", "columnIndex", "java.sql.SQLException", "[B"), 204);
        ajc$tjp_80 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:int", "columnIndex:x:length", "java.sql.SQLException", "void"), 706);
        ajc$tjp_81 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBinaryStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.InputStream:int", "columnIndex:x:length", "java.sql.SQLException", "void"), 713);
        ajc$tjp_82 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateCharacterStream", "com.mongodb.jdbc.MongoResultSet", "int:java.io.Reader:int", "columnIndex:x:length", "java.sql.SQLException", "void"), 720);
        ajc$tjp_83 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Object:int", "columnIndex:x:scaleOrLength", "java.sql.SQLException", "void"), 727);
        ajc$tjp_84 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateObject", "com.mongodb.jdbc.MongoResultSet", "int:java.lang.Object", "columnIndex:x", "java.sql.SQLException", "void"), 733);
        ajc$tjp_85 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateNull", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "void"), 739);
        ajc$tjp_86 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBoolean", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:boolean", "columnLabel:x", "java.sql.SQLException", "void"), 745);
        ajc$tjp_87 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateByte", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:byte", "columnLabel:x", "java.sql.SQLException", "void"), 751);
        ajc$tjp_88 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateShort", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:short", "columnLabel:x", "java.sql.SQLException", "void"), 757);
        ajc$tjp_89 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateInt", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:int", "columnLabel:x", "java.sql.SQLException", "void"), 763);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBytes", "com.mongodb.jdbc.MongoResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "[B"), 210);
        ajc$tjp_90 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateLong", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:long", "columnLabel:x", "java.sql.SQLException", "void"), 769);
        ajc$tjp_91 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateFloat", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:float", "columnLabel:x", "java.sql.SQLException", "void"), 775);
        ajc$tjp_92 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDouble", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:double", "columnLabel:x", "java.sql.SQLException", "void"), 781);
        ajc$tjp_93 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBigDecimal", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.math.BigDecimal", "columnLabel:x", "java.sql.SQLException", "void"), 787);
        ajc$tjp_94 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateString", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.lang.String", "columnLabel:x", "java.sql.SQLException", "void"), 793);
        ajc$tjp_95 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBytes", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:[B", "columnLabel:x", "java.sql.SQLException", "void"), 799);
        ajc$tjp_96 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateDate", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Date", "columnLabel:x", "java.sql.SQLException", "void"), 805);
        ajc$tjp_97 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTime", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Time", "columnLabel:x", "java.sql.SQLException", "void"), 811);
        ajc$tjp_98 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTimestamp", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.sql.Timestamp", "columnLabel:x", "java.sql.SQLException", "void"), 817);
        ajc$tjp_99 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateAsciiStream", "com.mongodb.jdbc.MongoResultSet", "java.lang.String:java.io.InputStream:int", "columnLabel:x:length", "java.sql.SQLException", "void"), 823);
    }
}

