/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.jdbc.BsonTypeInfo;
import com.mongodb.jdbc.MongoColumnInfo;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonType;

public class MySQLColumnInfo
implements MongoColumnInfo,
LoggingAspect$ajcMightHaveAspect {
    public String database;
    public String table;
    public String tableAlias;
    public String column;
    public String columnAlias;
    public String bsonType;
    private static Set<String> nullTypes;
    private BsonType bsonTypeEnum;
    private int jdbcType;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MySQLColumnInfo.ajc$preClinit();
        nullTypes = new HashSet<String>();
        nullTypes.add("dbPointer");
        nullTypes.add("javascript");
        nullTypes.add("javascriptWithScope");
        nullTypes.add("maxKey");
        nullTypes.add("minKey");
        nullTypes.add("object");
        nullTypes.add("regex");
        nullTypes.add("symbol");
        nullTypes.add("timestamp");
        nullTypes.add("undefined");
    }

    public MySQLColumnInfo() {
        LoggingAspect.ajc$perObjectBind(this);
    }

    public MySQLColumnInfo(String database, String table, String tableAlias, String column, String columnAlias, String bsonType) throws SQLException {
        LoggingAspect.ajc$perObjectBind(this);
        this.database = database;
        this.table = table;
        this.tableAlias = tableAlias;
        this.column = column;
        this.columnAlias = columnAlias;
        this.bsonType = bsonType;
    }

    public void init() throws SQLException {
        try {
            this.bsonTypeEnum = BsonTypeInfo.getBsonTypeInfoByName(this.bsonType).getBsonType();
            this.jdbcType = MySQLColumnInfo.getJDBCTypeForBsonType(this.bsonTypeEnum);
            if (nullTypes.contains(this.bsonType)) {
                this.bsonType = "null";
            }
            if ("objectId".equals(this.bsonType)) {
                this.bsonType = "string";
            }
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private static int getJDBCTypeForBsonType(BsonType bsonTypeEnum) throws SQLException {
        switch (bsonTypeEnum) {
            case ARRAY: {
                return 2003;
            }
            case BINARY: {
                return 2004;
            }
            case BOOLEAN: {
                return -7;
            }
            case DATE_TIME: {
                return 93;
            }
            case DB_POINTER: {
                return 0;
            }
            case DECIMAL128: {
                return 3;
            }
            case DOCUMENT: {
                return 0;
            }
            case DOUBLE: {
                return 8;
            }
            case INT32: {
                return 4;
            }
            case INT64: {
                return 4;
            }
            case JAVASCRIPT: {
                return 0;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return 0;
            }
            case MAX_KEY: {
                return 0;
            }
            case MIN_KEY: {
                return 0;
            }
            case NULL: {
                return 0;
            }
            case OBJECT_ID: {
                return -1;
            }
            case REGULAR_EXPRESSION: {
                return 0;
            }
            case STRING: {
                return -1;
            }
            case SYMBOL: {
                return 0;
            }
            case TIMESTAMP: {
                return 0;
            }
            case UNDEFINED: {
                return 0;
            }
        }
        throw new SQLException("Unknown BSON type: " + (Object)((Object)bsonTypeEnum) + ".");
    }

    public String toString() {
        try {
            return "Column{database='" + this.database + '\'' + ", table='" + this.table + '\'' + ", tableAlias='" + this.tableAlias + '\'' + ", column='" + this.column + '\'' + ", columnAlias='" + this.columnAlias + '\'' + ", bsonType=" + this.bsonType + '}';
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    public boolean isPolymorphic() {
        try {
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    public BsonType getBsonTypeEnum() {
        try {
            return this.bsonTypeEnum;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    public String getBsonTypeName() {
        try {
            return this.bsonType;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public int getJDBCType() {
        try {
            return this.jdbcType;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public int getNullability() {
        try {
            return 2;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnName() {
        try {
            return this.column;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public String getColumnAlias() {
        try {
            return this.columnAlias;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public String getTableName() {
        try {
            return this.table;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public String getTableAlias() {
        try {
            return this.tableAlias;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    public String getDatabase() {
        try {
            return this.database;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MySQLColumnInfo.java", MySQLColumnInfo.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "init", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "java.sql.SQLException", "void"), 69);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "java.lang.String"), 134);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableAlias", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "java.lang.String"), 197);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDatabase", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "java.lang.String"), 202);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isPolymorphic", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "boolean"), 157);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBsonTypeEnum", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "org.bson.BsonType"), 162);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBsonTypeName", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "java.lang.String"), 167);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getJDBCType", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "int"), 172);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNullability", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "int"), 177);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnName", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "java.lang.String"), 182);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnAlias", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "java.lang.String"), 187);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableName", "com.mongodb.jdbc.MySQLColumnInfo", "", "", "", "java.lang.String"), 192);
    }
}

