/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client.indications;

import org.sblim.wbem.cim.CIMException;

public class CIMError {
    private int iStatusCode;
    private String iDescription;

    public CIMError() {
        this(1, "");
    }

    public CIMError(CIMException pCimException) {
        if (pCimException == null) {
            throw new IllegalArgumentException("null cim exception argument");
        }
        this.iStatusCode = pCimException.getStatusCode();
        this.iDescription = pCimException.getDescription();
    }

    public CIMError(int pStatus) {
        this(pStatus, null);
    }

    public CIMError(int status, String msg) {
        this.setCode(status);
        this.setDescription(msg);
    }

    public int getCode() {
        return this.iStatusCode;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setCode(int pStatus) {
        if (pStatus > 18 || pStatus < 1) {
            throw new IllegalArgumentException("invalid error code");
        }
        this.iStatusCode = pStatus;
    }

    public void setDescription(String pDescription) {
        this.iDescription = pDescription;
    }

    public String toString() {
        return "CIMError: " + CIMException.getStatusFromCode(this.iStatusCode + 1) + (this.iDescription != null ? "(" + this.iDescription + ")" : "");
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMError)) {
            return false;
        }
        CIMError that = (CIMError)o;
        return this.iStatusCode == that.iStatusCode && (this.iDescription == null ? that.iDescription == null : this.iDescription.equals(that.iDescription));
    }

    public int hashCode() {
        return (this.iDescription != null ? this.iDescription.hashCode() : 0) << 16 + this.iStatusCode;
    }
}

