/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    DataOutputStream iOs;
    byte[] iBuffer;
    int iUsed;

    public ChunkedOutputStream(OutputStream os, int buflen) {
        this.iOs = new DataOutputStream(os);
        this.iBuffer = new byte[buflen];
        this.iUsed = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.iOs.writeChars("0\r\n");
        this.iOs.flush();
    }

    public void flush() throws IOException {
        if (this.iUsed > 0) {
            this.iOs.writeBytes(Integer.toHexString(this.iUsed) + "\r\n");
            this.iOs.write(this.iBuffer, 0, this.iUsed);
            this.iOs.writeBytes("\r\n");
            this.iOs.flush();
        }
        this.iUsed = 0;
    }

    public void write(byte[] source, int offset, int len) throws IOException {
        int copied = 0;
        while (len > 0) {
            int total;
            int n = total = this.iBuffer.length - this.iUsed < len ? this.iBuffer.length - this.iUsed : len;
            if (total > 0) {
                System.arraycopy(source, copied, this.iBuffer, this.iUsed, total);
                len -= total;
                this.iUsed += total;
                copied += total;
            }
            if (this.iUsed != this.iBuffer.length) continue;
            this.flush();
        }
    }

    public void write(int i) throws IOException {
        if (this.iBuffer.length == this.iUsed) {
            this.flush();
        }
        this.iBuffer[this.iUsed++] = (byte)(0xFF & i);
    }
}

