'use strict'

const logger = require('../logger');
const appConstants = require('../app-constants');

const appendMsg = 'HttpStatusCodeTest:'

function HttpStatusCodeTest(agent) {
  this.agent = agent;
  this.isRunning = false;
  this.promiseFor404 = null;
  _reset.call(this);
}

function _reset() {
  this.status404Data = {
    requestCount: 0,
    requestRedirectCount: 0
  }
}

module.exports = HttpStatusCodeTest;

HttpStatusCodeTest.prototype.start = function () {
  if (this.isRunning) return;

  const _self = this;
  const interval = this.agent.getConfig('http_status_404_interval');
  this.promiseFor404 = setInterval(function () {
    if (!_self.status404Data.requestCount) return;

    logger.info(appendMsg, _self.status404Data.requestCount + ' no of 404 is added to the queue');
    _self.agent.collector.add({
      btm: {
        is404Request: true,
        isHttpStatusCodeTestEnabled: true,
        requestDetails: Object.assign({}, _self.status404Data)
      }
    });
    _reset.call(_self);
  }, interval * 1000);

  this.isRunning = true;
  logger.info(appendMsg, 'Started..!');
}

HttpStatusCodeTest.prototype.add = function (trans) {
  const req = trans.requestIdentifier;
  if (!req) return true;

  if (req.statusCode === 404) {
    if (this.isRunning) {
      this.status404Data.requestCount++;
      if (req.isRequestRedirect) this.status404Data.requestRedirectCount++;
      logger.debug(appendMsg, '404 request is ignored, url:', req.uri);
    }
    return false;
  }

  if (this.agent.getConfig('http_status_code') !== true && this.agent.getConfig('enable_http_status_code_test') !== true) {
    delete req.statusCode;
    delete req.statusMessage;
    delete req.isRequestRedirect;
  }

  return true;
}

HttpStatusCodeTest.prototype.stop = function () {
  if (!this.isRunning) return;
  clearInterval(this.promiseFor404);
  this.isRunning = false;
  logger.info(appendMsg, 'Stoped..!');
}