/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.rolling.helper;

import com.eg.ch.qos.logback.core.pattern.DynamicConverter;
import com.eg.ch.qos.logback.core.pattern.FormatInfo;
import com.eg.ch.qos.logback.core.rolling.helper.MonoTypedConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerTokenConverter
extends DynamicConverter<Object>
implements MonoTypedConverter {
    public static final String CONVERTER_KEY = "i";

    @Override
    public String convert(int i) {
        String s = Integer.toString(i);
        FormatInfo formattingInfo = this.getFormattingInfo();
        if (formattingInfo == null) {
            return s;
        }
        int min = formattingInfo.getMin();
        StringBuilder sbuf = new StringBuilder();
        int j = s.length();
        while (j < min) {
            sbuf.append('0');
            ++j;
        }
        return sbuf.append(s).toString();
    }

    @Override
    public String convert(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null argument forbidden");
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return this.convert(i);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " of type" + o.getClass().getName());
    }

    @Override
    public boolean isApplicable(Object o) {
        return o instanceof Integer;
    }
}

