/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;

public class CIMException
extends RuntimeException
implements Serializable {
    private static final long serialVersionUID = 2720629774634502419L;
    public static final String CIM_ERR_FAILED = "CIM_ERR_FAILED";
    public static final String CIM_ERR_ACCESS_DENIED = "CIM_ERR_ACCESS_DENIED";
    public static final String CIM_ERR_INVALID_NAMESPACE = "CIM_ERR_INVALID_NAMESPACE";
    public static final String CIM_ERR_INVALID_PARAMETER = "CIM_ERR_INVALID_PARAMETER";
    public static final String CIM_ERR_INVALID_CLASS = "CIM_ERR_INVALID_CLASS";
    public static final String CIM_ERR_NOT_FOUND = "CIM_ERR_NOT_FOUND";
    public static final String CIM_ERR_NOT_SUPPORTED = "CIM_ERR_NOT_SUPPORTED";
    public static final String CIM_ERR_CLASS_HAS_CHILDREN = "CIM_ERR_CLASS_HAS_CHILDREN";
    public static final String CIM_ERR_CLASS_HAS_INSTANCES = "CIM_ERR_CLASS_HAS_INSTANCES";
    public static final String CIM_ERR_INVALID_SUPERCLASS = "CIM_ERR_INVALID_SUPERCLASS";
    public static final String CIM_ERR_ALREADY_EXISTS = "CIM_ERR_ALREADY_EXISTS";
    public static final String CIM_ERR_NO_SUCH_PROPERTY = "CIM_ERR_NO_SUCH_PROPERTY";
    public static final String CIM_ERR_TYPE_MISMATCH = "CIM_ERR_TYPE_MISMATCH";
    public static final String CIM_ERR_LOW_ON_MEMORY = "CIM_ERR_LOW_ON_MEMORY";
    public static final String CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED = "CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED";
    public static final String CIM_ERR_INVALID_QUERY = "CIM_ERR_INVALID_QUERY";
    public static final String CIM_ERR_METHOD_NOT_AVAILABLE = "CIM_ERR_METHOD_NOT_AVAILABLE";
    public static final String CIM_ERR_METHOD_NOT_FOUND = "CIM_ERR_METHOD_NOT_FOUND";
    public static final String CIM_ERR_NOT_IMPLEMENTED = "CIM_ERR_NOT_IMPLEMENTED";
    public static final String IBM_ERR_VER_ERROR = "IBM_ERR_VER_ERROR";
    public static final String IBM_ERR_TIMED_OUT = "IBM_ERR_TIMED_OUT";
    protected static final String[] CIM_ERROR_NAMES = new String[]{"CIM_ERR_FAILED", "CIM_ERR_ACCESS_DENIED", "CIM_ERR_INVALID_NAMESPACE", "CIM_ERR_INVALID_PARAMETER", "CIM_ERR_INVALID_CLASS", "CIM_ERR_NOT_FOUND", "CIM_ERR_NOT_SUPPORTED", "CIM_ERR_CLASS_HAS_CHILDREN", "CIM_ERR_CLASS_HAS_INSTANCES", "CIM_ERR_INVALID_SUPERCLASS", "CIM_ERR_ALREADY_EXISTS", "CIM_ERR_NO_SUCH_PROPERTY", "CIM_ERR_TYPE_MISMATCH", "CIM_ERR_QUERY_LANGUAGE_NOT_SUPPORTED", "CIM_ERR_INVALID_QUERY", "CIM_ERR_METHOD_NOT_AVAILABLE", "CIM_ERR_METHOD_NOT_FOUND"};
    private Throwable iCause;
    private String iReason;
    private String iDescription;
    private Object[] iExtendedReason;

    public CIMException() {
        this((String)null, (Object[])null);
    }

    public CIMException(String pReason) {
        this(pReason, (Object[])null);
    }

    public CIMException(String pReason, Object pExtendedReason) {
        this(pReason, new Object[]{pExtendedReason});
    }

    public CIMException(String pReason, Object pExtendedReason1, Object pExtendedReason2) {
        this(pReason, new Object[]{pExtendedReason1, pExtendedReason2});
    }

    public CIMException(String pReason, Object pExtendedReason1, Object pExtendedReason2, Object pExtendedReason3) {
        this(pReason, new Object[]{pExtendedReason1, pExtendedReason2, pExtendedReason3});
    }

    public CIMException(String pReason, Object[] pExtendedReason) {
        super(pReason);
        if (pExtendedReason != null) {
            for (int i = 0; i < pExtendedReason.length; ++i) {
                if (!(pExtendedReason[i] instanceof Throwable)) continue;
                this.iCause = (Throwable)pExtendedReason[i];
                break;
            }
        }
        this.iReason = pReason;
        this.iExtendedReason = pExtendedReason;
    }

    public CIMException(String pReason, Throwable pThrowable) {
        super(pReason);
        this.iCause = pThrowable;
        this.iReason = pReason;
        this.iExtendedReason = null;
    }

    public synchronized Throwable initCause(Throwable pCause) {
        if (this.iCause != this) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (pCause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.iCause = pCause;
        return this;
    }

    public String getID() {
        return this.iReason;
    }

    public void setDescription(String pDescription) {
        this.iDescription = pDescription;
    }

    public String getDescription() {
        if (this.iDescription == null) {
            if (this.iExtendedReason != null) {
                int i;
                StringBuffer sb = new StringBuffer();
                sb.append('(');
                sb.append(this.iReason);
                sb.append(": ");
                for (i = 0; i < this.iExtendedReason.length - 1; ++i) {
                    if (this.iExtendedReason[i] != null) {
                        sb.append(this.iExtendedReason[i].toString());
                    } else {
                        sb.append("null");
                    }
                    sb.append(',');
                }
                sb.append(this.iExtendedReason[i]);
                sb.append(')');
                sb.insert(0, this.iReason);
                return sb.toString();
            }
            return this.iReason;
        }
        return this.iDescription;
    }

    public String toString() {
        if (this.iExtendedReason != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            for (i = 0; i < this.iExtendedReason.length - 1; ++i) {
                Object o = this.iExtendedReason[i];
                if (o != null && !(o instanceof Throwable)) {
                    sb.append(this.iExtendedReason[i].toString());
                } else {
                    sb.append("null");
                }
                sb.append(',');
            }
            sb.append(this.iExtendedReason[i]);
            sb.append(')');
            sb.insert(0, super.toString());
            return sb.toString();
        }
        return super.toString();
    }

    public int getStatusCode() {
        return CIMException.getStatusCode(this.iReason);
    }

    public static int getStatusCode(String pMessage) {
        if (pMessage == null) {
            return -1;
        }
        for (int i = 0; i < CIM_ERROR_NAMES.length; ++i) {
            if (!pMessage.equalsIgnoreCase(CIM_ERROR_NAMES[i])) continue;
            return i + 1;
        }
        return -1;
    }

    public static String getStatusFromCode(int i) {
        return CIM_ERROR_NAMES[i > 0 && i <= CIM_ERROR_NAMES.length ? i - 1 : 0];
    }

    public void setParams(Object[] pReason) {
        this.iExtendedReason = pReason;
    }

    public Object[] getParams() {
        return this.iExtendedReason;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMException)) {
            return false;
        }
        CIMException that = (CIMException)o;
        if (!(this.iDescription == null && that.iDescription == null || this.iDescription != null && this.iDescription.equals(that.iDescription))) {
            return false;
        }
        if (!(this.iReason == null && that.iReason == null || this.iReason != null && this.iReason.equals(that.iReason))) {
            return false;
        }
        return this.iExtendedReason == null && that.iExtendedReason == null || this.iExtendedReason != null && this.iExtendedReason.equals(that.iExtendedReason);
    }

    public int hashCode() {
        return super.hashCode() + (this.iReason != null ? this.iReason.hashCode() : 0) << 16 + (this.iDescription != null ? this.iDescription.hashCode() : 0) << 8 + (this.iExtendedReason != null ? this.iExtendedReason.hashCode() : 0);
    }

    public String getMessage() {
        if (this.iCause == null) {
            return super.getMessage();
        }
        return super.getMessage() + "; nested exception is: \n\t" + this.iCause.toString();
    }

    public Throwable getCause() {
        return this.iCause == this ? null : this.iCause;
    }
}

