/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.contrib.json.classic;

import com.eg.ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import com.eg.ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import com.eg.ch.qos.logback.classic.spi.ILoggingEvent;
import com.eg.ch.qos.logback.classic.spi.IThrowableProxy;
import com.eg.ch.qos.logback.contrib.json.JsonLayoutBase;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonLayout
extends JsonLayoutBase<ILoggingEvent> {
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String THREAD_ATTR_NAME = "thread";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "logger";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "message";
    public static final String MESSAGE_ATTR_NAME = "raw-message";
    public static final String EXCEPTION_ATTR_NAME = "exception";
    public static final String CONTEXT_ATTR_NAME = "context";
    protected boolean includeLevel = true;
    protected boolean includeThreadName = true;
    protected boolean includeMDC = true;
    protected boolean includeLoggerName = true;
    protected boolean includeFormattedMessage = true;
    protected boolean includeMessage;
    protected boolean includeException = true;
    protected boolean includeContextName = true;
    private ThrowableHandlingConverter throwableProxyConverter = new ThrowableProxyConverter();

    public void start() {
        this.throwableProxyConverter.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.throwableProxyConverter.stop();
    }

    @Override
    protected Map toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.addTimestamp(TIMESTAMP_ATTR_NAME, this.includeTimestamp, event.getTimeStamp(), map);
        this.add(LEVEL_ATTR_NAME, this.includeLevel, String.valueOf(event.getLevel()), map);
        this.add(THREAD_ATTR_NAME, this.includeThreadName, event.getThreadName(), map);
        this.addMap(MDC_ATTR_NAME, this.includeMDC, event.getMDCPropertyMap(), map);
        this.add(LOGGER_ATTR_NAME, this.includeLoggerName, event.getLoggerName(), map);
        this.add(FORMATTED_MESSAGE_ATTR_NAME, this.includeFormattedMessage, event.getFormattedMessage(), map);
        this.add(MESSAGE_ATTR_NAME, this.includeMessage, event.getMessage(), map);
        this.add(CONTEXT_ATTR_NAME, this.includeContextName, event.getLoggerContextVO().getName(), map);
        this.addThrowableInfo(EXCEPTION_ATTR_NAME, this.includeException, event, map);
        this.addCustomDataToJsonMap(map, event);
        return map;
    }

    protected void addThrowableInfo(String fieldName, boolean field, ILoggingEvent value, Map<String, Object> map) {
        String ex;
        IThrowableProxy throwableProxy;
        if (field && value != null && (throwableProxy = value.getThrowableProxy()) != null && (ex = this.throwableProxyConverter.convert((Object)value)) != null && !ex.equals("")) {
            map.put(fieldName, ex);
        }
    }

    protected void addCustomDataToJsonMap(Map<String, Object> map, ILoggingEvent event) {
    }

    public boolean isIncludeLevel() {
        return this.includeLevel;
    }

    public void setIncludeLevel(boolean includeLevel) {
        this.includeLevel = includeLevel;
    }

    public boolean isIncludeLoggerName() {
        return this.includeLoggerName;
    }

    public void setIncludeLoggerName(boolean includeLoggerName) {
        this.includeLoggerName = includeLoggerName;
    }

    public boolean isIncludeFormattedMessage() {
        return this.includeFormattedMessage;
    }

    public void setIncludeFormattedMessage(boolean includeFormattedMessage) {
        this.includeFormattedMessage = includeFormattedMessage;
    }

    public boolean isIncludeMessage() {
        return this.includeMessage;
    }

    public void setIncludeMessage(boolean includeMessage) {
        this.includeMessage = includeMessage;
    }

    public boolean isIncludeMDC() {
        return this.includeMDC;
    }

    public void setIncludeMDC(boolean includeMDC) {
        this.includeMDC = includeMDC;
    }

    public boolean isIncludeThreadName() {
        return this.includeThreadName;
    }

    public void setIncludeThreadName(boolean includeThreadName) {
        this.includeThreadName = includeThreadName;
    }

    public boolean isIncludeException() {
        return this.includeException;
    }

    public void setIncludeException(boolean includeException) {
        this.includeException = includeException;
    }

    public boolean isIncludeContextName() {
        return this.includeContextName;
    }

    public void setIncludeContextName(boolean includeContextName) {
        this.includeContextName = includeContextName;
    }

    public ThrowableHandlingConverter getThrowableProxyConverter() {
        return this.throwableProxyConverter;
    }

    public void setThrowableProxyConverter(ThrowableHandlingConverter throwableProxyConverter) {
        this.throwableProxyConverter = throwableProxyConverter;
    }
}

