/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.requestreply;

import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.ClosedFacilityException;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.InvalidOperationException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPInterruptedException;
import com.solacesystems.jcsmp.JCSMPTransportException;
import com.solacesystems.jcsmp.Requestor;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.XMLMessageConsumer;
import com.solacesystems.jcsmp.XMLMessageProducer;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.JCSMPBasicSession;
import com.solacesystems.jcsmp.impl.JCSMPUtils;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageConsumer;
import com.solacesystems.jcsmp.impl.JCSMPXMLMessageProducer;
import com.solacesystems.jcsmp.impl.requestreply.GenericRequestTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestorImpl
implements Requestor {
    private final JCSMPBasicSession _session;
    private static final Log Trace = LogFactory.getLog(RequestorImpl.class);

    public RequestorImpl(JCSMPBasicSession session) {
        this._session = session;
    }

    private void validateCanRequest(XMLMessageProducer producer, XMLMessageConsumer consumer) throws JCSMPException {
        if (producer == null) {
            throw new InvalidOperationException("No producer to perform operation");
        }
        if (consumer == null) {
            throw new InvalidOperationException("No consumer to perform operation");
        }
    }

    @Override
    public BytesXMLMessage request(XMLMessage request, long timeoutMillis, Destination sendDestination) throws JCSMPException {
        if (JCSMPUtils.isAdMessage(request)) {
            throw new IllegalArgumentException(JCSMPRB.BUNDLE.getStringSafely("Requestor.cannotSendAd"));
        }
        if (Trace.isDebugEnabled()) {
            Trace.debug((Object)String.format("Requestor.request: timeout=%s, msg=%s", timeoutMillis, request));
        }
        if (this._session.isClosed()) {
            throw new ClosedFacilityException("Session is closed.");
        }
        JCSMPXMLMessageProducer producer = this._session.getProducer();
        JCSMPXMLMessageConsumer consumer = this._session.getConsumer();
        this.validateCanRequest(producer, consumer);
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException(String.format(JCSMPRB.BUNDLE.getStringSafely("GlobalMessages.argumentMustBeGreaterThan"), "timeoutMillis", 0));
        }
        boolean isBlocking = timeoutMillis > 0L;
        GenericRequestTask task = new GenericRequestTask(this._session, request, producer, consumer, sendDestination, timeoutMillis);
        task.send();
        if (isBlocking) {
            try {
                return task.waitForResponse();
            }
            catch (JCSMPTransportException e) {
                throw new JCSMPInterruptedException("Request interrupted", (Throwable)((Object)e));
            }
            catch (JCSMPException e) {
                throw e;
            }
        }
        return null;
    }
}

