/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.jdbc.BsonExplicitCursor;
import com.mongodb.jdbc.BsonTypeInfo;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoDatabaseMetaData;
import com.mongodb.jdbc.MongoDriver;
import com.mongodb.jdbc.MongoFunctions;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.MongoJsonSchemaResult;
import com.mongodb.jdbc.MongoListTablesResult;
import com.mongodb.jdbc.MongoSQLFunctions;
import com.mongodb.jdbc.MongoSQLResultSet;
import com.mongodb.jdbc.Pair;
import com.mongodb.jdbc.SortableBsonDocument;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;

@AutoLoggable
public class MongoSQLDatabaseMetaData
extends MongoDatabaseMetaData
implements DatabaseMetaData,
LoggingAspect$ajcMightHaveAspect {
    private static final String BOT_NAME = "";
    private static final String INDEX_KEY_KEY = "key";
    private static final String INDEX_NAME_KEY = "name";
    private static final List<String> UNIQUE_KEY_PATH;
    private static final List<SortableBsonDocument.SortSpec> GET_TABLES_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_TABLE_PRIVILEGES_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_COLUMNS_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_COLUMN_PRIVILEGES_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_PRIMARY_KEYS_SORT_SPECS;
    private static final List<SortableBsonDocument.SortSpec> GET_INDEX_INFO_SORT_SPECS;
    private static final MongoSQLFunctions MongoSQLFunctions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_30;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_31;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_32;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_33;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_34;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_35;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_36;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_37;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_38;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_39;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_40;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_41;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_42;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_43;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_44;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_45;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_46;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_47;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_48;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_49;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_50;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_51;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_52;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_53;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_54;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_55;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_56;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_57;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_58;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_59;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_60;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_61;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_62;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_63;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_64;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_65;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_66;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_67;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_68;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_69;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_70;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_71;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_72;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_73;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_74;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    static {
        MongoSQLDatabaseMetaData.ajc$preClinit();
        UNIQUE_KEY_PATH = Arrays.asList("options", "unique");
        GET_TABLES_SORT_SPECS = Arrays.asList(new SortableBsonDocument.SortSpec("TABLE_TYPE", SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec("TABLE_CAT", SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec("TABLE_NAME", SortableBsonDocument.ValueType.String));
        GET_TABLE_PRIVILEGES_SORT_SPECS = Arrays.asList(new SortableBsonDocument.SortSpec("TABLE_CAT", SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec("TABLE_NAME", SortableBsonDocument.ValueType.String));
        GET_COLUMNS_SORT_SPECS = Arrays.asList(new SortableBsonDocument.SortSpec("TABLE_CAT", SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec("TABLE_NAME", SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec("ORDINAL_POSITION", SortableBsonDocument.ValueType.Int));
        GET_COLUMN_PRIVILEGES_SORT_SPECS = Collections.singletonList(new SortableBsonDocument.SortSpec("COLUMN_NAME", SortableBsonDocument.ValueType.String));
        GET_PRIMARY_KEYS_SORT_SPECS = Collections.singletonList(new SortableBsonDocument.SortSpec("COLUMN_NAME", SortableBsonDocument.ValueType.String));
        GET_INDEX_INFO_SORT_SPECS = Arrays.asList(new SortableBsonDocument.SortSpec("NON_UNIQUE", SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec("INDEX_NAME", SortableBsonDocument.ValueType.String), new SortableBsonDocument.SortSpec("ORDINAL_POSITION", SortableBsonDocument.ValueType.Int));
        MongoSQLFunctions = com.mongodb.jdbc.MongoSQLFunctions.getInstance();
    }

    public MongoSQLDatabaseMetaData(MongoConnection conn) {
        super(conn);
        LoggingAspect.ajc$perObjectBind(this);
    }

    private BsonDocument createBottomBson(BsonElement ... elements) {
        try {
            BsonDocument bot = new BsonDocument(Arrays.asList(elements));
            return new BsonDocument(BOT_NAME, bot);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    private SortableBsonDocument createSortableBottomBson(List<SortableBsonDocument.SortSpec> sortSpecs, BsonElement ... elements) {
        try {
            BsonDocument bot = new BsonDocument(Arrays.asList(elements));
            return new SortableBsonDocument(sortSpecs, BOT_NAME, bot);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @SafeVarargs
    private final MongoJsonSchema createBottomSchema(MongoJsonSchema.ScalarProperties ... resultSchemaFields) {
        try {
            MongoJsonSchema resultSchema = MongoJsonSchema.createEmptyObjectSchema();
            resultSchema.addScalarKeys(resultSchemaFields);
            MongoJsonSchema bot = MongoJsonSchema.createEmptyObjectSchema();
            bot.required.add(BOT_NAME);
            bot.properties.put(BOT_NAME, resultSchema);
            return bot;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_3, this, this));
            }
            return "AGGREGATE,ASC,BINDATA,BIT,BOOL,BSON_DATE,BSON_TIMESTAMP,DBPOINTER,DESC,DOCUMENT,ERROR,EXTRACT,FIRST,JAVASCRIPT,JAVASCRIPTWITHSCOPE,LIMIT,LONG,MAXKEY,MINKEY,MISSING,NEXT,NUMBER,OBJECTID,OFFSET,POSITION,REGEX,SUBSTRING,SYMBOL,TRIM,UNDEFINED";
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_4, this, this));
            }
            return MongoSQLDatabaseMetaData.MongoSQLFunctions.numericFunctionsString;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_5, this, this));
            }
            return MongoSQLDatabaseMetaData.MongoSQLFunctions.stringFunctionsString;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_6, this, this));
            }
            return MongoSQLDatabaseMetaData.MongoSQLFunctions.systemFunctionsString;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_7, this, this));
            }
            return MongoSQLDatabaseMetaData.MongoSQLFunctions.dateFunctionsString;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = procedureNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_8, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("PROCEDURE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PROCEDURE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PROCEDURE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("PROCEDURE_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SPECIFIC_NAME", BsonTypeInfo.BSON_STRING));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = procedureNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_9, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("PROCEDURE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PROCEDURE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PROCEDURE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("PRECISION", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("LENGTH", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SCALE", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("RADIX", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("NULLABLE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_DEF", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SQL_DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SQL_DATETIME_SUB", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("CHAR_OCTET_LENGTH", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("ORDINAL_POSITION", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("IS_NULLABLE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("SPECIFIC_NAME", BsonTypeInfo.BSON_STRING));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_10, this, this));
            }
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>();
            MongoJsonSchema schema = MongoJsonSchema.createEmptyObjectSchema();
            schema.addScalarKeys(new MongoJsonSchema.ScalarProperties("TABLE_TYPE", BsonTypeInfo.BSON_STRING));
            docs.add(this.createBottomBson(new BsonElement("TABLE_TYPE", new BsonString("TABLE"))));
            docs.add(this.createBottomBson(new BsonElement("TABLE_TYPE", new BsonString("VIEW"))));
            MongoJsonSchema botSchema = MongoJsonSchema.createEmptyObjectSchema();
            botSchema.properties.put(BOT_NAME, schema);
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)new BsonExplicitCursor(docs), botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    private Stream<String> getDatabaseNames() {
        try {
            return this.conn.mongoClient.listDatabaseNames().into(new ArrayList()).stream();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    private Stream<MongoListTablesResult> getTableDataFromDB(String dbName, Function<MongoListTablesResult, Boolean> filter) {
        try {
            return this.conn.getDatabase(dbName).withCodecRegistry(MongoDriver.registry).listCollections(MongoListTablesResult.class).into(new ArrayList()).stream().filter(filter::apply);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    private BsonDocument toGetTablesDoc(String dbName, MongoListTablesResult res) {
        try {
            return this.createSortableBottomBson(GET_TABLES_SORT_SPECS, new BsonElement("TABLE_CAT", new BsonString(dbName)), new BsonElement("TABLE_SCHEM", BsonNull.VALUE), new BsonElement("TABLE_NAME", new BsonString(res.name)), new BsonElement("TABLE_TYPE", new BsonString(res.type)), new BsonElement("REMARKS", BsonNull.VALUE), new BsonElement("TYPE_CAT", BsonNull.VALUE), new BsonElement("TYPE_SCHEM", BsonNull.VALUE), new BsonElement("TYPE_NAME", BsonNull.VALUE), new BsonElement("SELF_REFERENCING_COL_NAME", BsonNull.VALUE), new BsonElement("REF_GENERATION", BsonNull.VALUE));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    private BsonDocument toGetTablePrivilegesDoc(String dbName, MongoListTablesResult res) {
        try {
            return this.createSortableBottomBson(GET_TABLE_PRIVILEGES_SORT_SPECS, new BsonElement("TABLE_CAT", new BsonString(dbName)), new BsonElement("TABLE_SCHEM", BsonNull.VALUE), new BsonElement("TABLE_NAME", new BsonString(res.name)), new BsonElement("GRANTOR", BsonNull.VALUE), new BsonElement("GRANTEE", new BsonString(BOT_NAME)), new BsonElement("PRIVILEGE", new BsonString("SELECT")), new BsonElement("IS_GRANTABLE", BsonNull.VALUE));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> getTableDataFromDB(String dbName, Pattern tableNamePatternRE, List<String> types, BiFunction<String, MongoListTablesResult, BsonDocument> bsonSerializer) {
        try {
            return this.getTableDataFromDB(dbName, res -> !(tableNamePatternRE != null && !tableNamePatternRE.matcher(res.name).matches() || types != null && !types.contains(res.type.toLowerCase()))).map(res -> (BsonDocument)bsonSerializer.apply(dbName, (MongoListTablesResult)res));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    private List<String> toTableTypeList(String[] types) {
        try {
            List<String> l = null;
            if (types != null) {
                l = Arrays.asList(types);
                l.replaceAll(String::toLowerCase);
            }
            return l;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        String[] stringArray = types;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, stringArray};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_17, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("TABLE_TYPE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("TYPE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SELF_REFERENCING_COL_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("REF_GENERATION", BsonTypeInfo.BSON_STRING, false));
            Pattern tableNamePatternRE = MongoSQLDatabaseMetaData.toJavaPattern(tableNamePattern);
            List<String> typesList = this.toTableTypeList(types);
            Stream<Object> docs = catalog == null ? this.getDatabaseNames().flatMap(dbName -> {
                try {
                    return this.getTableDataFromDB((String)dbName, tableNamePatternRE, typesList, this::toGetTablesDoc);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_56);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : this.getTableDataFromDB(catalog, tableNamePatternRE, typesList, this::toGetTablesDoc));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_18, this, this));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("TABLE_CATALOG", BsonTypeInfo.BSON_STRING, false));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_19, this, this));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING));
            BsonExplicitCursor c = new BsonExplicitCursor(this.getDatabaseNames().sorted().map(dbName -> {
                try {
                    return this.createBottomBson(new BsonElement("TABLE_CAT", new BsonString((String)dbName)));
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_57);
                    }
                    throw exception;
                }
            }).collect(Collectors.toList()));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    private static <T> T liftSQLException(Supplier<T> f) throws SQLException {
        try {
            return f.get();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw e;
        }
    }

    private BsonDocument toGetColumnsDoc(GetColumnsDocInfo i) {
        try {
            BsonString isNullable = new BsonString(i.nullability == 0 ? "NO" : (i.nullability == 1 ? "YES" : BOT_NAME));
            return this.createSortableBottomBson(GET_COLUMNS_SORT_SPECS, new BsonElement("TABLE_CAT", new BsonString(i.dbName)), new BsonElement("TABLE_SCHEM", BsonNull.VALUE), new BsonElement("TABLE_NAME", new BsonString(i.tableName)), new BsonElement("COLUMN_NAME", new BsonString(i.columnName)), new BsonElement("DATA_TYPE", new BsonInt32(i.columnBsonTypeInfo.getJdbcType())), new BsonElement("TYPE_NAME", new BsonString(i.columnBsonTypeInfo.getBsonName())), new BsonElement("COLUMN_SIZE", BsonNull.VALUE), new BsonElement("BUFFER_LENGTH", new BsonInt32(0)), new BsonElement("DECIMAL_DIGITS", this.asBsonIntOrNull(i.columnBsonTypeInfo.getDecimalDigits())), new BsonElement("NUM_PREC_RADIX", new BsonInt32(i.columnBsonTypeInfo.getNumPrecRadix())), new BsonElement("NULLABLE", new BsonInt32(i.nullability)), new BsonElement("REMARKS", new BsonString(BOT_NAME)), new BsonElement("COLUMN_DEF", BsonNull.VALUE), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("CHAR_OCTET_LENGTH", this.asBsonIntOrNull(i.columnBsonTypeInfo.getCharOctetLength())), new BsonElement("ORDINAL_POSITION", new BsonInt32(i.idx)), new BsonElement("IS_NULLABLE", isNullable), new BsonElement("SCOPE_CATALOG", BsonNull.VALUE), new BsonElement("SCOPE_SCHEMA", BsonNull.VALUE), new BsonElement("SCOPE_TABLE", BsonNull.VALUE), new BsonElement("SOURCE_DATA_TYPE", new BsonInt32(0)), new BsonElement("IS_AUTOINCREMENT", new BsonString("NO")), new BsonElement("IS_GENERATEDCOLUMN", new BsonString(BOT_NAME)));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    private BsonDocument toGetColumnPrivilegesDoc(GetColumnsDocInfo i) {
        try {
            return this.createSortableBottomBson(GET_COLUMN_PRIVILEGES_SORT_SPECS, new BsonElement("TABLE_CAT", new BsonString(i.dbName)), new BsonElement("TABLE_SCHEM", BsonNull.VALUE), new BsonElement("TABLE_NAME", new BsonString(i.tableName)), new BsonElement("COLUMN_NAME", new BsonString(i.columnName)), new BsonElement("GRANTOR", BsonNull.VALUE), new BsonElement("GRANTEE", new BsonString(BOT_NAME)), new BsonElement("PRIVILEGE", new BsonString("SELECT")), new BsonElement("IS_GRANTABLE", BsonNull.VALUE));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    private boolean isValidSchema(MongoJsonSchemaResult res) {
        try {
            return res.ok == 1 && res.schema.mongoJsonSchema != null && res.schema.mongoJsonSchema.isObject();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> getColumnsFromDB(String dbName, Pattern tableNamePatternRE, Pattern columnNamePatternRE, Function<GetColumnsDocInfo, BsonDocument> bsonSerializer) {
        try {
            MongoDatabase db = this.conn.getDatabase(dbName).withCodecRegistry(MongoDriver.registry);
            return db.listCollectionNames().into(new ArrayList()).stream().filter(tableName -> tableNamePatternRE == null || tableNamePatternRE.matcher((CharSequence)tableName).matches()).map(tableName -> new Pair<Pair<String, String>, MongoJsonSchemaResult>(new Pair<String, String>(dbName, (String)tableName), db.runCommand((Bson)new BsonDocument("sqlGetSchema", new BsonString((String)tableName)), MongoJsonSchemaResult.class))).filter(p -> {
                try {
                    return this.isValidSchema((MongoJsonSchemaResult)p.right());
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_58);
                    }
                    throw exception;
                }
            }).flatMap(p -> {
                Pair ns = (Pair)p.left();
                MongoJsonSchemaResult res = (MongoJsonSchemaResult)p.right();
                AtomicInteger idx = new AtomicInteger();
                return res.schema.mongoJsonSchema.properties.entrySet().stream().filter(entry -> columnNamePatternRE == null || columnNamePatternRE.matcher((CharSequence)entry.getKey()).matches()).sorted(Map.Entry.comparingByKey()).map(entry -> (BsonDocument)bsonSerializer.apply(new GetColumnsDocInfo((String)ns.left(), (String)ns.right(), (String)entry.getKey(), mongoJsonSchemaResult.schema.mongoJsonSchema, (MongoJsonSchema)entry.getValue(), idx.getAndIncrement())));
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_24, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_SIZE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("BUFFER_LENGTH", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("DECIMAL_DIGITS", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("NUM_PREC_RADIX", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("NULLABLE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("COLUMN_DEF", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SQL_DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SQL_DATETIME_SUB", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("CHAR_OCTET_LENGTH", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("ORDINAL_POSITION", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("IS_NULLABLE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("SCOPE_CATALOG", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SCOPE_SCHEMA", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SCOPE_TABLE", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SOURCE_DATA_TYPE", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("IS_AUTOINCREMENT", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("IS_GENERATEDCOLUMN", BsonTypeInfo.BSON_STRING));
            Pattern tableNamePatternRE = MongoSQLDatabaseMetaData.toJavaPattern(tableNamePattern);
            Pattern columnNamePatternRE = MongoSQLDatabaseMetaData.toJavaPattern(columnNamePattern);
            Stream docs = catalog == null ? MongoSQLDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getDatabaseNames().flatMap(dbName -> {
                        try {
                            return this.getColumnsFromDB((String)dbName, tableNamePatternRE, columnNamePatternRE, this::toGetColumnsDoc);
                        }
                        catch (Exception exception) {
                            if (LoggingAspect.hasAspect(this)) {
                                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_71);
                            }
                            throw exception;
                        }
                    });
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_59);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : MongoSQLDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getColumnsFromDB(catalog, tableNamePatternRE, columnNamePatternRE, this::toGetColumnsDoc);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_60);
                    }
                    throw exception;
                }
            }));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_25, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("GRANTOR", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("GRANTEE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("PRIVILEGE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("IS_GRANTABLE", BsonTypeInfo.BSON_STRING, false));
            Pattern tableNamePatternRE = MongoSQLDatabaseMetaData.toJavaPattern(tableNamePattern);
            Pattern columnNamePatternRE = MongoSQLDatabaseMetaData.toJavaPattern(columnNamePattern);
            Stream docs = catalog == null ? MongoSQLDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getDatabaseNames().flatMap(dbName -> {
                        try {
                            return this.getColumnsFromDB((String)dbName, tableNamePatternRE, columnNamePatternRE, this::toGetColumnPrivilegesDoc);
                        }
                        catch (Exception exception) {
                            if (LoggingAspect.hasAspect(this)) {
                                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_72);
                            }
                            throw exception;
                        }
                    });
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_61);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : MongoSQLDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getColumnsFromDB(catalog, tableNamePatternRE, columnNamePatternRE, this::toGetColumnPrivilegesDoc);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_62);
                    }
                    throw exception;
                }
            }));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_26, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("GRANTOR", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("GRANTEE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("PRIVILEGE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("IS_GRANTABLE", BsonTypeInfo.BSON_STRING, false));
            Pattern tableNamePatternRE = MongoSQLDatabaseMetaData.toJavaPattern(tableNamePattern);
            Stream<Object> docs = catalog == null ? this.getDatabaseNames().flatMap(dbName -> {
                try {
                    return this.getTableDataFromDB((String)dbName, tableNamePatternRE, null, this::toGetTablePrivilegesDoc);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_63);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : this.getTableDataFromDB(catalog, tableNamePatternRE, null, this::toGetTablePrivilegesDoc));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_26);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> getFirstUniqueIndexDocsForTable(String dbName, String tableName, BiFunction<Pair<String, String>, Document, List<BsonDocument>> serializer) {
        try {
            MongoDatabase db = this.conn.getDatabase(dbName).withCodecRegistry(MongoDriver.registry);
            ListIndexesIterable<Document> i = db.getCollection(tableName).listIndexes();
            ArrayList docs = new ArrayList();
            for (Document d : i) {
                Boolean isUnique = (Boolean)((Object)d.getEmbedded((List<?>)UNIQUE_KEY_PATH, Boolean.class));
                if (isUnique == null || !isUnique.booleanValue()) continue;
                docs.addAll(serializer.apply(new Pair<String, String>(dbName, tableName), d));
                break;
            }
            return docs.stream();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_27);
            }
            throw exception;
        }
    }

    private ResultSet getFirstUniqueIndexResultSet(String catalog, String table, MongoJsonSchema botSchema, BiFunction<Pair<String, String>, Document, List<BsonDocument>> serializer) {
        try {
            try {
                Stream<Object> docs = catalog == null ? this.getDatabaseNames().flatMap(dbName -> {
                    try {
                        return this.getTableDataFromDB((String)dbName, res -> res.name.equals(table)).flatMap(r -> {
                            try {
                                return this.getFirstUniqueIndexDocsForTable((String)dbName, r.name, serializer);
                            }
                            catch (Exception exception) {
                                if (LoggingAspect.hasAspect(this)) {
                                    LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_73);
                                }
                                throw exception;
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (LoggingAspect.hasAspect(this)) {
                            LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_64);
                        }
                        throw exception;
                    }
                }) : (catalog.isEmpty() ? Stream.empty() : this.getFirstUniqueIndexDocsForTable(catalog, table, serializer));
                List<BsonDocument> docsList = docs.collect(Collectors.toList());
                BsonExplicitCursor c = new BsonExplicitCursor(docsList);
                return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)c, botSchema);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_28);
            }
            throw exception;
        }
    }

    private List<BsonDocument> toGetBestRowIdentifierDocs(Pair<String, String> namespace, Document indexInfo) {
        try {
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>();
            MongoJsonSchemaResult r = this.conn.getDatabase(namespace.left()).runCommand((Bson)new BsonDocument("sqlGetSchema", new BsonString(namespace.right())), MongoJsonSchemaResult.class);
            Document keys = (Document)((Object)indexInfo.get((Object)INDEX_KEY_KEY, Document.class));
            try {
                for (String key : keys.keySet()) {
                    docs.add(this.toGetBestRowIdentifierDoc(key, r.schema.mongoJsonSchema.properties.get(key).getBsonTypeInfo()));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return docs;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_29);
            }
            throw exception;
        }
    }

    private BsonDocument toGetBestRowIdentifierDoc(String columnName, BsonTypeInfo columnBsonTypeInfo) {
        try {
            return this.createBottomBson(new BsonElement("SCOPE", BsonNull.VALUE), new BsonElement("COLUMN_NAME", new BsonString(columnName)), new BsonElement("DATA_TYPE", new BsonInt32(columnBsonTypeInfo.getJdbcType())), new BsonElement("TYPE_NAME", new BsonString(columnBsonTypeInfo.getBsonName())), new BsonElement("COLUMN_SIZE", this.asBsonIntOrNull(columnBsonTypeInfo.getPrecision())), new BsonElement("BUFFER_LENGTH", BsonNull.VALUE), new BsonElement("DECIMAL_DIGITS", this.asBsonIntOrNull(columnBsonTypeInfo.getDecimalDigits())), new BsonElement("PSEUDO_COLUMN", new BsonInt32(1)));
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_30);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        int n = scope;
        boolean bl = nullable;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, Conversions.intObject(n), Conversions.booleanObject(bl)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_31, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("SCOPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_SIZE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("BUFFER_LENGTH", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DECIMAL_DIGITS", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("PSEUDO_COLUMN", BsonTypeInfo.BSON_INT));
            return MongoSQLDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getFirstUniqueIndexResultSet(catalog, table, botSchema, this::toGetBestRowIdentifierDocs);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_65);
                    }
                    throw exception;
                }
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_31);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_32, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("SCOPE", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_SIZE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("BUFFER_LENGTH", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DECIMAL_DIGITS", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("PSEUDO_COLUMN", BsonTypeInfo.BSON_INT));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_32);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_33, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("PKTABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PKTABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PKTABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("PKCOLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("FKTABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FKTABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FKTABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("FKCOLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("KEY_SEQ", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("UPDATE_RULE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DELETE_RULE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("FK_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PK_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("DEFERRABILITY", BsonTypeInfo.BSON_INT));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_33);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_34, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("PKTABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PKTABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PKTABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("PKCOLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("FKTABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FKTABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FKTABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("FKCOLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("KEY_SEQ", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("UPDATE_RULE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DELETE_RULE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("FK_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PK_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("DEFERRABILITY", BsonTypeInfo.BSON_INT));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_34);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String string = parentCatalog;
        String string2 = parentSchema;
        String string3 = parentTable;
        String string4 = foreignCatalog;
        String string5 = foreignSchema;
        String string6 = foreignTable;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_35, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("PKTABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PKTABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PKTABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("PKCOLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("FKTABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FKTABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FKTABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("FKCOLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("KEY_SEQ", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("UPDATE_RULE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DELETE_RULE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("FK_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("PK_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("DEFERRABILITY", BsonTypeInfo.BSON_INT));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_35);
            }
            throw exception;
        }
    }

    private List<BsonDocument> toGetPrimaryKeysDocs(Pair<String, String> namespace, Document indexInfo) {
        try {
            Document keys = (Document)((Object)indexInfo.get((Object)INDEX_KEY_KEY, Document.class));
            String indexName = indexInfo.getString(INDEX_NAME_KEY);
            AtomicInteger pos = new AtomicInteger();
            return keys.keySet().stream().map(key -> {
                try {
                    return this.createSortableBottomBson(GET_PRIMARY_KEYS_SORT_SPECS, new BsonElement("TABLE_CAT", new BsonString((String)namespace.left())), new BsonElement("TABLE_SCHEM", BsonNull.VALUE), new BsonElement("TABLE_NAME", new BsonString((String)namespace.right())), new BsonElement("COLUMN_NAME", new BsonString((String)key)), new BsonElement("KEY_SEQ", new BsonInt32(pos.incrementAndGet())), new BsonElement("PK_NAME", new BsonString(indexName)));
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_66);
                    }
                    throw exception;
                }
            }).sorted().collect(Collectors.toList());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_36);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_37, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("KEY_SEQ", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("PK_NAME", BsonTypeInfo.BSON_STRING, false));
            return MongoSQLDatabaseMetaData.liftSQLException(() -> {
                try {
                    return this.getFirstUniqueIndexResultSet(catalog, table, botSchema, this::toGetPrimaryKeysDocs);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_67);
                    }
                    throw exception;
                }
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_37);
            }
            throw exception;
        }
    }

    private MongoJsonSchema getTypeInfoJsonSchema() {
        try {
            MongoJsonSchema schema = MongoJsonSchema.createEmptyObjectSchema();
            schema.addScalarKeys(new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("PRECISION", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("LITERAL_PREFIX", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("LITERAL_SUFFIX", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("CREATE_PARAMS", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("NULLABLE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("CASE_SENSITIVE", BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties("SEARCHABLE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("UNSIGNED_ATTRIBUTE", BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties("FIX_PREC_SCALE", BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties("AUTO_INCREMENT", BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties("LOCAL_TYPE_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("MINIMUM_SCALE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("MAXIMUM_SCALE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SQL_DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SQL_DATETIME_SUB", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("NUM_PREC_RADIX", BsonTypeInfo.BSON_INT));
            return schema;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_38);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_39, this, this));
            }
            BsonNull n = new BsonNull();
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>();
            MongoJsonSchema schema = this.getTypeInfoJsonSchema();
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_BINDATA.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(-2)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_BINDATA.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_BINDATA.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(0)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_BINDATA.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_BINDATA.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_BINDATA.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_BOOL.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(-7)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_BOOL.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_BOOL.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_BOOL.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_BOOL.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_BOOL.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_DATE.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(93)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_DATE.getPrecision())), new BsonElement("LITERAL_PREFIX", new BsonString("'")), new BsonElement("LITERAL_SUFFIX", new BsonString("'")), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_DATE.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_DATE.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_DATE.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_DATE.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_DECIMAL.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(3)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_DECIMAL.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_DECIMAL.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_DECIMAL.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_DECIMAL.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_DECIMAL.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_DOUBLE.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(8)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_DOUBLE.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_DOUBLE.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_DOUBLE.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_DOUBLE.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_DOUBLE.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_INT.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(4)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_INT.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_INT.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_INT.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_INT.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_INT.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_LONG.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(-5)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_LONG.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_LONG.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_LONG.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_LONG.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_LONG.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_STRING.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(-1)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_STRING.getPrecision())), new BsonElement("LITERAL_PREFIX", new BsonString("'")), new BsonElement("LITERAL_SUFFIX", new BsonString("'")), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_STRING.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_STRING.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_STRING.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_STRING.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_ARRAY.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_ARRAY.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_ARRAY.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_ARRAY.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_ARRAY.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_ARRAY.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_OBJECT.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_OBJECT.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_OBJECT.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_OBJECT.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_OBJECT.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_OBJECT.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_OBJECTID.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_OBJECTID.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_OBJECTID.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_OBJECTID.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_OBJECTID.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_OBJECTID.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_DBPOINTER.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_DBPOINTER.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_DBPOINTER.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_DBPOINTER.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_DBPOINTER.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_DBPOINTER.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_JAVASCRIPT.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_JAVASCRIPT.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_JAVASCRIPT.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPT.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPT.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPT.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_JAVASCRIPTWITHSCOPE.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_MAXKEY.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_MAXKEY.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_MAXKEY.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_MAXKEY.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_MAXKEY.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_MAXKEY.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_MINKEY.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_MINKEY.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_MINKEY.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_MINKEY.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_MINKEY.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_MINKEY.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_REGEX.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_REGEX.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_REGEX.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_REGEX.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_REGEX.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_REGEX.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_SYMBOL.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_SYMBOL.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_SYMBOL.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_SYMBOL.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_SYMBOL.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_SYMBOL.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_TIMESTAMP.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_TIMESTAMP.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_TIMESTAMP.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_TIMESTAMP.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_TIMESTAMP.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_TIMESTAMP.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_UNDEFINED.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_UNDEFINED.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_UNDEFINED.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_UNDEFINED.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_UNDEFINED.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_UNDEFINED.getNumPrecRadix()))));
            docs.add(this.createBottomBson(new BsonElement("TYPE_NAME", new BsonString(BsonTypeInfo.BSON_BSON.getBsonName())), new BsonElement("DATA_TYPE", new BsonInt32(1111)), new BsonElement("PRECISION", this.asBsonIntOrNull(BsonTypeInfo.BSON_BSON.getPrecision())), new BsonElement("LITERAL_PREFIX", n), new BsonElement("LITERAL_SUFFIX", n), new BsonElement("CREATE_PARAMS", n), new BsonElement("NULLABLE", new BsonInt32(1)), new BsonElement("CASE_SENSITIVE", new BsonBoolean(BsonTypeInfo.BSON_BSON.getCaseSensitivity())), new BsonElement("SEARCHABLE", new BsonInt32(3)), new BsonElement("UNSIGNED_ATTRIBUTE", new BsonBoolean(false)), new BsonElement("FIXED_PREC_SCALE", new BsonBoolean(false)), new BsonElement("AUTO_INCREMENT", new BsonBoolean(false)), new BsonElement("LOCAL_TYPE_NAME", n), new BsonElement("MINIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_BSON.getMinScale())), new BsonElement("MAXIMUM_SCALE", new BsonInt32(BsonTypeInfo.BSON_BSON.getMaxScale())), new BsonElement("SQL_DATA_TYPE", new BsonInt32(0)), new BsonElement("SQL_DATETIME_SUB", new BsonInt32(0)), new BsonElement("NUM_PREC_RADIX", new BsonInt32(BsonTypeInfo.BSON_BSON.getNumPrecRadix()))));
            MongoJsonSchema botSchema = MongoJsonSchema.createEmptyObjectSchema();
            botSchema.properties.put(BOT_NAME, schema);
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)new BsonExplicitCursor(docs), botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_39);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> toGetIndexInfoDocs(String dbName, String tableName, Document indexInfo) {
        try {
            Boolean isUnique = (Boolean)((Object)indexInfo.getEmbedded((List<?>)UNIQUE_KEY_PATH, Boolean.class));
            BsonBoolean nonUnique = new BsonBoolean(isUnique == null || isUnique == false);
            BsonString indexName = new BsonString(indexInfo.getString(INDEX_NAME_KEY));
            Document keys = (Document)((Object)indexInfo.get((Object)INDEX_KEY_KEY, Document.class));
            AtomicInteger pos = new AtomicInteger();
            return keys.keySet().stream().map(key -> {
                try {
                    BsonString ascOrDesc = new BsonString(keys.getInteger(key) > 0 ? "A" : "D");
                    return this.createSortableBottomBson(GET_INDEX_INFO_SORT_SPECS, new BsonElement("TABLE_CAT", new BsonString(dbName)), new BsonElement("TABLE_SCHEM", BsonNull.VALUE), new BsonElement("TABLE_NAME", new BsonString(tableName)), new BsonElement("NON_UNIQUE", nonUnique), new BsonElement("INDEX_QUALIFIER", BsonNull.VALUE), new BsonElement("INDEX_NAME", indexName), new BsonElement("TYPE", new BsonInt32(3)), new BsonElement("ORDINAL_POSITION", new BsonInt32(pos.incrementAndGet())), new BsonElement("COLUMN_NAME", new BsonString((String)key)), new BsonElement("ASC_OR_DESC", ascOrDesc), new BsonElement("CARDINALITY", BsonNull.VALUE), new BsonElement("PAGES", BsonNull.VALUE), new BsonElement("FILTER_CONDITION", BsonNull.VALUE));
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_68);
                    }
                    throw exception;
                }
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_40);
            }
            throw exception;
        }
    }

    private Stream<BsonDocument> getIndexesFromTable(String dbName, String tableName, boolean unique) {
        try {
            return this.conn.getDatabase(dbName).getCollection(tableName).listIndexes().into(new ArrayList()).stream().filter(d -> {
                Boolean isUnique = (Boolean)((Object)d.getEmbedded((List<?>)UNIQUE_KEY_PATH, Boolean.class));
                return !unique || isUnique != null && isUnique != false;
            }).flatMap(d -> {
                try {
                    return this.toGetIndexInfoDocs(dbName, tableName, (Document)d);
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_69);
                    }
                    throw exception;
                }
            });
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_41);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String string = catalog;
        String string2 = schema;
        String string3 = table;
        boolean bl = unique;
        boolean bl2 = approximate;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, Conversions.booleanObject(bl), Conversions.booleanObject(bl2)};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_42, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("NON_UNIQUE", BsonTypeInfo.BSON_BOOL), new MongoJsonSchema.ScalarProperties("INDEX_QUALIFIER", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("INDEX_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("ORDINAL_POSITION", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("ASC_OR_DESC", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("CARDINALITY", BsonTypeInfo.BSON_LONG), new MongoJsonSchema.ScalarProperties("PAGES", BsonTypeInfo.BSON_LONG), new MongoJsonSchema.ScalarProperties("FILTER_CONDITION", BsonTypeInfo.BSON_LONG, false));
            Stream<Object> docs = catalog == null ? this.getDatabaseNames().flatMap(dbName -> {
                try {
                    return this.getTableDataFromDB((String)dbName, res -> res.name.equals(table)).flatMap(r -> {
                        try {
                            return this.getIndexesFromTable((String)dbName, r.name, unique);
                        }
                        catch (Exception exception) {
                            if (LoggingAspect.hasAspect(this)) {
                                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_74);
                            }
                            throw exception;
                        }
                    });
                }
                catch (Exception exception) {
                    if (LoggingAspect.hasAspect(this)) {
                        LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_70);
                    }
                    throw exception;
                }
            }) : (catalog.isEmpty() ? Stream.empty() : this.getIndexesFromTable(catalog, table, unique));
            List<BsonDocument> docsList = docs.sorted().collect(Collectors.toList());
            BsonExplicitCursor c = new BsonExplicitCursor(docsList);
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)c, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_42);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = typeNamePattern;
        int[] nArray = types;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, nArray};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_43, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TYPE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("CLASS_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("BASE_TYPE", BsonTypeInfo.BSON_INT, false));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_43);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = typeNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_44, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TYPE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("SUPERTYPE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SUPERTYPE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SUPERTYPE_NAME", BsonTypeInfo.BSON_STRING));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_44);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_45, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("SUPERTABLE_NAME", BsonTypeInfo.BSON_STRING));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_45);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = typeNamePattern;
        String string4 = attributeNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_46, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TYPE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("ATTR_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("ATTR_TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("ATTR_SIZE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DECIMAL_DIGITS", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("NUM_PREC_RADIX", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("NULLABLE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("ATTR_DEF", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SQL_DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SQL_DATETIME_SUB", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("CHAR_OCTET_LENGTH", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("ORDINAL_POSITION", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("IS_NULLABLE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("SCOPE_CATALOG", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SCOPE_SCHEMA", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SCOPE_TABLE", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("SOURCE_DATA_TYPE", BsonTypeInfo.BSON_INT, false));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_46);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_47, this, this, string, string2));
            }
            return this.getSchemas();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_47);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_48, this, this));
            }
            new ArrayList();
            MongoJsonSchema schema = MongoJsonSchema.createEmptyObjectSchema();
            schema.addScalarKeys(new MongoJsonSchema.ScalarProperties("NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("MAX_LEN", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DEFAULT_VALUE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DESCRIPTION", BsonTypeInfo.BSON_STRING));
            MongoJsonSchema botSchema = MongoJsonSchema.createEmptyObjectSchema();
            botSchema.properties.put(BOT_NAME, schema);
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_48);
            }
            throw exception;
        }
    }

    private MongoJsonSchema getFunctionJsonSchema() {
        try {
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("FUNCTION_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FUNCTION_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FUNCTION_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("FUNCTION_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SPECIFIC_NAME", BsonTypeInfo.BSON_STRING));
            return botSchema;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_49);
            }
            throw exception;
        }
    }

    private BsonDocument getFunctionValuesDoc(String functionName, String remarks) {
        try {
            BsonDocument root = new BsonDocument();
            BsonDocument bot = new BsonDocument();
            root.put(BOT_NAME, bot);
            bot.put("FUNCTION_CAT", new BsonString("def"));
            bot.put("FUNCTION_SCHEM", BsonNull.VALUE);
            bot.put("FUNCTION_NAME", new BsonString(functionName));
            bot.put("REMARKS", new BsonString(remarks));
            bot.put("FUNCTION_TYPE", new BsonInt32(1));
            bot.put("SPECIFIC_NAME", new BsonString(functionName));
            return root;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_50);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = functionNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_51, (Object)this, (Object)this, objectArray));
            }
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>(MongoSQLDatabaseMetaData.MongoSQLFunctions.functions.length);
            MongoJsonSchema schema = this.getFunctionJsonSchema();
            Pattern functionPatternRE = null;
            if (functionNamePattern != null) {
                functionPatternRE = MongoSQLDatabaseMetaData.toJavaPattern(functionNamePattern);
            }
            MongoFunctions.MongoFunction[] mongoFunctionArray = MongoSQLDatabaseMetaData.MongoSQLFunctions.functions;
            int n = MongoSQLDatabaseMetaData.MongoSQLFunctions.functions.length;
            int n2 = 0;
            while (n2 < n) {
                MongoFunctions.MongoFunction func = mongoFunctionArray[n2];
                if (functionPatternRE == null || functionPatternRE.matcher(func.name).matches()) {
                    BsonDocument doc = this.getFunctionValuesDoc(func.name, func.comment);
                    docs.add(doc);
                }
                ++n2;
            }
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)new BsonExplicitCursor(docs), schema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_51);
            }
            throw exception;
        }
    }

    private MongoJsonSchema getFunctionColumnJsonSchema() {
        try {
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("FUNCTION_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FUNCTION_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("FUNCTION_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("TYPE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("PRECISION", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("LENGTH", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("SCALE", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("RADIX", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("NULLABLE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("CHAR_OCTET_LENGTH", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("ORDINAL_POSITION", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("IS_NULLABLE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("SPECIFIC_NAME", BsonTypeInfo.BSON_STRING));
            return botSchema;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_52);
            }
            throw exception;
        }
    }

    private BsonDocument getFunctionColumnValuesDoc(MongoFunctions.MongoFunction func, int i, String argName, String argType, boolean isReturnColumn) throws SQLException {
        try {
            Map<String, BsonValue> info = super.getFunctionParameterValues(func, i, argName, argType, isReturnColumn);
            BsonDocument root = new BsonDocument();
            BsonDocument bot = new BsonDocument();
            root.put(BOT_NAME, bot);
            String cfr_ignored_0 = func.name;
            bot.putAll((Map<? extends String, ? extends BsonValue>)info);
            return root;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_53);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = functionNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_54, (Object)this, (Object)this, objectArray));
            }
            ArrayList<BsonDocument> docs = new ArrayList<BsonDocument>(MongoSQLDatabaseMetaData.MongoSQLFunctions.functions.length);
            MongoJsonSchema schema = this.getFunctionColumnJsonSchema();
            Pattern functionNamePatternRE = null;
            Pattern columnNamePatternRE = null;
            if (functionNamePattern != null) {
                functionNamePatternRE = MongoSQLDatabaseMetaData.toJavaPattern(functionNamePattern);
            }
            if (columnNamePattern != null) {
                columnNamePatternRE = MongoSQLDatabaseMetaData.toJavaPattern(columnNamePattern);
            }
            MongoFunctions.MongoFunction[] mongoFunctionArray = MongoSQLDatabaseMetaData.MongoSQLFunctions.functions;
            int n = MongoSQLDatabaseMetaData.MongoSQLFunctions.functions.length;
            int n2 = 0;
            while (n2 < n) {
                MongoFunctions.MongoFunction func = mongoFunctionArray[n2];
                if (functionNamePatternRE == null || functionNamePatternRE.matcher(func.name).matches()) {
                    int i = 0;
                    String[] stringArray = func.argTypes;
                    int n3 = func.argTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String argType = stringArray[n4];
                        String columnName = "arg" + ++i;
                        if (columnNamePatternRE == null || columnNamePatternRE.matcher(columnName).matches()) {
                            BsonDocument doc = this.getFunctionColumnValuesDoc(func, i, columnName, argType, false);
                            docs.add(doc);
                        }
                        ++n4;
                    }
                    String columnName = "argReturn";
                    if (columnNamePatternRE == null || columnNamePatternRE.matcher(columnName).matches()) {
                        BsonDocument doc = this.getFunctionColumnValuesDoc(func, i, "argReturn", func.returnType, true);
                        docs.add(doc);
                    }
                }
                ++n2;
            }
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)new BsonExplicitCursor(docs), schema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_54);
            }
            throw exception;
        }
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String string = catalog;
        String string2 = schemaPattern;
        String string3 = tableNamePattern;
        String string4 = columnNamePattern;
        try {
            if (LoggingAspect.hasAspect(this)) {
                Object[] objectArray = new Object[]{string, string2, string3, string4};
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_55, (Object)this, (Object)this, objectArray));
            }
            MongoJsonSchema botSchema = this.createBottomSchema(new MongoJsonSchema.ScalarProperties("TABLE_CAT", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_SCHEM", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("TABLE_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_NAME", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("DATA_TYPE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("COLUMN_SIZE", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("DECIMAL_DIGITS", BsonTypeInfo.BSON_INT, false), new MongoJsonSchema.ScalarProperties("NUM_PREC_RADIX", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("COLUMN_USAGE", BsonTypeInfo.BSON_STRING), new MongoJsonSchema.ScalarProperties("REMARKS", BsonTypeInfo.BSON_STRING, false), new MongoJsonSchema.ScalarProperties("CHAR_OCTET_LENGTH", BsonTypeInfo.BSON_INT), new MongoJsonSchema.ScalarProperties("IS_NULLABLE", BsonTypeInfo.BSON_STRING));
            return new MongoSQLResultSet(this.conn.getLogger(), (MongoCursor<BsonDocument>)BsonExplicitCursor.EMPTY_CURSOR, botSchema);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_55);
            }
            throw exception;
        }
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoSQLDatabaseMetaData.java", MongoSQLDatabaseMetaData.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "createBottomBson", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "[Lorg.bson.BsonElement;", "elements", BOT_NAME, "org.bson.BsonDocument"), 113);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("82", "createSortableBottomBson", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.util.List:[Lorg.bson.BsonElement;", "sortSpecs:elements", BOT_NAME, "com.mongodb.jdbc.SortableBsonDocument"), 120);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableTypes", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 245);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getDatabaseNames", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "java.util.stream.Stream"), 262);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTableDataFromDB", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.util.function.Function", "dbName:filter", BOT_NAME, "java.util.stream.Stream"), 268);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetTablesDoc", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:com.mongodb.jdbc.MongoListTablesResult", "dbName:res", BOT_NAME, "org.bson.BsonDocument"), 282);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetTablePrivilegesDoc", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:com.mongodb.jdbc.MongoListTablesResult", "dbName:res", BOT_NAME, "org.bson.BsonDocument"), 302);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTableDataFromDB", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.util.regex.Pattern:java.util.List:java.util.function.BiFunction", "dbName:tableNamePatternRE:types:bsonSerializer", BOT_NAME, "java.util.stream.Stream"), 319);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toTableTypeList", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "[Ljava.lang.String;", "types", BOT_NAME, "java.util.List"), 335);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTables", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:[Ljava.lang.String;", "catalog:schemaPattern:tableNamePattern:types", "java.sql.SQLException", "java.sql.ResultSet"), 345);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemas", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 396);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCatalogs", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 406);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("92", "createBottomSchema", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "[Lcom.mongodb.jdbc.MongoJsonSchema$ScalarProperties;", "resultSchemaFields", BOT_NAME, "com.mongodb.jdbc.MongoJsonSchema"), 130);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetColumnsDoc", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "com.mongodb.jdbc.MongoSQLDatabaseMetaData$GetColumnsDocInfo", "i", BOT_NAME, "org.bson.BsonDocument"), 485);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetColumnPrivilegesDoc", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "com.mongodb.jdbc.MongoSQLDatabaseMetaData$GetColumnsDocInfo", "i", BOT_NAME, "org.bson.BsonDocument"), 529);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isValidSchema", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "com.mongodb.jdbc.MongoJsonSchemaResult", "res", BOT_NAME, "boolean"), 546);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getColumnsFromDB", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.util.regex.Pattern:java.util.regex.Pattern:java.util.function.Function", "dbName:tableNamePatternRE:columnNamePatternRE:bsonSerializer", BOT_NAME, "java.util.stream.Stream"), 555);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumns", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 624);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnPrivileges", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 698);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTablePrivileges", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 756);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFirstUniqueIndexDocsForTable", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.util.function.BiFunction", "dbName:tableName:serializer", BOT_NAME, "java.util.stream.Stream"), 802);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFirstUniqueIndexResultSet", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:com.mongodb.jdbc.MongoJsonSchema:java.util.function.BiFunction", "catalog:table:botSchema:serializer", BOT_NAME, "java.sql.ResultSet"), 832);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetBestRowIdentifierDocs", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "com.mongodb.jdbc.Pair:org.bson.Document", "namespace:indexInfo", BOT_NAME, "java.util.List"), 878);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSQLKeywords", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 142);
        ajc$tjp_30 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetBestRowIdentifierDoc", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:com.mongodb.jdbc.BsonTypeInfo", "columnName:columnBsonTypeInfo", BOT_NAME, "org.bson.BsonDocument"), 908);
        ajc$tjp_31 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getBestRowIdentifier", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:int:boolean", "catalog:schema:table:scope:nullable", "java.sql.SQLException", "java.sql.ResultSet"), 923);
        ajc$tjp_32 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getVersionColumns", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schema:table", "java.sql.SQLException", "java.sql.ResultSet"), 946);
        ajc$tjp_33 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getImportedKeys", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schema:table", "java.sql.SQLException", "java.sql.ResultSet"), 963);
        ajc$tjp_34 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getExportedKeys", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schema:table", "java.sql.SQLException", "java.sql.ResultSet"), 986);
        ajc$tjp_35 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCrossReference", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String", "parentCatalog:parentSchema:parentTable:foreignCatalog:foreignSchema:foreignTable", "java.sql.SQLException", "java.sql.ResultSet"), 1009);
        ajc$tjp_36 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetPrimaryKeysDocs", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "com.mongodb.jdbc.Pair:org.bson.Document", "namespace:indexInfo", BOT_NAME, "java.util.List"), 1041);
        ajc$tjp_37 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPrimaryKeys", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schema:table", "java.sql.SQLException", "java.sql.ResultSet"), 1068);
        ajc$tjp_38 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getTypeInfoJsonSchema", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "com.mongodb.jdbc.MongoJsonSchema"), 1085);
        ajc$tjp_39 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTypeInfo", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 1111);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumericFunctions", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 177);
        ajc$tjp_40 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "toGetIndexInfoDocs", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:org.bson.Document", "dbName:tableName:indexInfo", BOT_NAME, "java.util.stream.Stream"), 1622);
        ajc$tjp_41 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getIndexesFromTable", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:boolean", "dbName:tableName:unique", BOT_NAME, "java.util.stream.Stream"), 1661);
        ajc$tjp_42 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIndexInfo", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:boolean:boolean", "catalog:schema:table:unique:approximate", "java.sql.SQLException", "java.sql.ResultSet"), 1681);
        ajc$tjp_43 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUDTs", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:[I", "catalog:schemaPattern:typeNamePattern:types", "java.sql.SQLException", "java.sql.ResultSet"), 1731);
        ajc$tjp_44 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSuperTypes", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:typeNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1748);
        ajc$tjp_45 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSuperTables", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1763);
        ajc$tjp_46 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAttributes", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:typeNamePattern:attributeNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1776);
        ajc$tjp_47 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSchemas", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String", "catalog:schemaPattern", "java.sql.SQLException", "java.sql.ResultSet"), 1812);
        ajc$tjp_48 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClientInfoProperties", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.sql.ResultSet"), 1817);
        ajc$tjp_49 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionJsonSchema", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "com.mongodb.jdbc.MongoJsonSchema"), 1833);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStringFunctions", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 182);
        ajc$tjp_50 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionValuesDoc", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String", "functionName:remarks", BOT_NAME, "org.bson.BsonDocument"), 1846);
        ajc$tjp_51 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFunctions", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:functionNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1860);
        ajc$tjp_52 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionColumnJsonSchema", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, BOT_NAME, "com.mongodb.jdbc.MongoJsonSchema"), 1881);
        ajc$tjp_53 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getFunctionColumnValuesDoc", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "com.mongodb.jdbc.MongoFunctions$MongoFunction:int:java.lang.String:java.lang.String:boolean", "func:i:argName:argType:isReturnColumn", "java.sql.SQLException", "org.bson.BsonDocument"), 1904);
        ajc$tjp_54 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFunctionColumns", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:functionNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1923);
        ajc$tjp_55 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getPseudoColumns", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:tableNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 1972);
        ajc$tjp_56 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$4", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.util.regex.Pattern:java.util.List:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 375);
        ajc$tjp_57 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$7", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String", "dbName", BOT_NAME, "org.bson.BsonDocument"), 416);
        ajc$tjp_58 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$10", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "com.mongodb.jdbc.Pair", "p", BOT_NAME, "boolean"), 583);
        ajc$tjp_59 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$14", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.util.regex.Pattern:java.util.regex.Pattern", "arg0:arg1", BOT_NAME, "java.util.stream.Stream"), 666);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSystemFunctions", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 187);
        ajc$tjp_60 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$17", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.util.regex.Pattern:java.util.regex.Pattern", "arg0:arg1:arg2", BOT_NAME, "java.util.stream.Stream"), 683);
        ajc$tjp_61 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$19", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.util.regex.Pattern:java.util.regex.Pattern", "arg0:arg1", BOT_NAME, "java.util.stream.Stream"), 724);
        ajc$tjp_62 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$22", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.util.regex.Pattern:java.util.regex.Pattern", "arg0:arg1:arg2", BOT_NAME, "java.util.stream.Stream"), 741);
        ajc$tjp_63 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$24", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.util.regex.Pattern:java.lang.String", "arg0:dbName", BOT_NAME, "java.util.stream.Stream"), 780);
        ajc$tjp_64 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$27", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.util.function.BiFunction:java.lang.String:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 846);
        ajc$tjp_65 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$30", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:com.mongodb.jdbc.MongoJsonSchema", "arg0:arg1:arg2", BOT_NAME, "java.sql.ResultSet"), 941);
        ajc$tjp_66 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$32", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "com.mongodb.jdbc.Pair:java.util.concurrent.atomic.AtomicInteger:java.lang.String:java.lang.String", "arg0:arg1:arg2:key", BOT_NAME, "com.mongodb.jdbc.SortableBsonDocument"), 1051);
        ajc$tjp_67 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$33", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:com.mongodb.jdbc.MongoJsonSchema", "arg0:arg1:arg2", BOT_NAME, "java.sql.ResultSet"), 1081);
        ajc$tjp_68 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$35", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "org.bson.Document:java.lang.String:java.lang.String:org.bson.BsonValue:org.bson.BsonValue:java.util.concurrent.atomic.AtomicInteger:java.lang.String", "arg0:arg1:arg2:arg3:arg4:arg5:key", BOT_NAME, "org.bson.BsonDocument"), 1636);
        ajc$tjp_69 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$37", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:org.bson.Document", "arg0:arg1:d", BOT_NAME, "java.util.stream.Stream"), 1677);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimeDateFunctions", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", BOT_NAME, BOT_NAME, "java.sql.SQLException", "java.lang.String"), 192);
        ajc$tjp_70 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$38", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "boolean:java.lang.String:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 1708);
        ajc$tjp_71 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$15", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.util.regex.Pattern:java.util.regex.Pattern:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 669);
        ajc$tjp_72 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$20", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.util.regex.Pattern:java.util.regex.Pattern:java.lang.String", "arg0:arg1:dbName", BOT_NAME, "java.util.stream.Stream"), 727);
        ajc$tjp_73 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$29", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.util.function.BiFunction:com.mongodb.jdbc.MongoListTablesResult", "arg0:arg1:r", BOT_NAME, "java.util.stream.Stream"), 851);
        ajc$tjp_74 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$40", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:boolean:com.mongodb.jdbc.MongoListTablesResult", "arg0:arg1:r", BOT_NAME, "java.util.stream.Stream"), 1712);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProcedures", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:procedureNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 197);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProcedureColumns", "com.mongodb.jdbc.MongoSQLDatabaseMetaData", "java.lang.String:java.lang.String:java.lang.String:java.lang.String", "catalog:schemaPattern:procedureNamePattern:columnNamePattern", "java.sql.SQLException", "java.sql.ResultSet"), 212);
    }

    private static class GetColumnsDocInfo {
        String dbName;
        String tableName;
        String columnName;
        BsonTypeInfo columnBsonTypeInfo;
        int nullability;
        int idx;

        GetColumnsDocInfo(String dbName, String tableName, String columnName, MongoJsonSchema parentSchema, MongoJsonSchema columnSchema, int idx) {
            this.dbName = dbName;
            this.tableName = tableName;
            this.columnName = columnName;
            this.idx = idx;
            try {
                this.columnBsonTypeInfo = columnSchema.getBsonTypeInfo();
                this.nullability = parentSchema.getColumnNullability(columnName);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

