/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.DataStreamException;
import com.ibm.jtopenlite.HostServerConnection;
import com.ibm.jtopenlite.Message;
import com.ibm.jtopenlite.MessageException;
import com.ibm.jtopenlite.SignonConnection;
import com.ibm.jtopenlite.SystemInfo;
import com.ibm.jtopenlite.database.AttributeBlockingFactor;
import com.ibm.jtopenlite.database.AttributeColumnIndex;
import com.ibm.jtopenlite.database.AttributeCompressionIndicator;
import com.ibm.jtopenlite.database.AttributeCursorName;
import com.ibm.jtopenlite.database.AttributeDescribeOption;
import com.ibm.jtopenlite.database.AttributeExtendedColumnDescriptorOption;
import com.ibm.jtopenlite.database.AttributeExtendedSQLParameterMarkerDataFormat;
import com.ibm.jtopenlite.database.AttributeExtendedSQLStatementText;
import com.ibm.jtopenlite.database.AttributeFetchBufferSize;
import com.ibm.jtopenlite.database.AttributeFetchScrollOption;
import com.ibm.jtopenlite.database.AttributeHoldIndicator;
import com.ibm.jtopenlite.database.AttributeLOBLocatorHandle;
import com.ibm.jtopenlite.database.AttributeOpenAttributes;
import com.ibm.jtopenlite.database.AttributePackageLibrary;
import com.ibm.jtopenlite.database.AttributePackageName;
import com.ibm.jtopenlite.database.AttributePrepareOption;
import com.ibm.jtopenlite.database.AttributePrepareStatementName;
import com.ibm.jtopenlite.database.AttributeQueryTimeoutLimit;
import com.ibm.jtopenlite.database.AttributeRLECompressedFunctionParameters;
import com.ibm.jtopenlite.database.AttributeRequestedSize;
import com.ibm.jtopenlite.database.AttributeResultSetHoldabilityOption;
import com.ibm.jtopenlite.database.AttributeReturnCurrentLengthIndicator;
import com.ibm.jtopenlite.database.AttributeReturnOptimisticLockingColumns;
import com.ibm.jtopenlite.database.AttributeReturnSize;
import com.ibm.jtopenlite.database.AttributeReuseIndicator;
import com.ibm.jtopenlite.database.AttributeSQLExtendedParameterMarkerData;
import com.ibm.jtopenlite.database.AttributeSQLParameterMarkerBlockIndicator;
import com.ibm.jtopenlite.database.AttributeSQLParameterMarkerData;
import com.ibm.jtopenlite.database.AttributeSQLParameterMarkerDataFormat;
import com.ibm.jtopenlite.database.AttributeSQLStatementText;
import com.ibm.jtopenlite.database.AttributeSQLStatementType;
import com.ibm.jtopenlite.database.AttributeScrollableCursorFlag;
import com.ibm.jtopenlite.database.AttributeServerSideStaticCursorResultSetSize;
import com.ibm.jtopenlite.database.AttributeStartOffset;
import com.ibm.jtopenlite.database.AttributeSyncPointCount;
import com.ibm.jtopenlite.database.AttributeTranslateIndicator;
import com.ibm.jtopenlite.database.AttributeVariableFieldCompression;
import com.ibm.jtopenlite.database.DatabaseChangeDescriptorAttributes;
import com.ibm.jtopenlite.database.DatabaseCloseCursorAttributes;
import com.ibm.jtopenlite.database.DatabaseCreateRequestParameterBlockAttributes;
import com.ibm.jtopenlite.database.DatabaseDeleteDescriptorAttributes;
import com.ibm.jtopenlite.database.DatabaseDeleteRequestParameterBlockAttributes;
import com.ibm.jtopenlite.database.DatabaseDescribeAttributes;
import com.ibm.jtopenlite.database.DatabaseDescribeCallback;
import com.ibm.jtopenlite.database.DatabaseDescribeParameterMarkerAttributes;
import com.ibm.jtopenlite.database.DatabaseEndStreamFetchAttributes;
import com.ibm.jtopenlite.database.DatabaseException;
import com.ibm.jtopenlite.database.DatabaseExecuteAttributes;
import com.ibm.jtopenlite.database.DatabaseExecuteImmediateAttributes;
import com.ibm.jtopenlite.database.DatabaseExecuteOrOpenAndDescribeAttributes;
import com.ibm.jtopenlite.database.DatabaseFetchAttributes;
import com.ibm.jtopenlite.database.DatabaseFetchCallback;
import com.ibm.jtopenlite.database.DatabaseLOBDataCallback;
import com.ibm.jtopenlite.database.DatabaseOpenAndDescribeAttributes;
import com.ibm.jtopenlite.database.DatabaseOpenDescribeFetchAttributes;
import com.ibm.jtopenlite.database.DatabasePackageAttributes;
import com.ibm.jtopenlite.database.DatabasePackageCallback;
import com.ibm.jtopenlite.database.DatabaseParameterMarkerCallback;
import com.ibm.jtopenlite.database.DatabasePrepareAndDescribeAttributes;
import com.ibm.jtopenlite.database.DatabasePrepareAndExecuteAttributes;
import com.ibm.jtopenlite.database.DatabasePrepareAttributes;
import com.ibm.jtopenlite.database.DatabaseRetrieveLOBDataAttributes;
import com.ibm.jtopenlite.database.DatabaseRetrievePackageAttributes;
import com.ibm.jtopenlite.database.DatabaseSQLCommunicationsAreaCallback;
import com.ibm.jtopenlite.database.DatabaseServerAttributes;
import com.ibm.jtopenlite.database.DatabaseStreamFetchAttributes;
import com.ibm.jtopenlite.database.DatabaseWarningCallback;
import com.ibm.jtopenlite.database.OperationalResultBitmap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class DatabaseConnection
extends HostServerConnection
implements OperationalResultBitmap {
    private final byte[] byteBuffer_ = new byte[1024];
    private char[] charBuffer_ = new char[1024];
    private static final boolean DEBUG = false;
    public static final int DEFAULT_DATABASE_SERVER_PORT = 8471;
    public static final int DEFAULT_SSL_DATABASE_SERVER_PORT = 9471;
    private static final int TYPE_CALL = 3;
    private int correlationID_ = 1;
    private int currentRPB_;
    private boolean compress_ = true;
    private DatabaseWarningCallback warningCallback_;
    private DatabaseSQLCommunicationsAreaCallback sqlcaCallback_;
    private boolean returnMessageInfo_ = false;
    private int rleRepeatValue1_ = 0;
    private int rleRepeatValue2_ = 0;
    private int rleRepeatTotal_ = 0;
    private int rleRepeatCount_ = 0;
    private boolean rleCompression_ = false;
    private final byte[] tempIndicator_ = new byte[2];

    private int newCorrelationID() {
        if (this.correlationID_ == Integer.MAX_VALUE) {
            this.correlationID_ = 0;
        }
        return ++this.correlationID_;
    }

    private DatabaseConnection(SystemInfo systemInfo, Socket socket, HostServerConnection.HostInputStream hostInputStream, HostServerConnection.HostOutputStream hostOutputStream, String string, String string2) {
        super(systemInfo, string, string2, socket, hostInputStream, hostOutputStream);
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress.isLoopbackAddress()) {
            this.compress_ = false;
        } else {
            String string3 = systemInfo.getSystem();
            if (string3.equalsIgnoreCase("localhost") || string3.equalsIgnoreCase("127.0.0.1")) {
                this.compress_ = false;
            } else {
                try {
                    if (inetAddress.equals(InetAddress.getLocalHost())) {
                        this.compress_ = false;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isMessageInfoReturned() {
        return this.returnMessageInfo_;
    }

    public void setMessageInfoReturned(boolean bl) {
        this.returnMessageInfo_ = bl;
    }

    public void setDebug(boolean bl) {
        this.in_.setDebug(bl);
        this.out_.setDebug(bl);
    }

    public void setWarningCallback(DatabaseWarningCallback databaseWarningCallback) {
        this.warningCallback_ = databaseWarningCallback;
    }

    public void setSQLCommunicationsAreaCallback(DatabaseSQLCommunicationsAreaCallback databaseSQLCommunicationsAreaCallback) {
        this.sqlcaCallback_ = databaseSQLCommunicationsAreaCallback;
    }

    protected void sendEndJobRequest() throws IOException {
        this.out_.writeInt(40);
        this.out_.writeShort(0);
        this.out_.writeShort(57348);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeShort(0);
        this.out_.writeShort(8191);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
    }

    public static DatabaseConnection getConnection(String string, String string2, String string3) throws IOException {
        return DatabaseConnection.getConnection(false, string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseConnection getConnection(boolean bl, String string, String string2, String string3) throws IOException {
        SignonConnection signonConnection = SignonConnection.getConnection(bl, string, string2, string3);
        try {
            DatabaseConnection databaseConnection = DatabaseConnection.getConnection(bl, signonConnection.getInfo(), string2, string3);
            return databaseConnection;
        }
        finally {
            signonConnection.close();
        }
    }

    public static DatabaseConnection getConnection(SystemInfo systemInfo, String string, String string2) throws IOException {
        return DatabaseConnection.getConnection(false, systemInfo, string, string2);
    }

    public static DatabaseConnection getConnection(boolean bl, SystemInfo systemInfo, String string, String string2) throws IOException {
        return DatabaseConnection.getConnection(bl, systemInfo, string, string2, bl ? 9471 : 8471);
    }

    public static DatabaseConnection getConnection(SystemInfo systemInfo, String string, String string2, int n) throws IOException {
        return DatabaseConnection.getConnection(false, systemInfo, string, string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseConnection getConnection(boolean bl, SystemInfo systemInfo, String string, String string2, int n) throws IOException {
        if (n < 0 || n > 65535) {
            throw new IOException("Bad database port: " + n);
        }
        DatabaseConnection databaseConnection = null;
        Socket socket = bl ? SSLSocketFactory.getDefault().createSocket(systemInfo.getSystem(), n) : new Socket(systemInfo.getSystem(), n);
        socket.setPerformancePreferences(0, 1, 2);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            HostServerConnection.HostOutputStream hostOutputStream = new HostServerConnection.HostOutputStream(new BufferedOutputStream(outputStream, 1024));
            HostServerConnection.HostInputStream hostInputStream = new HostServerConnection.HostInputStream(new BufferedInputStream(inputStream, 32768));
            String string3 = DatabaseConnection.connect(systemInfo, hostOutputStream, hostInputStream, 57348, string, string2);
            DatabaseConnection databaseConnection2 = databaseConnection = new DatabaseConnection(systemInfo, socket, hostInputStream, hostOutputStream, string, string3);
            return databaseConnection2;
        }
        finally {
            if (databaseConnection == null) {
                inputStream.close();
                outputStream.close();
                socket.close();
            }
        }
    }

    private void readFullReply(String string) throws IOException {
        int n = this.readReplyHeader(string);
        this.skipBytes(n - 40);
        this.in_.end();
    }

    public int getCurrentRequestParameterBlockID() {
        return this.currentRPB_;
    }

    public void setCurrentRequestParameterBlockID(int n) {
        this.currentRPB_ = n;
    }

    public void createRequestParameterBlock(DatabaseCreateRequestParameterBlockAttributes databaseCreateRequestParameterBlockAttributes, int n) throws IOException {
        this.sendCreateSQLRPBRequest(databaseCreateRequestParameterBlockAttributes, true, n);
        this.out_.flush();
        this.readFullReply("createSQLRPB");
        this.currentRPB_ = n;
    }

    public void deleteRequestParameterBlock(DatabaseDeleteRequestParameterBlockAttributes databaseDeleteRequestParameterBlockAttributes, int n) throws IOException {
        this.sendDeleteSQLRPBRequest(databaseDeleteRequestParameterBlockAttributes, n);
        this.out_.flush();
        this.readFullReply("deleteSQLRPB");
    }

    public void resetRequestParameterBlock(DatabaseCreateRequestParameterBlockAttributes databaseCreateRequestParameterBlockAttributes, int n) throws IOException {
        this.sendResetSQLRPBRequest(databaseCreateRequestParameterBlockAttributes, true, n);
        this.out_.flush();
        this.readFullReply("resetSQLRPB");
        this.currentRPB_ = n;
    }

    public void prepare(DatabasePrepareAttributes databasePrepareAttributes) throws IOException {
        this.sendPrepareRequest(databasePrepareAttributes);
        this.out_.flush();
        this.readFullReply("prepare");
    }

    public void prepareAndDescribe(DatabasePrepareAndDescribeAttributes databasePrepareAndDescribeAttributes, DatabaseDescribeCallback databaseDescribeCallback, DatabaseParameterMarkerCallback databaseParameterMarkerCallback) throws IOException {
        this.sendPrepareAndDescribeRequest(databasePrepareAndDescribeAttributes);
        this.out_.flush();
        this.parseReply("prepareAndDescribe", databaseDescribeCallback, null, null, databaseParameterMarkerCallback, null);
    }

    public void prepareAndExecute(DatabasePrepareAndExecuteAttributes databasePrepareAndExecuteAttributes, DatabaseDescribeCallback databaseDescribeCallback) throws IOException {
        this.sendPrepareAndExecuteRequest(databasePrepareAndExecuteAttributes);
        this.out_.flush();
        this.parseReply("prepareAndExecute", databaseDescribeCallback, null);
    }

    private void sendPrepareAndExecuteRequest(DatabasePrepareAndExecuteAttributes databasePrepareAndExecuteAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databasePrepareAndExecuteAttributes != null) {
            if (databasePrepareAndExecuteAttributes.isPrepareStatementNameSet()) {
                n += this.getPrepareStatementNameLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isSQLStatementTextSet()) {
                n += this.getSQLStatementTextLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isSQLStatementTypeSet()) {
                n += this.getSQLStatementTypeLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isPrepareOptionSet()) {
                n += this.getPrepareOptionLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isOpenAttributesSet()) {
                n += this.getOpenAttributesLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isDescribeOptionSet()) {
                ++n2;
                n += this.getDescribeOptionLength(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isCursorNameSet()) {
                ++n2;
                n += this.getCursorNameLength(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isBlockingFactorSet()) {
                ++n2;
                n += this.getBlockingFactorLength(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isScrollableCursorFlagSet()) {
                ++n2;
                n += this.getScrollableCursorFlagLength(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isSQLParameterMarkerDataSet()) {
                ++n2;
                n += this.getSQLParameterMarkerDataLength(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isSQLExtendedParameterMarkerDataSet()) {
                ++n2;
                n += this.getSQLExtendedParameterMarkerDataLength(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                ++n2;
                n += this.getSQLParameterMarkerBlockIndicatorLength(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isPackageNameSet()) {
                n += this.getPackageNameLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isPackageLibrarySet()) {
                n += this.getPackageLibraryLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isTranslateIndicatorSet()) {
                n += this.getTranslateIndicatorLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isRLECompressedFunctionParametersSet()) {
                n += this.getRLECompressedFunctionParametersLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isExtendedColumnDescriptorOptionSet()) {
                n += this.getExtendedColumnDescriptorOptionLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
            if (databasePrepareAndExecuteAttributes.isExtendedSQLStatementTextSet()) {
                n += this.getExtendedSQLStatementTextLength(databasePrepareAndExecuteAttributes);
                ++n2;
            }
        }
        this.writeHeader(n, 6157);
        this.writeTemplate(n2);
        if (databasePrepareAndExecuteAttributes != null) {
            if (databasePrepareAndExecuteAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isSQLStatementTextSet()) {
                this.writeSQLStatementText(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isSQLStatementTypeSet()) {
                this.writeSQLStatementType(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isPrepareOptionSet()) {
                this.writePrepareOption(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isOpenAttributesSet()) {
                this.writeOpenAttributes(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isDescribeOptionSet()) {
                this.writeDescribeOption(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isCursorNameSet()) {
                this.writeCursorName(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isBlockingFactorSet()) {
                this.writeBlockingFactor(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isScrollableCursorFlagSet()) {
                this.writeScrollableCursorFlag(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isSQLParameterMarkerDataSet()) {
                this.writeSQLParameterMarkerData(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isSQLExtendedParameterMarkerDataSet()) {
                this.writeSQLExtendedParameterMarkerData(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                this.writeSQLParameterMarkerBlockIndicator(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isPackageNameSet()) {
                this.writePackageName(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isExtendedColumnDescriptorOptionSet()) {
                this.writeExtendedColumnDescriptorOption(databasePrepareAndExecuteAttributes);
            }
            if (databasePrepareAndExecuteAttributes.isExtendedSQLStatementTextSet()) {
                this.writeExtendedSQLStatementText(databasePrepareAndExecuteAttributes);
            }
        }
    }

    private int getPackageLibraryLength(AttributePackageLibrary attributePackageLibrary) {
        return 10 + attributePackageLibrary.getPackageLibrary().length();
    }

    private void writePackageLibrary(AttributePackageLibrary attributePackageLibrary) throws IOException {
        String string = attributePackageLibrary.getPackageLibrary();
        this.out_.writeInt(10 + string.length());
        this.out_.writeShort(14337);
        this.out_.writeShort(37);
        this.out_.writeShort(string.length());
        DatabaseConnection.writePadEBCDIC(string, string.length(), this.out_);
    }

    private int getPackageNameLength(AttributePackageName attributePackageName) {
        return 10 + attributePackageName.getPackageName().length();
    }

    private void writePackageName(AttributePackageName attributePackageName) throws IOException {
        String string = attributePackageName.getPackageName();
        this.out_.writeInt(10 + string.length());
        this.out_.writeShort(14340);
        this.out_.writeShort(37);
        this.out_.writeShort(string.length());
        DatabaseConnection.writePadEBCDIC(string, string.length(), this.out_);
    }

    private int getPrepareStatementNameLength(AttributePrepareStatementName attributePrepareStatementName) {
        return 10 + attributePrepareStatementName.getPrepareStatementName().length();
    }

    private void writePrepareStatementName(AttributePrepareStatementName attributePrepareStatementName) throws IOException {
        String string = attributePrepareStatementName.getPrepareStatementName();
        this.out_.writeInt(10 + string.length());
        this.out_.writeShort(14342);
        this.out_.writeShort(37);
        this.out_.writeShort(string.length());
        DatabaseConnection.writePadEBCDIC(string, string.length(), this.out_);
    }

    private int getSQLStatementTextLength(AttributeSQLStatementText attributeSQLStatementText) {
        return 10 + attributeSQLStatementText.getSQLStatementText().length() * 2;
    }

    private void writeSQLStatementText(AttributeSQLStatementText attributeSQLStatementText) throws IOException {
        String string = attributeSQLStatementText.getSQLStatementText();
        this.out_.writeInt(10 + string.length() * 2);
        this.out_.writeShort(14343);
        this.out_.writeShort(13488);
        this.out_.writeShort(string.length() * 2);
        DatabaseConnection.writeStringToUnicodeBytes(string, this.out_);
    }

    private int getSQLStatementTypeLength(AttributeSQLStatementType attributeSQLStatementType) {
        return 8;
    }

    private void writeSQLStatementType(AttributeSQLStatementType attributeSQLStatementType) throws IOException {
        this.out_.writeInt(8);
        this.out_.writeShort(14354);
        this.out_.writeShort(attributeSQLStatementType.getSQLStatementType());
    }

    private int getPrepareOptionLength(AttributePrepareOption attributePrepareOption) {
        return 7;
    }

    private void writePrepareOption(AttributePrepareOption attributePrepareOption) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14344);
        this.out_.writeByte(attributePrepareOption.getPrepareOption());
    }

    private int getOpenAttributesLength(AttributeOpenAttributes attributeOpenAttributes) {
        return 7;
    }

    private void writeOpenAttributes(AttributeOpenAttributes attributeOpenAttributes) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14345);
        this.out_.writeByte(attributeOpenAttributes.getOpenAttributes());
    }

    private int getTranslateIndicatorLength(AttributeTranslateIndicator attributeTranslateIndicator) {
        return 7;
    }

    private void writeTranslateIndicator(AttributeTranslateIndicator attributeTranslateIndicator) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14341);
        this.out_.writeByte(attributeTranslateIndicator.getTranslateIndicator());
    }

    private int getRLECompressedFunctionParametersLength(AttributeRLECompressedFunctionParameters attributeRLECompressedFunctionParameters) {
        return 10 + attributeRLECompressedFunctionParameters.getRLECompressedFunctionParameters().length;
    }

    private void writeRLECompressedFunctionParameters(AttributeRLECompressedFunctionParameters attributeRLECompressedFunctionParameters) throws IOException {
        byte[] byArray = attributeRLECompressedFunctionParameters.getRLECompressedFunctionParameters();
        this.out_.writeInt(10 + byArray.length);
        this.out_.writeShort(14386);
        this.out_.writeInt(byArray.length);
        this.out_.write(byArray);
    }

    private int getExtendedColumnDescriptorOptionLength(AttributeExtendedColumnDescriptorOption attributeExtendedColumnDescriptorOption) {
        return 7;
    }

    private void writeExtendedColumnDescriptorOption(AttributeExtendedColumnDescriptorOption attributeExtendedColumnDescriptorOption) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14377);
        this.out_.writeByte(attributeExtendedColumnDescriptorOption.getExtendedColumnDescriptorOption());
    }

    private int getExtendedSQLStatementTextLength(AttributeExtendedSQLStatementText attributeExtendedSQLStatementText) {
        return 12 + attributeExtendedSQLStatementText.getExtendedSQLStatementText().length() * 2;
    }

    private void writeExtendedSQLStatementText(AttributeExtendedSQLStatementText attributeExtendedSQLStatementText) throws IOException {
        String string = attributeExtendedSQLStatementText.getExtendedSQLStatementText();
        this.out_.writeInt(12 + string.length() * 2);
        this.out_.writeShort(14385);
        this.out_.writeShort(13488);
        this.out_.writeInt(string.length() * 2);
        DatabaseConnection.writeStringToUnicodeBytes(string, this.out_);
    }

    private int getSyncPointCountLength(AttributeSyncPointCount attributeSyncPointCount) {
        return 10;
    }

    private void writeSyncPointCount(AttributeSyncPointCount attributeSyncPointCount) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14358);
        this.out_.writeInt(attributeSyncPointCount.getSyncPointCount());
    }

    private void sendPrepareRequest(DatabasePrepareAttributes databasePrepareAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databasePrepareAttributes != null) {
            if (databasePrepareAttributes.isPrepareStatementNameSet()) {
                n += this.getPrepareStatementNameLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isSQLStatementTextSet()) {
                n += this.getSQLStatementTextLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isSQLStatementTypeSet()) {
                n += this.getSQLStatementTypeLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isPrepareOptionSet()) {
                n += this.getPrepareOptionLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isOpenAttributesSet()) {
                n += this.getOpenAttributesLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isPackageNameSet()) {
                n += this.getPackageNameLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isPackageLibrarySet()) {
                n += this.getPackageLibraryLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isTranslateIndicatorSet()) {
                n += this.getTranslateIndicatorLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isRLECompressedFunctionParametersSet()) {
                n += this.getRLECompressedFunctionParametersLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isExtendedColumnDescriptorOptionSet()) {
                n += this.getExtendedColumnDescriptorOptionLength(databasePrepareAttributes);
                ++n2;
            }
            if (databasePrepareAttributes.isExtendedSQLStatementTextSet()) {
                n += this.getExtendedSQLStatementTextLength(databasePrepareAttributes);
                ++n2;
            }
        }
        this.writeHeader(n, 6144);
        int n3 = Integer.MIN_VALUE;
        this.writeTemplate(n2, n3);
        if (databasePrepareAttributes != null) {
            if (databasePrepareAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isSQLStatementTextSet()) {
                this.writeSQLStatementText(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isSQLStatementTypeSet()) {
                this.writeSQLStatementType(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isPrepareOptionSet()) {
                this.writePrepareOption(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isOpenAttributesSet()) {
                this.writeOpenAttributes(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isPackageNameSet()) {
                this.writePackageName(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isExtendedColumnDescriptorOptionSet()) {
                this.writeExtendedColumnDescriptorOption(databasePrepareAttributes);
            }
            if (databasePrepareAttributes.isExtendedSQLStatementTextSet()) {
                this.writeExtendedSQLStatementText(databasePrepareAttributes);
            }
        }
    }

    private void sendStreamFetchRequest(DatabaseStreamFetchAttributes databaseStreamFetchAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseStreamFetchAttributes != null) {
            if (databaseStreamFetchAttributes.isPrepareStatementNameSet()) {
                n += this.getPrepareStatementNameLength(databaseStreamFetchAttributes);
                ++n2;
            }
            if (databaseStreamFetchAttributes.isSQLStatementTextSet()) {
                n += this.getSQLStatementTextLength(databaseStreamFetchAttributes);
                ++n2;
            }
            if (databaseStreamFetchAttributes.isSQLStatementTypeSet()) {
                n += this.getSQLStatementTypeLength(databaseStreamFetchAttributes);
                ++n2;
            }
            if (databaseStreamFetchAttributes.isPackageNameSet()) {
                n += this.getPackageNameLength(databaseStreamFetchAttributes);
                ++n2;
            }
            if (databaseStreamFetchAttributes.isPackageLibrarySet()) {
                n += this.getPackageLibraryLength(databaseStreamFetchAttributes);
                ++n2;
            }
            if (databaseStreamFetchAttributes.isTranslateIndicatorSet()) {
                n += this.getTranslateIndicatorLength(databaseStreamFetchAttributes);
                ++n2;
            }
            if (databaseStreamFetchAttributes.isSyncPointCountSet()) {
                n += this.getSyncPointCountLength(databaseStreamFetchAttributes);
                ++n2;
            }
            if (databaseStreamFetchAttributes.isRLECompressedFunctionParametersSet()) {
                n += this.getRLECompressedFunctionParametersLength(databaseStreamFetchAttributes);
                ++n2;
            }
            if (databaseStreamFetchAttributes.isExtendedSQLStatementTextSet()) {
                n += this.getExtendedSQLStatementTextLength(databaseStreamFetchAttributes);
                ++n2;
            }
        }
        this.writeHeader(n, 6156);
        int n3 = -2080374784;
        this.writeTemplate(n2, n3);
        if (databaseStreamFetchAttributes != null) {
            if (databaseStreamFetchAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databaseStreamFetchAttributes);
            }
            if (databaseStreamFetchAttributes.isSQLStatementTextSet()) {
                this.writeSQLStatementText(databaseStreamFetchAttributes);
            }
            if (databaseStreamFetchAttributes.isSQLStatementTypeSet()) {
                this.writeSQLStatementType(databaseStreamFetchAttributes);
            }
            if (databaseStreamFetchAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseStreamFetchAttributes);
            }
            if (databaseStreamFetchAttributes.isPackageNameSet()) {
                this.writePackageName(databaseStreamFetchAttributes);
            }
            if (databaseStreamFetchAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseStreamFetchAttributes);
            }
            if (databaseStreamFetchAttributes.isSyncPointCountSet()) {
                this.writeSyncPointCount(databaseStreamFetchAttributes);
            }
            if (databaseStreamFetchAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseStreamFetchAttributes);
            }
            if (databaseStreamFetchAttributes.isExtendedSQLStatementTextSet()) {
                this.writeExtendedSQLStatementText(databaseStreamFetchAttributes);
            }
        }
    }

    private void sendEndStreamFetchRequest(DatabaseEndStreamFetchAttributes databaseEndStreamFetchAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseEndStreamFetchAttributes != null) {
            if (databaseEndStreamFetchAttributes.isTranslateIndicatorSet()) {
                n += this.getTranslateIndicatorLength(databaseEndStreamFetchAttributes);
                ++n2;
            }
            if (databaseEndStreamFetchAttributes.isRLECompressedFunctionParametersSet()) {
                n += this.getRLECompressedFunctionParametersLength(databaseEndStreamFetchAttributes);
                ++n2;
            }
        }
        this.writeHeader(n, 6163);
        int n3 = Integer.MIN_VALUE;
        this.writeTemplate(n2, n3);
        if (databaseEndStreamFetchAttributes != null) {
            if (databaseEndStreamFetchAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseEndStreamFetchAttributes);
            }
            if (databaseEndStreamFetchAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseEndStreamFetchAttributes);
            }
        }
    }

    private void writeHeader(int n, int n2) throws IOException {
        this.out_.writeInt(n);
        this.out_.writeInt(57348);
        this.out_.writeInt(0);
        this.out_.writeInt(this.newCorrelationID());
        this.out_.writeShort(20);
        this.out_.writeShort(n2);
    }

    private void writeTemplate(int n) throws IOException {
        int n2 = Integer.MIN_VALUE;
        this.writeTemplate(n, n2);
    }

    private void writeTemplate(int n, int n2) throws IOException {
        this.writeTemplate(n, n2, 0);
    }

    private void writeTemplate(int n, int n2, int n3) throws IOException {
        this.writeTemplate(n, n2, n3, this.currentRPB_);
    }

    private void writeTemplate(int n, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6 = n5 = this.sqlcaCallback_ != null ? n2 | 0x2000000 : n2;
        if (this.compress_) {
            n5 |= 0x40000;
        }
        if (this.returnMessageInfo_) {
            n5 = n5 | 0x40000000 | 0x20000000 | 0x10000000;
        }
        this.out_.writeInt(n5);
        this.out_.writeInt(0);
        this.out_.writeInt(65537);
        this.out_.writeShort(0);
        this.out_.writeShort(n4);
        this.out_.writeShort(n3);
        this.out_.writeShort(n);
    }

    private int getSQLParameterMarkerDataLength(AttributeSQLParameterMarkerData attributeSQLParameterMarkerData) {
        return 6 + attributeSQLParameterMarkerData.getSQLParameterMarkerData().length;
    }

    private void writeSQLParameterMarkerData(AttributeSQLParameterMarkerData attributeSQLParameterMarkerData) throws IOException {
        byte[] byArray = attributeSQLParameterMarkerData.getSQLParameterMarkerData();
        this.out_.writeInt(6 + byArray.length);
        this.out_.writeShort(14353);
        this.out_.write(byArray);
    }

    private int getSQLExtendedParameterMarkerDataLength(AttributeSQLExtendedParameterMarkerData attributeSQLExtendedParameterMarkerData) {
        return 6 + attributeSQLExtendedParameterMarkerData.getSQLExtendedParameterMarkerData().length;
    }

    private void writeSQLExtendedParameterMarkerData(AttributeSQLExtendedParameterMarkerData attributeSQLExtendedParameterMarkerData) throws IOException {
        byte[] byArray = attributeSQLExtendedParameterMarkerData.getSQLExtendedParameterMarkerData();
        this.out_.writeInt(6 + byArray.length);
        this.out_.writeShort(14367);
        this.out_.write(byArray);
    }

    private int getSQLParameterMarkerBlockIndicatorLength(AttributeSQLParameterMarkerBlockIndicator attributeSQLParameterMarkerBlockIndicator) {
        return 8;
    }

    private void writeSQLParameterMarkerBlockIndicator(AttributeSQLParameterMarkerBlockIndicator attributeSQLParameterMarkerBlockIndicator) throws IOException {
        this.out_.writeInt(8);
        this.out_.writeShort(14356);
        this.out_.writeShort(attributeSQLParameterMarkerBlockIndicator.getSQLParameterMarkerBlockIndicator());
    }

    private void sendFetchRequest(DatabaseFetchAttributes databaseFetchAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseFetchAttributes != null) {
            if (databaseFetchAttributes.isCursorNameSet()) {
                ++n2;
                n += this.getCursorNameLength(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isVariableFieldCompressionSet()) {
                ++n2;
                n += this.getVariableFieldCompressionLength(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isBlockingFactorSet()) {
                ++n2;
                n += this.getBlockingFactorLength(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isFetchScrollOptionSet()) {
                ++n2;
                n += this.getFetchScrollOptionLength(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isTranslateIndicatorSet()) {
                ++n2;
                n += this.getTranslateIndicatorLength(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isRLECompressedFunctionParametersSet()) {
                ++n2;
                n += this.getRLECompressedFunctionParametersLength(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isFetchBufferSizeSet()) {
                ++n2;
                n += this.getFetchBufferSizeLength(databaseFetchAttributes);
            }
        }
        this.writeHeader(n, 6155);
        int n3 = -2080374784;
        this.writeTemplate(n2, n3);
        if (databaseFetchAttributes != null) {
            if (databaseFetchAttributes.isCursorNameSet()) {
                this.writeCursorName(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isVariableFieldCompressionSet()) {
                this.writeVariableFieldCompression(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isBlockingFactorSet()) {
                this.writeBlockingFactor(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isFetchScrollOptionSet()) {
                this.writeFetchScrollOption(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseFetchAttributes);
            }
            if (databaseFetchAttributes.isFetchBufferSizeSet()) {
                this.writeFetchBufferSize(databaseFetchAttributes);
            }
        }
    }

    private void sendPackageRequest(DatabasePackageAttributes databasePackageAttributes, boolean bl) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databasePackageAttributes != null) {
            if (databasePackageAttributes.isPackageNameSet()) {
                ++n2;
                n += this.getPackageNameLength(databasePackageAttributes);
            }
            if (databasePackageAttributes.isPackageLibrarySet()) {
                ++n2;
                n += this.getPackageLibraryLength(databasePackageAttributes);
            }
            if (databasePackageAttributes.isTranslateIndicatorSet()) {
                ++n2;
                n += this.getTranslateIndicatorLength(databasePackageAttributes);
            }
            if (databasePackageAttributes.isRLECompressedFunctionParametersSet()) {
                ++n2;
                n += this.getRLECompressedFunctionParametersLength(databasePackageAttributes);
            }
        }
        this.writeHeader(n, bl ? 6159 : 6161);
        int n3 = -2113929216;
        this.writeTemplate(n2, n3);
        if (databasePackageAttributes != null) {
            if (databasePackageAttributes.isPackageNameSet()) {
                this.writePackageName(databasePackageAttributes);
            }
            if (databasePackageAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databasePackageAttributes);
            }
            if (databasePackageAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databasePackageAttributes);
            }
            if (databasePackageAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databasePackageAttributes);
            }
        }
    }

    private int getReturnSizeLength(AttributeReturnSize attributeReturnSize) {
        return 10;
    }

    private void writeReturnSize(AttributeReturnSize attributeReturnSize) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14357);
        this.out_.writeInt(attributeReturnSize.getReturnSize());
    }

    private void sendRetrievePackageRequest(DatabaseRetrievePackageAttributes databaseRetrievePackageAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseRetrievePackageAttributes != null) {
            if (databaseRetrievePackageAttributes.isPackageNameSet()) {
                ++n2;
                n += this.getPackageNameLength(databaseRetrievePackageAttributes);
            }
            if (databaseRetrievePackageAttributes.isPackageLibrarySet()) {
                ++n2;
                n += this.getPackageLibraryLength(databaseRetrievePackageAttributes);
            }
            if (databaseRetrievePackageAttributes.isTranslateIndicatorSet()) {
                ++n2;
                n += this.getTranslateIndicatorLength(databaseRetrievePackageAttributes);
            }
            if (databaseRetrievePackageAttributes.isReturnSizeSet()) {
                ++n2;
                n += this.getReturnSizeLength(databaseRetrievePackageAttributes);
            }
            if (databaseRetrievePackageAttributes.isRLECompressedFunctionParametersSet()) {
                ++n2;
                n += this.getRLECompressedFunctionParametersLength(databaseRetrievePackageAttributes);
            }
        }
        this.writeHeader(n, 6165);
        int n3 = -2146435072;
        this.writeTemplate(n2, n3);
        if (databaseRetrievePackageAttributes != null) {
            if (databaseRetrievePackageAttributes.isPackageNameSet()) {
                this.writePackageName(databaseRetrievePackageAttributes);
            }
            if (databaseRetrievePackageAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseRetrievePackageAttributes);
            }
            if (databaseRetrievePackageAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseRetrievePackageAttributes);
            }
            if (databaseRetrievePackageAttributes.isReturnSizeSet()) {
                this.writeReturnSize(databaseRetrievePackageAttributes);
            }
            if (databaseRetrievePackageAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseRetrievePackageAttributes);
            }
        }
    }

    private int getSQLParameterMarkerDataFormatLength(AttributeSQLParameterMarkerDataFormat attributeSQLParameterMarkerDataFormat) {
        return 6 + attributeSQLParameterMarkerDataFormat.getSQLParameterMarkerDataFormat().length;
    }

    private void writeSQLParameterMarkerDataFormat(AttributeSQLParameterMarkerDataFormat attributeSQLParameterMarkerDataFormat) throws IOException {
        this.out_.writeInt(this.getSQLParameterMarkerDataFormatLength(attributeSQLParameterMarkerDataFormat));
        this.out_.writeShort(14337);
        this.out_.write(attributeSQLParameterMarkerDataFormat.getSQLParameterMarkerDataFormat());
    }

    private int getExtendedSQLParameterMarkerDataFormatLength(AttributeExtendedSQLParameterMarkerDataFormat attributeExtendedSQLParameterMarkerDataFormat) {
        return 6 + attributeExtendedSQLParameterMarkerDataFormat.getExtendedSQLParameterMarkerDataFormat().length;
    }

    private void writeExtendedSQLParameterMarkerDataFormat(AttributeExtendedSQLParameterMarkerDataFormat attributeExtendedSQLParameterMarkerDataFormat) throws IOException {
        this.out_.writeInt(this.getExtendedSQLParameterMarkerDataFormatLength(attributeExtendedSQLParameterMarkerDataFormat));
        this.out_.writeShort(14366);
        this.out_.write(attributeExtendedSQLParameterMarkerDataFormat.getExtendedSQLParameterMarkerDataFormat());
    }

    private void sendDeleteDescriptorRequest(DatabaseDeleteDescriptorAttributes databaseDeleteDescriptorAttributes, int n) throws IOException {
        int n2 = 40;
        int n3 = 0;
        if (databaseDeleteDescriptorAttributes != null) {
            if (databaseDeleteDescriptorAttributes.isTranslateIndicatorSet()) {
                ++n3;
                n2 += this.getTranslateIndicatorLength(databaseDeleteDescriptorAttributes);
            }
            if (databaseDeleteDescriptorAttributes.isRLECompressedFunctionParametersSet()) {
                ++n3;
                n2 += this.getRLECompressedFunctionParametersLength(databaseDeleteDescriptorAttributes);
            }
        }
        this.writeHeader(n2, 7681);
        int n4 = -2139095040;
        this.writeTemplate(n3, n4, n);
        if (databaseDeleteDescriptorAttributes != null) {
            if (databaseDeleteDescriptorAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseDeleteDescriptorAttributes);
            }
            if (databaseDeleteDescriptorAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseDeleteDescriptorAttributes);
            }
        }
    }

    private void sendChangeDescriptorRequest(DatabaseChangeDescriptorAttributes databaseChangeDescriptorAttributes, int n) throws IOException {
        int n2 = 40;
        int n3 = 0;
        if (databaseChangeDescriptorAttributes != null) {
            if (databaseChangeDescriptorAttributes.isSQLParameterMarkerDataFormatSet()) {
                ++n3;
                n2 += this.getSQLParameterMarkerDataFormatLength(databaseChangeDescriptorAttributes);
            }
            if (databaseChangeDescriptorAttributes.isTranslateIndicatorSet()) {
                ++n3;
                n2 += this.getTranslateIndicatorLength(databaseChangeDescriptorAttributes);
            }
            if (databaseChangeDescriptorAttributes.isExtendedSQLParameterMarkerDataFormatSet()) {
                ++n3;
                n2 += this.getExtendedSQLParameterMarkerDataFormatLength(databaseChangeDescriptorAttributes);
            }
            if (databaseChangeDescriptorAttributes.isRLECompressedFunctionParametersSet()) {
                ++n3;
                n2 += this.getRLECompressedFunctionParametersLength(databaseChangeDescriptorAttributes);
            }
        }
        this.writeHeader(n2, 7680);
        int n4 = 262144;
        this.writeTemplate(n3, n4, n);
        if (databaseChangeDescriptorAttributes != null) {
            if (databaseChangeDescriptorAttributes.isSQLParameterMarkerDataFormatSet()) {
                this.writeSQLParameterMarkerDataFormat(databaseChangeDescriptorAttributes);
            }
            if (databaseChangeDescriptorAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseChangeDescriptorAttributes);
            }
            if (databaseChangeDescriptorAttributes.isExtendedSQLParameterMarkerDataFormatSet()) {
                this.writeExtendedSQLParameterMarkerDataFormat(databaseChangeDescriptorAttributes);
            }
            if (databaseChangeDescriptorAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseChangeDescriptorAttributes);
            }
        }
    }

    private void sendDescribeParameterMarkerRequest(DatabaseDescribeParameterMarkerAttributes databaseDescribeParameterMarkerAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseDescribeParameterMarkerAttributes != null) {
            if (databaseDescribeParameterMarkerAttributes.isPackageNameSet()) {
                ++n2;
                n += this.getPackageNameLength(databaseDescribeParameterMarkerAttributes);
            }
            if (databaseDescribeParameterMarkerAttributes.isPackageLibrarySet()) {
                ++n2;
                n += this.getPackageLibraryLength(databaseDescribeParameterMarkerAttributes);
            }
            if (databaseDescribeParameterMarkerAttributes.isTranslateIndicatorSet()) {
                ++n2;
                n += this.getTranslateIndicatorLength(databaseDescribeParameterMarkerAttributes);
            }
            if (databaseDescribeParameterMarkerAttributes.isRLECompressedFunctionParametersSet()) {
                ++n2;
                n += this.getRLECompressedFunctionParametersLength(databaseDescribeParameterMarkerAttributes);
            }
            if (databaseDescribeParameterMarkerAttributes.isPrepareStatementNameSet()) {
                ++n2;
                n += this.getPrepareStatementNameLength(databaseDescribeParameterMarkerAttributes);
            }
        }
        this.writeHeader(n, 6146);
        int n3 = -2139095040;
        this.writeTemplate(n2, n3);
        if (databaseDescribeParameterMarkerAttributes != null) {
            if (databaseDescribeParameterMarkerAttributes.isPackageNameSet()) {
                this.writePackageName(databaseDescribeParameterMarkerAttributes);
            }
            if (databaseDescribeParameterMarkerAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseDescribeParameterMarkerAttributes);
            }
            if (databaseDescribeParameterMarkerAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseDescribeParameterMarkerAttributes);
            }
            if (databaseDescribeParameterMarkerAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseDescribeParameterMarkerAttributes);
            }
            if (databaseDescribeParameterMarkerAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databaseDescribeParameterMarkerAttributes);
            }
        }
    }

    private void sendDescribeRequest(DatabaseDescribeAttributes databaseDescribeAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseDescribeAttributes != null) {
            if (databaseDescribeAttributes.isPrepareStatementNameSet()) {
                ++n2;
                n += this.getPrepareStatementNameLength(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isDescribeOptionSet()) {
                ++n2;
                n += this.getDescribeOptionLength(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isPackageNameSet()) {
                ++n2;
                n += this.getPackageNameLength(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isPackageLibrarySet()) {
                ++n2;
                n += this.getPackageLibraryLength(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isTranslateIndicatorSet()) {
                ++n2;
                n += this.getTranslateIndicatorLength(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isRLECompressedFunctionParametersSet()) {
                ++n2;
                n += this.getRLECompressedFunctionParametersLength(databaseDescribeAttributes);
            }
        }
        this.writeHeader(n, 6145);
        int n3 = -2013265920;
        this.writeTemplate(n2, n3);
        if (databaseDescribeAttributes != null) {
            if (databaseDescribeAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isDescribeOptionSet()) {
                this.writeDescribeOption(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isPackageNameSet()) {
                this.writePackageName(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseDescribeAttributes);
            }
            if (databaseDescribeAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseDescribeAttributes);
            }
        }
    }

    private void sendOpenAndDescribeRequest(DatabaseOpenAndDescribeAttributes databaseOpenAndDescribeAttributes, int n) throws IOException {
        int n2 = 40;
        int n3 = 0;
        if (databaseOpenAndDescribeAttributes != null) {
            if (databaseOpenAndDescribeAttributes.isPrepareStatementNameSet()) {
                ++n3;
                n2 += this.getPrepareStatementNameLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isCursorNameSet()) {
                ++n3;
                n2 += this.getCursorNameLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isOpenAttributesSet()) {
                ++n3;
                n2 += this.getOpenAttributesLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isVariableFieldCompressionSet()) {
                ++n3;
                n2 += this.getVariableFieldCompressionLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isDescribeOptionSet()) {
                ++n3;
                n2 += this.getDescribeOptionLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isBlockingFactorSet()) {
                ++n3;
                n2 += this.getBlockingFactorLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isScrollableCursorFlagSet()) {
                ++n3;
                n2 += this.getScrollableCursorFlagLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isSQLParameterMarkerDataSet()) {
                ++n3;
                n2 += this.getSQLParameterMarkerDataLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isSQLExtendedParameterMarkerDataSet()) {
                ++n3;
                n2 += this.getSQLExtendedParameterMarkerDataLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                ++n3;
                n2 += this.getSQLParameterMarkerBlockIndicatorLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isPackageNameSet()) {
                ++n3;
                n2 += this.getPackageNameLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isPackageLibrarySet()) {
                ++n3;
                n2 += this.getPackageLibraryLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isTranslateIndicatorSet()) {
                ++n3;
                n2 += this.getTranslateIndicatorLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isRLECompressedFunctionParametersSet()) {
                ++n3;
                n2 += this.getRLECompressedFunctionParametersLength(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isResultSetHoldabilityOptionSet()) {
                ++n3;
                n2 += this.getResultSetHoldabilityOptionLength(databaseOpenAndDescribeAttributes);
            }
        }
        this.writeHeader(n2, 6148);
        int n4 = -2013003776;
        this.writeTemplate(n3, n4, n);
        if (databaseOpenAndDescribeAttributes != null) {
            if (databaseOpenAndDescribeAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isCursorNameSet()) {
                this.writeCursorName(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isOpenAttributesSet()) {
                this.writeOpenAttributes(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isVariableFieldCompressionSet()) {
                this.writeVariableFieldCompression(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isDescribeOptionSet()) {
                this.writeDescribeOption(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isBlockingFactorSet()) {
                this.writeBlockingFactor(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isScrollableCursorFlagSet()) {
                this.writeScrollableCursorFlag(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isSQLParameterMarkerDataSet()) {
                this.writeSQLParameterMarkerData(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isSQLExtendedParameterMarkerDataSet()) {
                this.writeSQLExtendedParameterMarkerData(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                this.writeSQLParameterMarkerBlockIndicator(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isPackageNameSet()) {
                this.writePackageName(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseOpenAndDescribeAttributes);
            }
            if (databaseOpenAndDescribeAttributes.isResultSetHoldabilityOptionSet()) {
                this.writeResultSetHoldabilityOption(databaseOpenAndDescribeAttributes);
            }
        }
    }

    private void sendExecuteOrOpenAndDescribeRequest(DatabaseExecuteOrOpenAndDescribeAttributes databaseExecuteOrOpenAndDescribeAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseExecuteOrOpenAndDescribeAttributes != null) {
            if (databaseExecuteOrOpenAndDescribeAttributes.isPrepareStatementNameSet()) {
                ++n2;
                n += this.getPrepareStatementNameLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isCursorNameSet()) {
                ++n2;
                n += this.getCursorNameLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isOpenAttributesSet()) {
                ++n2;
                n += this.getOpenAttributesLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isDescribeOptionSet()) {
                ++n2;
                n += this.getDescribeOptionLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isBlockingFactorSet()) {
                ++n2;
                n += this.getBlockingFactorLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isScrollableCursorFlagSet()) {
                ++n2;
                n += this.getScrollableCursorFlagLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isSQLParameterMarkerDataSet()) {
                ++n2;
                n += this.getSQLParameterMarkerDataLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isSQLExtendedParameterMarkerDataSet()) {
                ++n2;
                n += this.getSQLExtendedParameterMarkerDataLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                ++n2;
                n += this.getSQLParameterMarkerBlockIndicatorLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isPackageNameSet()) {
                ++n2;
                n += this.getPackageNameLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isPackageLibrarySet()) {
                ++n2;
                n += this.getPackageLibraryLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isTranslateIndicatorSet()) {
                ++n2;
                n += this.getTranslateIndicatorLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isRLECompressedFunctionParametersSet()) {
                ++n2;
                n += this.getRLECompressedFunctionParametersLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isResultSetHoldabilityOptionSet()) {
                ++n2;
                n += this.getResultSetHoldabilityOptionLength(databaseExecuteOrOpenAndDescribeAttributes);
            }
        }
        this.writeHeader(n, 6162);
        int n3 = -2013265920;
        this.writeTemplate(n2, n3);
        if (databaseExecuteOrOpenAndDescribeAttributes != null) {
            if (databaseExecuteOrOpenAndDescribeAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isCursorNameSet()) {
                this.writeCursorName(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isOpenAttributesSet()) {
                this.writeOpenAttributes(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isDescribeOptionSet()) {
                this.writeDescribeOption(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isBlockingFactorSet()) {
                this.writeBlockingFactor(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isScrollableCursorFlagSet()) {
                this.writeScrollableCursorFlag(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isSQLParameterMarkerDataSet()) {
                this.writeSQLParameterMarkerData(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isSQLExtendedParameterMarkerDataSet()) {
                this.writeSQLExtendedParameterMarkerData(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                this.writeSQLParameterMarkerBlockIndicator(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isPackageNameSet()) {
                this.writePackageName(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseExecuteOrOpenAndDescribeAttributes);
            }
            if (databaseExecuteOrOpenAndDescribeAttributes.isResultSetHoldabilityOptionSet()) {
                this.writeResultSetHoldabilityOption(databaseExecuteOrOpenAndDescribeAttributes);
            }
        }
    }

    private void sendOpenDescribeFetchRequest(DatabaseOpenDescribeFetchAttributes databaseOpenDescribeFetchAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseOpenDescribeFetchAttributes != null) {
            if (databaseOpenDescribeFetchAttributes.isPrepareStatementNameSet()) {
                ++n2;
                n += this.getPrepareStatementNameLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isCursorNameSet()) {
                ++n2;
                n += this.getCursorNameLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isOpenAttributesSet()) {
                ++n2;
                n += this.getOpenAttributesLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isVariableFieldCompressionSet()) {
                ++n2;
                n += this.getVariableFieldCompressionLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isDescribeOptionSet()) {
                ++n2;
                n += this.getDescribeOptionLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isBlockingFactorSet()) {
                ++n2;
                n += this.getBlockingFactorLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isScrollableCursorFlagSet()) {
                ++n2;
                n += this.getScrollableCursorFlagLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isSQLParameterMarkerDataSet()) {
                ++n2;
                n += this.getSQLParameterMarkerDataLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isSQLExtendedParameterMarkerDataSet()) {
                ++n2;
                n += this.getSQLExtendedParameterMarkerDataLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                ++n2;
                n += this.getSQLParameterMarkerBlockIndicatorLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isPackageNameSet()) {
                ++n2;
                n += this.getPackageNameLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isPackageLibrarySet()) {
                ++n2;
                n += this.getPackageLibraryLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isTranslateIndicatorSet()) {
                ++n2;
                n += this.getTranslateIndicatorLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isRLECompressedFunctionParametersSet()) {
                ++n2;
                n += this.getRLECompressedFunctionParametersLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isResultSetHoldabilityOptionSet()) {
                ++n2;
                n += this.getResultSetHoldabilityOptionLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isFetchScrollOptionSet()) {
                ++n2;
                n += this.getFetchScrollOptionLength(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isFetchBufferSizeSet()) {
                ++n2;
                n += this.getFetchBufferSizeLength(databaseOpenDescribeFetchAttributes);
            }
        }
        this.writeHeader(n, 6158);
        int n3 = -2046525440;
        this.writeTemplate(n2, n3);
        if (databaseOpenDescribeFetchAttributes != null) {
            if (databaseOpenDescribeFetchAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isCursorNameSet()) {
                this.writeCursorName(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isOpenAttributesSet()) {
                this.writeOpenAttributes(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isVariableFieldCompressionSet()) {
                this.writeVariableFieldCompression(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isDescribeOptionSet()) {
                this.writeDescribeOption(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isBlockingFactorSet()) {
                this.writeBlockingFactor(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isScrollableCursorFlagSet()) {
                this.writeScrollableCursorFlag(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isSQLParameterMarkerDataSet()) {
                this.writeSQLParameterMarkerData(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isSQLExtendedParameterMarkerDataSet()) {
                this.writeSQLExtendedParameterMarkerData(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                this.writeSQLParameterMarkerBlockIndicator(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isPackageNameSet()) {
                this.writePackageName(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isResultSetHoldabilityOptionSet()) {
                this.writeResultSetHoldabilityOption(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isFetchScrollOptionSet()) {
                this.writeFetchScrollOption(databaseOpenDescribeFetchAttributes);
            }
            if (databaseOpenDescribeFetchAttributes.isFetchBufferSizeSet()) {
                this.writeFetchBufferSize(databaseOpenDescribeFetchAttributes);
            }
        }
    }

    public void openAndDescribe(DatabaseOpenAndDescribeAttributes databaseOpenAndDescribeAttributes, DatabaseDescribeCallback databaseDescribeCallback) throws IOException {
        this.openAndDescribe(databaseOpenAndDescribeAttributes, 0, databaseDescribeCallback);
    }

    public void openAndDescribe(DatabaseOpenAndDescribeAttributes databaseOpenAndDescribeAttributes, int n, DatabaseDescribeCallback databaseDescribeCallback) throws IOException {
        this.sendOpenAndDescribeRequest(databaseOpenAndDescribeAttributes, n);
        this.out_.flush();
        this.parseReply("openAndDescribe", databaseDescribeCallback, null);
    }

    public void openDescribeFetch(DatabaseOpenDescribeFetchAttributes databaseOpenDescribeFetchAttributes, DatabaseDescribeCallback databaseDescribeCallback, DatabaseFetchCallback databaseFetchCallback) throws IOException {
        this.sendOpenDescribeFetchRequest(databaseOpenDescribeFetchAttributes);
        this.out_.flush();
        this.parseReply("openDescribeFetch", databaseDescribeCallback, databaseFetchCallback);
    }

    public void createPackage(DatabasePackageAttributes databasePackageAttributes) throws IOException {
        this.sendPackageRequest(databasePackageAttributes, true);
        this.out_.flush();
        this.parseReply("createPackage", null, null);
    }

    public void deletePackage(DatabasePackageAttributes databasePackageAttributes) throws IOException {
        this.sendPackageRequest(databasePackageAttributes, false);
        this.out_.flush();
        this.parseReply("deletePackage", null, null);
    }

    public void retrievePackage(DatabaseRetrievePackageAttributes databaseRetrievePackageAttributes, DatabasePackageCallback databasePackageCallback) throws IOException {
        this.sendRetrievePackageRequest(databaseRetrievePackageAttributes);
        this.out_.flush();
        this.parseReply("retrievePackage", databasePackageCallback);
    }

    public void describeParameterMarker(DatabaseDescribeParameterMarkerAttributes databaseDescribeParameterMarkerAttributes, DatabaseParameterMarkerCallback databaseParameterMarkerCallback) throws IOException {
        this.sendDescribeParameterMarkerRequest(databaseDescribeParameterMarkerAttributes);
        this.out_.flush();
        this.parseReply("describeParameterMarker", databaseParameterMarkerCallback);
    }

    public void changeDescriptor(DatabaseChangeDescriptorAttributes databaseChangeDescriptorAttributes, int n) throws IOException {
        this.sendChangeDescriptorRequest(databaseChangeDescriptorAttributes, n);
        this.out_.flush();
    }

    public void deleteDescriptor(DatabaseDeleteDescriptorAttributes databaseDeleteDescriptorAttributes, int n) throws IOException {
        this.sendDeleteDescriptorRequest(databaseDeleteDescriptorAttributes, n);
        this.out_.flush();
        this.parseReply("deleteDescriptor", null, null);
    }

    public void describe(DatabaseDescribeAttributes databaseDescribeAttributes, DatabaseDescribeCallback databaseDescribeCallback) throws IOException {
        this.sendDescribeRequest(databaseDescribeAttributes);
        this.out_.flush();
        this.parseReply("describe", databaseDescribeCallback, null);
    }

    private void parseReply(String string, DatabaseParameterMarkerCallback databaseParameterMarkerCallback) throws IOException {
        this.parseReply(string, null, null, null, databaseParameterMarkerCallback, null);
    }

    private void parseReply(String string, DatabasePackageCallback databasePackageCallback) throws IOException {
        this.parseReply(string, null, null, databasePackageCallback, null, null);
    }

    private void parseReply(String string, DatabaseDescribeCallback databaseDescribeCallback, DatabaseFetchCallback databaseFetchCallback) throws IOException {
        this.parseReply(string, databaseDescribeCallback, databaseFetchCallback, null, null, null);
    }

    private int readCompressedInt() throws IOException {
        int n = this.readCompressedByte();
        int n2 = this.readCompressedByte();
        int n3 = this.readCompressedByte();
        int n4 = this.readCompressedByte();
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    private int readCompressedShort() throws IOException {
        int n = this.readCompressedByte();
        int n2 = this.readCompressedByte();
        return n << 8 | n2;
    }

    private void readCompressedFully(byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)this.readCompressedByte();
        }
    }

    private void readCompressedFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byArray[i] = (byte)this.readCompressedByte();
        }
    }

    private void skipCompressedBytes(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.readCompressedByte();
        }
    }

    private int readCompressedByte() throws IOException {
        if (this.rleRepeatCount_ < this.rleRepeatTotal_) {
            return this.rleRepeatCount_++ % 2 == 0 ? this.rleRepeatValue1_ : this.rleRepeatValue2_;
        }
        int n = this.in_.readByte();
        if (n == 27) {
            int n2 = this.in_.readByte();
            if (n2 == 27) {
                return 27;
            }
            this.rleRepeatValue1_ = n2;
            this.rleRepeatValue2_ = this.in_.readByte();
            int n3 = this.in_.readByte();
            int n4 = this.in_.readByte();
            this.rleRepeatTotal_ = (n3 << 8 | n4) * 2;
            this.rleRepeatCount_ = 1;
            return this.rleRepeatValue1_;
        }
        return n;
    }

    private int readInt() throws IOException {
        return this.rleCompression_ ? this.readCompressedInt() : this.in_.readInt();
    }

    private int readShort() throws IOException {
        return this.rleCompression_ ? this.readCompressedShort() : this.in_.readShort();
    }

    private int readByte() throws IOException {
        return this.rleCompression_ ? this.readCompressedByte() : this.in_.readByte();
    }

    private void readFullyReturnCount(byte[] byArray) throws IOException {
        if (this.rleCompression_) {
            this.readCompressedFully(byArray);
        } else {
            this.in_.readFully(byArray);
        }
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (this.rleCompression_) {
            this.readCompressedFully(byArray, n, n2);
        } else {
            this.in_.readFully(byArray, n, n2);
        }
    }

    private void skipBytes(int n) throws IOException {
        if (this.rleCompression_) {
            this.skipCompressedBytes(n);
        } else {
            this.in_.skipBytes(n);
        }
    }

    private void parseReply(String string, DatabaseDescribeCallback databaseDescribeCallback, DatabaseFetchCallback databaseFetchCallback, DatabasePackageCallback databasePackageCallback, DatabaseParameterMarkerCallback databaseParameterMarkerCallback, DatabaseLOBDataCallback databaseLOBDataCallback) throws IOException {
        this.in_.resetLatestBytesReceived();
        int n = this.readReplyHeader(string);
        this.rleCompression_ = false;
        while (this.in_.getLatestBytesReceived() < (long)n) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = this.readInt();
            int n10 = this.readShort();
            if (n10 == 14386) {
                n8 = this.readInt();
                this.rleCompression_ = true;
                continue;
            }
            if (n10 == 14337 && this.warningCallback_ != null) {
                if (n9 <= 6) continue;
                n8 = 2;
                n7 = this.readShort();
                byte[] byArray = new byte[n9 - 8];
                this.readFullyReturnCount(byArray);
                if (n9 > this.charBuffer_.length) {
                    this.charBuffer_ = new char[n9];
                }
                this.warningCallback_.newMessageID(Conv.ebcdicByteArrayToString(byArray, this.charBuffer_));
                continue;
            }
            if (n10 == 14338 && this.warningCallback_ != null) {
                if (n9 <= 6) continue;
                n8 = this.readShort();
                n7 = this.readShort();
                byte[] byArray = new byte[n9 - 10];
                this.readFullyReturnCount(byArray);
                if (n9 > this.charBuffer_.length) {
                    this.charBuffer_ = new char[n9];
                }
                this.warningCallback_.newMessageText(Conv.ebcdicByteArrayToString(byArray, this.charBuffer_));
                continue;
            }
            if (n10 == 14339 && this.warningCallback_ != null) {
                if (n9 <= 6) continue;
                n8 = this.readShort();
                n7 = this.readShort();
                byte[] byArray = new byte[n9 - 10];
                this.readFullyReturnCount(byArray);
                if (n9 > this.charBuffer_.length) {
                    this.charBuffer_ = new char[n9];
                }
                this.warningCallback_.newSecondLevelText(Conv.ebcdicByteArrayToString(byArray, this.charBuffer_));
                continue;
            }
            if (n10 == 14353 && databaseDescribeCallback != null) {
                int n11;
                int n12;
                int n13;
                int n14;
                if (n9 <= 6) continue;
                n8 = (int)this.in_.getLatestBytesReceived() - 6;
                n7 = n8 + 6;
                int n15 = this.readInt();
                int[] nArray = new int[n15];
                int[] nArray2 = new int[n15];
                this.skipBytes(6);
                n7 += 10;
                for (n14 = 0; n14 < n15; ++n14) {
                    n13 = this.readByte();
                    n12 = this.readByte();
                    n11 = this.readShort();
                    databaseDescribeCallback.columnAttributes(n14, n13, n12, (n11 & 0x8000) != 0, (n11 & 0x4000) == 0, (n11 & 0x2000) != 0, (n11 & 0x1000) != 0, (n11 & 0x800) != 0, (n11 & 0x400) != 0, (n11 & 0x200) != 0, (n11 & 0x100) == 0, (n11 & 0x80) != 0, (n11 & 0x40) != 0);
                    nArray[n14] = this.readInt();
                    nArray2[n14] = this.readInt();
                    this.readInt();
                    n7 += 16;
                }
                for (n14 = 0; n14 < n15; ++n14) {
                    n13 = n7 - n8;
                    n12 = nArray[n14] - n13;
                    if (n12 > 0) {
                        this.skipBytes(n12);
                        n7 += n12;
                    }
                    if (nArray2[n14] < 8) continue;
                    n11 = 0;
                    while (n11 < nArray2[n14]) {
                        int n16;
                        int n17 = n11;
                        int n18 = this.readInt();
                        int n19 = this.readShort();
                        n11 += 6;
                        n7 += 6;
                        int n20 = 37;
                        int n21 = n18 - 6;
                        if (n19 == 14594) {
                            n20 = this.readShort();
                            n11 += 2;
                            n7 += 2;
                            n21 = n18 - 8;
                            if (n20 == 65535) {
                                n20 = 37;
                            }
                        }
                        this.readFully(this.byteBuffer_, 0, n21);
                        n11 += n21;
                        n7 += n21;
                        String string2 = Conv.ebcdicByteArrayToString(this.byteBuffer_, 0, n21, this.charBuffer_, n20);
                        switch (n19) {
                            case 14592: {
                                databaseDescribeCallback.baseColumnName(n14, string2);
                                break;
                            }
                            case 14593: {
                                databaseDescribeCallback.baseTableName(n14, string2);
                                break;
                            }
                            case 14594: {
                                databaseDescribeCallback.columnLabel(n14, string2);
                                break;
                            }
                            case 14596: {
                                databaseDescribeCallback.baseSchemaName(n14, string2);
                                break;
                            }
                            case 14597: {
                                databaseDescribeCallback.sqlFromTable(n14, string2);
                                break;
                            }
                            case 14598: {
                                databaseDescribeCallback.sqlFromSchema(n14, string2);
                            }
                        }
                        if ((n16 = n18 - n11 + n17) <= 0) continue;
                        this.skipBytes(n16);
                        n11 += n16;
                        n7 += n16;
                    }
                }
                n14 = n9 - n7 + n8;
                this.skipBytes(n14);
                n7 += n14;
                continue;
            }
            if (n10 == 14354) {
                if (n9 > 6 && databaseDescribeCallback != null) {
                    int n22;
                    int n23;
                    int n24;
                    int n25;
                    n7 = n8 = (int)this.in_.getLatestBytesReceived() - 6;
                    n7 += 6;
                    int n26 = this.readInt();
                    int n27 = this.readInt();
                    int n28 = this.readByte();
                    int n29 = this.readByte();
                    int n30 = this.readByte();
                    int n31 = this.readByte();
                    int n32 = this.readInt();
                    databaseDescribeCallback.resultSetDescription(n27, n28, n29, n30, n31, n32);
                    n7 += 16;
                    int[] nArray = new int[n27];
                    int[] nArray3 = new int[n27];
                    int n33 = 48 * n27;
                    for (n25 = 0; n25 < n27; ++n25) {
                        int n34 = this.readShort();
                        int n35 = this.readShort();
                        int n36 = this.readInt();
                        n6 = this.readShort();
                        n24 = this.readShort();
                        n23 = this.readShort();
                        this.readByte();
                        n5 = this.readShort();
                        this.readInt();
                        int n37 = this.readByte();
                        this.readInt();
                        n4 = this.readInt();
                        this.readShort();
                        n3 = this.readInt();
                        n2 = this.readInt();
                        this.readInt();
                        this.readInt();
                        n7 += 48;
                        databaseDescribeCallback.fieldDescription(n25, n35, n36, n6, n24, n23, n5, n37, n4);
                        nArray[n25] = 48 * n25 + n3 - n33;
                        nArray3[n25] = n2;
                    }
                    n25 = 0;
                    for (n22 = 0; n22 < n27; ++n22) {
                        int n38 = nArray[n22] - n25;
                        this.skipBytes(n38);
                        n7 += n38;
                        n25 += n38;
                        for (int i = nArray3[n22]; i > 0; i -= n6) {
                            n6 = this.readInt();
                            n24 = this.readShort();
                            n23 = this.readShort();
                            n5 = n6 - 8;
                            this.readFully(this.byteBuffer_, 0, n5);
                            n7 += n6;
                            String string3 = Conv.ebcdicByteArrayToString(this.byteBuffer_, 0, n5, this.charBuffer_);
                            switch (n24) {
                                case 14400: {
                                    databaseDescribeCallback.fieldName(n22, string3);
                                    break;
                                }
                                case 14401: {
                                    databaseDescribeCallback.udtName(n22, string3);
                                }
                            }
                            n25 += n6;
                        }
                    }
                    n22 = n9 - n7 + n8;
                    this.skipBytes(n22);
                    continue;
                }
                this.skipBytes(n9 - 6);
                continue;
            }
            if (n10 == 14350 && databaseFetchCallback != null) {
                n8 = (int)this.in_.getLatestBytesReceived() - 6;
                n7 = n8 + 6;
                if (n7 + 20 <= n) {
                    byte[] byArray;
                    int n39 = this.readInt();
                    int n40 = this.readInt();
                    int n41 = this.readShort();
                    int n42 = this.readShort();
                    this.readInt();
                    int n43 = this.readInt();
                    databaseFetchCallback.newResultData(n40, n41, n43);
                    n7 += 20;
                    if (n42 == 0) {
                        this.tempIndicator_[0] = 0;
                        this.tempIndicator_[1] = 0;
                        byArray = this.tempIndicator_;
                    } else {
                        byArray = n42 == 2 ? this.tempIndicator_ : new byte[n42];
                    }
                    for (int i = 0; i < n40; ++i) {
                        for (int j = 0; j < n41; ++j) {
                            if (n42 > 0) {
                                this.readFullyReturnCount(byArray);
                                n7 += n42;
                            }
                            databaseFetchCallback.newIndicator(i, j, byArray);
                        }
                    }
                    byte[] byArray2 = databaseFetchCallback.getTempDataBuffer(n43);
                    byte[] byArray3 = byArray2 != null && byArray2.length >= n43 ? byArray2 : new byte[n43];
                    int n44 = n9 + n8;
                    for (int i = 0; i < n40 && n7 < n44; n7 += n43, ++i) {
                        this.readFully(byArray3, 0, n43);
                        databaseFetchCallback.newRowData(i, byArray3);
                    }
                }
                int n45 = n9 - (n7 - n8);
                this.skipBytes(n45);
                continue;
            }
            if (n10 == 14347 && databasePackageCallback != null) {
                String string4;
                int n46;
                n7 = n8 = (int)this.in_.getLatestBytesReceived() - 6;
                n7 += 6;
                int n47 = this.readInt();
                int n48 = this.readShort();
                byte[] byArray = new byte[18];
                this.readFullyReturnCount(byArray);
                String string5 = Conv.ebcdicByteArrayToString(byArray, this.charBuffer_);
                int n49 = this.readShort();
                int n50 = 26;
                n7 += 26;
                this.skipBytes(16);
                n7 += 16;
                databasePackageCallback.newPackageInfo(n48, string5, n49);
                int n51 = 48;
                int[] nArray = new int[n49];
                int[] nArray4 = new int[n49];
                int[] nArray5 = new int[n49];
                int[] nArray6 = new int[n49];
                int[] nArray7 = new int[n49];
                int[] nArray8 = new int[n49];
                for (n46 = 0; n46 < n49; ++n46) {
                    n6 = this.readByte();
                    int n52 = this.readShort();
                    this.readFullyReturnCount(byArray);
                    string4 = Conv.ebcdicByteArrayToString(byArray, this.charBuffer_);
                    databasePackageCallback.newStatementInfo(n46, n6, n52, string4);
                    this.skipBytes(19);
                    n7 += 40;
                    n5 = this.readInt();
                    int n53 = this.readInt();
                    nArray5[n46] = n5;
                    nArray6[n46] = n53;
                    n4 = this.readInt();
                    n3 = this.readInt();
                    nArray[n46] = n4;
                    nArray4[n46] = n3;
                    n2 = this.readInt();
                    int n54 = this.readInt();
                    nArray7[n46] = n2;
                    nArray8[n46] = n54;
                    n7 += 24;
                    n51 += 64;
                }
                for (n46 = 0; n46 < n49; ++n46) {
                    byte[] byArray4;
                    if (nArray4[n46] > 0) {
                        n6 = nArray[n46] - n51;
                        this.skipBytes(n6);
                        n7 += n6;
                        n51 += n6;
                        byArray4 = new byte[nArray4[n46]];
                        this.readFullyReturnCount(byArray4);
                        n7 += nArray4[n46];
                        n51 += nArray4[n46];
                        string4 = Conv.unicodeByteArrayToString(byArray4, 0, byArray4.length);
                        databasePackageCallback.statementText(n46, string4);
                    }
                    if (nArray6[n46] > 0) {
                        n6 = nArray5[n46] - n51;
                        this.skipBytes(n6);
                        n7 += n6;
                        n51 += n6;
                        byArray4 = new byte[nArray6[n46]];
                        this.readFullyReturnCount(byArray4);
                        n51 += nArray6[n46];
                        n7 += nArray6[n46];
                        databasePackageCallback.statementDataFormat(n46, byArray4);
                    }
                    if (nArray8[n46] <= 0) continue;
                    n6 = nArray7[n46] - n51;
                    this.skipBytes(n6);
                    n7 += n6;
                    n51 += n6;
                    byArray4 = new byte[nArray8[n46]];
                    this.readFullyReturnCount(byArray4);
                    n7 += nArray8[n46];
                    n51 += nArray8[n46];
                    databasePackageCallback.statementParameterMarkerFormat(n46, byArray4);
                }
                n46 = n9 - n7 + n8;
                this.skipBytes(n46);
                continue;
            }
            if (n10 == 14343 && this.sqlcaCallback_ != null) {
                this.readFully(this.byteBuffer_, 0, n9 - 6);
                this.parseSQLCA();
                continue;
            }
            if (n10 == 14355 && databaseParameterMarkerCallback != null) {
                n7 = n8 = (int)this.in_.getLatestBytesReceived() - 6;
                n7 += 6;
                if (n8 + 6 + 16 <= n && n9 > 6) {
                    int n55;
                    int n56 = this.readInt();
                    int n57 = this.readInt();
                    this.readInt();
                    int n58 = this.readInt();
                    databaseParameterMarkerCallback.parameterMarkerDescription(n57, n58);
                    n7 += 16;
                    int[] nArray = new int[n57];
                    int[] nArray9 = new int[n57];
                    int n59 = 48 * n57;
                    for (n55 = 0; n55 < n57; ++n55) {
                        int n60 = this.readShort();
                        int n61 = this.readShort();
                        int n62 = this.readInt();
                        int n63 = this.readShort();
                        int n64 = this.readShort();
                        int n65 = this.readShort();
                        int n66 = this.readByte();
                        n6 = this.readShort();
                        int n67 = this.readInt();
                        this.readInt();
                        this.readByte();
                        int n68 = this.readInt();
                        this.readShort();
                        n5 = this.readInt();
                        int n69 = this.readInt();
                        this.readInt();
                        this.readInt();
                        n7 += 48;
                        databaseParameterMarkerCallback.parameterMarkerFieldDescription(n55, n61, n62, n63, n64, n65, n66, n6, n67, n68);
                        nArray[n55] = 48 * n55 + n5 - n59;
                        nArray9[n55] = n69;
                    }
                    n55 = 0;
                    for (int i = 0; i < n57; ++i) {
                        int n70 = nArray[i] - n55;
                        this.skipBytes(n70);
                        n7 += n70;
                        int n71 = this.readInt();
                        int n72 = this.readShort();
                        int n73 = this.readShort();
                        int n74 = nArray9[i] - 8;
                        this.readFully(this.byteBuffer_, 0, n74);
                        String string6 = Conv.ebcdicByteArrayToString(this.byteBuffer_, 0, n74, this.charBuffer_);
                        if (n72 == 14400) {
                            databaseParameterMarkerCallback.parameterMarkerFieldName(i, string6);
                        } else if (n72 == 14401) {
                            databaseParameterMarkerCallback.parameterMarkerUDTName(i, string6);
                        }
                        n55 += nArray9[i];
                        n7 += nArray9[i];
                    }
                } else {
                    databaseParameterMarkerCallback.parameterMarkerDescription(0, 0);
                }
                int n75 = n9 - n7 + n8;
                this.skipBytes(n75);
                continue;
            }
            if (n10 == 14352 && databaseLOBDataCallback != null) {
                n8 = this.readShort();
                n7 = 0;
                if (n8 == 0) {
                    databaseLOBDataCallback.newLOBLength(0L);
                    n7 = 2;
                } else if (n8 == 4) {
                    int n76 = this.readInt();
                    databaseLOBDataCallback.newLOBLength(n76);
                    n7 = 6;
                } else {
                    this.readShort();
                    int n77 = this.readInt();
                    int n78 = this.readInt();
                    long l = (long)n77 << 32 | (long)n78;
                    databaseLOBDataCallback.newLOBLength(l);
                    n7 = 12;
                }
                int n79 = n7;
                this.skipBytes(n9 - 6 - n7);
                continue;
            }
            if (n10 == 14351 && databaseLOBDataCallback != null) {
                n8 = (int)this.in_.getLatestBytesReceived() - 6;
                n7 = n8 + 6;
                if (this.in_.getLatestBytesReceived() + 6L <= (long)n && n9 > 6) {
                    int n80;
                    int n81 = this.readShort();
                    int n82 = this.readInt();
                    databaseLOBDataCallback.newLOBData(n81, n82);
                    byte[] byArray = databaseLOBDataCallback.getLOBBuffer();
                    if (byArray == null || byArray.length == 0) {
                        int n83 = 65535 > n82 ? n82 : 65535;
                        byArray = new byte[n83];
                        databaseLOBDataCallback.setLOBBuffer(byArray);
                    }
                    int n84 = byArray.length > (n80 = n82) ? n80 : byArray.length;
                    this.readFully(byArray, 0, n84);
                    n7 += n84;
                    databaseLOBDataCallback.newLOBSegment(byArray, 0, n84);
                    n80 -= n84;
                    while (n80 > 0) {
                        n84 = byArray.length > n80 ? n80 : byArray.length;
                        this.readFully(byArray, 0, n84);
                        n7 += n84;
                        databaseLOBDataCallback.newLOBSegment(byArray, 0, n84);
                        n80 -= n84;
                    }
                }
                int n85 = n9 - n7 + n8;
                this.skipBytes(n85);
                continue;
            }
            this.skipBytes(n9 - 6);
        }
        this.in_.end();
    }

    private void parseSQLCA() {
        int n = Conv.byteArrayToInt(this.byteBuffer_, 12);
        int n2 = Conv.byteArrayToInt(this.byteBuffer_, 104);
        String string = Conv.ebcdicByteArrayToString(this.byteBuffer_, 131, 5, this.charBuffer_);
        String string2 = Conv.packedDecimalToString(this.byteBuffer_, 72, 30, 0, this.charBuffer_);
        int n3 = Conv.byteArrayToInt(this.byteBuffer_, 100);
        this.sqlcaCallback_.newSQLCommunicationsAreaData(n, string, string2, n2, n3);
    }

    public void fetch(DatabaseFetchAttributes databaseFetchAttributes, DatabaseFetchCallback databaseFetchCallback) throws IOException {
        this.sendFetchRequest(databaseFetchAttributes);
        this.out_.flush();
        this.parseReply("fetch", null, databaseFetchCallback);
    }

    public void streamFetch(DatabaseStreamFetchAttributes databaseStreamFetchAttributes, DatabaseFetchCallback databaseFetchCallback) throws IOException {
        this.sendStreamFetchRequest(databaseStreamFetchAttributes);
        this.out_.flush();
        this.parseReply("streamFetch", null, databaseFetchCallback);
    }

    public void endStreamFetch(DatabaseEndStreamFetchAttributes databaseEndStreamFetchAttributes) throws IOException {
        this.sendEndStreamFetchRequest(databaseEndStreamFetchAttributes);
        this.out_.flush();
        this.readFullReply("endStreamFetch");
    }

    public void executeImmediate(DatabaseExecuteImmediateAttributes databaseExecuteImmediateAttributes) throws IOException {
        this.sendExecuteImmediateRequest(databaseExecuteImmediateAttributes);
        this.out_.flush();
        if (this.sqlcaCallback_ != null) {
            this.parseReply("executeImmediate", null, null, null, null, null);
        } else {
            this.readFullReply("executeImmediate");
        }
    }

    public void execute(DatabaseExecuteAttributes databaseExecuteAttributes) throws IOException {
        this.execute(databaseExecuteAttributes, 0);
    }

    public void execute(DatabaseExecuteAttributes databaseExecuteAttributes, int n) throws IOException {
        this.sendExecuteRequest(databaseExecuteAttributes, n);
        this.out_.flush();
        if (this.sqlcaCallback_ != null) {
            this.parseReply("execute", null, null, null, null, null);
        } else {
            this.readFullReply("execute");
        }
    }

    public void executeOrOpenAndDescribe(DatabaseExecuteOrOpenAndDescribeAttributes databaseExecuteOrOpenAndDescribeAttributes, DatabaseDescribeCallback databaseDescribeCallback) throws IOException {
        this.sendExecuteOrOpenAndDescribeRequest(databaseExecuteOrOpenAndDescribeAttributes);
        this.out_.flush();
        this.parseReply("executeOrOpenAndDescribe", databaseDescribeCallback, null);
    }

    private int getScrollableCursorFlagLength(AttributeScrollableCursorFlag attributeScrollableCursorFlag) {
        return 8;
    }

    private void writeScrollableCursorFlag(AttributeScrollableCursorFlag attributeScrollableCursorFlag) throws IOException {
        this.out_.writeInt(8);
        this.out_.writeShort(14349);
        this.out_.writeShort(attributeScrollableCursorFlag.getScrollableCursorFlag());
    }

    private void sendExecuteImmediateRequest(DatabaseExecuteImmediateAttributes databaseExecuteImmediateAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseExecuteImmediateAttributes != null) {
            if (databaseExecuteImmediateAttributes.isSQLStatementTextSet()) {
                ++n2;
                n += this.getSQLStatementTextLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isCursorNameSet()) {
                ++n2;
                n += this.getCursorNameLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isSQLStatementTypeSet()) {
                ++n2;
                n += this.getSQLStatementTypeLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isOpenAttributesSet()) {
                ++n2;
                n += this.getOpenAttributesLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isDescribeOptionSet()) {
                ++n2;
                n += this.getDescribeOptionLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isBlockingFactorSet()) {
                ++n2;
                n += this.getBlockingFactorLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isScrollableCursorFlagSet()) {
                ++n2;
                n += this.getScrollableCursorFlagLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isSQLParameterMarkerDataSet()) {
                ++n2;
                n += this.getSQLParameterMarkerDataLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isSQLExtendedParameterMarkerDataSet()) {
                ++n2;
                n += this.getSQLExtendedParameterMarkerDataLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                ++n2;
                n += this.getSQLParameterMarkerBlockIndicatorLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isTranslateIndicatorSet()) {
                ++n2;
                n += this.getTranslateIndicatorLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isRLECompressedFunctionParametersSet()) {
                ++n2;
                n += this.getRLECompressedFunctionParametersLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isExtendedSQLStatementTextSet()) {
                ++n2;
                n += this.getExtendedSQLStatementTextLength(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isPrepareOptionSet()) {
                ++n2;
                n += this.getPrepareOptionLength(databaseExecuteImmediateAttributes);
            }
        }
        this.writeHeader(n, 6150);
        this.writeTemplate(n2);
        if (databaseExecuteImmediateAttributes != null) {
            if (databaseExecuteImmediateAttributes.isSQLStatementTextSet()) {
                this.writeSQLStatementText(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isCursorNameSet()) {
                this.writeCursorName(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isSQLStatementTypeSet()) {
                this.writeSQLStatementType(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isOpenAttributesSet()) {
                this.writeOpenAttributes(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isDescribeOptionSet()) {
                this.writeDescribeOption(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isBlockingFactorSet()) {
                this.writeBlockingFactor(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isScrollableCursorFlagSet()) {
                this.writeScrollableCursorFlag(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isSQLParameterMarkerDataSet()) {
                this.writeSQLParameterMarkerData(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isSQLExtendedParameterMarkerDataSet()) {
                this.writeSQLExtendedParameterMarkerData(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                this.writeSQLParameterMarkerBlockIndicator(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isExtendedSQLStatementTextSet()) {
                this.writeExtendedSQLStatementText(databaseExecuteImmediateAttributes);
            }
            if (databaseExecuteImmediateAttributes.isPrepareOptionSet()) {
                this.writePrepareOption(databaseExecuteImmediateAttributes);
            }
        }
    }

    private void sendExecuteRequest(DatabaseExecuteAttributes databaseExecuteAttributes, int n) throws IOException {
        int n2 = 40;
        int n3 = 0;
        if (databaseExecuteAttributes != null) {
            if (databaseExecuteAttributes.isPrepareStatementNameSet()) {
                ++n3;
                n2 += this.getPrepareStatementNameLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isCursorNameSet()) {
                ++n3;
                n2 += this.getCursorNameLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isSQLParameterMarkerDataSet()) {
                ++n3;
                n2 += this.getSQLParameterMarkerDataLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isSQLExtendedParameterMarkerDataSet()) {
                ++n3;
                n2 += this.getSQLExtendedParameterMarkerDataLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                ++n3;
                n2 += this.getSQLParameterMarkerBlockIndicatorLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isPackageNameSet()) {
                ++n3;
                n2 += this.getPackageNameLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isPackageLibrarySet()) {
                ++n3;
                n2 += this.getPackageLibraryLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isTranslateIndicatorSet()) {
                ++n3;
                n2 += this.getTranslateIndicatorLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isRLECompressedFunctionParametersSet()) {
                ++n3;
                n2 += this.getRLECompressedFunctionParametersLength(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isSQLStatementTypeSet()) {
                ++n3;
                n2 += this.getSQLStatementTypeLength(databaseExecuteAttributes);
            }
        }
        this.writeHeader(n2, 6149);
        int n4 = -2113929216;
        this.writeTemplate(n3, n4, n);
        if (databaseExecuteAttributes != null) {
            if (databaseExecuteAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isCursorNameSet()) {
                this.writeCursorName(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isSQLParameterMarkerDataSet()) {
                this.writeSQLParameterMarkerData(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isSQLExtendedParameterMarkerDataSet()) {
                this.writeSQLExtendedParameterMarkerData(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                this.writeSQLParameterMarkerBlockIndicator(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isPackageNameSet()) {
                this.writePackageName(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseExecuteAttributes);
            }
            if (databaseExecuteAttributes.isSQLStatementTypeSet()) {
                this.writeSQLStatementType(databaseExecuteAttributes);
            }
        }
    }

    public void closeCursor(DatabaseCloseCursorAttributes databaseCloseCursorAttributes) throws IOException {
        this.sendCloseCursorRequest(databaseCloseCursorAttributes, true);
        this.out_.flush();
        this.readFullReply("closeCursor");
    }

    public void commit() throws IOException {
        this.sendCommitRequest(this.out_);
        this.out_.flush();
        this.readFullReply("commit");
    }

    public void rollback() throws IOException {
        this.sendRollbackRequest(this.out_);
        this.out_.flush();
        this.readFullReply("rollback");
    }

    public void setServerAttributes(DatabaseServerAttributes databaseServerAttributes) throws IOException {
        this.sendSetServerAttributesRequest(this.out_, databaseServerAttributes);
        this.out_.flush();
        int n = this.readReplyHeader("setServerAttributes");
        int n2 = 40;
        if (n > 46) {
            int n3 = this.readInt();
            int n4 = this.readShort();
            if (n4 != 14340) {
                throw DataStreamException.badReply("setServerAttributes-reply", n4);
            }
            if (n3 < 122) {
                throw DataStreamException.badLength("setServerAttributes-reply", n3);
            }
            int n5 = this.readShort();
            int n6 = this.readShort();
            databaseServerAttributes.setDateFormatParserOption(n6);
            int n7 = this.readShort();
            databaseServerAttributes.setDateSeparatorParserOption(n7);
            int n8 = this.readShort();
            databaseServerAttributes.setTimeFormatParserOption(n8);
            int n9 = this.readShort();
            databaseServerAttributes.setTimeSeparatorParserOption(n9);
            int n10 = this.readShort();
            databaseServerAttributes.setDecimalSeparatorParserOption(n10);
            int n11 = this.readShort();
            databaseServerAttributes.setNamingConventionParserOption(n11);
            int n12 = this.readShort();
            databaseServerAttributes.setIgnoreDecimalDataErrorParserOption(n12);
            int n13 = this.readShort();
            databaseServerAttributes.setCommitmentControlLevelParserOption(n13);
            int n14 = this.readShort();
            databaseServerAttributes.setDRDAPackageSize(n14);
            int n15 = this.readByte();
            databaseServerAttributes.setTranslateIndicator(n15);
            int n16 = this.readShort();
            databaseServerAttributes.setServerCCSID(n16);
            int n17 = this.readShort();
            databaseServerAttributes.setNLSSIdentifier(n17);
            byte[] byArray = new byte[32];
            char[] cArray = new char[32];
            this.readFully(byArray, 0, 3);
            String string = Conv.ebcdicByteArrayToString(byArray, 0, 3, cArray);
            databaseServerAttributes.setNLSSIdentifierLanguageID(string);
            this.readFully(byArray, 0, 10);
            String string2 = Conv.ebcdicByteArrayToString(byArray, 0, 10, cArray);
            databaseServerAttributes.setNLSSIdentifierLanguageTableName(string2);
            this.readFully(byArray, 0, 10);
            String string3 = Conv.ebcdicByteArrayToString(byArray, 0, 10, cArray);
            databaseServerAttributes.setNLSSIdentifierLanguageTableLibrary(string3);
            this.readFully(byArray, 0, 4);
            String string4 = Conv.ebcdicByteArrayToString(byArray, 0, 4, cArray);
            databaseServerAttributes.setLanguageFeatureCode(string4);
            this.readFully(byArray, 0, 10);
            String string5 = Conv.ebcdicByteArrayToString(byArray, 0, 10, cArray);
            databaseServerAttributes.setServerFunctionalLevel(string5);
            this.readFully(byArray, 0, 18);
            String string6 = Conv.ebcdicByteArrayToString(byArray, 0, 18, cArray);
            databaseServerAttributes.setRDBName(string6);
            this.readFully(byArray, 0, 10);
            String string7 = Conv.ebcdicByteArrayToString(byArray, 0, 10, cArray);
            databaseServerAttributes.setDefaultSQLLibraryName(string7);
            this.readFully(byArray, 0, 26);
            String string8 = Conv.ebcdicByteArrayToString(byArray, 0, 10, cArray);
            String string9 = Conv.ebcdicByteArrayToString(byArray, 10, 10, cArray);
            String string10 = Conv.ebcdicByteArrayToString(byArray, 20, 6, cArray);
            databaseServerAttributes.setServerJob(string8, string9, string10);
            this.skipBytes(n3 - 122);
            n2 += n3;
        }
        this.skipBytes(n - n2);
        this.in_.end();
    }

    public void retrieveLOBData(DatabaseRetrieveLOBDataAttributes databaseRetrieveLOBDataAttributes, DatabaseLOBDataCallback databaseLOBDataCallback) throws IOException {
        this.sendRetrieveLOBDataRequest(this.out_, databaseRetrieveLOBDataAttributes, this.currentRPB_);
        this.out_.flush();
        this.parseReply("retrieveLOBData", null, null, null, null, databaseLOBDataCallback);
    }

    private void sendDeleteSQLRPBRequest(DatabaseDeleteRequestParameterBlockAttributes databaseDeleteRequestParameterBlockAttributes, int n) throws IOException {
        int n2 = 40;
        int n3 = 0;
        if (databaseDeleteRequestParameterBlockAttributes != null) {
            if (databaseDeleteRequestParameterBlockAttributes.isTranslateIndicatorSet()) {
                n2 += this.getTranslateIndicatorLength(databaseDeleteRequestParameterBlockAttributes);
                ++n3;
            }
            if (databaseDeleteRequestParameterBlockAttributes.isRLECompressedFunctionParametersSet()) {
                n2 += this.getRLECompressedFunctionParametersLength(databaseDeleteRequestParameterBlockAttributes);
                ++n3;
            }
        }
        this.writeHeader(n2, 7426);
        int n4 = Integer.MIN_VALUE;
        this.writeTemplate(n3, n4, 0, n);
        if (databaseDeleteRequestParameterBlockAttributes != null) {
            if (databaseDeleteRequestParameterBlockAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseDeleteRequestParameterBlockAttributes);
            }
            if (databaseDeleteRequestParameterBlockAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseDeleteRequestParameterBlockAttributes);
            }
        }
    }

    private int getCursorNameLength(AttributeCursorName attributeCursorName) {
        return 10 + attributeCursorName.getCursorName().length();
    }

    private void writeCursorName(AttributeCursorName attributeCursorName) throws IOException {
        String string = attributeCursorName.getCursorName();
        this.out_.writeInt(10 + string.length());
        this.out_.writeShort(14347);
        this.out_.writeShort(37);
        this.out_.writeShort(string.length());
        DatabaseConnection.writePadEBCDIC(string, string.length(), this.out_);
    }

    private int getReuseIndicatorLength(AttributeReuseIndicator attributeReuseIndicator) {
        return 7;
    }

    private void writeReuseIndicator(AttributeReuseIndicator attributeReuseIndicator) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14352);
        this.out_.write(attributeReuseIndicator.getReuseIndicator());
    }

    private void sendCloseCursorRequest(DatabaseCloseCursorAttributes databaseCloseCursorAttributes, boolean bl) throws IOException {
        int n = 40;
        int n2 = 0;
        if (databaseCloseCursorAttributes != null) {
            if (databaseCloseCursorAttributes.isCursorNameSet()) {
                n += this.getCursorNameLength(databaseCloseCursorAttributes);
                ++n2;
            }
            if (databaseCloseCursorAttributes.isReuseIndicatorSet()) {
                n += this.getReuseIndicatorLength(databaseCloseCursorAttributes);
                ++n2;
            }
            if (databaseCloseCursorAttributes.isTranslateIndicatorSet()) {
                n += this.getTranslateIndicatorLength(databaseCloseCursorAttributes);
                ++n2;
            }
            if (databaseCloseCursorAttributes.isRLECompressedFunctionParametersSet()) {
                n += this.getRLECompressedFunctionParametersLength(databaseCloseCursorAttributes);
                ++n2;
            }
        }
        this.writeHeader(n, 6154);
        this.out_.writeInt(bl ? Integer.MIN_VALUE : 0);
        this.out_.writeInt(0);
        this.out_.writeShort(1);
        this.out_.writeShort(1);
        this.out_.writeShort(0);
        this.out_.writeShort(this.currentRPB_);
        this.out_.writeShort(0);
        this.out_.writeShort(n2);
        if (databaseCloseCursorAttributes != null) {
            if (databaseCloseCursorAttributes.isCursorNameSet()) {
                this.writeCursorName(databaseCloseCursorAttributes);
            }
            if (databaseCloseCursorAttributes.isReuseIndicatorSet()) {
                this.writeReuseIndicator(databaseCloseCursorAttributes);
            }
            if (databaseCloseCursorAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseCloseCursorAttributes);
            }
            if (databaseCloseCursorAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseCloseCursorAttributes);
            }
        }
    }

    private int getDescribeOptionLength(AttributeDescribeOption attributeDescribeOption) {
        return 7;
    }

    private void writeDescribeOption(AttributeDescribeOption attributeDescribeOption) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14346);
        this.out_.writeByte(attributeDescribeOption.getDescribeOption());
    }

    private int getBlockingFactorLength(AttributeBlockingFactor attributeBlockingFactor) {
        return 10;
    }

    private void writeBlockingFactor(AttributeBlockingFactor attributeBlockingFactor) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14348);
        this.out_.writeInt((int)attributeBlockingFactor.getBlockingFactor());
    }

    private int getFetchScrollOptionLength(AttributeFetchScrollOption attributeFetchScrollOption) {
        int n = attributeFetchScrollOption.getFetchScrollOption();
        return n == 7 || n == 8 ? 12 : 8;
    }

    private void writeFetchScrollOption(AttributeFetchScrollOption attributeFetchScrollOption) throws IOException {
        int n = attributeFetchScrollOption.getFetchScrollOption();
        boolean bl = n == 7 || n == 8;
        this.out_.writeInt(bl ? 12 : 8);
        this.out_.writeShort(14350);
        this.out_.writeShort(n);
        if (bl) {
            this.out_.writeInt(attributeFetchScrollOption.getFetchScrollOptionRelativeValue());
        }
    }

    private int getFetchBufferSizeLength(AttributeFetchBufferSize attributeFetchBufferSize) {
        return 10;
    }

    private void writeFetchBufferSize(AttributeFetchBufferSize attributeFetchBufferSize) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14388);
        this.out_.writeInt((int)attributeFetchBufferSize.getFetchBufferSize());
    }

    private int getHoldIndicatorLength(AttributeHoldIndicator attributeHoldIndicator) {
        return 7;
    }

    private void writeHoldIndicator(AttributeHoldIndicator attributeHoldIndicator) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14351);
        this.out_.writeByte(attributeHoldIndicator.getHoldIndicator());
    }

    private int getQueryTimeoutLimitLength(AttributeQueryTimeoutLimit attributeQueryTimeoutLimit) {
        return 10;
    }

    private void writeQueryTimeoutLimit(AttributeQueryTimeoutLimit attributeQueryTimeoutLimit) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14359);
        this.out_.writeInt(attributeQueryTimeoutLimit.getQueryTimeoutLimit());
    }

    private int getServerSideStaticCursorResultSetSizeLength(AttributeServerSideStaticCursorResultSetSize attributeServerSideStaticCursorResultSetSize) {
        return 10;
    }

    private void writeServerSideStaticCursorResultSetSize(AttributeServerSideStaticCursorResultSetSize attributeServerSideStaticCursorResultSetSize) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14375);
        this.out_.writeInt(attributeServerSideStaticCursorResultSetSize.getServerSideStaticCursorResultSetSize());
    }

    private int getResultSetHoldabilityOptionLength(AttributeResultSetHoldabilityOption attributeResultSetHoldabilityOption) {
        return 7;
    }

    private void writeResultSetHoldabilityOption(AttributeResultSetHoldabilityOption attributeResultSetHoldabilityOption) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14384);
        this.out_.writeByte(attributeResultSetHoldabilityOption.getResultSetHoldabilityOption());
    }

    private int getVariableFieldCompressionLength(AttributeVariableFieldCompression attributeVariableFieldCompression) {
        return 7;
    }

    private void writeVariableFieldCompression(AttributeVariableFieldCompression attributeVariableFieldCompression) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14387);
        this.out_.writeByte(attributeVariableFieldCompression.getVariableFieldCompression());
    }

    private int getReturnOptimisticLockingColumnsLength(AttributeReturnOptimisticLockingColumns attributeReturnOptimisticLockingColumns) {
        return 7;
    }

    private void writeReturnOptimisticLockingColumns(AttributeReturnOptimisticLockingColumns attributeReturnOptimisticLockingColumns) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14389);
        this.out_.writeByte(attributeReturnOptimisticLockingColumns.getReturnOptimisticLockingColumns());
    }

    private void sendCreateSQLRPBRequest(DatabaseCreateRequestParameterBlockAttributes databaseCreateRequestParameterBlockAttributes, boolean bl, int n) throws IOException {
        this.sendSQLRPBRequest(databaseCreateRequestParameterBlockAttributes, bl, n, 7424);
    }

    private void sendResetSQLRPBRequest(DatabaseCreateRequestParameterBlockAttributes databaseCreateRequestParameterBlockAttributes, boolean bl, int n) throws IOException {
        this.sendSQLRPBRequest(databaseCreateRequestParameterBlockAttributes, bl, n, 7428);
    }

    private void sendSQLRPBRequest(DatabaseCreateRequestParameterBlockAttributes databaseCreateRequestParameterBlockAttributes, boolean bl, int n, int n2) throws IOException {
        int n3 = 40;
        int n4 = 0;
        if (databaseCreateRequestParameterBlockAttributes != null) {
            if (databaseCreateRequestParameterBlockAttributes.isPackageLibrarySet()) {
                ++n4;
                n3 += this.getPackageLibraryLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isPackageNameSet()) {
                ++n4;
                n3 += this.getPackageNameLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isTranslateIndicatorSet()) {
                ++n4;
                n3 += this.getTranslateIndicatorLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isPrepareStatementNameSet()) {
                ++n4;
                n3 += this.getPrepareStatementNameLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isSQLStatementTextSet()) {
                ++n4;
                n3 += this.getSQLStatementTextLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isPrepareOptionSet()) {
                ++n4;
                n3 += this.getPrepareOptionLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isOpenAttributesSet()) {
                ++n4;
                n3 += this.getOpenAttributesLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isDescribeOptionSet()) {
                ++n4;
                n3 += this.getDescribeOptionLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isCursorNameSet()) {
                ++n4;
                n3 += this.getCursorNameLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isVariableFieldCompressionSet()) {
                ++n4;
                n3 += this.getVariableFieldCompressionLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isBlockingFactorSet()) {
                ++n4;
                n3 += this.getBlockingFactorLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isScrollableCursorFlagSet()) {
                ++n4;
                n3 += this.getScrollableCursorFlagLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isFetchScrollOptionSet()) {
                ++n4;
                n3 += this.getFetchScrollOptionLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isHoldIndicatorSet()) {
                ++n4;
                n3 += this.getHoldIndicatorLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isReuseIndicatorSet()) {
                ++n4;
                n3 += this.getReuseIndicatorLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isSQLStatementTypeSet()) {
                ++n4;
                n3 += this.getSQLStatementTypeLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                ++n4;
                n3 += this.getSQLParameterMarkerBlockIndicatorLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isQueryTimeoutLimitSet()) {
                ++n4;
                n3 += this.getQueryTimeoutLimitLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isServerSideStaticCursorResultSetSizeSet()) {
                ++n4;
                n3 += this.getServerSideStaticCursorResultSetSizeLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isRLECompressedFunctionParametersSet()) {
                ++n4;
                n3 += this.getRLECompressedFunctionParametersLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isExtendedColumnDescriptorOptionSet()) {
                ++n4;
                n3 += this.getExtendedColumnDescriptorOptionLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isResultSetHoldabilityOptionSet()) {
                ++n4;
                n3 += this.getResultSetHoldabilityOptionLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isExtendedSQLStatementTextSet()) {
                ++n4;
                n3 += this.getExtendedSQLStatementTextLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isFetchBufferSizeSet()) {
                ++n4;
                n3 += this.getFetchBufferSizeLength(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isReturnOptimisticLockingColumnsSet()) {
                ++n4;
                n3 += this.getReturnOptimisticLockingColumnsLength(databaseCreateRequestParameterBlockAttributes);
            }
        }
        this.writeHeader(n3, n2);
        this.writeTemplate(n4, bl ? Integer.MIN_VALUE : 0, 0, n);
        if (databaseCreateRequestParameterBlockAttributes != null) {
            if (databaseCreateRequestParameterBlockAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isPackageNameSet()) {
                this.writePackageName(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isSQLStatementTextSet()) {
                this.writeSQLStatementText(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isPrepareOptionSet()) {
                this.writePrepareOption(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isOpenAttributesSet()) {
                this.writeOpenAttributes(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isDescribeOptionSet()) {
                this.writeDescribeOption(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isCursorNameSet()) {
                this.writeCursorName(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isVariableFieldCompressionSet()) {
                this.writeVariableFieldCompression(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isBlockingFactorSet()) {
                this.writeBlockingFactor(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isScrollableCursorFlagSet()) {
                this.writeScrollableCursorFlag(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isFetchScrollOptionSet()) {
                this.writeFetchScrollOption(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isHoldIndicatorSet()) {
                this.writeHoldIndicator(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isReuseIndicatorSet()) {
                this.writeReuseIndicator(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isSQLStatementTypeSet()) {
                this.writeSQLStatementType(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isSQLParameterMarkerBlockIndicatorSet()) {
                this.writeSQLParameterMarkerBlockIndicator(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isQueryTimeoutLimitSet()) {
                this.writeQueryTimeoutLimit(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isServerSideStaticCursorResultSetSizeSet()) {
                this.writeServerSideStaticCursorResultSetSize(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isExtendedColumnDescriptorOptionSet()) {
                this.writeExtendedColumnDescriptorOption(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isResultSetHoldabilityOptionSet()) {
                this.writeResultSetHoldabilityOption(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isExtendedSQLStatementTextSet()) {
                this.writeExtendedSQLStatementText(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isFetchBufferSizeSet()) {
                this.writeFetchBufferSize(databaseCreateRequestParameterBlockAttributes);
            }
            if (databaseCreateRequestParameterBlockAttributes.isReturnOptimisticLockingColumnsSet()) {
                this.writeReturnOptimisticLockingColumns(databaseCreateRequestParameterBlockAttributes);
            }
        }
    }

    private void sendPrepareAndDescribeRequest(DatabasePrepareAndDescribeAttributes databasePrepareAndDescribeAttributes) throws IOException {
        int n = 40;
        int n2 = 0;
        boolean bl = true;
        if (databasePrepareAndDescribeAttributes != null) {
            if (databasePrepareAndDescribeAttributes.isPrepareStatementNameSet()) {
                n += this.getPrepareStatementNameLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isSQLStatementTextSet()) {
                n += this.getSQLStatementTextLength(databasePrepareAndDescribeAttributes);
                ++n2;
                if (databasePrepareAndDescribeAttributes.getSQLStatementText().indexOf("?") < 0) {
                    bl = false;
                }
            }
            if (databasePrepareAndDescribeAttributes.isSQLStatementTypeSet()) {
                n += this.getSQLStatementTypeLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isPrepareOptionSet()) {
                n += this.getPrepareOptionLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isDescribeOptionSet()) {
                n += this.getDescribeOptionLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isOpenAttributesSet()) {
                n += this.getOpenAttributesLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isPackageNameSet()) {
                n += this.getPackageNameLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isPackageLibrarySet()) {
                n += this.getPackageLibraryLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isTranslateIndicatorSet()) {
                n += this.getTranslateIndicatorLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isRLECompressedFunctionParametersSet()) {
                n += this.getRLECompressedFunctionParametersLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isExtendedColumnDescriptorOptionSet()) {
                n += this.getExtendedColumnDescriptorOptionLength(databasePrepareAndDescribeAttributes);
                ++n2;
            }
            if (databasePrepareAndDescribeAttributes.isExtendedSQLStatementTextSet()) {
                n += this.getExtendedSQLStatementTextLength(databasePrepareAndDescribeAttributes);
                ++n2;
                if (databasePrepareAndDescribeAttributes.getExtendedSQLStatementText().indexOf("?") < 0) {
                    bl = false;
                }
            }
        }
        this.writeHeader(n, 6147);
        int n3 = -2013265920;
        if (databasePrepareAndDescribeAttributes == null || !databasePrepareAndDescribeAttributes.isSQLStatementTypeSet() || databasePrepareAndDescribeAttributes.getSQLStatementType() != 3) {
            n3 |= 0x20000;
        }
        if (bl) {
            n3 |= 0x800000;
        }
        this.writeTemplate(n2, n3);
        if (databasePrepareAndDescribeAttributes != null) {
            if (databasePrepareAndDescribeAttributes.isPrepareStatementNameSet()) {
                this.writePrepareStatementName(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isSQLStatementTextSet()) {
                this.writeSQLStatementText(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isSQLStatementTypeSet()) {
                this.writeSQLStatementType(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isPrepareOptionSet()) {
                this.writePrepareOption(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isDescribeOptionSet()) {
                this.writeDescribeOption(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isOpenAttributesSet()) {
                this.writeOpenAttributes(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isPackageLibrarySet()) {
                this.writePackageLibrary(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isPackageNameSet()) {
                this.writePackageName(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isTranslateIndicatorSet()) {
                this.writeTranslateIndicator(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isRLECompressedFunctionParametersSet()) {
                this.writeRLECompressedFunctionParameters(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isExtendedColumnDescriptorOptionSet()) {
                this.writeExtendedColumnDescriptorOption(databasePrepareAndDescribeAttributes);
            }
            if (databasePrepareAndDescribeAttributes.isExtendedSQLStatementTextSet()) {
                this.writeExtendedSQLStatementText(databasePrepareAndDescribeAttributes);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int readReplyHeader(String string) throws IOException {
        int n;
        int n2;
        int n3 = this.in_.readInt();
        if (n3 < 40) {
            throw DataStreamException.badLength(string, n3);
        }
        int n4 = this.in_.readShort();
        int n5 = this.in_.readShort();
        int n6 = this.in_.readInt();
        int n7 = this.in_.readInt();
        int n8 = this.in_.readShort();
        int n9 = this.in_.readShort();
        if (n9 != 10240) {
            this.in_.end();
            throw DataStreamException.badReply(string, n9);
        }
        int n10 = this.in_.readInt();
        int n11 = this.in_.readInt();
        int n12 = this.in_.readShort();
        int n13 = this.in_.readShort();
        int n14 = this.in_.readShort();
        int n15 = this.in_.readShort();
        int n16 = this.in_.readInt();
        if (n15 == 0) {
            if (this.warningCallback_ == null) return n3;
            this.warningCallback_.noWarnings();
            return n3;
        }
        if (n16 >= 0) {
            if (this.warningCallback_ == null) return n3;
            this.warningCallback_.newWarning(n15, n16);
            return n3;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (n = 40; n < n3; n += n2) {
            byte[] byArray;
            int n17;
            n2 = this.in_.readInt();
            int n18 = this.in_.readShort();
            if (n18 == 14337) {
                n17 = this.in_.readShort();
                byte[] byArray2 = new byte[n2 - 8];
                this.in_.readFully(byArray2);
                if (n2 > this.charBuffer_.length) {
                    this.charBuffer_ = new char[n2];
                }
                string2 = Conv.ebcdicByteArrayToString(byArray2, this.charBuffer_);
                continue;
            }
            if (n18 == 14338) {
                n17 = this.in_.readShort();
                int n19 = this.in_.readShort();
                byArray = new byte[n2 - 10];
                this.in_.readFully(byArray);
                if (n2 > this.charBuffer_.length) {
                    this.charBuffer_ = new char[n2];
                }
                string3 = Conv.ebcdicByteArrayToString(byArray, this.charBuffer_);
                continue;
            }
            if (n18 == 14339) {
                n17 = this.in_.readShort();
                int n20 = this.in_.readShort();
                byArray = new byte[n2 - 10];
                this.in_.readFully(byArray);
                if (n2 > this.charBuffer_.length) {
                    this.charBuffer_ = new char[n2];
                }
                string4 = Conv.ebcdicByteArrayToString(byArray, this.charBuffer_);
                continue;
            }
            if (n18 == 14343 && this.sqlcaCallback_ != null) {
                this.in_.readFully(this.byteBuffer_, 0, n2 - 6);
                this.parseSQLCA();
                continue;
            }
            this.skipBytes(n2 - 6);
        }
        this.skipBytes(n3 - n);
        this.in_.end();
        if (string2 == null) throw new DatabaseException(string, n15, n16);
        String string5 = string3 == null ? "" : string3;
        string5 = string5 + (string4 == null ? "" : " " + string4);
        throw new MessageException(new Message[]{new Message(string2, string5)});
    }

    private void writeLOBLocatorHandle(AttributeLOBLocatorHandle attributeLOBLocatorHandle) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14360);
        this.out_.writeInt(attributeLOBLocatorHandle.getLOBLocatorHandle());
    }

    private void writeRequestedSize(AttributeRequestedSize attributeRequestedSize) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14361);
        this.out_.writeInt(attributeRequestedSize.getRequestedSize());
    }

    private void writeStartOffset(AttributeStartOffset attributeStartOffset) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14362);
        this.out_.writeInt(attributeStartOffset.getStartOffset());
    }

    private void writeCompressionIndicator(AttributeCompressionIndicator attributeCompressionIndicator) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14363);
        this.out_.write(attributeCompressionIndicator.getCompressionIndicator());
    }

    private void writeReturnCurrentLengthIndicator(AttributeReturnCurrentLengthIndicator attributeReturnCurrentLengthIndicator) throws IOException {
        this.out_.writeInt(7);
        this.out_.writeShort(14369);
        this.out_.write(attributeReturnCurrentLengthIndicator.getReturnCurrentLengthIndicator());
    }

    private void writeColumnIndex(AttributeColumnIndex attributeColumnIndex) throws IOException {
        this.out_.writeInt(10);
        this.out_.writeShort(14376);
        this.out_.writeInt(attributeColumnIndex.getColumnIndex());
    }

    private void sendRetrieveLOBDataRequest(HostServerConnection.HostOutputStream hostOutputStream, DatabaseRetrieveLOBDataAttributes databaseRetrieveLOBDataAttributes, int n) throws IOException {
        int n2 = 40;
        int n3 = 0;
        if (databaseRetrieveLOBDataAttributes.isLOBLocatorHandleSet()) {
            n2 += 10;
            ++n3;
        }
        if (databaseRetrieveLOBDataAttributes.isRequestedSizeSet()) {
            n2 += 10;
            ++n3;
        }
        if (databaseRetrieveLOBDataAttributes.isStartOffsetSet()) {
            n2 += 10;
            ++n3;
        }
        if (databaseRetrieveLOBDataAttributes.isCompressionIndicatorSet()) {
            n2 += 7;
            ++n3;
        }
        if (databaseRetrieveLOBDataAttributes.isTranslateIndicatorSet()) {
            n2 += 7;
            ++n3;
        }
        if (databaseRetrieveLOBDataAttributes.isReturnCurrentLengthIndicatorSet()) {
            n2 += 7;
            ++n3;
        }
        if (databaseRetrieveLOBDataAttributes.isColumnIndexSet()) {
            n2 += 10;
            ++n3;
        }
        if (databaseRetrieveLOBDataAttributes.isRLECompressedFunctionParametersSet()) {
            ++n3;
            byte[] byArray = databaseRetrieveLOBDataAttributes.getRLECompressedFunctionParameters();
            n2 += 10 + byArray.length;
        }
        this.writeHeader(n2, 6166);
        int n4 = -1946157056;
        this.writeTemplate(n3, n4, 0, n);
        if (databaseRetrieveLOBDataAttributes.isLOBLocatorHandleSet()) {
            this.writeLOBLocatorHandle(databaseRetrieveLOBDataAttributes);
        }
        if (databaseRetrieveLOBDataAttributes.isRequestedSizeSet()) {
            this.writeRequestedSize(databaseRetrieveLOBDataAttributes);
        }
        if (databaseRetrieveLOBDataAttributes.isStartOffsetSet()) {
            this.writeStartOffset(databaseRetrieveLOBDataAttributes);
        }
        if (databaseRetrieveLOBDataAttributes.isCompressionIndicatorSet()) {
            this.writeCompressionIndicator(databaseRetrieveLOBDataAttributes);
        }
        if (databaseRetrieveLOBDataAttributes.isTranslateIndicatorSet()) {
            this.writeTranslateIndicator(databaseRetrieveLOBDataAttributes);
        }
        if (databaseRetrieveLOBDataAttributes.isReturnCurrentLengthIndicatorSet()) {
            this.writeReturnCurrentLengthIndicator(databaseRetrieveLOBDataAttributes);
        }
        if (databaseRetrieveLOBDataAttributes.isColumnIndexSet()) {
            this.writeColumnIndex(databaseRetrieveLOBDataAttributes);
        }
        if (databaseRetrieveLOBDataAttributes.isRLECompressedFunctionParametersSet()) {
            this.writeRLECompressedFunctionParameters(databaseRetrieveLOBDataAttributes);
        }
    }

    private void sendSetServerAttributesRequest(HostServerConnection.HostOutputStream hostOutputStream, DatabaseServerAttributes databaseServerAttributes) throws IOException {
        String string;
        int n;
        int n2 = 40;
        int n3 = 0;
        if (databaseServerAttributes.isDefaultClientCCSIDSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isLanguageFeatureCodeSet()) {
            n2 += 12;
            ++n3;
        }
        if (databaseServerAttributes.isClientFunctionalLevelSet()) {
            n2 += 18;
            ++n3;
        }
        if (databaseServerAttributes.isNLSSIdentifierSet()) {
            ++n3;
            n = databaseServerAttributes.getNLSSIdentifier();
            n2 += 8;
            if (n == 1 || n == 2) {
                n2 += 5;
            } else if (n == 3) {
                n2 += 6;
                String string2 = databaseServerAttributes.getNLSSIdentifierLanguageTableName();
                n2 += string2.length();
                string = databaseServerAttributes.getNLSSIdentifierLanguageTableLibrary();
                n2 += string.length();
            }
        }
        if (databaseServerAttributes.isTranslateIndicatorSet()) {
            n2 += this.getTranslateIndicatorLength(databaseServerAttributes);
            ++n3;
        }
        if (databaseServerAttributes.isDRDAPackageSizeSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isDateFormatParserOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isDateSeparatorParserOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isTimeFormatParserOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isTimeSeparatorParserOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isDecimalSeparatorParserOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isNamingConventionParserOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isIgnoreDecimalDataErrorParserOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isCommitmentControlLevelParserOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isDefaultSQLLibraryNameSet()) {
            ++n3;
            String string3 = databaseServerAttributes.getDefaultSQLLibraryName();
            n2 += 10 + string3.length();
        }
        if (databaseServerAttributes.isASCIICCSIDForTranslationTableSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isAmbiguousSelectOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isPackageAddStatementAllowedSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isUseExtendedFormatsSet()) {
            n2 += 7;
            ++n3;
        }
        if (databaseServerAttributes.isLOBFieldThresholdSet()) {
            n2 += 10;
            ++n3;
        }
        if (databaseServerAttributes.isDataCompressionParameterSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isTrueAutoCommitIndicatorSet()) {
            n2 += 7;
            ++n3;
        }
        if (databaseServerAttributes.isClientSupportInformationSet()) {
            n2 += 10;
            ++n3;
        }
        if (databaseServerAttributes.isRDBNameSet()) {
            ++n3;
            String string4 = databaseServerAttributes.getRDBName();
            n2 += 8 + string4.length();
        }
        if (databaseServerAttributes.isDecimalPrecisionAndScaleAttributesSet()) {
            n2 += 12;
            ++n3;
        }
        if (databaseServerAttributes.isHexadecimalConstantParserOptionSet()) {
            n2 += 7;
            ++n3;
        }
        if (databaseServerAttributes.isInputLocatorTypeSet()) {
            n2 += 7;
            ++n3;
        }
        if (databaseServerAttributes.isLocatorPersistenceSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isEWLMCorrelatorSet()) {
            ++n3;
            byte[] byArray = databaseServerAttributes.getEWLMCorrelator();
            n2 += 6 + byArray.length;
        }
        if (databaseServerAttributes.isRLECompressionSet()) {
            ++n3;
            byte[] byArray = databaseServerAttributes.getRLECompression();
            n2 += 10 + byArray.length;
        }
        if (databaseServerAttributes.isOptimizationGoalIndicatorSet()) {
            n2 += 7;
            ++n3;
        }
        if (databaseServerAttributes.isQueryStorageLimitSet()) {
            n2 += 10;
            ++n3;
        }
        if (databaseServerAttributes.isDecimalFloatingPointRoundingModeOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isDecimalFloatingPointErrorReportingOptionSet()) {
            n2 += 8;
            ++n3;
        }
        if (databaseServerAttributes.isClientAccountingInformationSet()) {
            ++n3;
            String string5 = databaseServerAttributes.getClientAccountingInformation();
            n2 += 10 + string5.length();
        }
        if (databaseServerAttributes.isClientApplicationNameSet()) {
            ++n3;
            String string6 = databaseServerAttributes.getClientApplicationName();
            n2 += 10 + string6.length();
        }
        if (databaseServerAttributes.isClientUserIdentifierSet()) {
            ++n3;
            String string7 = databaseServerAttributes.getClientUserIdentifier();
            n2 += 10 + string7.length();
        }
        if (databaseServerAttributes.isClientWorkstationNameSet()) {
            ++n3;
            String string8 = databaseServerAttributes.getClientWorkstationName();
            n2 += 10 + string8.length();
        }
        if (databaseServerAttributes.isClientProgramIdentifierSet()) {
            ++n3;
            String string9 = databaseServerAttributes.getClientProgramIdentifier();
            n2 += 10 + string9.length();
        }
        if (databaseServerAttributes.isInterfaceTypeSet()) {
            ++n3;
            String string10 = databaseServerAttributes.getInterfaceType();
            n2 += 10 + string10.length();
        }
        if (databaseServerAttributes.isInterfaceNameSet()) {
            ++n3;
            String string11 = databaseServerAttributes.getInterfaceName();
            n2 += 10 + string11.length();
        }
        if (databaseServerAttributes.isInterfaceLevelSet()) {
            ++n3;
            String string12 = databaseServerAttributes.getInterfaceLevel();
            n2 += 10 + string12.length();
        }
        if (databaseServerAttributes.isCloseOnEOFSet()) {
            n2 += 7;
            ++n3;
        }
        this.writeHeader(n2, 8064);
        hostOutputStream.writeInt(-2130706432);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(n3);
        if (databaseServerAttributes.isDefaultClientCCSIDSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14337);
            hostOutputStream.writeShort(databaseServerAttributes.getDefaultClientCCSID());
        }
        if (databaseServerAttributes.isLanguageFeatureCodeSet()) {
            hostOutputStream.writeInt(12);
            hostOutputStream.writeShort(14338);
            hostOutputStream.writeShort(37);
            DatabaseConnection.writePadEBCDIC(databaseServerAttributes.getLanguageFeatureCode(), 4, hostOutputStream);
        }
        if (databaseServerAttributes.isClientFunctionalLevelSet()) {
            hostOutputStream.writeInt(18);
            hostOutputStream.writeShort(14339);
            hostOutputStream.writeShort(37);
            DatabaseConnection.writePadEBCDIC(databaseServerAttributes.getClientFunctionalLevel(), 10, hostOutputStream);
        }
        if (databaseServerAttributes.isNLSSIdentifierSet()) {
            String string13;
            n = databaseServerAttributes.getNLSSIdentifier();
            int n4 = 8;
            if (n == 1 || n == 2) {
                n4 += 5;
            } else if (n == 3) {
                n4 += 6;
                string = databaseServerAttributes.getNLSSIdentifierLanguageTableName();
                n4 += string.length();
                string13 = databaseServerAttributes.getNLSSIdentifierLanguageTableLibrary();
                n4 += string13.length();
            }
            hostOutputStream.writeInt(n4);
            hostOutputStream.writeShort(14340);
            hostOutputStream.writeShort(n);
            if (n == 1 || n == 2) {
                hostOutputStream.writeShort(37);
                DatabaseConnection.writePadEBCDIC(databaseServerAttributes.getNLSSIdentifierLanguageID(), 3, hostOutputStream);
            } else if (n == 3) {
                hostOutputStream.writeShort(37);
                string = databaseServerAttributes.getNLSSIdentifierLanguageTableName();
                hostOutputStream.writeShort(string.length());
                DatabaseConnection.writePadEBCDIC(string, string.length(), hostOutputStream);
                string13 = databaseServerAttributes.getNLSSIdentifierLanguageTableLibrary();
                hostOutputStream.writeShort(string13.length());
                DatabaseConnection.writePadEBCDIC(string13, string13.length(), hostOutputStream);
            }
        }
        if (databaseServerAttributes.isTranslateIndicatorSet()) {
            this.writeTranslateIndicator(databaseServerAttributes);
        }
        if (databaseServerAttributes.isDRDAPackageSizeSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14342);
            hostOutputStream.writeShort(databaseServerAttributes.getDRDAPackageSize());
        }
        if (databaseServerAttributes.isDateFormatParserOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14343);
            hostOutputStream.writeShort(databaseServerAttributes.getDateFormatParserOption());
        }
        if (databaseServerAttributes.isDateSeparatorParserOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14344);
            hostOutputStream.writeShort(databaseServerAttributes.getDateSeparatorParserOption());
        }
        if (databaseServerAttributes.isTimeFormatParserOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14345);
            hostOutputStream.writeShort(databaseServerAttributes.getTimeFormatParserOption());
        }
        if (databaseServerAttributes.isTimeSeparatorParserOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14346);
            hostOutputStream.writeShort(databaseServerAttributes.getTimeSeparatorParserOption());
        }
        if (databaseServerAttributes.isDecimalSeparatorParserOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14347);
            hostOutputStream.writeShort(databaseServerAttributes.getDecimalSeparatorParserOption());
        }
        if (databaseServerAttributes.isNamingConventionParserOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14348);
            hostOutputStream.writeShort(databaseServerAttributes.getNamingConventionParserOption());
        }
        if (databaseServerAttributes.isIgnoreDecimalDataErrorParserOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14349);
            hostOutputStream.writeShort(databaseServerAttributes.getIgnoreDecimalDataErrorParserOption());
        }
        if (databaseServerAttributes.isCommitmentControlLevelParserOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14350);
            hostOutputStream.writeShort(databaseServerAttributes.getCommitmentControlLevelParserOption());
        }
        if (databaseServerAttributes.isDefaultSQLLibraryNameSet()) {
            String string14 = databaseServerAttributes.getDefaultSQLLibraryName();
            hostOutputStream.writeInt(10 + string14.length());
            hostOutputStream.writeShort(14351);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string14.length());
            DatabaseConnection.writePadEBCDIC(string14, string14.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isASCIICCSIDForTranslationTableSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14352);
            hostOutputStream.writeShort(databaseServerAttributes.getASCIICCSIDForTranslationTable());
        }
        if (databaseServerAttributes.isAmbiguousSelectOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14353);
            hostOutputStream.writeShort(databaseServerAttributes.getAmbiguousSelectOption());
        }
        if (databaseServerAttributes.isPackageAddStatementAllowedSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14354);
            hostOutputStream.writeShort(databaseServerAttributes.getPackageAddStatementAllowed());
        }
        if (databaseServerAttributes.isUseExtendedFormatsSet()) {
            hostOutputStream.writeInt(7);
            hostOutputStream.writeShort(14369);
            hostOutputStream.writeByte(databaseServerAttributes.getUseExtendedFormats());
        }
        if (databaseServerAttributes.isLOBFieldThresholdSet()) {
            hostOutputStream.writeInt(10);
            hostOutputStream.writeShort(14370);
            hostOutputStream.writeInt(databaseServerAttributes.getLOBFieldThreshold());
        }
        if (databaseServerAttributes.isDataCompressionParameterSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14371);
            hostOutputStream.writeShort(databaseServerAttributes.getDataCompressionParameter());
        }
        if (databaseServerAttributes.isTrueAutoCommitIndicatorSet()) {
            hostOutputStream.writeInt(7);
            hostOutputStream.writeShort(14372);
            hostOutputStream.writeByte(databaseServerAttributes.getTrueAutoCommitIndicator());
        }
        if (databaseServerAttributes.isClientSupportInformationSet()) {
            hostOutputStream.writeInt(10);
            hostOutputStream.writeShort(14373);
            hostOutputStream.writeInt(databaseServerAttributes.getClientSupportInformation());
        }
        if (databaseServerAttributes.isRDBNameSet()) {
            String string15 = databaseServerAttributes.getRDBName();
            hostOutputStream.writeInt(8 + string15.length());
            hostOutputStream.writeShort(14374);
            hostOutputStream.writeShort(37);
            DatabaseConnection.writePadEBCDIC(string15, string15.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isDecimalPrecisionAndScaleAttributesSet()) {
            hostOutputStream.writeInt(12);
            hostOutputStream.writeShort(14375);
            hostOutputStream.writeShort(databaseServerAttributes.getMaximumDecimalPrecision());
            hostOutputStream.writeShort(databaseServerAttributes.getMaximumDecimalScale());
            hostOutputStream.writeShort(databaseServerAttributes.getMinimumDivideScale());
        }
        if (databaseServerAttributes.isHexadecimalConstantParserOptionSet()) {
            hostOutputStream.writeInt(7);
            hostOutputStream.writeShort(14376);
            hostOutputStream.writeByte(databaseServerAttributes.getHexadecimalConstantParserOption());
        }
        if (databaseServerAttributes.isInputLocatorTypeSet()) {
            hostOutputStream.writeInt(7);
            hostOutputStream.writeShort(14377);
            hostOutputStream.writeByte(databaseServerAttributes.getInputLocatorType());
        }
        if (databaseServerAttributes.isLocatorPersistenceSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14384);
            hostOutputStream.writeShort(databaseServerAttributes.getLocatorPersistence());
        }
        if (databaseServerAttributes.isEWLMCorrelatorSet()) {
            byte[] byArray = databaseServerAttributes.getEWLMCorrelator();
            hostOutputStream.writeInt(6 + byArray.length);
            hostOutputStream.writeShort(14385);
            hostOutputStream.write(byArray);
        }
        if (databaseServerAttributes.isRLECompressionSet()) {
            byte[] byArray = databaseServerAttributes.getRLECompression();
            hostOutputStream.writeInt(10 + byArray.length);
            hostOutputStream.writeShort(14386);
            hostOutputStream.writeInt(byArray.length);
            hostOutputStream.write(byArray);
        }
        if (databaseServerAttributes.isOptimizationGoalIndicatorSet()) {
            hostOutputStream.writeInt(7);
            hostOutputStream.writeShort(14387);
            hostOutputStream.writeByte(databaseServerAttributes.getOptimizationGoalIndicator());
        }
        if (databaseServerAttributes.isQueryStorageLimitSet()) {
            hostOutputStream.writeInt(10);
            hostOutputStream.writeShort(14388);
            hostOutputStream.writeInt(databaseServerAttributes.getQueryStorageLimit());
        }
        if (databaseServerAttributes.isDecimalFloatingPointRoundingModeOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14389);
            hostOutputStream.writeShort(databaseServerAttributes.getDecimalFloatingPointRoundingModeOption());
        }
        if (databaseServerAttributes.isDecimalFloatingPointErrorReportingOptionSet()) {
            hostOutputStream.writeInt(8);
            hostOutputStream.writeShort(14390);
            hostOutputStream.writeShort(databaseServerAttributes.getDecimalFloatingPointErrorReportingOption());
        }
        if (databaseServerAttributes.isClientAccountingInformationSet()) {
            String string16 = databaseServerAttributes.getClientAccountingInformation();
            hostOutputStream.writeInt(10 + string16.length());
            hostOutputStream.writeShort(14391);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string16.length());
            DatabaseConnection.writePadEBCDIC(string16, string16.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isClientApplicationNameSet()) {
            String string17 = databaseServerAttributes.getClientApplicationName();
            hostOutputStream.writeInt(10 + string17.length());
            hostOutputStream.writeShort(14392);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string17.length());
            DatabaseConnection.writePadEBCDIC(string17, string17.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isClientUserIdentifierSet()) {
            String string18 = databaseServerAttributes.getClientUserIdentifier();
            hostOutputStream.writeInt(10 + string18.length());
            hostOutputStream.writeShort(14393);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string18.length());
            DatabaseConnection.writePadEBCDIC(string18, string18.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isClientWorkstationNameSet()) {
            String string19 = databaseServerAttributes.getClientWorkstationName();
            hostOutputStream.writeInt(10 + string19.length());
            hostOutputStream.writeShort(14394);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string19.length());
            DatabaseConnection.writePadEBCDIC(string19, string19.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isClientProgramIdentifierSet()) {
            String string20 = databaseServerAttributes.getClientProgramIdentifier();
            hostOutputStream.writeInt(10 + string20.length());
            hostOutputStream.writeShort(14395);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string20.length());
            DatabaseConnection.writePadEBCDIC(string20, string20.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isInterfaceTypeSet()) {
            String string21 = databaseServerAttributes.getInterfaceType();
            hostOutputStream.writeInt(10 + string21.length());
            hostOutputStream.writeShort(14396);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string21.length());
            DatabaseConnection.writePadEBCDIC(string21, string21.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isInterfaceNameSet()) {
            String string22 = databaseServerAttributes.getInterfaceName();
            hostOutputStream.writeInt(10 + string22.length());
            hostOutputStream.writeShort(14397);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string22.length());
            DatabaseConnection.writePadEBCDIC(string22, string22.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isInterfaceLevelSet()) {
            String string23 = databaseServerAttributes.getInterfaceLevel();
            hostOutputStream.writeInt(10 + string23.length());
            hostOutputStream.writeShort(14398);
            hostOutputStream.writeShort(37);
            hostOutputStream.writeShort(string23.length());
            DatabaseConnection.writePadEBCDIC(string23, string23.length(), hostOutputStream);
        }
        if (databaseServerAttributes.isCloseOnEOFSet()) {
            hostOutputStream.writeInt(7);
            hostOutputStream.writeShort(14399);
            hostOutputStream.writeByte(databaseServerAttributes.getCloseOnEOF());
        }
    }

    private void sendCommitRequest(HostServerConnection.HostOutputStream hostOutputStream) throws IOException {
        int n = 40;
        this.writeHeader(n, 6151);
        hostOutputStream.writeInt(Integer.MIN_VALUE);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
    }

    private void sendRollbackRequest(HostServerConnection.HostOutputStream hostOutputStream) throws IOException {
        int n = 40;
        this.writeHeader(n, 6152);
        hostOutputStream.writeInt(Integer.MIN_VALUE);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(0);
    }
}

