/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.database.jdbc.JDBCConnection;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import com.ibm.jtopenlite.database.jdbc.JDBCResultSet;
import com.ibm.jtopenlite.database.jdbc.NotImplementedException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCDatabaseMetaData
implements DatabaseMetaData {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    private JDBCConnection connection_;
    static final int SQL_NO_NULLS = 0;
    static final int SQL_NULLABLE = 1;
    static final int SQL_NULLABLE_UNKNOWN = 2;
    static final int SQL_BEST_ROWID = 1;
    static final int SQL_ROWVER = 2;
    static final String EMPTY_STRING = "";
    static final String MATCH_ALL = "%";
    private static final String VIEW = "VIEW";
    private static final String TABLE = "TABLE";
    private static final String SYSTEM_TABLE = "SYSTEM TABLE";
    private static final String ALIAS = "ALIAS";
    private static final String MQT = "MATERIALIZED QUERY TABLE";
    private static final String SYNONYM = "SYNONYM";
    private static final String FAKE_VALUE = "QCUJOFAKE";
    private static final int SQL_ALL_TYPES = 0;
    static final int MAX_LOB_LENGTH = 0x7FFFFFFE;
    static int javaVersion;

    JDBCDatabaseMetaData(JDBCConnection jDBCConnection) throws SQLException {
        this.connection_ = jDBCConnection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        this.supportsResultSetType(n);
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        Statement statement = this.connection_.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT VARCHAR('1', 128) AS TYPE_CAT, VARCHAR('2', 128)  AS TYPE_SCHEM, VARCHAR('3', 128)  AS TYPE_NAME, VARCHAR('4', 128)  AS ATTR_NAME, SMALLINT(5)        AS DATA_TYPE, VARCHAR('6', 128)  AS ATTR_TYPE_NAME, INT(7)             AS ATTR_SIZE, INT(8)             AS DECIMAL_DIGITS, INT(9)             AS NUM_PREC_RADIX, INT(10)            AS NULLABLE, VARCHAR('11', 128) AS REMARKS, VARCHAR('12', 128) AS ATTR_DEF, INT(13)            AS SQL_DATA_TYPE, INT(14)            AS SQL_DATETIME_SUB, INT(15)            AS CHAR_OCTET_LENGTH, INT(16)            AS ORDINAL_POSITION, VARCHAR('17', 128) AS IS_NULLABLE, VARCHAR('18', 128) AS SCOPE_CATALOG, VARCHAR('19', 128) AS SCOPE_SCHEMA, VARCHAR('20', 128) AS SCOPE_TABLE, SMALLINT(21)       AS SOURCE_DATA_TYPE FROM QSYS2" + this.getCatalogSeparator() + "SYSTYPES WHERE 1 = 2 FOR FETCH ONLY ");
        return resultSet;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("call SYSIBM" + this.getCatalogSeparator() + "SQLSPECIALCOLUMNS(?,?,?,?,?,?,?)");
        callableStatement.setShort(1, (short)1);
        callableStatement.setString(2, this.normalize(string));
        callableStatement.setString(3, this.normalize(string2));
        callableStatement.setString(4, this.normalize(string3));
        callableStatement.setShort(5, (short)n);
        if (bl) {
            callableStatement.setShort(6, (short)1);
        } else {
            callableStatement.setShort(6, (short)0);
        }
        callableStatement.setString(7, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLTABLES(?,?,?,?,?)");
        callableStatement.setString(1, MATCH_ALL);
        callableStatement.setString(2, MATCH_ALL);
        callableStatement.setString(3, MATCH_ALL);
        callableStatement.setString(4, MATCH_ALL);
        callableStatement.setString(5, "DATATYPE='JDBC';GETCATALOGS=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public String getCatalogSeparator() throws SQLException {
        String string = ".";
        return string;
    }

    public String getCatalogTerm() throws SQLException {
        return "Database";
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("call SYSIBM" + this.getCatalogSeparator() + "SQLCOLPRIVILEGES (?, ?, ?, ?, ?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, this.normalize(string4));
        callableStatement.setObject(5, (Object)"DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        ResultSet resultSet = callableStatement.executeQuery();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
        }
        return resultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLCOLUMNS(?,?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, this.normalize(string4));
        if (javaVersion > 16) {
            callableStatement.setString(5, "DATATYPE='JDBC';JDBCVER='4.1';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        } else if (javaVersion > 15) {
            callableStatement.setString(5, "DATATYPE='JDBC';JDBCVER='4.0';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        } else {
            callableStatement.setString(5, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        }
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
        }
        return resultSet;
    }

    public Connection getConnection() throws SQLException {
        return this.connection_;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, this.normalize(string4));
        callableStatement.setString(5, this.normalize(string5));
        callableStatement.setString(6, this.normalize(string6));
        callableStatement.setString(7, "DATATYPE='JDBC';EXPORTEDKEY=0;IMPORTEDKEY=0;DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public int getDatabaseMajorVersion() {
        int n = 0;
        try {
            String string = this.getDatabaseProductVersion();
            int n2 = string.indexOf(46);
            if (n2 > 0) {
                string = string.substring(0, n2);
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public int getDatabaseMinorVersion() {
        int n = 0;
        try {
            String string = this.getDatabaseProductVersion();
            int n2 = string.indexOf(46);
            if (n2 > 0) {
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(46)) > 0) {
                    string = string.substring(0, n2);
                }
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public String getDatabaseProductName() throws SQLException {
        return "DB2 UDB for AS/400";
    }

    public String getDatabaseProductVersion() throws SQLException {
        int n = this.connection_.getServerVersion();
        int n2 = (n & 0xFFFF0000) >>> 16;
        int n3 = (n & 0xFF00) >>> 8;
        int n4 = n & 0xFF;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        stringBuffer.append(".");
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        stringBuffer.append(".");
        if (n4 < 1000) {
            stringBuffer.append("0");
        }
        if (n4 < 100) {
            stringBuffer.append("0");
        }
        if (n4 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n4);
        stringBuffer.append(" V");
        stringBuffer.append(n2);
        stringBuffer.append("R");
        stringBuffer.append(n3);
        stringBuffer.append("m");
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 1;
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public String getDriverName() throws SQLException {
        return "jtopenlite JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "1.0";
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, this.normalize(string));
        callableStatement.setString(5, EMPTY_STRING);
        callableStatement.setString(6, EMPTY_STRING);
        callableStatement.setString(7, "DATATYPE='JDBC';EXPORTEDKEY=1; CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public String getExtraNameCharacters() throws SQLException {
        return "$@#";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, null);
        callableStatement.setString(3, null);
        callableStatement.setString(4, this.normalize(string));
        callableStatement.setString(5, this.normalize(string2));
        callableStatement.setString(6, this.normalize(string3));
        callableStatement.setString(7, "DATATYPE='JDBC';IMPORTEDKEY=1; CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        short s = 0;
        short s2 = bl ? (short)0 : 1;
        if (string2 != null) {
            string2 = this.normalize(string2);
        }
        if (string3 != null) {
            string3 = this.normalize(string3);
        }
        CallableStatement callableStatement = this.connection_.prepareCall("call SYSIBM" + this.getCatalogSeparator() + "SQLSTATISTICS(?,?,?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setShort(4, s2);
        callableStatement.setShort(5, s);
        callableStatement.setString(6, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public int getJDBCMajorVersion() throws SQLException {
        if (javaVersion >= 16) {
            return 4;
        }
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        if (javaVersion >= 17) {
            return 1;
        }
        return 0;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 32739;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 10;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 32739;
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (this.connection_.getServerVersion() >= 328704) {
            return 128;
        }
        return 30;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        if (this.connection_.getServerVersion() >= 393472) {
            return 8000;
        }
        return 120;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 120;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 10000;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 8000;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 8000;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (this.connection_.getServerVersion() >= 393472) {
            return 128;
        }
        return 18;
    }

    public int getMaxIndexLength() throws SQLException {
        return 2000;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 128;
    }

    public int getMaxRowSize() throws SQLException {
        return 32766;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (this.connection_.getServerVersion() >= 459008) {
            return 128;
        }
        return 10;
    }

    public int getMaxStatementLength() throws SQLException {
        if (this.connection_.getServerVersion() >= 328704) {
            return 0x100000;
        }
        return Short.MAX_VALUE;
    }

    public int getMaxStatements() throws SQLException {
        return 9999;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 128;
    }

    public int getMaxTablesInSelect() throws SQLException {
        if (this.connection_.getServerVersion() >= 328704) {
            return 1000;
        }
        return 32;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 10;
    }

    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sin,sign,sqrt,tan,truncate";
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLPRIMARYKEYS(?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLPROCEDURECOLS(?,?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, this.normalize(string4));
        if (javaVersion >= 16) {
            callableStatement.setString(5, "DATATYPE='JDBC';JDBCVER='4.0';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        } else {
            callableStatement.setString(5, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        }
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLPROCEDURES(?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public String getProcedureTerm() throws SQLException {
        return "Procedure";
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public ResultSet getSchemas() throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLTABLES(?,?,?,?,?)");
        callableStatement.setString(1, MATCH_ALL);
        callableStatement.setString(2, MATCH_ALL);
        callableStatement.setString(3, MATCH_ALL);
        callableStatement.setString(4, MATCH_ALL);
        callableStatement.setString(5, "DATATYPE='JDBC';GETSCHEMAS=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public String getSchemaTerm() throws SQLException {
        return "Library";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getSQLKeywords() throws SQLException {
        return "AFTER,ALIAS,ALLOW,APPLICATION,ASSOCIATE,ASUTIME,AUDIT,AUX,AUXILIARY,BEFORE,BINARY,BUFFERPOOL,CACHE,CALL,CALLED,CAPTURE,CARDINALITY,CCSID,CLUSTER,COLLECTION,COLLID,COMMENT,CONCAT,CONDITION,CONTAINS,COUNT_BIG,CURRENT_LC_CTYPE,CURRENT_PATH,CURRENT_SERVER,CURRENT_TIMEZONE,CYCLE,DATA,DATABASE,DAYS,DB2GENERAL,DB2GENRL,DB2SQL,DBINFO,DEFAULTS,DEFINITION,DETERMINISTIC,DISALLOW,DO,DSNHATTR,DSSIZE,DYNAMIC,EACH,EDITPROC,ELSEIF,ENCODING,END-EXEC1,ERASE,EXCLUDING,EXIT,FENCED,FIELDPROC,FILE,FINAL,FREE,FUNCTION,GENERAL,GENERATED,GRAPHIC,HANDLER,HOLD,HOURS,IF,INCLUDING,INCREMENT,INDEX,INHERIT,INOUT,INTEGRITY,ISOBID,ITERATE,JAR,JAVA,LABEL,LC_CTYPE,LEAVE,LINKTYPE,LOCALE,LOCATOR,LOCATORS,LOCK,LOCKMAX,LOCKSIZE,LONG,LOOP,MAXVALUE,MICROSECOND,MICROSECONDS,MINUTES,MINVALUE,MODE,MODIFIES,MONTHS,NEW,NEW_TABLE,NOCACHE,NOCYCLE,NODENAME,NODENUMBER,NOMAXVALUE,NOMINVALUE,NOORDER,NULLS,NUMPARTS,OBID,OLD,OLD_TABLE,OPTIMIZATION,OPTIMIZE,OUT,OVERRIDING,PACKAGE,PARAMETER,PART,PARTITION,PATH,PIECESIZE,PLAN,PRIQTY,PROGRAM,PSID,QUERYNO,READS,RECOVERY,REFERENCING,RELEASE,RENAME,REPEAT,RESET,RESIGNAL,RESTART,RESULT,RESULT_SET_LOCATOR,RETURN,RETURNS,ROUTINE,ROW,RRN,RUN,SAVEPOINT,SCRATCHPAD,SECONDS,SECQTY,SECURITY,SENSITIVE,SIGNAL,SIMPLE,SOURCE,SPECIFIC,SQLID,STANDARD,START,STATIC,STAY,STOGROUP,STORES,STYLE,SUBPAGES,SYNONYM,SYSFUN,SYSIBM,SYSPROC,SYSTEM,TABLESPACE,TRIGGER,TYPE,UNDO,UNTIL,VALIDPROC,VARIABLE,VARIANT,VCAT,VOLUMES,WHILE,WLM,YEARS";
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public String getStringFunctions() throws SQLException {
        return "char,concat,difference,insert,lcase,left,length,locate,ltrim,repeat,replace,right,rtrim,soundex,space,substring,ucase";
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        Statement statement = this.connection_.createStatement();
        return statement.executeQuery("SELECT VARCHAR('1', 128) AS TYPE_CAT, VARCHAR('2', 128) AS TYPE_SCHEM, VARCHAR('3', 128) AS TYPE_NAME, VARCHAR('4', 128) AS SUPERTYPE_NAME FROM QSYS2" + this.getCatalogSeparator() + "SYSTYPES WHERE 1 = 2 FOR FETCH ONLY ");
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        Statement statement = this.connection_.createStatement();
        return statement.executeQuery("SELECT VARCHAR('1', 128) AS TYPE_CAT, VARCHAR('2', 128) AS TYPE_SCHEM, VARCHAR('3', 128) AS TYPE_NAME, VARCHAR('4', 128) AS SUPERTYPE_CAT, VARCHAR('5', 128) AS SUPERTYPE_SCHEM, VARCHAR('6', 128) AS SUPERTYPE_NAME FROM QSYS2" + this.getCatalogSeparator() + "SYSTYPES WHERE 1 = 2 FOR FETCH ONLY ");
    }

    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user";
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLTABLEPRIVILEGES(?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        boolean bl = false;
        String string4 = EMPTY_STRING;
        if (!bl) {
            int n = 0;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string5 = stringArray[i];
                    if (!string5.equalsIgnoreCase(VIEW) && !string5.equalsIgnoreCase(TABLE) && !string5.equalsIgnoreCase(SYSTEM_TABLE) && !string5.equalsIgnoreCase(ALIAS) && !string5.equalsIgnoreCase(SYNONYM) && !string5.equalsIgnoreCase(MQT)) continue;
                    if (string5.equalsIgnoreCase(SYNONYM)) {
                        string5 = ALIAS;
                    }
                    if (++n > 1) {
                        string4 = string4.concat(",");
                    }
                    string4 = string4.concat(string5);
                }
                if (n == 0) {
                    bl = true;
                }
            }
        }
        if (bl) {
            string2 = FAKE_VALUE;
            string3 = FAKE_VALUE;
            string4 = string4.concat(TABLE);
        }
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLTABLES(?,?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, this.normalize(string4));
        callableStatement.setString(5, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLTABLES(?,?,?,?,?)");
        callableStatement.setString(1, MATCH_ALL);
        callableStatement.setString(2, MATCH_ALL);
        callableStatement.setString(3, MATCH_ALL);
        callableStatement.setString(4, MATCH_ALL);
        callableStatement.setString(5, "DATATYPE='JDBC';GETTABLETYPES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public String getTimeDateFunctions() throws SQLException {
        return "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,timestampdiff,week,year";
    }

    public ResultSet getTypeInfo() throws SQLException {
        PreparedStatement preparedStatement = this.connection_.prepareStatement("CALL SYSIBM" + this.getCatalogSeparator() + "SQLGETTYPEINFO(?,?)");
        preparedStatement.setShort(1, (short)0);
        if (javaVersion >= 16) {
            preparedStatement.setString(2, "DATATYPE='JDBC';JDBCVER='4.0';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        } else {
            preparedStatement.setString(2, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        }
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            preparedStatement.close();
        }
        return resultSet;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLUDTS(?,?,?,?,?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (n > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(nArray[i]);
                ++n;
            }
        }
        callableStatement.setString(4, stringBuffer.toString());
        if (javaVersion >= 16) {
            callableStatement.setString(5, "DATATYPE='JDBC';JDBCVER='4.0';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        } else {
            callableStatement.setString(5, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        }
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public String getURL() throws SQLException {
        return this.connection_.getURL();
    }

    public String getUserName() throws SQLException {
        return this.connection_.getUserName();
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("CALL SYSIBM" + this.getCatalogSeparator() + "SQLSPECIALCOLUMNS(?,?,?,?, ?,?,?)");
        callableStatement.setShort(1, (short)2);
        callableStatement.setString(2, this.normalize(string));
        callableStatement.setString(3, this.normalize(string2));
        callableStatement.setString(4, this.normalize(string3));
        callableStatement.setShort(5, (short)0);
        callableStatement.setShort(6, (short)1);
        callableStatement.setString(7, "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        this.supportsResultSetType(n);
        return false;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection_.isReadOnly();
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    private String normalize(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        this.supportsResultSetType(n);
        return n == 1005;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        this.supportsResultSetType(n);
        return n == 1005;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        this.supportsResultSetType(n);
        return n == 1005;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        this.supportsResultSetType(n);
        return n == 1005;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        this.supportsResultSetType(n);
        return n == 1005;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        this.supportsResultSetType(n);
        return n == 1005;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return this.connection_.getServerVersion() >= 393472;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (this.supportsResultSetType(n)) {
            if (n2 == 1007) {
                return true;
            }
            if (n2 == 1008) {
                return false;
            }
            JDBCError.throwSQLException("HY108");
            return false;
        }
        return false;
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return true;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        switch (n) {
            case 1003: {
                return true;
            }
            case 1004: 
            case 1005: {
                return false;
            }
        }
        throw new SQLException("resultSetType invalid: " + n);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (n != 0 && n != 1 && n != 2 && n != 4 && n != 8) {
            throw new SQLException("transactionIsolationLevel invalid : " + n);
        }
        return true;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public String toString() {
        try {
            return this.connection_.getCatalog();
        }
        catch (SQLException sQLException) {
            return super.toString();
        }
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        this.supportsResultSetType(n);
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        throw new NotImplementedException();
    }

    public ResultSet getSchemas(String string, String string2) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("call SYSIBM" + this.getCatalogSeparator() + "SQLTABLES  (?, ?, ?, ?, ?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, MATCH_ALL);
        callableStatement.setString(4, MATCH_ALL);
        callableStatement.setObject(5, (Object)"DATATYPE='JDBC';GETSCHEMAS=2;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("call SYSIBM" + this.getCatalogSeparator() + "SQLFUNCTIONS  ( ?, ?, ?, ?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setObject(4, (Object)"DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("call SYSIBM" + this.getCatalogSeparator() + "SQLFUNCTIONCOLS  ( ?, ?, ?, ?, ?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, this.normalize(string4));
        if (javaVersion > 16) {
            callableStatement.setObject(5, (Object)"DATATYPE='JDBC';JDBCVER='4.0';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        } else {
            callableStatement.setObject(5, (Object)"DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        }
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        CallableStatement callableStatement = this.connection_.prepareCall("call SYSIBM" + this.getCatalogSeparator() + "SQLPSEUDOCOLUMNS  ( ?, ?, ?, ?, ?)");
        callableStatement.setString(1, this.normalize(string));
        callableStatement.setString(2, this.normalize(string2));
        callableStatement.setString(3, this.normalize(string3));
        callableStatement.setString(4, this.normalize(string4));
        if (javaVersion >= 16) {
            callableStatement.setObject(5, (Object)"DATATYPE='JDBC';JDBCVER='4.0';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        } else {
            callableStatement.setObject(5, (Object)"DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1");
        }
        callableStatement.execute();
        ResultSet resultSet = callableStatement.getResultSet();
        if (resultSet != null) {
            ((JDBCResultSet)resultSet).isMetadataResultSet_ = true;
        } else {
            callableStatement.close();
            JDBCError.throwSQLException("HY000");
        }
        return resultSet;
    }

    static {
        int n;
        int n2;
        javaVersion = 0;
        String string = System.getProperty("java.version");
        if (string != null && (n2 = string.indexOf(46)) > 0 && (n = string.indexOf(46, n2 + 1)) > 0) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n);
            javaVersion = Integer.parseInt(string2) * 10 + Integer.parseInt(string3);
        }
    }
}

