/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.database.DatabaseParameterMarkerCallback;
import com.ibm.jtopenlite.database.jdbc.Column;
import com.ibm.jtopenlite.database.jdbc.JDBCColumnMetaData;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import com.ibm.jtopenlite.database.jdbc.JDBCStatement;
import com.ibm.jtopenlite.database.jdbc.NotImplementedException;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Calendar;

public class JDBCParameterMetaData
implements ParameterMetaData,
DatabaseParameterMarkerCallback {
    private Column[] columns_;
    private int rowSize_;
    private JDBCStatement statement_;
    private final Calendar calendar_;

    public JDBCParameterMetaData(Calendar calendar) {
        this.calendar_ = calendar;
        this.statement_ = null;
    }

    void setStatement(JDBCStatement jDBCStatement) {
        this.statement_ = jDBCStatement;
    }

    public void parameterMarkerDescription(int n, int n2) {
        this.columns_ = new Column[n];
        for (int i = 0; i < n; ++i) {
            this.columns_[i] = new Column(this.calendar_, i + 1, true);
        }
        this.rowSize_ = n2;
    }

    public void parameterMarkerFieldDescription(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.columns_[n].setType(n2);
        this.columns_[n].setLength(n3);
        this.columns_[n].setScale(n4);
        this.columns_[n].setPrecision(n5);
        this.columns_[n].setCCSID(n6);
    }

    public void parameterMarkerFieldName(int n, String string) {
        this.columns_[n].setName(string);
    }

    public void parameterMarkerUDTName(int n, String string) {
    }

    int getRowSize() {
        return this.rowSize_;
    }

    Column getColumn(int n) throws SQLException {
        if (this.columns_ == null || n >= this.columns_.length || n < 0) {
            throw new SQLException("Descriptor index not valid.");
        }
        return this.columns_[n];
    }

    byte[] getExtendedSQLParameterMarkerDataFormat() {
        if (this.columns_ == null) {
            return null;
        }
        int n = this.columns_.length;
        if (n == 0) {
            return null;
        }
        int n2 = 16 + n * 64;
        byte[] byArray = new byte[n2];
        Conv.intToByteArray(1, byArray, 0);
        Conv.intToByteArray(n, byArray, 4);
        Conv.intToByteArray(this.rowSize_, byArray, 12);
        int n3 = 16;
        for (int i = 0; i < n; ++i) {
            int n4 = this.columns_[i].getType();
            int n5 = this.columns_[i].getLength();
            int n6 = this.columns_[i].getScale();
            int n7 = this.columns_[i].getPrecision();
            int n8 = this.columns_[i].getCCSID();
            Conv.shortToByteArray(64, byArray, n3);
            Conv.shortToByteArray(n4, byArray, n3 + 2);
            Conv.intToByteArray(n5, byArray, n3 + 4);
            Conv.shortToByteArray(n6, byArray, n3 + 8);
            Conv.shortToByteArray(n7, byArray, n3 + 10);
            Conv.shortToByteArray(n8, byArray, n3 + 12);
            n3 += 64;
        }
        return byArray;
    }

    public String getParameterClassName(int n) throws SQLException {
        throw new NotImplementedException();
    }

    public int getParameterCount() throws SQLException {
        this.checkRequest();
        return this.columns_ == null ? 0 : this.columns_.length;
    }

    public int getParameterMode(int n) throws SQLException {
        this.checkRequest();
        return 0;
    }

    public int getParameterType(int n) throws SQLException {
        this.checkRequest(n);
        return this.columns_[n - 1].getSQLType();
    }

    public String getParameterTypeName(int n) throws SQLException {
        this.checkRequest(n);
        return this.columns_[n - 1].getSQLTypeName();
    }

    public int getPrecision(int n) throws SQLException {
        this.checkRequest(n);
        return JDBCColumnMetaData.getPrecision(this.columns_[n - 1]);
    }

    public int getScale(int n) throws SQLException {
        this.checkRequest(n);
        return JDBCColumnMetaData.getScale(this.columns_[n - 1]);
    }

    public int isNullable(int n) throws SQLException {
        this.checkRequest(n);
        throw new NotImplementedException();
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkRequest(n);
        throw new NotImplementedException();
    }

    private void checkRequest(int n) throws SQLException {
        this.checkRequest();
        if (this.columns_ == null || n < 1 || n > this.columns_.length) {
            throw JDBCError.getSQLException("07009");
        }
    }

    private void checkRequest() throws SQLException {
        if (this.statement_.isClosed()) {
            throw JDBCError.getSQLException("HY010");
        }
    }
}

