/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3.math;

import com.eg.org.apache.commons.lang3.Validate;

public class IEEE754rUtils {
    public static double min(double ... dArray) {
        Validate.isTrue(dArray != null, "The Array must not be null", new Object[0]);
        Validate.isTrue(dArray.length != 0, "Array cannot be empty.", new Object[0]);
        double d5 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            d5 = IEEE754rUtils.min(dArray[i2], d5);
        }
        return d5;
    }

    public static float min(float ... fArray) {
        Validate.isTrue(fArray != null, "The Array must not be null", new Object[0]);
        Validate.isTrue(fArray.length != 0, "Array cannot be empty.", new Object[0]);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            f2 = IEEE754rUtils.min(fArray[i2], f2);
        }
        return f2;
    }

    public static double min(double d5, double d6, double d7) {
        return IEEE754rUtils.min(IEEE754rUtils.min(d5, d6), d7);
    }

    public static double min(double d5, double d6) {
        if (Double.isNaN(d5)) {
            return d6;
        }
        if (Double.isNaN(d6)) {
            return d5;
        }
        return Math.min(d5, d6);
    }

    public static float min(float f2, float f3, float f4) {
        return IEEE754rUtils.min(IEEE754rUtils.min(f2, f3), f4);
    }

    public static float min(float f2, float f3) {
        if (Float.isNaN(f2)) {
            return f3;
        }
        if (Float.isNaN(f3)) {
            return f2;
        }
        return Math.min(f2, f3);
    }

    public static double max(double ... dArray) {
        Validate.isTrue(dArray != null, "The Array must not be null", new Object[0]);
        Validate.isTrue(dArray.length != 0, "Array cannot be empty.", new Object[0]);
        double d5 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            d5 = IEEE754rUtils.max(dArray[i2], d5);
        }
        return d5;
    }

    public static float max(float ... fArray) {
        Validate.isTrue(fArray != null, "The Array must not be null", new Object[0]);
        Validate.isTrue(fArray.length != 0, "Array cannot be empty.", new Object[0]);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            f2 = IEEE754rUtils.max(fArray[i2], f2);
        }
        return f2;
    }

    public static double max(double d5, double d6, double d7) {
        return IEEE754rUtils.max(IEEE754rUtils.max(d5, d6), d7);
    }

    public static double max(double d5, double d6) {
        if (Double.isNaN(d5)) {
            return d6;
        }
        if (Double.isNaN(d6)) {
            return d5;
        }
        return Math.max(d5, d6);
    }

    public static float max(float f2, float f3, float f4) {
        return IEEE754rUtils.max(IEEE754rUtils.max(f2, f3), f4);
    }

    public static float max(float f2, float f3) {
        if (Float.isNaN(f2)) {
            return f3;
        }
        if (Float.isNaN(f3)) {
            return f2;
        }
        return Math.max(f2, f3);
    }
}

