/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMCleanUpUtils;
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMUtils;
import com.eg.apm.APMWorkerHelper;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import com.eg.apm.ComponentWatcherTracker;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.SocketIpSelectorUtil;
import com.eg.apm.Status;
import com.eg.apm.util.IPAddressMaskHelper;
import com.eg.apm.util.QueryMaskHelper;
import com.eg.jtm.BTMConstants;
import com.egurkha.util.IPAddressUtils;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.PropertiesConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APMBase
extends GenericTest {
    protected int socketTimeout = 1000;
    protected static final SimpleDateFormat finalFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US);
    protected static final SimpleDateFormat finalUtcDateFormatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US);
    protected ArrayList propsList = new ArrayList();
    protected int BTM_Port = 13931;
    protected String trgtHost = "localhost";
    protected String logPrefix = "APMBase";
    protected String loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + this.logPrefix + "]";
    protected String applicationName = "My_Application";
    protected String tierName = "My_Tier";
    protected static final String DDCellColSep = "#=#";
    protected static final String DDCellRowSep = "%*%";
    protected static final String ExtCallSep = "[*#*]";
    protected static final String requestIDSep = " @ ";
    protected static final String LOCAL_HOST = "localhost";
    protected static final String acuteRegex = ",N'";
    protected static final String acuteReplStr = ",'";
    protected static final char newLineChar = '\n';
    protected static final char space = ' ';
    protected ArrayList<String> unmaskedHeaderList = new ArrayList();
    protected boolean sqlMaskFlag = false;
    protected boolean publicIPMaskFlag = false;
    protected boolean privateIPMaskFlag = false;
    protected boolean urlParamsMaskFlag = false;
    protected boolean exceptionParamsMaskFlag = false;
    protected boolean headersParamsMaskFlag = false;
    protected boolean cookiesParamsMaskFlag = false;
    protected static int xForwardIndex = 0;
    protected static final String[] offloadPropsOrder = new String[]{"Monitoring_Mode", "Max_URL_Segments", "URL_Patterns", "Excluded_Patterns", "Key_Excluded_Patterns", "Slow_URL_Threshold", "Stalled_URL_Threshold", "Method_Exec_CutOff", "SQL_Exec_CutOff", "Max_Slow_URLs_Per_Test_Period", "Max_Error_URLs_Per_Test_Period", "Max_Healthy_URLs_Per_Test_Period", "Max_Stalled_URLs_Per_Test_Period", "Healthy_URL_Trace", "egMeasPeriod", "Pojo_Method_Tracing_Limit", "Pojo_Method_Tracing_Cutoff_Time", "Recursive_Method_Tracing_Limit", "Non-Pojo_Method_Tracing_Limit", "Exception_Stacktrace_Lines", "Included_Exceptions", "Ignored_Exceptions", "Ignored_Characters", "Max_Grouped_Urls_Per_Measure_Period", "Key_Max_Grouped_Urls_Per_Measure_Period", "Max_Sql_Queries_Per_Transaction", "Show_HTTPStatus", "Show_Cookies", "Show_Headers", "Enable_Thread_Cpu_Monitoring", "Enable_Thread_Contention_Monitoring", "Max_Mongodb_Query_Length", "Max_Sql_Error_Queries_Per_Transaction", "Exception_With_StackTrace_Capture_Limit", "Exception_FQEN_Capture_Limit", "Max_Exception_Trace_Limit"};
    DecimalFormat formatter = new DecimalFormat("#.##");
    protected static final Double minusFive = -5.0;
    protected String apmComponentGUID = null;
    protected String NodeID = null;
    protected String componentIDForFolderName = null;
    private String agentIpAddress = "127.0.0.1";
    protected String componentType = null;
    String tempComponentID = null;
    boolean isTempCompIdFound = false;
    public static boolean agentStarted = true;
    public static final HashMap MAPPING = new HashMap();
    private static boolean doSQLStringHashing = false;
    private static boolean doMongoSQLStringHashing = false;
    private static boolean doRemoteCallExternal = false;
    private static boolean doExceptionStringHashing = false;
    private static Map<String, Boolean> causeExceptionTracingTable = new HashMap<String, Boolean>();
    protected boolean isContainerHost = false;
    String zipFileSync = new String("Zip");
    private boolean useReportingName = false;
    public static HashMap zipCreated = new HashMap();
    private static long noneThresholdTransactionStalledLimit = 120000L;
    protected String ipAddressMaskChar = "x";

    public APMBase(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        this.trgtHost = this.getValueForParam("trgtHost");
        this.ipAddressMaskChar = this.getValueForParam("IPMaskchar");
        if (this.ipAddressMaskChar == null || this.ipAddressMaskChar.length() == 0) {
            this.ipAddressMaskChar = "x";
        }
        this.applicationName = this.getValueForParam("Application_Name");
        this.tierName = this.getValueForParam("Tier_Name");
        this.fixedTestPeriod = true;
        DecimalFormatSymbols decimalFormatSymbols = this.formatter.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        this.formatter.setDecimalFormatSymbols(decimalFormatSymbols);
        if (this.applicationName == null) {
            this.applicationName = "-";
        }
        this.NodeID = "[" + this.reportingName + ":" + this.portNo + "]";
        this.componentIDForFolderName = this.reportingName + "_" + this.portNo;
        this.findServerType();
        this.isContainerHost = this.isContainerApp && this.strContainerId != null && this.strContainerId.length() > 0;
        this.getJvmGuid();
        this.checkTempComponentID();
        AgentLogger.testLogger.info("{} Component GUID from eg_apmGuid.ini : {} ", (Object)this.loggerDispStr, (Object)this.apmComponentGUID);
        if (this.entity.equalsIgnoreCase("TransactionFlowTest")) {
            this.getAppNameTierNameFromIni(new HashMap());
            APMWorkerHelper.getInstance().addNewComponentForAppTierName(this.NodeID, this.componentType);
            APMUtils.storeGuidWithNick(this.apmComponentGUID, this.NodeID, AgentLogger.testLogger);
            APMUtils.storeGuidWithIpPort(this.apmComponentGUID, this.trgtHost + ":" + this.portNo, this.reportingName + ":" + this.portNo, AgentLogger.testLogger);
        }
        boolean bl = false;
        int n = this.entity.indexOf("TransTest");
        if (n > 0) {
            bl = true;
        }
        if (bl) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8 = this.getValueForParam("Mask_SQL");
            if (string8 != null && (string8.equalsIgnoreCase("true") || string8.equalsIgnoreCase("yes"))) {
                this.sqlMaskFlag = true;
            }
            if ((string7 = this.getValueForParam("Mask_Public_IP")) != null && (string7.equalsIgnoreCase("true") || string7.equalsIgnoreCase("yes"))) {
                this.publicIPMaskFlag = true;
            }
            if ((string6 = this.getValueForParam("Mask_Private_IP")) != null && (string6.equalsIgnoreCase("true") || string6.equalsIgnoreCase("yes"))) {
                this.privateIPMaskFlag = true;
            }
            if ((string5 = this.getValueForParam("Mask_URL_Params")) != null && (string5.equalsIgnoreCase("true") || string5.equalsIgnoreCase("yes"))) {
                this.urlParamsMaskFlag = true;
            }
            if ((string4 = this.getValueForParam("Mask_Exception_Message")) != null && (string4.equalsIgnoreCase("true") || string4.equalsIgnoreCase("yes"))) {
                this.exceptionParamsMaskFlag = true;
            }
            if ((string3 = this.getValueForParam("Mask_All_Header_Fields")) != null && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"))) {
                this.headersParamsMaskFlag = true;
            }
            if ((string2 = this.getValueForParam("Mask_All_Cookie_Fields")) != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"))) {
                this.cookiesParamsMaskFlag = true;
            }
            if ((string = this.getValueForParam("Exclude_Header_Fields_From_Masking")) != null && !string.equalsIgnoreCase("None")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String string9 = (String)stringTokenizer.nextElement();
                    this.unmaskedHeaderList.add(string9.toLowerCase());
                }
                AgentLogger.testLogger.debug("{} Specific header list for unmasking updated with {} : for GUID {}", new Object[]{this.loggerDispStr, this.unmaskedHeaderList, this.apmComponentGUID});
            }
        }
    }

    protected void initComponentWatcher(APMLanguage aPMLanguage, BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration) {
        try {
            AgentLogger.testLogger.info("{} Entity :{} ", (Object)this.loggerDispStr, (Object)this.entity);
            ComponentWatcherTracker.isWatcherNull(true);
            if (aPMLanguage == APMLanguage.JAVA) {
                if (this.apmComponentGUID != null && this.apmComponentGUID.length() > 0) {
                    this.buildBtmZip(bTMOffloadAPMSocketConfiguration);
                } else {
                    AgentLogger.testLogger.warn("{} BTM Zip file creation & extraction skipped for {} due to Component GUID is NULL. \n \t \t \t \t \t \t Wait for one-measure peroid for next attempt, else restart the eG Agent. \n \t \t \t \t \t \t Currently, zips created to these components : {} ", new Object[]{this.loggerDispStr, this.NodeID, zipCreated.keySet()});
                }
            }
            APMComponentIDRepository.getRepository().registerComponent(this.apmComponentGUID, this.entity, this.reportingName, this.trgtHost, this.portNo, this.componentType, aPMLanguage);
            if (AgentLogger.testLogger.isDebugEnabled()) {
                AgentLogger.testLogger.debug("{} AppTierName Detail :- {} ", (Object)this.loggerDispStr, (Object)APMWorkerHelper.getInstance().getAppTierNameTable());
                AgentLogger.testLogger.debug("{} trgtHost           :- {}", (Object)this.loggerDispStr, (Object)this.trgtHost);
                AgentLogger.testLogger.debug("{} NodeID             :- {}", (Object)this.loggerDispStr, (Object)this.NodeID);
                AgentLogger.testLogger.debug("{} ComponentType      :- {}", (Object)this.loggerDispStr, (Object)this.componentType);
                AgentLogger.testLogger.debug("{} isContainerHost    :- {}, strContainerId : {}", new Object[]{this.loggerDispStr, this.isContainerHost, this.strContainerId});
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error("{} Exception in NodeBTMBase Constructor {}", (Object)this.loggerDispStr, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildBtmZip(BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration) {
        if (this.isTempCompIdFound) {
            AgentLogger.testLogger.info("{} {} is a newly discovered component, so skipping the btm zip file creation !!!. ", (Object)this.loggerDispStr, (Object)this.NodeID);
            return;
        }
        if (ApmConfigManager.getInstance().createBTMJarZipFile()) {
            boolean bl = false;
            boolean bl2 = bl = this.entity.equalsIgnoreCase("BusinessTransTest") || !zipCreated.containsKey(this.NodeID);
            if (bl) {
                String string = this.zipFileSync;
                synchronized (string) {
                    boolean bl3 = bl = this.entity.equalsIgnoreCase("BusinessTransTest") || !zipCreated.containsKey(this.NodeID);
                    if (bl) {
                        this.createBTMJarZipFile(bTMOffloadAPMSocketConfiguration);
                        zipCreated.put(this.NodeID, this.entity);
                    }
                }
            }
        } else {
            AgentLogger.testLogger.info("{} BTM Zip file creation disabled, So, Skipping the btm zip file creation for {}", (Object)this.loggerDispStr, (Object)this.NodeID);
        }
    }

    private void findServerType() {
        this.componentType = this.getValueForParam("serverType");
        if (this.componentType == null || this.componentType.trim().length() == 0) {
            this.componentType = "Not_Found";
            AgentLogger.testLogger.debug("{} Could not find the server type for {}:{} , {}", new Object[]{this.loggerDispStr, this.trgtHost, this.portNo, this.entity});
        } else {
            AgentLogger.testLogger.debug("{} Found server type as {} for {}:{} , {} ", new Object[]{this.loggerDispStr, this.componentType, this.trgtHost, this.portNo, this.entity});
        }
    }

    protected void checkTempComponentID() {
        if (AgentLogger.testLogger.isTraceEnabled()) {
            AgentLogger.testLogger.trace("{} Temp.Comp.ID Table   : {}", (Object)this.loggerDispStr, APMComponentIDRepository.getRepository().getTempComponentIDTable());
            AgentLogger.testLogger.trace("{} Temp.Comp.ID         : {} & Found? : {}", new Object[]{this.loggerDispStr, this.tempComponentID, this.isTempCompIdFound});
            AgentLogger.testLogger.trace("{} TargetHost           : {}, PortNo {} & CompType {} ", new Object[]{this.loggerDispStr, this.trgtHost, this.portNo, this.componentType});
        }
        try {
            Object object;
            APMComponent aPMComponent = APMComponentIDRepository.getRepository().getAPMComponent(this.apmComponentGUID);
            boolean bl = false;
            if (aPMComponent != null) {
                boolean bl2 = bl = aPMComponent.getHeartbeatStatus() == Status.HEART_BEATING;
            }
            if (this.tempComponentID != null && !this.tempComponentID.equalsIgnoreCase("null") && this.isTempCompIdFound && bl) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(":");
            stringBuilder2.append(this.portNo);
            stringBuilder2.append(":");
            stringBuilder2.append(this.componentType);
            if (this.isContainerHost) {
                stringBuilder.append(this.strContainerId);
            } else {
                stringBuilder.append(this.trgtHost);
            }
            stringBuilder.append(stringBuilder2.toString());
            AgentLogger.testLogger.trace("{} Temp.GUID read variable : {}", (Object)this.loggerDispStr, (Object)stringBuilder);
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Object object2 = null;
            String string = "";
            if (this.isContainerHost) {
                try {
                    String[] stringArray;
                    object = iniFile.getLinesUnderSubject("JAVA_UNIQUE_GUID_MAPPING");
                    if (object != null && ((String[])object).length > 0 && object != null && ((String[])object).length > 0) {
                        stringArray = object;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String string2 = stringArray[i];
                            if (!string2.contains("=")) continue;
                            String string3 = string2.split("=")[0];
                            String string4 = string2.split("=")[1];
                            if (!string3.contains(":")) continue;
                            String string5 = string3.split(":")[0];
                            hashMap.put(string5, string4);
                        }
                    }
                    object2 = (stringArray = (String[])hashMap.get(this.strContainerId)) != null ? stringArray : null;
                    string = "[Container-Env] " + this.strContainerId;
                    AgentLogger.testLogger.trace("{} Container-Env - Temp.GUID map : {}", (Object)this.loggerDispStr, hashMap);
                    AgentLogger.testLogger.debug("{} Container-Env - Temp.GUID read key : {}, value : {}", new Object[]{this.loggerDispStr, this.strContainerId, stringArray});
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.warn("{} [Container-Env] Error while doing the Temp component ID {}", (Object)this.loggerDispStr, (Object)exception);
                }
            } else {
                object2 = iniFile.getValue("JAVA_UNIQUE_GUID_MAPPING", stringBuilder.toString());
                string = "[Non-Container-Env] " + stringBuilder;
                AgentLogger.testLogger.debug("{} [Non-Container-Env] - Temp.GUID read variable : {}, value : {}", new Object[]{this.loggerDispStr, stringBuilder, object2});
            }
            if (!(object2 != null && object2.length() != 0 || this.isContainerHost)) {
                this.useReportingName = true;
                object = new StringBuilder();
                ((StringBuilder)object).append(this.reportingName);
                ((StringBuilder)object).append(stringBuilder2.toString());
                object2 = iniFile.getValue("JAVA_UNIQUE_GUID_MAPPING", ((StringBuilder)object).toString());
                string = "[Non-Container-Env] " + object;
                AgentLogger.testLogger.trace("{} [Non-Container-Env] 2nd attempt using Hostname. Temp.GUID read variable : {}, value : {}", new Object[]{this.loggerDispStr, object, object2});
            }
            if (object2 != null && object2.length() > 0) {
                this.tempComponentID = object2;
                AgentLogger.testLogger.info("{} Found Temp.Comp.ID - {} from BTM JAR for this component using {}. ", new Object[]{this.loggerDispStr, this.tempComponentID, string});
                this.isTempCompIdFound = true;
                this.storeToDiscoveryRepo(APMComponentIDRepository.getRepository());
                aPMComponent.setAsDiscoverdManagedComponent(true);
            }
            AgentLogger.testLogger.debug("{} Temp.Comp.ID Table :", APMComponentIDRepository.getRepository().getTempComponentIDTable());
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("{} Error while doing the Temp component ID {}", (Object)this.loggerDispStr, (Object)exception);
        }
    }

    protected void getJvmGuid() {
        try {
            if (this.apmComponentGUID == null || this.apmComponentGUID.length() <= 0) {
                AgentLogger.testLogger.info("{} Component GUID is NULL, Trying to read from eg_apmGuid.ini", (Object)this.loggerDispStr);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.componentType);
                stringBuilder.append("^");
                if (this.isContainerHost) {
                    stringBuilder.append(this.strContainerId);
                } else {
                    stringBuilder.append(this.trgtHost);
                }
                stringBuilder.append("^");
                stringBuilder.append(this.reportingName);
                stringBuilder.append("^");
                stringBuilder.append(this.portNo);
                String string = stringBuilder.toString();
                AgentDataContributor agentDataContributor = new AgentDataContributor();
                agentDataContributor.getGUID(true, string);
                this.apmComponentGUID = APMUtils.readJvmGUID(string);
                APMComponentIDRepository aPMComponentIDRepository = APMComponentIDRepository.getRepository();
                APMLanguage aPMLanguage = APMLanguage.JAVA;
                if ("NodeJS".equals(this.componentType)) {
                    aPMLanguage = APMLanguage.NODEJS;
                }
                aPMComponentIDRepository.registerComponent(this.apmComponentGUID, this.entity, this.reportingName, this.trgtHost, this.portNo, this.componentType, aPMLanguage);
                AgentLogger.testLogger.warn("{} INFO:- GUID fetch Key is {}, Component GUID from eg_apmGuid.ini : {} ", new Object[]{this.loggerDispStr, string, this.apmComponentGUID.toString()});
                if (this.entity.equalsIgnoreCase("TransactionFlowTest")) {
                    APMWorkerHelper.getInstance().addNewComponentForAppTierName(this.NodeID, this.componentType);
                    APMUtils.storeGuidWithNick(this.apmComponentGUID, this.NodeID, AgentLogger.testLogger);
                    APMUtils.storeGuidWithIpPort(this.apmComponentGUID, this.trgtHost + ":" + this.portNo, this.reportingName + ":" + this.portNo, AgentLogger.testLogger);
                }
                this.checkTempComponentID();
                if (this.isTempCompIdFound && this.apmComponentGUID != null && this.apmComponentGUID.length() > 0) {
                    this.storeToDiscoveryRepo(aPMComponentIDRepository);
                }
            } else {
                APMComponentIDRepository aPMComponentIDRepository = APMComponentIDRepository.getRepository();
                if (!aPMComponentIDRepository.isSiteIdAvailable(this.apmComponentGUID)) {
                    AgentLogger.testLogger.info("{} Component GUID [{}], not available in the component registry, Re-registering for fail-safe ", (Object)this.loggerDispStr, (Object)this.apmComponentGUID);
                    aPMComponentIDRepository.registerComponent(this.apmComponentGUID, this.entity, this.reportingName, this.trgtHost, this.portNo, this.componentType, APMLanguage.JAVA);
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("{} Unable to get Component GUID {}", (Object)this.loggerDispStr, (Object)exception);
        }
    }

    protected void getJvmGuid(boolean bl) {
        this.getJvmGuid();
        if (this.apmComponentGUID != null && this.apmComponentGUID.length() > 0 && !zipCreated.containsKey(this.NodeID)) {
            BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration = BTMOffloadAPMSocketConfiguration.getBTMOffloadAPMSocketConfiguration("eg_agentTests.ini");
            this.buildBtmZip(bTMOffloadAPMSocketConfiguration);
        }
    }

    private void storeToDiscoveryRepo(APMComponentIDRepository aPMComponentIDRepository) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = "";
        if (this.isContainerHost) {
            stringBuilder.append(this.strContainerId);
            string = "NEWLY_DISCOVERD_DETAILS_CONTAINER_BASED";
        } else {
            string = "NEWLY_DISCOVERD_DETAILS";
            if (this.useReportingName) {
                stringBuilder.append(this.reportingName);
            } else {
                stringBuilder.append(this.trgtHost);
            }
        }
        stringBuilder.append(":");
        stringBuilder.append(this.portNo);
        stringBuilder.append(":");
        stringBuilder.append(this.componentType);
        aPMComponentIDRepository.addToTempComponentRepository(stringBuilder.toString(), this.apmComponentGUID);
        aPMComponentIDRepository.addToTempComponentRepository(this.strContainerId, this.apmComponentGUID);
        aPMComponentIDRepository.addToTempComponentRepository(this.apmComponentGUID, this.tempComponentID);
        aPMComponentIDRepository.addToTempComponentRepository(this.tempComponentID, this.apmComponentGUID);
        stringBuilder2.append(stringBuilder.toString()).append(":").append(this.reportingName);
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
        if (!APMUtils.isDetailsAvailableInFile(iniFile, stringBuilder2.toString(), this.apmComponentGUID, string)) {
            JavaTransactionFlowUtility.storeToIni(string, stringBuilder2.toString(), this.apmComponentGUID);
        }
        this.addDummyHeartBeatForAutoDelete(this.apmComponentGUID);
    }

    private void addDummyHeartBeatForAutoDelete(String string) {
        try {
            String string2 = EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH;
            IniFile iniFile = new IniFile(string2);
            String string3 = iniFile.getValue("LAST_HEART_BEAT_CHECK_TIME", string);
            if (string3 == null || string3 != null && string3.length() == 0) {
                String string4 = System.currentTimeMillis() + "";
                JavaTransactionFlowUtility.addToIniFile(string2, "LAST_HEART_BEAT_CHECK_TIME", string, string4);
                if (ApmConfigManager.getInstance().isSaveDetailsOnTempFile()) {
                    JavaTransactionFlowUtility.addToIniFile(APMCleanUpUtils.getTrashFileName(), "LAST_HEART_BEAT_CHECK_TIME_MANUALLY_ADDED_FOR_AUTO_DELETE", string, string4);
                }
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.debug("{} Exception occurred {} ", (Object)this.loggerDispStr, (Object)exception);
        }
    }

    protected Hashtable getModifiedThresholdPatterns(Hashtable hashtable, Hashtable hashtable2) {
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        AgentLogger.testLogger.debug("{} - getModifiedThresholdPatterns : currentTable: {} \t  previousTable : {} ", new Object[]{this.loggerDispStr, hashtable, hashtable2});
        if (hashtable != null && hashtable.size() > 0) {
            Set set = hashtable.keySet();
            for (String string : set) {
                String string2 = (String)hashtable.get(string);
                if (string.startsWith("+")) {
                    string = string.substring(1);
                }
                if (hashtable2.containsKey(string)) {
                    String string3 = (String)hashtable2.get(string);
                    if (string2.equals(string3)) continue;
                    hashtable2.put(string, string2);
                    hashtable3.put(string, string2);
                    continue;
                }
                hashtable2.put(string, string2);
                hashtable3.put(string, string2);
            }
        }
        return hashtable3;
    }

    protected HashMap getModifiedProps(HashMap hashMap, HashMap hashMap2) {
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        AgentLogger.testLogger.debug("{} - getModifiedThresholdPatterns : currentTable: {} \t  previousTable : {} ", new Object[]{this.loggerDispStr, hashMap, hashMap2});
        if (hashMap != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                String string2 = (String)hashMap.get(string);
                if (hashMap2.containsKey(string)) {
                    String string3 = (String)hashMap2.get(string);
                    if (string2.equals(string3)) continue;
                    hashMap3.put(string, string2);
                    continue;
                }
                hashMap3.put(string, string2);
            }
        }
        return hashMap3;
    }

    protected HashMap updateThresholds(Hashtable hashtable, String string) {
        HashMap<String, String> hashMap = null;
        if (hashtable != null && hashtable.size() > 0) {
            Set set = hashtable.keySet();
            Iterator iterator = set.iterator();
            hashMap = new HashMap<String, String>();
            hashMap.put("Threshold", string);
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = (String)hashtable.get(string2);
                if (string.equalsIgnoreCase("BusinessTransTest")) {
                    hashMap.put("Thresh4B>" + string2, string3);
                    continue;
                }
                if (!string.equalsIgnoreCase("KBusinessTransTest")) continue;
                hashMap.put("Thresh4KB>" + string2, string3);
            }
        }
        return hashMap;
    }

    protected void createBTMJarZipFile(BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration) {
        String string = "_AgentTempBTM###";
        String string2 = EgInstallInfo.getInstallDir() + BTMConstants.apmOffloadFilePathTemp + this.componentIDForFolderName + string;
        String string3 = EgInstallInfo.getInstallDir() + BTMConstants.apmOffloadFolderPath;
        try {
            this.getAgentBoxIpAddress();
            APMFileOperations aPMFileOperations = new APMFileOperations();
            String string4 = EgInstallInfo.getInstallDir() + BTMConstants.apmSrcFilePath;
            String string5 = EgInstallInfo.getInstallDir() + BTMConstants.javaApmSrcZipFilePath;
            aPMFileOperations.unZip(string5, string4);
            if (!aPMFileOperations.isExists(string4)) {
                AgentLogger.testLogger.error("{} {} is empty.", (Object)this.loggerDispStr, (Object)string4);
                return;
            }
            aPMFileOperations.createDirectory(string2);
            String string6 = string3 + this.componentIDForFolderName;
            String string7 = string2 + BTMConstants.apmTempFilePath;
            String string8 = string6 + BTMConstants.fileSeperator + this.componentIDForFolderName + ".zip";
            aPMFileOperations.deleteDirectory(string7);
            File file = new File(string4);
            File file2 = new File(string7);
            aPMFileOperations.copyDirectory(file, file2);
            aPMFileOperations.createFile(string7 + BTMConstants.configFileName);
            aPMFileOperations.createFile(string7 + BTMConstants.thresholdFileName);
            String string9 = string7 + BTMConstants.configFileName;
            this.updateOffloadConfigPropertyFile(string9, bTMOffloadAPMSocketConfiguration);
            String string10 = string7 + BTMConstants.btmOtherPropsFileName;
            this.updateBtmOtherPropertyFile(string10);
            aPMFileOperations.dos2unix(string7 + BTMConstants.dynamicAttachScriptShFileName);
            aPMFileOperations.createDirectory(string6);
            aPMFileOperations.zipDirectory(file2, string8);
            aPMFileOperations.unZip(string8, string6);
            String string11 = string6 + BTMConstants.dynamicAttachScriptShFileName;
            aPMFileOperations.setExecutionPermissionForShFile(string11);
            aPMFileOperations.deleteDirectory(string2);
            AgentLogger.testLogger.debug("{} BTM Jar Directory location :{}", (Object)this.loggerDispStr, (Object)string8);
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error("{} Exception while storing config details for : {} {}", new Object[]{this.loggerDispStr, this.componentIDForFolderName, exception});
        }
    }

    private void updateBtmOtherPropertyFile(String string) {
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(string);
            String string2 = this.agentIpAddress;
            string2 = string2 != null && string2.length() > 0 ? string2 : "127.0.0.1";
            String string3 = this.getValueForParam("BTM_Port");
            propertiesConfiguration.setProperty("BTM_Port", (Object)string3);
            propertiesConfiguration.setProperty("Designated_Agent", (Object)string2);
            propertiesConfiguration.save();
            AgentLogger.testLogger.debug("{} Agent BTM_Port for btmOther.props file : {} ", (Object)this.loggerDispStr, (Object)string3);
            AgentLogger.testLogger.debug("{} Agent Designated_Agent Ip address for btmOther.props file : {} ", (Object)this.loggerDispStr, (Object)string2);
            AgentLogger.testLogger.debug("{} - {} -  updated Successfully!!", (Object)this.loggerDispStr, (Object)propertiesConfiguration.getFileName());
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error("{} Exception Occurred while updateting btmOther.props {} ", (Object)this.loggerDispStr, (Object)exception);
        }
    }

    private void updateOffloadConfigPropertyFile(String string, BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration) {
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(string);
            String string2 = bTMOffloadAPMSocketConfiguration.getOffloadServerSocketIP();
            String string3 = this.agentIpAddress;
            String string4 = string2;
            string3 = string3 != null && string3.length() > 0 ? string3 : string4;
            int n = bTMOffloadAPMSocketConfiguration.getOffloadJavaServerSocketPort();
            int n2 = bTMOffloadAPMSocketConfiguration.getSocketTimeOut();
            String[] stringArray = bTMOffloadAPMSocketConfiguration.getOffloadJavaPortList();
            List<String> list = Arrays.asList(stringArray);
            String string5 = list.toString();
            string5 = string5.substring(1, string5.length() - 1);
            propertiesConfiguration.setProperty("AGENT_IP", (Object)string3);
            propertiesConfiguration.setProperty("AGENT_PORT", (Object)n);
            propertiesConfiguration.setProperty("AGENT_PORT_ORDER", (Object)string5);
            propertiesConfiguration.setProperty("AGENT_SOCKET_TIMEOUT", (Object)n2);
            propertiesConfiguration.setProperty("COMPONENT_GUID", (Object)this.apmComponentGUID);
            propertiesConfiguration.setProperty("NODE_ID", (Object)this.NodeID);
            propertiesConfiguration.setProperty("WRITE_CONFIG_IN_DISK", (Object)"true");
            for (int i = 0; i < offloadPropsOrder.length; ++i) {
                String string6 = offloadPropsOrder[i];
                String string7 = this.getValueForParam(offloadPropsOrder[i]);
                String string8 = (String)MAPPING.get(string6);
                if (string8 == null) {
                    propertiesConfiguration.setProperty(string6, (Object)string7);
                    continue;
                }
                propertiesConfiguration.setProperty(string8, (Object)string7);
            }
            propertiesConfiguration.save();
            AgentLogger.testLogger.debug("{} {} {}-  updated Successfully!!", new Object[]{this.loggerDispStr, propertiesConfiguration.getFileName(), propertiesConfiguration});
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error("{} Exception Occurred while updating Config.props {} ", (Object)this.loggerDispStr, (Object)exception);
        }
    }

    private void getAgentBoxIpAddress() {
        try {
            if (this.meAgentless) {
                String[] stringArray = EgMainAgent.ipAddresses;
                AgentLogger.testLogger.debug("{} ipAddressList[0] :: {} ", (Object)this.loggerDispStr, (Object)stringArray[0]);
                AgentLogger.testLogger.debug("{} Ipv4 ipAddressList :: {} ", (Object)this.loggerDispStr, (Object)this.isValidIPv4Address(stringArray[0]));
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.isValidIPv4Address(stringArray[i])) continue;
                    this.agentIpAddress = stringArray[i];
                    break;
                }
                AgentLogger.testLogger.debug("{} Agent Box ip Address(s) List :: {} ", (Object)this.loggerDispStr, Arrays.asList(stringArray));
            } else {
                this.agentIpAddress = LOCAL_HOST;
            }
            if (this.isContainerHost && SocketIpSelectorUtil.getInstance().isServerSocketIpListening()) {
                this.agentIpAddress = SocketIpSelectorUtil.getInstance().getCurrentListeningIp();
            }
            AgentLogger.testLogger.debug("{} Agent IP Address :: {} ", (Object)this.loggerDispStr, (Object)this.agentIpAddress);
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error("{} Exception  Occurred while getting IP address from Agent Box {}", (Object)this.loggerDispStr, (Object)exception);
        }
    }

    private boolean isValidIPv4Address(String string) {
        if (string == null) {
            return false;
        }
        String string2 = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public Map<String, Boolean> getCauseExceptionTracingTable() {
        return causeExceptionTracingTable;
    }

    public void setCauseExceptionTracingTable(String string, boolean bl) {
        try {
            causeExceptionTracingTable.put(string, bl);
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error(" exception occured while updating exception map table... {} ", (Throwable)exception);
        }
    }

    protected HashMap getAppNameTierNameFromIni(HashMap hashMap) {
        String[] stringArray;
        String string;
        IniFile iniFile;
        String string2;
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        if ((string2 = (iniFile = new IniFile((string = EgInstallInfo.getInstallDir() + BTMConstants.agentConfigPath) + "eg_apm.ini")).getValue("BTM_PROFILER_APPNAME_MAPPING", this.componentType + ":" + this.reportingName + ":" + this.portNo)) != null && string2.length() > 0 && string2.contains(":") && (stringArray = string2.split(":")).length == 2) {
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            if (string3.equalsIgnoreCase("none")) {
                string3 = "MyApp";
            }
            hashMap.put("APPLICATION_NAME", string3);
            this.applicationName = string3;
            if (string4.equalsIgnoreCase("none")) {
                string4 = "MyTier";
            }
            hashMap.put("TIER_NAME", string4);
            this.tierName = string4;
        }
        return hashMap;
    }

    private static void updateStringHashingSettings() {
        String string;
        String string2;
        String string3 = "eg_apm.ini";
        String string4 = EgInstallInfo.getInstallDir() + BTMConstants.agentConfigPath;
        IniFile iniFile = new IniFile(string4 + string3);
        String string5 = iniFile.getValue("DATA_HASHING", "SQL");
        String string6 = iniFile.getValue("DATA_HASHING", "MONGODB");
        String string7 = iniFile.getValue("DATA_HASHING", "EXCEPTION");
        if (string5 != null && string5.equalsIgnoreCase("true")) {
            doSQLStringHashing = true;
        }
        if (string7 != null && string7.equalsIgnoreCase("true")) {
            doExceptionStringHashing = true;
        }
        if (string6 != null && string6.equalsIgnoreCase("true")) {
            doMongoSQLStringHashing = true;
        }
        if ((string2 = iniFile.getValue("DATA_HASHING", "HTTP")) != null && string2.equalsIgnoreCase("true")) {
            doRemoteCallExternal = true;
        }
        if ((string = iniFile.getValue("MISC_OPTIONS", "MAX_STALLED_LIMIT")) != null && string.length() > 0) {
            try {
                long l = Long.parseLong(string);
                if (l > 0L) {
                    noneThresholdTransactionStalledLimit = l * 1000L;
                }
            }
            catch (Exception exception) {
                noneThresholdTransactionStalledLimit = 120000L;
            }
        }
    }

    public boolean doRemoteCallExternalized() {
        return doRemoteCallExternal;
    }

    public boolean doSQLHashing() {
        return doSQLStringHashing;
    }

    public boolean doMongoSQLStringHashing() {
        return doMongoSQLStringHashing;
    }

    public boolean doExceptionHashing() {
        return doExceptionStringHashing;
    }

    protected long getMaxStalledLimit4None() {
        return noneThresholdTransactionStalledLimit;
    }

    public String[] getQueryResult(String string) {
        String[] stringArray = new String[3];
        boolean bl = false;
        if (string == null) {
            stringArray[0] = "-";
            stringArray[1] = "-";
            stringArray[2] = "-";
            return stringArray;
        }
        if (string.startsWith("{")) {
            string = string.substring(string.indexOf("{") + 1, string.lastIndexOf("}"));
            bl = true;
        }
        try {
            List<String> list = QueryMaskHelper.maskAndParseSQL(string);
            if (list != null && list.size() > 0) {
                stringArray[0] = list.get(1);
                stringArray[1] = list.get(0);
                stringArray[1] = stringArray[1].toUpperCase();
                if (this.sqlMaskFlag) {
                    stringArray[2] = list.get(2);
                    if (bl) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("{");
                        stringBuilder.append(stringArray[2]);
                        stringBuilder.append("}");
                        stringArray[2] = stringBuilder.toString();
                        stringArray[1] = "STORED PROCEDURE";
                    }
                } else {
                    stringArray[2] = string;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occurred while parsing SQL");
        }
        return stringArray;
    }

    protected String getMaskedIP(String string) {
        try {
            if (string != null) {
                int n;
                if (string.startsWith("[") && string.endsWith("]")) {
                    n = string.length();
                    string = string.substring(1, n - 1);
                }
                if ((n = IPAddressUtils.isValidPublicIp((String)string, (boolean)false)) != 0 && this.publicIPMaskFlag || n == 0 && this.privateIPMaskFlag) {
                    string = IPAddressMaskHelper.maskIPAddress(string, n == 0, n != 0, this.ipAddressMaskChar);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    protected boolean checkIsIpLocalhost(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(LOCAL_HOST) || string.startsWith("127.") || string.equals("0:0:0:0:0:0:0:1") || string.equals("[0:0:0:0:0:0:0:1]") || string.equals("-");
    }

    protected String getClientIP(String string) {
        String string2 = null;
        try {
            if (string != null) {
                String[] stringArray;
                int n = string.indexOf(",");
                string2 = n > 0 ? ((stringArray = string.split(",")).length > xForwardIndex ? stringArray[xForwardIndex] : stringArray[0]) : string;
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("Exception occured while getting ClientIP ");
        }
        return string2;
    }

    protected String getIpOnly(String string) {
        StringTokenizer stringTokenizer;
        int n;
        int n2;
        String string2 = string;
        if (string != null && (n2 = string.indexOf(".")) > 0 && (n = (stringTokenizer = new StringTokenizer(string, ":")).countTokens()) == 2) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        finalUtcDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        APMBase.updateStringHashingSettings();
        MAPPING.put("Monitoring_Mode", "Monitoring_Mode");
        MAPPING.put("Max_URL_Segments", "Max_URL_Segments");
        MAPPING.put("Excluded_Patterns", "Excluded_Patterns");
        MAPPING.put("Slow_URL_Threshold", "Slow_URL_Threshold");
        MAPPING.put("Stalled_URL_Threshold", "Stalled_URL_Threshold");
        MAPPING.put("Method_Exec_CutOff", "Method_Exec_CutOff");
        MAPPING.put("SQL_Exec_CutOff", "SQL_Exec_CutOff");
        MAPPING.put("Max_Slow_URLs_Per_Test_Period", "Max_Slow_URLs_Per_Test_Period");
        MAPPING.put("Max_Error_URLs_Per_Test_Period", "Max_Error_URLs_Per_Test_Period");
        MAPPING.put("Max_Healthy_URLs_Per_Test_Period", "Max_Healthy_URLs_Per_Test_Period");
        MAPPING.put("Max_Stalled_URLs_Per_Test_Period", "Max_Stalled_URLs_Per_Test_Period");
        MAPPING.put("Healthy_URL_Trace", "Healthy_URL_Trace");
        MAPPING.put("egMeasPeriod", "egMeasPeriod");
        MAPPING.put("Key_Excluded_Patterns", "Manual_Excluded_Patterns");
        MAPPING.put("URL_Patterns", "URL_Patterns");
        MAPPING.put("Key_Max_Grouped_Urls_Per_Measure_Period", "MAX_MANUAL_GROUPED_URLS");
        MAPPING.put("Show_HTTPStatus", "HTTP_STATUS_CODE");
        MAPPING.put("Show_Cookies", "HTTP_COOKIES");
        MAPPING.put("Show_Headers", "HTTP_HEADERS");
        MAPPING.put("Enable_Thread_Cpu_Monitoring", "TRACK_CPU_TIME");
        MAPPING.put("Enable_Thread_Contention_Monitoring", "TRACK_BLOCKED_WAITED_TIME");
        MAPPING.put("Pojo_Method_Tracing_Limit", "MAX_POJO_CALL_TRACE_COUNT");
        MAPPING.put("Pojo_Method_Tracing_Cutoff_Time", "MAX_POJO_CALL_TRACE_TIME");
        MAPPING.put("Recursive_Method_Tracing_Limit", "RECURSION_TRACE_LIMIT");
        MAPPING.put("Non-Pojo_Method_Tracing_Limit", "MAX_POINTCUT_LIMIT");
        MAPPING.put("Exception_Stacktrace_Lines", "MAX_EXCEPTION_TRACE_LINE_COUNT");
        MAPPING.put("Included_Exceptions", "INCLUDE_EXCEPTIONS");
        MAPPING.put("Ignored_Exceptions", "IGNORE_EXCEPTIONS");
        MAPPING.put("Ignored_Characters", "Chars_TO_Exclude");
        MAPPING.put("Max_Grouped_Urls_Per_Measure_Period", "MAX_AUTO_GROUPED_URLS");
        MAPPING.put("Max_Sql_Queries_Per_Transaction", "MAX_SQL_QUERY_COUNT");
        MAPPING.put("Max_Mongodb_Query_Length", "MAX_MONGODB_QUERY_LENGTH");
        MAPPING.put("Max_Sql_Error_Queries_Per_Transaction", "MAX_SQL_ERROR_QUERY_COUNT");
        MAPPING.put("Exception_With_StackTrace_Capture_Limit", "MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT");
        MAPPING.put("Exception_FQEN_Capture_Limit", "MAX_EXCE_FQEN_CAPTURE_LIMIT");
        MAPPING.put("Max_Exception_Trace_Limit", "MAX_EXCE_TRACE_COUNT_LIMIT");
        try {
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_apm.ini");
            String string = iniFile.getValue("APM_MISC", "Index_Position_Of_IP_To_Be_Considered");
            if (string != null) {
                xForwardIndex = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.warn("Exception occured while getting xForwardIndex value from INI file ");
        }
    }
}

