/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.ibm.jtopenlite.command.CommandConnection;
import com.ibm.jtopenlite.components.JobInfo;
import com.ibm.jtopenlite.components.ListActiveJobs;
import com.ibm.jtopenlite.ddm.DDMConnection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;

public class AS400JobStatTest
extends GenericTest {
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String TEST_NAME = "AS400JobStatTest";
    protected static final String LOG_FILE_NAME = "AS400JobStatTestLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "AS400JobStatTestLogSizeLimitInMB";
    protected static final String DEBUG_LOG_ABSOLUTE_PATH = EgInstallInfo.getInstallDir() + "/agent/logs/" + "AS400JobStatTestLog";
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 5.0;
    protected double debugLogSizeLimitInMB;
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String BYTES = "BYTES";
    protected static final String DEBUG_COMPUTE_MEASURE_METHOD_NAME = "[debugComputeMeasures] :";
    protected static final String OUTPUT_NULL_OR_EMPTY_INFO_MESSAGE = "command output null or size is zero or empty for ";
    protected static final String RETURNING_INFO_MESSAGE = ",So returning";
    private static final String JSON_OBJECT_PARSING_EXCEPTION_MESSAGE = "JSONException while parsing JSONObjects :";
    private static String logMessage = "";
    protected static String fieldSep = new String("");
    protected static String sync0 = new String("x");
    private static final String def_IdleTimeout = "120";
    protected long collectionTimeout;
    protected String serverName;
    protected String userName;
    protected String userPwd;
    protected String jobExceedPct;
    protected static Hashtable jobStatsHash_DD = new Hashtable();

    public static void main(String[] stringArray) {
        AS400JobStatTest aS400JobStatTest = new AS400JobStatTest(stringArray);
        try {
            aS400JobStatTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            aS400JobStatTest.printOutStackTrace("[main()] Occure error while collect data in Executor class :", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AS400JobStatTest(String[] stringArray) {
        block25: {
            super(stringArray);
            this.debugLogSizeLimitInMB = 5242880.0;
            this.collectionTimeout = 120L;
            this.serverName = "";
            this.userName = "";
            this.userPwd = "";
            this.jobExceedPct = "";
            String string = this.methodNameTemplate(TEST_NAME);
            this.printOut(string + "Constructor method called. Start get arguments");
            try {
                String string2;
                this.serverName = this.getValueForParam("servername");
                if (this.serverName == null || this.serverName.trim().length() == 0 || this.serverName.equalsIgnoreCase("NULL") || this.serverName.equalsIgnoreCase("NONE")) {
                    logMessage = string + "serverName is null or empty.  ";
                    this.printOut(logMessage);
                } else {
                    logMessage = string + "serverName : " + this.serverName;
                    this.printOut(logMessage);
                }
                this.userName = this.getValueForParam("username");
                if (this.userName == null || this.userName.trim().length() == 0 || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("NONE")) {
                    logMessage = string + "userName is null or empty.  ";
                    this.printOut(logMessage);
                } else {
                    logMessage = string + "userName : " + this.userName;
                    this.printOut(logMessage);
                }
                this.userPwd = this.getValueForParam("password");
                if (this.userPwd == null || this.userPwd.trim().length() == 0 || this.userPwd.equalsIgnoreCase("NULL") || this.userPwd.equalsIgnoreCase("NONE")) {
                    logMessage = string + "userPwd is null or empty.  ";
                    this.printOut(logMessage);
                } else {
                    this.userPwd = EgCrypt.decrypt(this.userPwd);
                    logMessage = string + "userPwd : ***********";
                    this.printOut(logMessage);
                }
                this.jobExceedPct = this.getValueForParam("job_exceeded_percent");
                if (this.jobExceedPct == null || this.jobExceedPct.trim().length() == 0 || this.jobExceedPct.equalsIgnoreCase("NULL") || this.jobExceedPct.equalsIgnoreCase("NONE")) {
                    logMessage = string + "jobExceedPct is null or empty. set default 0 like LCKW_0,MSGW_0 ";
                    this.printOut(logMessage);
                    this.jobExceedPct = "LCKW_0,MSGW_0";
                } else {
                    logMessage = string + "jobExceedPct : " + this.jobExceedPct;
                    this.printOut(logMessage);
                }
                IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
                String string3 = iniFile.getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
                if (string3 != null && string3.length() > 0) {
                    string3 = string3.trim();
                    try {
                        this.debugLogSizeLimitInMB = Double.parseDouble(string3);
                        this.debugLogSizeLimitInMB *= 1048576.0;
                        this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                    }
                    catch (Exception exception) {
                        this.printOutStackTrace(string + "Conversion error for strLogSizeLimitInMB value to bytes", exception);
                        this.debugLogSizeLimitInMB = 5242880.0;
                    }
                } else {
                    this.debugLogSizeLimitInMB = 5242880.0;
                }
                if ((string2 = this.getValueForParam("timeout_seconds")) != null && string2.trim().length() > 0) {
                    logMessage = string + "Timeout string value in constructor : " + string2;
                    this.printOut(logMessage);
                    logMessage = "";
                    try {
                        this.collectionTimeout = Long.parseLong(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            this.collectionTimeout = Long.parseLong(def_IdleTimeout);
                        }
                        catch (NumberFormatException numberFormatException2) {}
                    }
                } else {
                    logMessage = string + "Timeout value not provided by parameter ,so assigning default value : " + this.collectionTimeout;
                    this.printOut(logMessage);
                    logMessage = "";
                }
                if (fieldSep.length() != 0) break block25;
                String string4 = sync0;
                synchronized (string4) {
                    if (fieldSep.length() == 0) {
                        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                        fieldSep = egTesterInfo.getDDSeparator1();
                    }
                }
            }
            catch (Exception exception) {
                this.printOutStackTrace(string + "Occurred Exception while get arguments ", exception);
            }
        }
        this.setMeasureCount(5);
        this.setConfigInfoTestFlag(true);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        String string = this.methodNameTemplate("debugComputeMeasures");
        try {
            Hashtable hashtable2 = this.collectDataFromIBM();
            this.printOut(string + " measureData : " + hashtable2);
            Set set = hashtable2.keySet();
            for (String string2 : set) {
                Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
                ArrayList arrayList = (ArrayList)hashtable3.get("measureArr");
                this.printOut(string + " ============== [AS400 Job Status metric data] ==============");
                this.printOut(string + " [Job Status Metric] descriptor \t: " + string2 + " , measureArr : " + arrayList);
                ArrayList arrayList2 = (ArrayList)hashtable3.get("totalJobCnt_DD");
                ArrayList arrayList3 = (ArrayList)hashtable3.get("totalExceedCnt_DD");
                Hashtable<String, ArrayList> hashtable4 = new Hashtable<String, ArrayList>();
                hashtable4.put("totalJobCnt", arrayList2);
                hashtable4.put("totalExceedCnt", arrayList3);
                jobStatsHash_DD.put(string2, hashtable4);
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while getting measures from IBM { collectDataFromIBM() } ", exception);
        }
    }

    protected CommandConnection getCmdConnection() {
        String string = this.methodNameTemplate("getCmdConnection");
        CommandConnection commandConnection = null;
        try {
            commandConnection = CommandConnection.getConnection((String)this.serverName, (String)this.userName, (String)this.userPwd);
            this.printOut(string + " command connection successful.");
            return commandConnection;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while get Connection for command execute ", exception);
            return null;
        }
    }

    protected DDMConnection getDDMConnection() {
        String string = this.methodNameTemplate("getDDMConnection");
        DDMConnection dDMConnection = null;
        try {
            dDMConnection = DDMConnection.getConnection((String)this.serverName, (String)this.userName, (String)this.userPwd);
            this.printOut(string + " DDM connection successful.");
            return dDMConnection;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while get DDM(Distributed Data Management) Connection ", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable collectDataFromIBM() {
        String string = this.methodNameTemplate("collectDataFromIBMDB2");
        CommandConnection commandConnection = this.getCmdConnection();
        DDMConnection dDMConnection = this.getDDMConnection();
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = this.getWRKACTJOBdata(commandConnection);
            dDMConnection.close();
            commandConnection.close();
            dDMConnection = null;
            commandConnection = null;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while collect Data From IBM ", exception);
        }
        finally {
            try {
                if (dDMConnection != null) {
                    dDMConnection.close();
                    dDMConnection = null;
                    this.printOut(string + " [ collectDataFromIBM() ] : finally { ddmConnection() } closed.");
                }
                if (commandConnection != null) {
                    commandConnection.close();
                    commandConnection = null;
                    this.printOut(string + " [ collectDataFromIBM() ] : finally { commandConnection() } closed.");
                }
            }
            catch (IOException iOException) {
                this.printOutStackTrace(string + "Occurred Exception while close ddmConnection and commandConnection ", iOException);
            }
        }
        return hashtable;
    }

    protected Hashtable getWRKACTJOBdata(CommandConnection commandConnection) {
        String string = this.methodNameTemplate("getWRKACTJOBdata");
        Hashtable hashtable = new Hashtable();
        ArrayList<JobInfo> arrayList = new ArrayList<JobInfo>();
        ArrayList<JobInfo> arrayList2 = new ArrayList<JobInfo>();
        try {
            Object object;
            ListActiveJobs listActiveJobs = new ListActiveJobs();
            JobInfo[] jobInfoArray = listActiveJobs.getJobs(commandConnection, false);
            this.printOut(string + " actJobsStrArr.length : " + jobInfoArray.length);
            if (jobInfoArray.length <= 0) {
                this.printOut(string + " JobInfo[] data is null..... please check parameters like userName, userPwd, serverName.");
                this.printOut(string + " Data classifying for loop will pass.");
            }
            for (int i = 0; i < jobInfoArray.length; ++i) {
                object = jobInfoArray[i];
                if (!object.getStatus().trim().equalsIgnoreCase("LCKW") && !object.getStatus().trim().equalsIgnoreCase("MSGW")) continue;
                this.printOut(string + " This Job is " + object.getStatus().trim() + " status .... .... ....");
                this.printOut(string + " ActiveJob [ " + i + " ] : " + object.toString());
                String string2 = object.getStatus().trim();
                if (string2.equalsIgnoreCase("LCKW")) {
                    arrayList.add((JobInfo)object);
                    continue;
                }
                arrayList2.add((JobInfo)object);
            }
            Hashtable hashtable2 = this.parseWRKACTJOBdata("LCKW", arrayList);
            object = this.parseWRKACTJOBdata("MSGW", arrayList2);
            this.printOut(string + " ============== [Common metric data] ==============");
            this.printOut(string + " [LCKW Job Metric] lckwJobInfoHT \t: " + hashtable2);
            this.printOut(string + " [MSGW Job Metric] msgwJobInfoHT \t: " + object);
            hashtable = this.mergeHashtable(hashtable, hashtable2);
            hashtable = this.mergeHashtable(hashtable, (Hashtable)object);
            this.printOut(string + " [All Job Metric] measureData\t: " + hashtable);
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while get AS400 WRKACTJOB command output/metrics(JobInfo Object). ", exception);
            return null;
        }
        return hashtable;
    }

    protected Hashtable parseWRKACTJOBdata(String string, ArrayList arrayList) {
        double d;
        Object object;
        String[] stringArray;
        Object object2;
        String string2 = this.methodNameTemplate("parseWRKACTJOBdata");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<String[]> arrayList3 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList4 = new ArrayList<String[]>();
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        ArrayList<Double> arrayList5 = new ArrayList<Double>();
        try {
            if (this.jobExceedPct.contains(",") && this.jobExceedPct.contains("_")) {
                object2 = this.jobExceedPct.split(",");
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    stringArray = object2[i];
                    object = stringArray.split("_");
                    d = this.convertStrToDouble(object[1]);
                    hashtable2.put(object[0], new Double(d));
                }
                this.printOut(string2 + " [value-set] jobExceedBaseHT : " + hashtable2);
            } else {
                this.printOut(string2 + " jobExceedPct has not contains , and _ . please check parameters. this method will gerate default value (0) ");
                hashtable2.put("LCKW", new Double(0.0));
                hashtable2.put("MSGW", new Double(0.0));
                this.printOut(string2 + " [default-set] jobExceedBaseHT : " + hashtable2);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string2 + "Occurred Exception while parsing jobExceedPct to Hashtable ", exception);
            hashtable2.put("LCKW", new Double(0.0));
            hashtable2.put("MSGW", new Double(0.0));
        }
        try {
            double d2;
            double d3;
            double d4;
            double d5;
            if (arrayList != null && !arrayList.isEmpty() && arrayList.size() > 0) {
                this.printOut(string2 + " jobInfoArr is not null. Start data parsing and set Measure/DD data ");
                for (int i = 0; i < arrayList.size(); ++i) {
                    JobInfo jobInfo = (JobInfo)arrayList.get(i);
                    stringArray = new String[]{jobInfo.getSubsystem().trim(), jobInfo.getCurrentUser().trim(), jobInfo.getJobType().trim(), jobInfo.getCPUPercent() + "".trim(), jobInfo.getFunction().trim(), jobInfo.getStatus().trim()};
                    object = "";
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string3 = "";
                        string3 = stringArray[j].trim().length() > 0 && !stringArray[j].trim().equalsIgnoreCase("") && stringArray[j].trim() != "" && stringArray[j].trim() != null ? stringArray[j].trim() : "-";
                        object = j == 0 ? string3 : (String)object + fieldSep + string3;
                    }
                    this.printOut(string2 + " ddLine : " + (String)object);
                    arrayList3.add((String[])object);
                    d = this.convertStrToDouble(hashtable2.get(string) + "");
                    d5 = Double.parseDouble(jobInfo.getCPUPercent() + "");
                    this.printOut(string2 + " exceedThrd : " + d + " , cpuUsagePct : " + d5);
                    this.printOut(string2 + " [cpuUsagePct > exceedThr] ? " + (d5 > d));
                    if (d5 > d) {
                        arrayList4.add((String[])object);
                    }
                    d4 = jobInfo.getCPUPercent();
                    arrayList5.add(new Double(d4));
                }
                d3 = arrayList3.size();
                d2 = 0.0;
                for (int i = 0; i < arrayList5.size(); ++i) {
                    double d6 = Double.parseDouble(arrayList5.get(i).toString());
                    d2 += d6;
                }
            } else {
                this.printOut(string2 + " jobInfoArr is null. return default Hashtable that 0 ArrayList for measure and there is no DD");
                object2 = new Hashtable();
                arrayList2.add(new Double(0.0));
                arrayList2.add(new Double(0.0));
                arrayList2.add(new Double(0.0));
                arrayList2.add(new Double(0.0));
                arrayList2.add(new Double(0.0));
                ((Hashtable)object2).put("measureArr", arrayList2);
                ((Hashtable)object2).put("totalJobCnt_DD", new ArrayList());
                ((Hashtable)object2).put("totalExceedCnt_DD", new ArrayList());
                this.printOut(string2 + " [Temp Metric] tempHash \t\t\t: " + object2);
                hashtable.put(string, object2);
                this.printOut(string2 + " [Final Metric] measureData \t\t: " + hashtable);
                return hashtable;
            }
            double d7 = d2 / d3;
            d5 = Double.parseDouble(Collections.max(arrayList5).toString());
            d4 = Double.parseDouble(Collections.min(arrayList5).toString());
            double d8 = arrayList4.size();
            arrayList2.add(new Double(d3));
            arrayList2.add(new Double(d7));
            arrayList2.add(new Double(d5));
            arrayList2.add(new Double(d4));
            arrayList2.add(new Double(d8));
            this.printOut(string2 + " ============== [Common metric data] ==============");
            this.printOut(string2 + " [Common Metric] measureArr \t\t\t: " + arrayList2);
            this.printOut(string2 + " [Common Metric] totalJobCnt_DD \t\t: " + arrayList3);
            this.printOut(string2 + " [Common Metric] totalExceedCnt_DD \t: " + arrayList4);
            Hashtable<String, ArrayList<Object>> hashtable3 = new Hashtable<String, ArrayList<Object>>();
            hashtable3.put("measureArr", arrayList2);
            hashtable3.put("totalJobCnt_DD", arrayList3);
            hashtable3.put("totalExceedCnt_DD", arrayList4);
            this.printOut(string2 + " [Temp Metric] tempHash \t\t\t: " + hashtable3);
            hashtable.put(string, hashtable3);
            this.printOut(string2 + " [Final Metric] measureData \t\t: " + hashtable);
        }
        catch (Exception exception) {
            this.printOutStackTrace(string2 + "Occurred Exception while parsing AS400 WRKACTJOB command output/metrics(JobInfo Object). ", exception);
        }
        return hashtable;
    }

    protected Hashtable mergeHashtable(Hashtable hashtable, Hashtable hashtable2) {
        String string = "mergeHashtable";
        string = this.methodNameTemplate(string);
        try {
            if (hashtable != null && !hashtable.isEmpty() && hashtable.size() > 0) {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object v = hashtable2.get(k);
                    if (v == null) continue;
                    hashtable.put(k, v);
                }
            } else if (hashtable2 != null && !hashtable2.isEmpty() && hashtable2.size() > 0) {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object v = hashtable2.get(k);
                    hashtable.put(k, v);
                }
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + " Occurred exception while merget two Hashtable in " + string + " method. ", exception);
            return hashtable2;
        }
        return hashtable;
    }

    protected double convertStrToDouble(String string) {
        String string2 = this.methodNameTemplate("convertStrToDouble");
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            logMessage = string2 + " Occurred error while parsing String to Double using Double.parseDouble(). set 0.0 as default";
            this.printOutStackTrace(logMessage, exception);
            logMessage = "";
            d = 0.0;
        }
        return d;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            AS400JobStatTest.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AS400JobStatTest.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AS400JobStatTest.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AS400JobStatTest.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_ABSOLUTE_PATH;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            AS400JobStatTest.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    protected boolean isStringNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase("NULL") || string.equalsIgnoreCase("NONE");
    }
}

