/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgTesterInfo;
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class ApigeeEdgeValidator
extends EgServerValidator {
    protected String host = "";
    protected String port = "";
    protected String username = "";
    protected String password = "";
    protected String reportingName = "";
    protected String entity = null;
    protected String measurePeriodInSec = "";
    protected String useSSLStr = "";
    protected String logSizeInMB = "";
    protected String logMessage = null;
    protected String organizations = null;
    protected String environments = null;
    String javaOptions = "java";
    String heapDumpPath = null;
    private long collectionTimeout;
    private static final long collectionTimeout_Chk = 50L;
    public boolean meAgentLess = false;
    public boolean isFromManager = false;
    protected static String fieldSep = new String("");
    protected static String sync0 = new String("x");
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    protected static final String DEBUG = "DEBUG";
    protected static final String INFO = "INFO";
    protected static final String WARNING = "WARNING";
    protected static final String ERROR = "ERROR";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final String TEST_NAME = "ApigeeEdgeValidator";
    protected static final String LOG_FILE_NAME = "ApigeeEdgeValidatorLog";
    protected static final String DEBUG_LOG_ABSOLUTE_PATH = EgInstallInfo.getInstallDir() + "/agent/logs/" + "ApigeeEdgeValidatorLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "ApigeeEdgeValidatorLogSizeLimitInMB";
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 5.0;
    protected double debugLogSizeLimitInMB = 5242880.0;
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String BASE_REST_EXECUTOR_CLASS = SPACE + "ApigeeEdgeValidator" + "RESTExecutor" + SPACE;
    private static final int j = 124;
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public int code = 0;
    String className = this.getClass().getName();
    EgUtilities egutil = EgUtilities.createInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApigeeEdgeValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        Object object;
        Object object2;
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            object2 = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
            object = ((IniFile)object2).getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
            if (object != null && ((String)object).length() > 0) {
                object = ((String)object).trim();
                try {
                    this.debugLogSizeLimitInMB = Double.parseDouble((String)object);
                    this.debugLogSizeLimitInMB *= 1048576.0;
                    this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                }
                catch (Exception exception) {
                    this.printOut(string + "Conversion error for strLogSizeLimitInMB value to bytes : " + (String)object + " ,exception :" + exception.toString());
                    this.debugLogSizeLimitInMB = 5242880.0;
                }
            } else {
                this.debugLogSizeLimitInMB = 5242880.0;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                String string3 = stringArray[i];
                String string4 = string3.substring(0, string3.indexOf(":"));
                String string5 = string3.substring(string3.indexOf(":") + 1);
                if ((string4 = string4.trim()) != null && string4.equalsIgnoreCase("-host")) {
                    this.host = string5.trim();
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-port")) {
                    if (this.port != null && this.port.trim().length() != 0 && !this.port.equalsIgnoreCase(NULL) && !this.port.equalsIgnoreCase(NONE)) continue;
                    this.port = string5.trim();
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-username")) {
                    this.username = string5.trim();
                    if (this.username == null || this.username.trim().length() == 0 || this.username.equalsIgnoreCase(NULL) || this.username.equalsIgnoreCase(NONE)) {
                        this.logMessage = string + "APIGEE REST API User name is null or empty ";
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.logMessage = string + "APIGEE REST API User name :" + this.username;
                    this.printOut(this.logMessage);
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-password")) {
                    if ((string5 = EgCrypt.decrypt(string5)).indexOf("~EG~") != -1) {
                        string5 = string5.substring(0, string5.indexOf("~EG~"));
                    }
                    this.password = string5;
                    if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase(NULL) || this.password.equalsIgnoreCase(NONE)) {
                        this.logMessage = string + "APIGEE REST API password is null or empty ";
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.logMessage = string + "APIGEE REST API Password  :*******";
                    this.printOut(this.logMessage);
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-reportingName")) {
                    this.reportingName = string5.trim();
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-ssl")) {
                    this.useSSLStr = string5.trim();
                    if (this.useSSLStr != null && (this.useSSLStr.equalsIgnoreCase("true") || this.useSSLStr.equalsIgnoreCase("yes") || this.useSSLStr.equalsIgnoreCase("y"))) {
                        this.useSSLStr = "yes";
                        this.printOut(string + "Transport type is HTTPS");
                        continue;
                    }
                    this.useSSLStr = "no";
                    this.printOut(string + "Transport type is HTTP");
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-mea_period_in_sec")) {
                    this.measurePeriodInSec = string5.trim();
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-organizations")) {
                    this.organizations = string5.trim();
                    if (this.organizations == null || this.organizations.trim().length() == 0 || this.organizations.equalsIgnoreCase(NULL) || this.organizations.equalsIgnoreCase(NONE)) {
                        this.logMessage = string + "Organizations is null or empty ";
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.logMessage = string + "Organizations :" + this.organizations;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (string4 != null && string4.equalsIgnoreCase("-environments")) {
                    this.environments = string5.trim();
                    if (this.environments == null || this.environments.trim().length() == 0 || this.environments.equalsIgnoreCase(NULL) || this.environments.equalsIgnoreCase(NONE)) {
                        this.environments = "test";
                        this.logMessage = string + "Environments is null or empty ,so assinging default value as \"prod\" ";
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.logMessage = string + "Environments :" + this.environments;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if ((string4 == null || !string4.equalsIgnoreCase("-timeout_seconds")) && !string4.equalsIgnoreCase("-timeout") || (string2 = string5.trim()) == null || string2.trim().length() == 0 || string2.equalsIgnoreCase(NONE) || string2.equalsIgnoreCase(NULL)) continue;
                this.printOut(string + "Timeout string is " + string2);
                if (string2 == null || string2.equals("120")) continue;
                try {
                    this.collectionTimeout = Integer.parseInt(string2);
                    this.collectionTimeout *= 1000L;
                    this.printOut(string + "Timeout in Milliseconds is " + this.collectionTimeout);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.printOut(string + "Could not parse specified timeout " + string2 + ". Using 120 seconds");
                    this.collectionTimeout = 120000L;
                }
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
        this.entity = this.className;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
        this.printOut(string + "collectionTimeout is " + this.collectionTimeout + " and collectionTimeout_Chk is " + 50L);
        if (fieldSep.length() == 0) {
            object2 = sync0;
            synchronized (object2) {
                if (fieldSep.length() == 0) {
                    object = new EgTesterInfo("agent");
                    fieldSep = ((EgTesterInfo)object).getDDSeparator1();
                }
            }
        }
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "*******************************************************************************");
        this.printOut(string + "APIGEE host       :" + this.host);
        this.printOut(string + "APIGEE port       :" + this.port);
        this.printOut(string + "APIGEE username   :" + this.username);
        this.printOut(string + "APIGEE password   :**********");
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        int n = 0;
        if (!this.isIPReachable()) {
            this.validationMsgs.add(0, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
            this.validationMsgs.add(1, "Port$#$NA");
        } else if (!this.isSpecificPortReachable(this.port)) {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$Port " + this.port + " is down or listener is down");
        } else {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$OK");
            this.username = this.username.trim();
            this.password = this.password.trim();
            if (this.username.isEmpty() || this.username.length() == 0 || this.username.equalsIgnoreCase(null) || this.password.isEmpty() || this.password.length() == 0 || this.password.equalsIgnoreCase(null)) {
                this.validationMsgs.add("User/Password$#$Please provide valid Username/Password");
                return;
            }
            n = this.getJSONDataFromExe();
            this.checkAPIGEEConnectivity(n);
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    public void checkAPIGEEConnectivity(int n) {
        String string = "checkAPIGEEConnectivity";
        string = this.methodNameTemplate(string);
        int n2 = n;
        this.printOut(string + "Response code :" + n2);
        if (n2 == 200) {
            this.validationErrorMsg = "code 200 - Server is running normal";
            this.validationMsgs.add("User/Password$#$OK");
            this.validationMsgs.add("APIGEE Server Connectivity$#$OK");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 500) {
            this.validationErrorMsg = "Error 500 - No Response from server due to internal server error";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("APIGEE Server Connectivity$#$No Response from server due to internal server error");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 404) {
            this.validationErrorMsg = "Error 404 - No Response from server";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("APIGEE Server Connectivity$#$No Response from server");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 503) {
            this.validationErrorMsg = "Error 503 - The server is currently unavailable or not started";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("APIGEE Server Connectivity$#$The server is currently unavailable or not started");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else if (n2 == 401) {
            this.validationErrorMsg = "Error 401 - Unauthorized: Access is denied due to invalid credentials";
            this.validationMsgs.add("User/Password$$#$ Access denied. Please check Username/Password");
            this.printOut(string + "Added Validation Messages for Response Code :" + n2);
        } else {
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("APIGEE Server Connectivity$#$Connectivity Error.");
            this.printOut(string + "Executional error occured for Response Code :" + n2);
        }
    }

    public int getJSONDataFromExe() {
        String string;
        String string2;
        Object object;
        String string3 = "getJSONDataFromExe";
        string3 = this.methodNameTemplate(string3);
        int n = 0;
        String string4 = NONE;
        String string5 = "getJSONDataFromURL";
        double d = 0.0;
        this.heapDumpPath = null;
        this.javaOptions = "java";
        try {
            object = System.getProperty("os.name");
            string2 = System.getProperty("java.version");
            string = System.getProperty("os.arch");
            if (string2.compareTo("10.0") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                }
                this.printOut(string3 + "javaVersion 10.0 HeapDumpPath :" + this.heapDumpPath);
            } else if (string2.compareTo("1.7") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                }
                this.printOut(string3 + "javaVersion 1.7  HeapDumpPath :" + this.heapDumpPath);
            } else if (string2.compareTo("1.6") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL";
                }
                this.printOut(string3 + "javaVersion 1.6 HeapDumpPath :" + this.heapDumpPath);
            }
            if (this.heapDumpPath != null) {
                this.printOut(string3 + " HeapDumpPath :" + this.heapDumpPath);
                this.javaOptions = this.javaOptions + " " + this.heapDumpPath;
                this.printOut(string3 + " HeapDumpPath :" + this.heapDumpPath + " java options : " + this.javaOptions);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string3 + "Error while set the heapDumpPath to call rexec process  :", exception);
        }
        this.printOut(string3 + " javaOptions " + this.javaOptions);
        object = new ArrayList();
        string2 = " -host " + this.host + " -port " + this.port + " -username " + this.username + " -password " + this.password + " -ssl " + this.useSSLStr + " -organizations " + this.organizations + " -environments " + this.environments + " -timeout " + this.collectionTimeout + " -reportingName " + this.reportingName + " -entity " + this.entity + " -log_size " + this.debugLogSizeLimitInMB + " -mea_period_in_sec " + d + " -method " + string5 + " -uri " + string4;
        string = "";
        String string6 = "";
        boolean bl = false;
        String string7 = "";
        try {
            boolean bl2;
            String string8 = System.getProperty("os.name").toLowerCase();
            boolean bl3 = bl2 = System.getProperty("java.version").compareTo("1.5") > 0;
            if (string8.indexOf("win") >= 0) {
                bl = true;
            }
            if (bl) {
                string6 = EgInstallInfo.getInstallDir() + "\\jre\\bin\\";
                string7 = EgInstallInfo.getInstallDir() + "\\lib\\eg_agent.jar;" + EgInstallInfo.getInstallDir() + "\\lib\\eg_util.jar;" + EgInstallInfo.getInstallDir() + "\\lib\\commons-codec.jar;" + EgInstallInfo.getInstallDir() + "\\agent\\lib\\json-simple-1.1.1.jar";
                string = bl2 ? "cmd.exe /c " + string6 + this.javaOptions + " -client -cp \"" + string7 + "\"" + BASE_REST_EXECUTOR_CLASS + string2 : "cmd.exe /c " + string6 + this.javaOptions + " -cp \"" + string7 + "\"" + BASE_REST_EXECUTOR_CLASS + string2;
            } else if (string8.indexOf("aix") >= 0) {
                string7 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string = "/opt/egurkha/jre/bin/" + this.javaOptions + " -cp " + string7 + BASE_REST_EXECUTOR_CLASS + string2;
            } else if (bl2) {
                string7 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string = "/opt/egurkha/jre/bin/" + this.javaOptions + " -client -cp " + string7 + BASE_REST_EXECUTOR_CLASS + string2;
            } else {
                string7 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string = "/opt/egurkha/jre/bin/" + this.javaOptions + " -cp " + string7 + BASE_REST_EXECUTOR_CLASS + string2;
            }
            this.printOut(string3 + "Inside execute program " + string);
            this.printOut(string3 + "Going to call getExecOutputLines to execute" + BASE_REST_EXECUTOR_CLASS);
            ArrayList arrayList = this.egutil.getExecOutputLines(string);
            this.printOut(string3 + "Completed  getExecOutputLines method call for" + BASE_REST_EXECUTOR_CLASS);
            if (arrayList == null || arrayList.size() < 2) {
                this.logMessage = string3 + "Rexec process returned null or some exception " + arrayList;
                this.printOut(this.logMessage);
                this.logMessage = "";
            } else {
                this.logMessage = string3 + "Rexec process returned Values  :" + arrayList;
                this.printOut(this.logMessage);
                this.logMessage = "";
                object = (ArrayList)arrayList.clone();
                String string9 = ((ArrayList)object).get(0).toString();
                this.printOut(string3 + "Response Value from exe :" + string9);
                if (string9.equalsIgnoreCase(null) || string9.length() > 0) {
                    String string10 = string9.substring(string9.indexOf(":") + 1, string9.indexOf("]"));
                    try {
                        n = Integer.parseInt(string10);
                    }
                    catch (Exception exception) {
                        this.logMessage = "Error occured while parsing String to Integer";
                        this.printOutStackTrace(this.logMessage, exception);
                        this.logMessage = "";
                        n = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.printOut(string3 + "Error while rexec process :" + exception);
        }
        return n;
    }

    public String decrypt(String string) {
        int n;
        if (string != null && string.length() < 2) {
            return string;
        }
        if (string != null && string.indexOf(":") == -1) {
            return string;
        }
        ArrayList arrayList = this.myTokenizer(string, ":");
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n2 = n = arrayList.size();
        byte[] byArray = new byte[n];
        String string2 = null;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayList.get(i);
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return string;
            }
            int n5 = 124 - n4 + n3 * 3;
            --n3;
            byArray[--n] = (byte)n5;
        }
        String string3 = new String(byArray);
        return string3;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            ApigeeEdgeValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            ApigeeEdgeValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            ApigeeEdgeValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            ApigeeEdgeValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_ABSOLUTE_PATH;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            ApigeeEdgeValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        ApigeeEdgeValidator apigeeEdgeValidator = new ApigeeEdgeValidator(stringArray, new Boolean(false));
        apigeeEdgeValidator.getValidationMsgs();
    }
}

