/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.Base64;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

class BitBuktPipeTest
extends GenericTest {
    protected static final String DEFAULT_SERVICE_URL = "https://api.bitbucket.org/";
    protected static String bitBucketVersion = "2.0";
    protected static String resourcePath = "/repositories/";
    protected static String pipelinepath = "/pipelines/";
    protected static String pagelength = "?pagelen=100";
    protected static String page = "&page=";
    public Hashtable successhash = new Hashtable();
    public Hashtable failedhash = new Hashtable();
    public Hashtable pendinghash = new Hashtable();
    public Hashtable haltedhash = new Hashtable();
    public Hashtable stoppedhash = new Hashtable();
    JSONObject resultObj = null;
    private String user = "";
    private String password = "";
    private String excluded_repositories = "none";
    private String encodedAuth = "";
    private String targetHost = "";
    Long buildnumber = 0L;
    String pipebuildTime = "";
    String commitid = "";
    String commitmessg = "";
    protected ArrayList excludedRepos_al = new ArrayList();

    public BitBuktPipeTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            this.user = this.getValueForParam("Username");
            this.password = this.getValueForParam("password");
            this.excluded_repositories = this.getValueForParam("excluded_repositories");
            this.encodedAuth = new String(Base64.encode((String)(this.user + ":" + this.password)));
            if (this.excluded_repositories != null && !this.excluded_repositories.trim().equalsIgnoreCase("none")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.excluded_repositories, ",");
                this.excludedRepos_al = new ArrayList();
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    this.excludedRepos_al.add(string);
                }
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Date date = new Date();
            ArrayList<Double> arrayList = null;
            BitBuktHelper bitBuktHelper = new BitBuktHelper();
            Hashtable hashtable2 = bitBuktHelper.getRepositoriesList(this.reportingName, this.user, this.encodedAuth);
            if (hashtable2 != null) {
                Set set = hashtable2.keySet();
                for (String string : set) {
                    if (string != null && this.excludedRepos_al.contains(string)) continue;
                    String string2 = (String)hashtable2.get(string);
                    arrayList = new ArrayList<Double>();
                    ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList3 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList4 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList5 = new ArrayList<ArrayList>();
                    ArrayList<ArrayList> arrayList6 = new ArrayList<ArrayList>();
                    String string3 = "";
                    String string4 = "";
                    int n = 1;
                    int n2 = 0;
                    JSONArray jSONArray = new JSONArray();
                    do {
                        String string5;
                        JSONObject jSONObject;
                        if ((jSONObject = this.getJsonObject(string5 = DEFAULT_SERVICE_URL + bitBucketVersion + resourcePath + string2 + pipelinepath + pagelength + page + n)) != null) {
                            JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"values");
                            n2 = jSONArray2.size();
                            for (int i = 0; i < n2; ++i) {
                                JSONObject jSONObject2 = (JSONObject)jSONArray2.get(i);
                                jSONArray.add((Object)jSONObject2);
                            }
                        }
                        ++n;
                    } while (n2 != 0);
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    double d6 = 0.0;
                    for (int i = 0; i < jSONArray.size(); ++i) {
                        Object object;
                        JSONObject jSONObject;
                        String string6;
                        String string7;
                        JSONObject jSONObject3;
                        JSONObject jSONObject4 = (JSONObject)jSONArray.get(i);
                        if (jSONObject4 == null) continue;
                        this.buildnumber = (Long)jSONObject4.get((Object)"build_number");
                        long l = date.getTime();
                        long l2 = l - this.measurePeriod;
                        this.pipebuildTime = this.Dateformat(((String)jSONObject4.get((Object)"created_on")).substring(0, 19));
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                        Date date2 = simpleDateFormat.parse(this.pipebuildTime);
                        long l3 = date2.getTime();
                        if (l3 < l2 || l3 > l) continue;
                        JSONObject jSONObject5 = (JSONObject)jSONObject4.get((Object)"target");
                        if (jSONObject5 != null) {
                            string4 = (String)jSONObject5.get((Object)"ref_name");
                        }
                        if ((jSONObject3 = (JSONObject)jSONObject5.get((Object)"commit")) != null) {
                            this.commitid = (String)jSONObject3.get((Object)"hash");
                            string7 = (JSONObject)jSONObject3.get((Object)"links");
                            if (string7 == null) continue;
                            string6 = (JSONObject)string7.get((Object)"self");
                            if (string6 != null && (jSONObject = this.getJsonObject((String)(object = (String)string6.get((Object)"href")))) != null) {
                                this.commitmessg = (String)jSONObject.get((Object)"message");
                            }
                        }
                        string7 = "";
                        string6 = "";
                        object = (JSONObject)jSONObject4.get((Object)"state");
                        if (object == null) continue;
                        jSONObject = (JSONObject)object.get((Object)"result");
                        JSONObject jSONObject6 = (JSONObject)object.get((Object)"stage");
                        if (jSONObject != null) {
                            string7 = (String)jSONObject.get((Object)"name");
                        } else if (jSONObject6 != null) {
                            string6 = (String)jSONObject6.get((Object)"name");
                        }
                        if (string7.equalsIgnoreCase("SUCCESSFUL")) {
                            d += 1.0;
                            arrayList2.add(this.getPipeDD(jSONObject4));
                            this.successhash.put(string + ":" + string4, arrayList2);
                            continue;
                        }
                        if (string7.equalsIgnoreCase("FAILED")) {
                            d2 += 1.0;
                            arrayList3.add(this.getPipeDD(jSONObject4));
                            this.failedhash.put(string + ":" + string4, arrayList3);
                            continue;
                        }
                        if (string7.equalsIgnoreCase("PENDING") || string6.equalsIgnoreCase("RUNNING")) {
                            d3 += 1.0;
                            arrayList4.add(this.getPipeDD(jSONObject4));
                            this.pendinghash.put(string + ":" + string4, arrayList4);
                            continue;
                        }
                        if (string7.equalsIgnoreCase("HALTED") || string6.equalsIgnoreCase("HALTED")) {
                            d4 += 1.0;
                            arrayList5.add(this.getPipeDD(jSONObject4));
                            this.haltedhash.put(string + ":" + string4, arrayList5);
                            continue;
                        }
                        if (!string7.equalsIgnoreCase("STOPPED")) continue;
                        d5 += 1.0;
                        arrayList6.add(this.getPipeDD(jSONObject4));
                        this.stoppedhash.put(string + ":" + string4, arrayList6);
                    }
                    d6 = d + d2 + d3 + d4 + d5;
                    arrayList.add(d6);
                    arrayList.add(d);
                    arrayList.add(d2);
                    arrayList.add(d3);
                    arrayList.add(d4);
                    arrayList.add(d5);
                    string3 = string4 == null || string4.length() == 0 ? string : string + ":" + string4;
                    this.addNewMeasure(string3, arrayList);
                }
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string);
        }
    }

    public void freeTest() {
        this.successhash = new Hashtable();
        this.failedhash = new Hashtable();
        this.pendinghash = new Hashtable();
        this.haltedhash = new Hashtable();
        this.stoppedhash = new Hashtable();
    }

    public ArrayList getPipeDD(JSONObject jSONObject) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = "";
        String string2 = "";
        try {
            if (jSONObject != null) {
                JSONObject jSONObject2;
                Long l = (Long)jSONObject.get((Object)"duration_in_seconds");
                JSONObject jSONObject3 = (JSONObject)jSONObject.get((Object)"creator");
                if (jSONObject3 != null) {
                    string = (String)jSONObject3.get((Object)"display_name");
                }
                if ((jSONObject2 = (JSONObject)jSONObject.get((Object)"trigger")) != null) {
                    string2 = (String)jSONObject2.get((Object)"name");
                }
                arrayList.add(string);
                arrayList.add(this.commitid);
                arrayList.add(this.commitmessg);
                arrayList.add(string2);
                arrayList.add(this.buildnumber);
                arrayList.add(this.pipebuildTime);
                arrayList.add(l);
            }
        }
        catch (Exception exception) {
            String string3 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string3);
        }
        return arrayList;
    }

    public JSONObject getJsonObject(String string) {
        String string2 = "";
        try {
            string2 = string;
            Client client = Client.create();
            WebResource webResource = client.resource(string2);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.header("Authorization", (Object)("Basic " + this.encodedAuth)).type("application/json")).accept(new String[]{"application/json"})).get(ClientResponse.class);
            int n = clientResponse.getStatus();
            String string3 = (String)clientResponse.getEntity(String.class);
            if (n == 201 || n == 200) {
                JSONParser jSONParser = new JSONParser();
                Object object = jSONParser.parse(string3.toString());
                this.resultObj = (JSONObject)object;
            } else if (n == 401) {
                this.logToErrorFile("Error", this.entity, "Invalid Username or Password -failed to get bitbucket metrics");
            }
            if (n == 404) {
                this.logToErrorFile("Error", this.entity, "Invalid url or the specified repository does not exist.");
                return null;
            }
        }
        catch (Exception exception) {
            String string4 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string4);
        }
        return this.resultObj;
    }

    private String Dateformat(String string) {
        String string2 = "";
        try {
            Locale locale = Locale.US;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", locale);
            Date date = simpleDateFormat.parse(string);
            String string3 = Calendar.getInstance().getTimeZone().getID();
            Date date2 = new Date(date.getTime() + (long)TimeZone.getTimeZone(string3).getOffset(date.getTime()));
            long l = date2.getTime();
            string2 = dateInfo.egetDate(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string4 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile("ERROR", this.entity, string4);
        }
        return string2;
    }
}

