/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class BobiCMSSysDBTest
extends BobiBase {
    private static final String SERVER_TYPE = "cms";
    private static final String DB_CONNECTIONS = "Established System Database Connections";
    private static final String USED_DB_CONNECTIONS = "Currently Used System Database Connections";
    private static final String PENDING_DB_REQUESTS = "Pending System Database Requests";
    private static final ArrayList attrArrayList = new ArrayList();
    private static final ArrayList dummymeasureArrayList = new ArrayList();

    public BobiCMSSysDBTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(attrArrayList.size());
        this.isDynamicInfoTest = true;
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        Hashtable hashtable2 = null;
        this.printOut("Node name :" + this.nodeName);
        String string = "Servers:name=" + this.nodeName + "*,type=" + SERVER_TYPE;
        this.printOut("Query Filter :" + string);
        hashtable2 = this.getAttrs(string, attrArrayList);
        if (hashtable2 == null || hashtable2.size() == 0 || hashtable2.isEmpty()) {
            this.logToErrorFile("WARNING", this.reportingName + ":" + this.entity, "Attributes data hashtable value is null");
            this.addNewMeasure(dummymeasureArrayList);
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            this.printOut("Info :" + string2);
            d = this.getHashtableData(hashtable3, DB_CONNECTIONS);
            double d4 = this.getHashtableData(hashtable3, USED_DB_CONNECTIONS);
            d2 = this.roundDouble(d4 / d * 100.0, 2);
            this.printOut("dbConnections  :" + d + ",usedDBConnections  :" + d4 + ", usedDBConnectionsPCT " + d2);
            d3 = this.getHashtableData(hashtable3, PENDING_DB_REQUESTS);
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            if (!bl) {
                this.addNewMeasure(string2, arrayList);
            }
            this.printOut("Info  :" + string2 + "  ,Measure ArrayList  :" + arrayList);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        BobiCMSSysDBTest bobiCMSSysDBTest = new BobiCMSSysDBTest(stringArray);
        bobiCMSSysDBTest.debugComputeMeasures(new Hashtable(), true);
    }

    static {
        attrArrayList.add(DB_CONNECTIONS);
        attrArrayList.add(USED_DB_CONNECTIONS);
        attrArrayList.add(PENDING_DB_REQUESTS);
        for (int i = 0; i < attrArrayList.size(); ++i) {
            dummymeasureArrayList.add(new Double(-5.0));
        }
    }
}

