/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class BobiWISPerfTest
extends BobiBase {
    private static final int WEB_INTELLIGENCE_SERVER_PERF_MEASURE_COUNT = 6;
    private static final String SERVER_TYPE = "webiserver";
    public Hashtable prevHash = new Hashtable();
    private static final String CPU_USAGE_PCT = "CPU usage _%_";
    private static final String MEMORY_HIGH_THRESHOLD = "Memory high threshold count";
    private static final String MEMORY_MAX_THRESHOLD = "Memory max threshold count";
    private static final String VIRTUAL_MEMORY = "Virtual memory size _Mb_";
    private static final String ACTIVE_THREADS = "Number of active threads";
    private static final String AUDITING_EVENTS_IN_QUEUE = "Current Number of Auditing Events in the Queue";
    private static final ArrayList attrArrayList = new ArrayList();
    private static final ArrayList dummymeasureArrayList = new ArrayList();

    public BobiWISPerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        this.isDynamicInfoTest = true;
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        Hashtable hashtable2 = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.printOut("Node name :" + this.nodeName);
        String string = "Servers:name=" + this.nodeName + "*,type=" + SERVER_TYPE;
        this.printOut("Query Filter :" + string);
        hashtable2 = this.getAttrs(string, attrArrayList);
        if (hashtable2 == null || hashtable2.size() == 0 || hashtable2.isEmpty()) {
            this.logToErrorFile("WARNING", this.reportingName + ":" + this.entity, "Attributes data hashtable value is null");
            this.addNewMeasure(dummymeasureArrayList);
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        while (enumeration.hasMoreElements()) {
            arrayList = new ArrayList();
            String string2 = (String)enumeration.nextElement();
            this.printOut("Info  :" + string2);
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string2);
            d4 = this.getHashtableData(hashtable3, VIRTUAL_MEMORY);
            d5 = this.getHashtableData(hashtable3, ACTIVE_THREADS);
            d6 = this.getHashtableData(hashtable3, AUDITING_EVENTS_IN_QUEUE);
            if (this.prevHash != null && this.prevHash.size() > 0 && !this.prevHash.isEmpty()) {
                Hashtable hashtable4 = (Hashtable)this.prevHash.get(string2);
                if (hashtable4 == null || hashtable4.size() == 0 || hashtable4.isEmpty() || hashtable3 == null || hashtable3.size() == 0 || hashtable3.isEmpty()) continue;
                d = this.getHashtableData(hashtable3, CPU_USAGE_PCT);
                double d7 = this.getHashtableData(hashtable3, MEMORY_HIGH_THRESHOLD);
                double d8 = this.getHashtableData(hashtable4, MEMORY_HIGH_THRESHOLD);
                double d9 = this.getHashtableData(hashtable3, MEMORY_MAX_THRESHOLD);
                double d10 = this.getHashtableData(hashtable4, MEMORY_MAX_THRESHOLD);
                double d11 = d7 - d8;
                double d12 = d9 - d10;
                if (bl) {
                    this.timeSinceLastTest = 1.0;
                }
                if (debug) {
                    this.printOut("currCPUUsagePCT  :" + d);
                    this.printOut("currMemoryHighThreshold  :" + d7);
                    this.printOut("prevMemoryHighThreshold  :" + d8);
                    this.printOut("currMemoryMaxThreshold  :" + d9);
                    this.printOut("prevMemoryMaxThreshold  :" + d10);
                    this.printOut("memoryHighThreshold :" + d11);
                    this.printOut("memoryMaxThreshold  :" + d12);
                }
                if (d11 < 0.0) {
                    d11 = -5.0;
                    d2 = -5.0;
                } else {
                    d2 = this.roundDouble(d11 / this.timeSinceLastTest, 2);
                }
                if (d12 < 0.0) {
                    d12 = -5.0;
                    d3 = -5.0;
                } else {
                    d3 = this.roundDouble(d12 / this.timeSinceLastTest, 2);
                }
                if (bl || debug) {
                    this.printOut("cpuUsagePCT :" + d);
                    this.printOut("Memory High Threshold Rate  :" + d2);
                    this.printOut("Memory Max Threshold Rate   :" + d3);
                }
            }
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            this.printOut("Info :" + string2 + "  MeasureArrayList  :" + arrayList);
            if (!bl) {
                this.addNewMeasure(string2, arrayList);
            }
            d = -5.0;
            d2 = -5.0;
            d3 = -5.0;
            d4 = -5.0;
            d5 = -5.0;
            d6 = -5.0;
        }
        this.prevHash = hashtable2;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        BobiWISPerfTest bobiWISPerfTest = new BobiWISPerfTest(stringArray);
        int n = 0;
        int n2 = 3;
        while (n < n2) {
            ++n;
            bobiWISPerfTest.debugComputeMeasures(new Hashtable(), true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    static {
        attrArrayList.add(CPU_USAGE_PCT);
        attrArrayList.add(MEMORY_HIGH_THRESHOLD);
        attrArrayList.add(MEMORY_MAX_THRESHOLD);
        attrArrayList.add(VIRTUAL_MEMORY);
        attrArrayList.add(ACTIVE_THREADS);
        attrArrayList.add(AUDITING_EVENTS_IN_QUEUE);
        for (int i = 0; i < 6; ++i) {
            dummymeasureArrayList.add(new Double(-5.0));
        }
    }
}

