/*
 * Decompiled with CFR 0.152.
 */
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class CassandraBase
extends GenericTest {
    private String jmx_port = null;
    private String username = null;
    private String password = null;
    protected String myDatePattern = "dd/MM/yy hh:mm:ss a";
    protected SimpleDateFormat mySDF = new SimpleDateFormat(this.myDatePattern);
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    private String jndiName = null;
    protected JMXServiceURL url = null;
    protected MBeanServerConnection beanServerConnection = null;

    public CassandraBase(String[] stringArray) {
        super(stringArray);
        this.username = this.getValueForParam("Jmx_user");
        this.password = this.getValueForParam("Jmx_password");
        this.jmx_port = this.getValueForParam("Jmx_Remote_Port");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "none";
        }
        if (this.password == null) {
            this.password = this.getValueForParam("password");
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "none";
        }
        if (this.jmx_port == null || this.jmx_port.equalsIgnoreCase("NULL") || this.jmx_port.equalsIgnoreCase("none")) {
            this.jmx_port = "7199";
        }
        this.password = EgCrypt.encrypt(this.password, true);
    }

    protected void connect() {
        this.printOut("Host " + this.targetHost);
        this.printOut("jmx_port " + this.jmx_port);
        this.printOut("username " + this.username);
        String string = "service:jmx:rmi:///jndi/rmi://" + this.targetHost + ":" + this.jmx_port + "/jmxrmi";
        this.printOut("JMX URL " + string);
        try {
            JMXServiceURL jMXServiceURL = null;
            boolean bl = false;
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            try {
                jMXServiceURL = new JMXServiceURL(string);
            }
            catch (Exception exception) {
                this.printOut("Error in JMXServiceURL : " + exception);
                this.putErrorMessageToLogfile("JMXServiceURL : " + string);
                this.putErrorMessageToLogfile("Error in JMXServiceURL " + exception);
                this.disconnect();
                return;
            }
            if (this.username.equalsIgnoreCase("none") && this.password.equalsIgnoreCase("none")) {
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(jMXServiceURL);
                    this.printOut("jmxConnector " + this.jmxConnector);
                }
                catch (Exception exception) {
                    this.printOut("JMX connection error with user/pass : none/none " + exception);
                    this.putErrorMessageToLogfile("JMX connection error with user/pass : none/none " + exception);
                    bl = true;
                }
            } else {
                hashMap.put("jmx.remote.credentials", new String[]{this.username, this.password});
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(jMXServiceURL, hashMap);
                }
                catch (Exception exception) {
                    this.printOut("Error in jmxConnector " + exception);
                    exception.printStackTrace();
                    this.putErrorMessageToLogfile("Error in jmxConnector " + exception);
                    bl = true;
                }
            }
            if (bl) {
                try {
                    SslRMIClientSocketFactory sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
                    Registry registry = LocateRegistry.getRegistry(this.targetHost, Integer.parseInt(this.jmx_port), sslRMIClientSocketFactory);
                    RMIServer rMIServer = (RMIServer)registry.lookup(this.jndiName);
                    this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                    this.rmiConnector.connect(hashMap);
                    this.beanServerConnection = this.rmiConnector.getMBeanServerConnection();
                }
                catch (Exception exception) {
                    this.printOut("JMX connection error in SSL");
                    exception.printStackTrace();
                    this.putErrorMessageToLogfile("JMX connection error in SSL");
                    this.disconnect();
                    return;
                }
            }
            try {
                this.beanServerConnection = this.jmxConnector.getMBeanServerConnection();
                this.printOut("beanServerConnection : " + this.beanServerConnection);
            }
            catch (Exception exception) {
                this.printOut("JMX connection error in beanServerConnection");
                this.putErrorMessageToLogfile("JMX connection error in beanServerConnection");
                this.disconnect();
                return;
            }
            if (this.beanServerConnection == null) {
                this.printOut("beanServerConnection  is null ,Connection to JMX Agent is not established ");
                this.putErrorMessageToLogfile("beanServerConnection  is null ,Connection to JMX Agent is not established ");
                this.disconnect();
                return;
            }
        }
        catch (Exception exception) {
            this.printOut("Error in creation server connecetion " + exception);
            exception.printStackTrace();
            this.putErrorMessageToLogfile("Error in creation server connecetion");
            this.disconnect();
        }
    }

    protected void disconnect() {
        try {
            if (this.beanServerConnection != null) {
                this.beanServerConnection = null;
            }
        }
        catch (Exception exception) {
            this.printOut("Error in closing beanServerConnection");
            this.putErrorMessageToLogfile("Error in closing beanServerConnection");
            return;
        }
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
        }
        catch (Exception exception) {
            this.printOut("Error in closing connection in jmxConnector");
            this.putErrorMessageToLogfile("Error in closing connection in jmxConnector");
            return;
        }
        try {
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            this.printOut("Error in closing connection in rmiConnector");
            this.putErrorMessageToLogfile("Error in closing connection in rmiConnector");
            return;
        }
    }

    protected Hashtable getData(ObjectName objectName, ArrayList arrayList) {
        Hashtable hashtable = new Hashtable();
        Set<ObjectInstance> set = null;
        Iterator<ObjectInstance> iterator = null;
        if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
            return hashtable;
        }
        try {
            set = this.beanServerConnection.queryMBeans(objectName, null);
            iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                ObjectInstance objectInstance = iterator.next();
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                objectName = objectInstance.getObjectName();
                String string = objectName.toString();
                MBeanInfo mBeanInfo = this.beanServerConnection.getMBeanInfo(objectName);
                MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                    String string2 = mBeanAttributeInfoArray[i].getName();
                    if (!arrayList.contains(string2)) continue;
                    String string3 = "" + this.beanServerConnection.getAttribute(objectName, string2);
                    hashtable2.put(string2, string3);
                }
                hashtable.put(string, hashtable2);
            }
        }
        catch (Exception exception) {
            this.printOut("Error itrating mbeandata " + exception);
            this.putErrorMessageToLogfile("Error itrating mbeandata " + exception);
        }
        return hashtable;
    }

    protected Hashtable getKeyspaceData(ObjectName objectName, ArrayList arrayList, ArrayList arrayList2) {
        Hashtable hashtable = new Hashtable();
        Set<ObjectInstance> set = null;
        Iterator<ObjectInstance> iterator = null;
        if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
            return hashtable;
        }
        try {
            set = this.beanServerConnection.queryMBeans(objectName, null);
            iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                ObjectInstance objectInstance = iterator.next();
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                objectName = objectInstance.getObjectName();
                String string = objectName.toString();
                String string2 = string.substring(string.lastIndexOf("=") + 1, string.length());
                if (!arrayList2.contains(string2)) continue;
                MBeanInfo mBeanInfo = this.beanServerConnection.getMBeanInfo(objectName);
                MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                    String string3 = mBeanAttributeInfoArray[i].getName();
                    String string4 = "" + this.beanServerConnection.getAttribute(objectName, string3);
                    if (!arrayList.contains(string3)) continue;
                    hashtable2.put(string3, string4);
                }
                hashtable.put(string, hashtable2);
            }
        }
        catch (Exception exception) {
            this.printOut("Error itrating mbeandata " + exception);
            this.putErrorMessageToLogfile("Error itrating mbeandata " + exception);
        }
        return hashtable;
    }

    protected double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + this.mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }
}

