/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class CiscoQFPMemoryTest
extends EgSnmpGenericTest {
    private boolean isFirst = true;
    public double byteToMB = 1048576.0;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);

    public CiscoQFPMemoryTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.2.1.47.1.1.1.1.2");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.9.9.715.1.1.7.1.9");
            Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.9.9.715.1.1.7.1.11");
            Hashtable hashtable5 = this.getMeasure(".1.3.6.1.4.1.9.9.715.1.1.7.1.13");
            if (hashtable3 == null || hashtable3.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Error :", "No QFP relevant data available for :", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null || !string.endsWith("1")) continue;
                String string2 = (String)hashtable3.get(string);
                String string3 = (String)hashtable4.get(string);
                String string4 = (String)hashtable5.get(string);
                String string5 = string.substring(0, string.indexOf("."));
                System.out.println(this.entity + " Key ==>" + string + " phyIndexKey ==>" + string5);
                String string6 = (String)hashtable2.get(string5);
                double d = this.getDoubleValue(string2);
                double d2 = this.getDoubleValue(string3);
                double d3 = this.getDoubleValue(string4);
                double d4 = -5.0;
                if (d > 0.0 && d2 <= d2) {
                    d4 = d2 / d * 100.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(this.roundDouble(d2)));
                arrayList.add(new Double(this.roundDouble(d3)));
                arrayList.add(new Double(this.roundDouble(d4)));
                String string7 = string6 + "/DRAM";
                System.out.println(this.entity + " Info ==>" + string7 + " measureList ==>" + arrayList);
                this.addNewMeasure(string7, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception:", "CiscoQFPMemoryTest Exception occured in computeMeasures()", this.targetHost);
        }
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CiscoQFPMemoryTest Exception occured in getMeasure() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            if (string != null && string.trim().length() > 0 && (d = Double.parseDouble(string)) > 0.0) {
                d /= this.byteToMB;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CiscoQFPMemoryTest Exception occured in getDoubleValue() for " + this.targetHost, exception.toString());
        }
        return d;
    }

    private double roundDouble(double d) {
        double d2 = -5.0;
        try {
            BigDecimal bigDecimal = new BigDecimal(d);
            String string = this.df.format(bigDecimal);
            d2 = Double.parseDouble(string);
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CiscoQFPMemoryTest Exception occured in roundDouble() for " + this.targetHost, exception.toString());
        }
        return d2;
    }
}

