/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ColdfusionTest
extends EgTest {
    private static int rateOfPageHitsIndex = 0;
    private static int rateOfDBHitsIndex = 1;
    private static int rateOfBytesInIndex = 2;
    private static int rateOfBytesOutIndex = 3;
    private static int numRequestsQueuedIndex = 4;
    private static int numRequestsRunningIndex = 5;
    private static int rateOfRequestsTimedOutIndex = 6;
    private static int averageQueueTimeIndex = 7;
    private static int averageRequestTimeIndex = 8;
    private static int averageDBTimeIndex = 9;
    double rateOfPageHits = 0.0;
    double rateOfDBHits = 0.0;
    double rateOfBytesIn = 0.0;
    double rateOfBytesOut = 0.0;
    long numRequestsQueued = 0L;
    long numRequestsRunning = 0L;
    double rateOfRequestsTimedOut = 0.0;
    double averageQueueTime = 0.0;
    double averageRequestTime = 0.0;
    double averageDBTime = 0.0;
    long prevPageHits = 0L;
    long prevBytesIn = 0L;
    long prevBytesOut = 0L;
    long prevDBHits = 0L;
    long prevRequestsTimedOut = 0L;
    long currPageHits = 0L;
    long currBytesIn = 0L;
    long currBytesOut = 0L;
    long currDBHits = 0L;
    long currRequestsTimedOut = 0L;
    String webServerPort;
    URL url = null;
    boolean isSsl = false;
    boolean DEBUG = false;

    public static void main(String[] stringArray) {
        ColdfusionTest coldfusionTest = new ColdfusionTest(stringArray);
        if (coldfusionTest.executeTest()) {
            System.out.println("this is the answer");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public ColdfusionTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 10;
        if (stringArray.length < 4) {
            System.err.println("Usage: ColdfusionTest -host<host> -webServerPort <wsPortNo> ");
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equalsIgnoreCase("-host")) {
                if (++n >= stringArray.length) {
                    System.err.println("Usage:ColdfusionTest -host <host> -webServerPort <wsPortNo> ");
                    return;
                }
                this.targetHost = new String(stringArray[n]);
            } else if (stringArray[n].equalsIgnoreCase("-port")) {
                if (++n >= stringArray.length) {
                    System.err.println("Usage:ColdfusionTest -host <host> -webServerPort <wsPortNo> ");
                    return;
                }
                this.portNo = new String(stringArray[n]);
            }
            if (stringArray[n].equalsIgnoreCase("-webServerPort")) {
                if (++n >= stringArray.length) {
                    System.err.println("Usage: ColdfusionTest -host <host> -webServerPort <wsPortNo> ");
                    return;
                }
                this.webServerPort = new String(stringArray[n]);
            } else if (stringArray[n].equalsIgnoreCase("-ssl")) {
                if (++n >= stringArray.length) {
                    System.err.println("Usage:ColdfusionTest -host <host> -webServerPort <wsPortNo> ");
                    return;
                }
                this.isSsl = new Boolean(stringArray[n]);
            }
            ++n;
        }
        return;
    }

    public boolean executeTest() {
        this.initTest();
        try {
            String string = this.returnMeasures();
            if (string == null) {
                this.errorMsg = new String("Error while accessing the URL " + this.url.toString());
                return false;
            }
            if (this.tokenize(string)) {
                String string2 = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
                this.addValueToResultSet(string2, rateOfPageHitsIndex, this.rateOfPageHits);
                this.addValueToResultSet(string2, rateOfDBHitsIndex, this.rateOfDBHits);
                this.addValueToResultSet(string2, rateOfBytesInIndex, this.rateOfBytesIn);
                this.addValueToResultSet(string2, rateOfBytesOutIndex, this.rateOfBytesOut);
                this.addValueToResultSet(string2, numRequestsQueuedIndex, this.numRequestsQueued);
                this.addValueToResultSet(string2, numRequestsRunningIndex, this.numRequestsRunning);
                this.addValueToResultSet(string2, rateOfRequestsTimedOutIndex, this.rateOfRequestsTimedOut);
                this.addValueToResultSet(string2, averageQueueTimeIndex, this.averageQueueTime);
                this.addValueToResultSet(string2, averageRequestTimeIndex, this.averageRequestTime);
                this.addValueToResultSet(string2, averageDBTimeIndex, this.averageDBTime);
                this.updateAllResultSets();
                return true;
            }
            this.updateAllResultSets();
            return true;
        }
        catch (Exception exception) {
            this.errorMsg = new String("Exception while executing ColdfusionTest");
            this.updateAllResultSets();
            return false;
        }
    }

    private boolean tokenize(String string) {
        StringTokenizer stringTokenizer;
        long l;
        int n = string.indexOf(58);
        if (n < 0) {
            return false;
        }
        string = new String(string.substring(n + 1));
        string.trim();
        if (this.DEBUG) {
            System.out.println(string);
        }
        if ((l = (long)(stringTokenizer = new StringTokenizer(string, ",")).countTokens()) != (long)this.numOutputFields) {
            System.err.println("In correct output fields!");
            return false;
        }
        this.currPageHits = this.parse(stringTokenizer.nextToken());
        this.numRequestsQueued = this.parse(stringTokenizer.nextToken());
        this.currDBHits = this.parse(stringTokenizer.nextToken());
        this.numRequestsRunning = this.parse(stringTokenizer.nextToken());
        this.currRequestsTimedOut = this.parse(stringTokenizer.nextToken());
        this.currBytesIn = this.parse(stringTokenizer.nextToken());
        this.currBytesOut = this.parse(stringTokenizer.nextToken());
        this.averageQueueTime = this.parse(stringTokenizer.nextToken());
        this.averageRequestTime = this.parse(stringTokenizer.nextToken());
        this.averageDBTime = this.parse(stringTokenizer.nextToken());
        if (this.timeSinceLastTest == -1.0) {
            this.rateOfPageHits = -1.0;
            this.rateOfDBHits = -1.0;
            this.rateOfBytesIn = -1.0;
            this.rateOfBytesOut = -1.0;
            this.rateOfRequestsTimedOut = -1.0;
            this.prevPageHits = this.currPageHits;
            this.prevDBHits = this.currDBHits;
            this.prevBytesIn = this.currBytesIn;
            this.prevBytesOut = this.currBytesOut;
            this.prevRequestsTimedOut = this.currRequestsTimedOut;
        } else {
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
            String string2 = iniFile.getValue("ColdFusion", "ComputeDifferenceForColdFusion");
            boolean bl = false;
            try {
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"))) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in parsing String to boolean " + exception);
            }
            if (bl) {
                this.rateOfPageHits = (double)(this.currPageHits - this.prevPageHits) / this.timeSinceLastTest;
                this.rateOfPageHits = this.rateOfPageHits < 0.0 ? -1.0 : this.rateOfPageHits;
                this.prevPageHits = this.currPageHits;
                this.rateOfBytesIn = (double)(this.currBytesIn - this.prevBytesIn) / this.timeSinceLastTest;
                this.rateOfBytesIn /= 1024.0;
                if (this.DEBUG) {
                    System.out.println("by in rate " + this.rateOfBytesIn);
                }
                this.rateOfBytesIn = this.rateOfBytesIn < 0.0 ? -1.0 : this.rateOfBytesIn;
                this.prevBytesIn = this.currBytesIn;
                this.averageRequestTime /= 1000.0;
            } else {
                this.rateOfPageHits = this.currPageHits;
                this.rateOfBytesIn = this.currBytesIn;
                this.averageRequestTime /= 1000.0;
                if (this.averageRequestTime < 0.0) {
                    this.averageRequestTime = 0.0;
                }
            }
            this.rateOfDBHits = (double)(this.currDBHits - this.prevDBHits) / this.timeSinceLastTest;
            this.rateOfDBHits = this.rateOfDBHits < 0.0 ? -1.0 : this.rateOfDBHits;
            this.prevDBHits = this.currDBHits;
            this.rateOfBytesOut = (double)(this.currBytesOut - this.prevBytesOut) / this.timeSinceLastTest;
            this.rateOfBytesOut /= 1024.0;
            if (this.DEBUG) {
                System.out.println("bytes out " + this.rateOfBytesOut);
            }
            this.rateOfBytesOut = this.rateOfBytesOut < 0.0 ? -1.0 : this.rateOfBytesOut;
            this.prevBytesOut = this.currBytesOut;
            this.rateOfRequestsTimedOut = (double)(this.currRequestsTimedOut - this.prevRequestsTimedOut) / this.timeSinceLastTest;
            this.rateOfRequestsTimedOut = this.rateOfRequestsTimedOut < 0.0 ? -1.0 : this.rateOfRequestsTimedOut;
            this.prevRequestsTimedOut = this.currRequestsTimedOut;
        }
        this.averageQueueTime /= 1000.0;
        this.averageDBTime /= 1000.0;
        return true;
    }

    private long parse(String string) {
        if (this.DEBUG) {
            System.out.println(string.trim());
        }
        return Long.parseLong(string.trim());
    }

    private String returnMeasures() {
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        String string = "";
        if (this.isSsl) {
            String string2 = "https://" + this.targetHost + ":" + this.webServerPort + "/egurkha/cftest.cfm";
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var8_12 = null;
            try {
                String string3;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                URL uRL = new URL(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                inputStream = httpURLConnection.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (!string3.startsWith("cftest")) continue;
                    string = new String(string3);
                    break;
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
                httpURLConnection.disconnect();
                return null;
            }
        }
        try {
            String string4;
            this.url = new URL("http://" + this.targetHost + ":" + this.webServerPort + "/egurkha/cftest.cfm");
            httpURLConnection = (HttpURLConnection)this.url.openConnection();
            httpURLConnection.connect();
            inputStream = httpURLConnection.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string4 = bufferedReader.readLine()) != null) {
                if (!string4.startsWith("cftest")) continue;
                string = new String(string4);
                break;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            httpURLConnection.disconnect();
            return null;
        }
        return string;
    }
}

