/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.util.ArrayList;

public class DownloadUpgradeFile
extends Thread {
    private HttpURLConnection con;
    public boolean done = false;
    public int code = 0;
    public int respData = 0;
    private ArrayList input = null;
    private String whoIs = null;
    private boolean haveToConnect = false;
    private boolean haveToDisconnect = false;
    private String egAgentAutoUpgradeOut = null;
    public String filePath = null;

    public DownloadUpgradeFile(HttpURLConnection httpURLConnection, ArrayList arrayList, String string) {
        this.con = httpURLConnection;
        this.haveToConnect = true;
        this.haveToDisconnect = true;
        if (arrayList != null) {
            this.input = arrayList;
        }
        this.setDaemon(true);
        this.egAgentAutoUpgradeOut = string;
        this.start();
    }

    public void run() {
        if (this.haveToConnect) {
            if (this.input != null) {
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.con.getOutputStream(), "UTF-8"));
                    if (this.input != null) {
                        int n = this.input.size();
                        for (int i = 0; i < n; ++i) {
                            printWriter.println((String)this.input.get(i));
                        }
                    }
                    printWriter.close();
                    this.con.connect();
                }
                catch (Exception exception) {
                    this.code = 0;
                    this.done = true;
                    return;
                }
            }
            try {
                this.con.connect();
            }
            catch (Exception exception) {
                this.code = 0;
                this.done = true;
                return;
            }
        }
        try {
            this.code = this.con.getResponseCode();
            if (this.code == 200) {
                this.respData = this.getFile();
            }
            if (this.haveToConnect || this.haveToDisconnect) {
                try {
                    if (this.con != null) {
                        this.con.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.done = true;
        }
        catch (Exception exception) {
            if (this.haveToConnect || this.haveToDisconnect) {
                try {
                    if (this.con != null) {
                        this.con.disconnect();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            this.code = 0;
            this.done = true;
        }
    }

    private int getFile() {
        String string = "";
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            int n;
            inputStream = this.con.getInputStream();
            if (inputStream == null) {
                return 1;
            }
            byte[] byArray = new byte[4];
            filterInputStream = new DataInputStream(inputStream);
            ((DataInputStream)filterInputStream).read(byArray);
            String string2 = new String(byArray);
            if (string2.equals("RC01")) {
                this.writeToAgentAutoUpgradeLog("Auto upgrade is disabled");
                filterInputStream.close();
                return 1;
            }
            if (string2.equals("RC05")) {
                this.writeToAgentAutoUpgradeLog("No package to upgrade");
                filterInputStream.close();
                return 1;
            }
            if (string2.equals("RC02") || string2.equals("RC03") || string2.equals("RC04")) {
                this.writeToAgentAutoUpgradeLog("Attempt to download upgrade package has resulted in an error code of " + string2);
                filterInputStream.close();
                return 1;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(new String(byArray));
            byArray = new byte[1];
            int n2 = 0;
            boolean bl2 = false;
            while ((n = ((DataInputStream)filterInputStream).read(byArray)) != -1 && !new String(byArray).equals("$")) {
                if (n2 > 100) {
                    bl2 = true;
                    break;
                }
                stringBuffer.append(new String(byArray));
                ++n2;
            }
            if (bl2) {
                this.writeToAgentAutoUpgradeLog("Data Stream would be corrupted. Attempt to download upgrade package failed");
                filterInputStream.close();
                return 1;
            }
            string = stringBuffer.toString();
            this.writeToAgentAutoUpgradeLog("Going to download " + string);
            File file = new File(EgInstallInfo.getInstallDir() + System.getProperty("file.separator") + "agent" + System.getProperty("file.separator") + string);
            this.filePath = file.getAbsolutePath();
            fileOutputStream = new FileOutputStream(file);
            int n3 = 0;
            int n4 = 1024;
            byte[] byArray2 = new byte[n4];
            while ((n3 = ((DataInputStream)filterInputStream).read(byArray2)) != -1) {
                fileOutputStream.write(byArray2, 0, n3);
            }
            fileOutputStream.close();
            filterInputStream.close();
            this.writeToAgentAutoUpgradeLog("File has been downloaded and is available for install");
            return 0;
        }
        catch (Exception exception) {
            System.out.println(exception);
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            exception.printStackTrace();
            return 1;
        }
    }

    public synchronized void writeToAgentAutoUpgradeLog(String string) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string2 = egDateInfo.egetDate(false);
        File file = new File(this.egAgentAutoUpgradeOut);
        if (file.exists() && file.length() >= 1000000L) {
            EgInstallInfo.fileRename(this.egAgentAutoUpgradeOut, this.egAgentAutoUpgradeOut + ".1");
        }
        try {
            printWriter = new PrintWriter(new FileWriter(this.egAgentAutoUpgradeOut, true));
        }
        catch (Exception exception) {
            System.err.println("writeToAgentAutoUpgradeLog: Cannot open log file ");
            return;
        }
        printWriter.println(string2 + " : " + string);
        printWriter.close();
    }
}

