/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class ESKMMemoryTest
extends EgSnmpGenericTest {
    private double bytesToMB = 1048576.0;

    public ESKMMemoryTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = this.getMeasure(".1.3.6.1.4.1.11.13.1.3.2.6.0");
        double d2 = this.getMeasure(".1.3.6.1.4.1.11.13.1.3.2.5.0");
        double d3 = -5.0;
        double d4 = -5.0;
        if (d > 0.0) {
            d /= this.bytesToMB;
        }
        if (d2 > 0.0) {
            d2 /= this.bytesToMB;
        }
        if (d >= 0.0 && d2 >= 0.0) {
            d3 = d - d2;
        }
        if (d > 0.0) {
            d4 = d2 / d * 100.0;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        arrayList.add(new Double(d3));
        arrayList.add(new Double(d4));
        System.out.println("[ESKMMemoryTest]:Non Info====================>" + arrayList);
        this.addNewMeasure(arrayList);
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        double d = -5.0;
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = -5.0;
                    exception.printStackTrace();
                }
            }
        }
        return d;
    }
}

