/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgInfoSnmpTest
extends EgSmartSnmpTest {
    private double[] objectValues;
    Vector v_hashtables;
    private boolean b_firstTime = true;
    private String s_elementOID;
    private String s_elementValidOID;
    private String s_elementValidValue;
    private Hashtable validElementNames;
    private long l_rediscPeriod = 3600000L;
    private long l_prevDiscPeriod = 0L;

    public static void main(String[] stringArray) {
        EgInfoSnmpTest egInfoSnmpTest = new EgInfoSnmpTest(stringArray);
        egInfoSnmpTest.executeTest();
    }

    public EgInfoSnmpTest(String[] stringArray) {
        super(stringArray);
        debug = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        if (!this.loadMethods()) {
            return;
        }
        this.b_firstTime = this.fileModified;
        if (!this.setMeasures()) {
            return;
        }
        this.b_firstTime = this.fileModified;
        this.fileModified = false;
        if (this.validElementNames.isEmpty()) {
            this.logToErrorFile("WARNING", this.entity, "Value for the descriptor is null");
            return;
        }
        ArrayList arrayList = null;
        Enumeration enumeration = this.validElementNames.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            String string = (String)this.validElementNames.get(k);
            arrayList = new ArrayList();
            for (int i = 0; i < this.v_hashtables.size(); ++i) {
                String string2 = (String)this.al_oids.get(i);
                Hashtable hashtable2 = (Hashtable)this.v_hashtables.elementAt(i);
                if (hashtable2.size() > 0) {
                    if (!hashtable2.containsKey(k)) {
                        if (!this.isConfigTest) {
                            arrayList.add(new Double(-1.0));
                            continue;
                        }
                        arrayList.add("-");
                        continue;
                    }
                    try {
                        String string3;
                        if (!this.isConfigTest) {
                            string3 = (String)hashtable2.get(k);
                            this.sop(this.entity + ":Measure string = " + string3);
                            arrayList.add(new Double(Double.parseDouble(string3)));
                            continue;
                        }
                        string3 = (String)hashtable2.get(k);
                        this.sop(this.entity + ":Adding config = " + string3);
                        arrayList.add(string3);
                    }
                    catch (Exception exception) {
                        if (!this.isConfigTest) {
                            arrayList.add(new Double(-1.0));
                        } else {
                            arrayList.add("-");
                        }
                        this.logToErrorFile("Warn", this.entity, "Value for the oid " + string2 + "=" + (String)hashtable2.get(string) + " for the element " + string + " is not a numeric value");
                    }
                    continue;
                }
                if (!this.isConfigTest) {
                    arrayList.add(new Double(-1.0));
                    continue;
                }
                arrayList.add("-");
            }
            if (!this.isConfigTest) {
                arrayList = this.processMeasures(string, arrayList);
            }
            if (string != null && string.indexOf(",") != -1) {
                string = string.replace(',', ':');
            }
            this.sop(this.entity + ":S_INFO = " + string);
            this.addNewMeasure(string, arrayList);
        }
    }

    private boolean setMeasures() {
        this.getData();
        if (this.s_elementOID == null || this.s_elementOID.equals("")) {
            this.logToErrorFile("ERROR", this.entity, "No elementOID defined");
            return false;
        }
        if (this.s_elementValidOID == null || this.s_elementValidOID.equals("")) {
            this.logToErrorFile("ERROR", this.entity, "No elementValidOID defined");
            return false;
        }
        if (this.s_elementValidValue == null || this.s_elementValidValue.equals("")) {
            this.logToErrorFile("ERROR", this.entity, "No elementValidValue defined");
            return false;
        }
        long l = System.currentTimeMillis();
        if (l - this.l_prevDiscPeriod > this.l_rediscPeriod) {
            this.findValidElements();
            this.l_prevDiscPeriod = l;
        }
        if (this.al_measureNames == null || this.al_measureNames.size() == 0) {
            this.sop(this.entity + ":No measures Defined");
            this.logToErrorFile("ERROR", this.entity, "No measures defined");
            return false;
        }
        if (this.al_oids == null || this.al_oids.size() == 0) {
            this.sop(this.entity + ":No oids Defined");
            this.logToErrorFile("ERROR", this.entity, "No oids defined");
            return false;
        }
        if (this.al_measureNames.size() != this.al_oids.size()) {
            this.logToErrorFile("ERROR", this.entity, "Measure_oid mapping not unique");
            return false;
        }
        this.v_hashtables = new Vector();
        for (int i = 0; i < this.al_oids.size(); ++i) {
            boolean bl = this.runSnmpCmdForOid((String)this.al_oids.get(i));
            if (!(this.rhs == null || bl && this.rhs.length >= 1)) {
                this.logToErrorFile("ERROR", this.entity, "Snmpwalk failed for oid " + (String)this.al_oids.get(i) + " from targetHost " + this.targetHost);
                this.v_hashtables.addElement(new Hashtable());
                continue;
            }
            if (bl && l - this.l_prevDiscPeriod < this.l_rediscPeriod && this.validElementNames.isEmpty()) {
                this.findValidElements();
                this.l_prevDiscPeriod = l = System.currentTimeMillis();
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.lhs != null) {
                for (int j = 0; j < this.lhs.length; ++j) {
                    hashtable.put(this.lhs[j], this.rhs[j]);
                }
            }
            this.v_hashtables.addElement(hashtable);
        }
        return true;
    }

    private void getData() {
        if (this.b_firstTime) {
            String string;
            String string2;
            StringTokenizer stringTokenizer;
            String string3;
            this.al_measureNames = new ArrayList();
            this.al_oids = new ArrayList();
            String string4 = this.testsFilePtr.getValue("MEASURE_OID_MAPPING", this.entity);
            this.sop("MOP = " + string4);
            if (string4 == null || string4.equals("")) {
                this.logToErrorFile("ERROR", this.entity, "No measure_oid mapping available");
                return;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
                this.sop("Token = " + string3);
                stringTokenizer = new StringTokenizer(string3, ":");
                if (stringTokenizer.countTokens() != 2) {
                    this.logToErrorFile("ERROR", this.entity, "Wrong measure_oid mapping");
                    continue;
                }
                string2 = "";
                string = "";
                string2 = stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                this.al_measureNames.add(string2);
                this.al_oids.add(string);
            }
            string4 = this.testsFilePtr.getValue("SNMP_INFO_OID", this.entity);
            this.sop("MOP = " + string4);
            if (string4 == null || string4.equals("")) {
                this.logToErrorFile("ERROR", this.entity, "No ElementOID or ElementValidOID or ElementValidValue or ElementRediscPeriod available");
                return;
            }
            stringTokenizer2 = new StringTokenizer(string4, ",");
            if (stringTokenizer2.countTokens() != 4) {
                this.logToErrorFile("ERROR", this.entity, "ElementOID or ElementValidOID or ElementValidValue or ElementRediscPeriod not available");
                this.s_elementOID = null;
                this.s_elementValidOID = null;
                this.s_elementValidValue = null;
                return;
            }
            while (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
                this.sop("Token = " + string3);
                stringTokenizer = new StringTokenizer(string3, ":");
                if (stringTokenizer.countTokens() != 2) {
                    this.logToErrorFile("ERROR", this.entity, "No ElementOID or ElementValidOID or ElementValidValue or ElementRediscPeriod available");
                    continue;
                }
                string2 = stringTokenizer.nextToken();
                string = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("ElementOID")) {
                    this.s_elementOID = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("ElementValidOID")) {
                    this.s_elementValidOID = string;
                    continue;
                }
                if (string2.equalsIgnoreCase("ElementValidValue")) {
                    this.s_elementValidValue = string;
                    continue;
                }
                if (!string2.equalsIgnoreCase("ElementRediscPeriod")) continue;
                try {
                    this.l_rediscPeriod = Long.parseLong(string) * 60L * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    this.l_rediscPeriod = 3600000L;
                    numberFormatException.printStackTrace();
                }
            }
            this.b_firstTime = false;
        }
    }

    public void findValidElements() {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.runSnmpCmdForOid(this.s_elementOID)) {
            for (n = 0; n < this.lhs.length; ++n) {
                hashtable.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            this.validElementNames = new Hashtable();
            return;
        }
        this.validElementNames = hashtable;
        if (this.s_elementValidOID.equalsIgnoreCase("none")) {
            return;
        }
        if (this.runSnmpCmdForOid(this.s_elementValidOID)) {
            for (n = 0; n < this.lhs.length; ++n) {
                if (this.rhs[n].equals(this.s_elementValidValue)) continue;
                this.validElementNames.remove(this.lhs[n]);
            }
        }
    }
}

