/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.IniFile;
import com.eg.RUMAggregateStats;
import com.eg.RUMBeacon;
import com.eg.apm.EgLogbackManager;
import com.eg.apm.util.IPAddressMaskHelper;
import com.eg.apm.util.UrlParamMaskHelper;
import com.eg.org.slf4j.Logger;
import com.egurkha.util.EgSorter;
import com.egurkha.util.IPAddressUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EgRUMBase
extends GenericTest {
    public static final Logger logger = EgLogbackManager.getInstance().getLogger("TEST_LOGGER");
    private static final String rumInfoProps = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/logs/ruminfo.properties";
    private static final String path = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/logs/RUM_PageVisit_Counter_";
    public static final String Sync = new String("EgRUMBase Object Lock");
    private static Hashtable commonTestTimeMap = new Hashtable();
    private static Hashtable resultData = new Hashtable();
    public static Hashtable siteRumTimeMap = new Hashtable();
    private static Hashtable geoMMDBTable = new Hashtable();
    private static final String UNKNOWN_STRING = "Unknown";
    public static Hashtable flagTable = new Hashtable();
    private boolean isDone = false;
    private static Hashtable SendDDStatusMap = new Hashtable();
    private static HashMap serviceDDStatusMap = new HashMap();
    private String collectorDateFormat = "yyyy-MM-dd kk:mm:ss";
    private String egSorterDateFormat = "MM/dd/yyyy kk:mm:ss";
    private static final String myDatePattern = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat mySDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    private static final SimpleDateFormat finalFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US);
    private int req_per_day_count;
    private int present_request_count;
    private int prv_request_count;
    private int total_request_count;
    private String groupUrlCategoriesLimit;
    private String slowTransactionCutOff;
    private String tolerateCutOffINI;
    private String url_level;
    private String urlString;
    private String geoXmlUrlString;
    private String ignoreErrorMsg;
    private int slowTopNDD_Limit;
    private int errorTopNDD_Limit;
    public int healthyTopNDD_Limit;
    private String reqPerDay;
    private String show_exat_requests;
    private String is_trail;
    private boolean publicIPMaskFlag = false;
    private boolean privateIPMaskFlag = false;
    private boolean urlParamsMaskFlag = false;
    private String ipMaskCharValue = "x";
    String currentCount;
    public String allUrlPatterns;
    public String allFilterUrlPatterns;
    String collectorName;
    private String rumPerDayProps;
    public String serviceName;
    public static Hashtable keyTransactionPatterns = new Hashtable();
    public static Hashtable perDayLimitTable = new Hashtable();
    private boolean is_perday_limit_exceeded;
    public static Hashtable totalRequestDDTable = new Hashtable();
    private static boolean isGeoFileRead = false;
    private String propertyFileDirectory;
    private String filterFileName;
    private int NumberOfDays;
    private String rumUrlDelimiters;
    private int maxDecodeAttempts;
    private final int DEFAULT_MAX_DECODE_ATTEMPTS = 10;
    private String requiredPageTypes;
    private static final String MINUS_FIVE = "-5";
    private static final String HYPHEN = "-";
    private static HashMap<String, Long> geoXmlFileLastModifedTime = new HashMap();
    private static String GeoXMLFileDir = null;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private boolean useProxy;
    private boolean useProxyAuthentication;
    private boolean firstTime = false;
    private boolean dataFromNewCollector = false;
    protected static final Hashtable<String, ArrayList> newCollectorDD = new Hashtable();
    protected static final Hashtable<String, Boolean> serviceNameNewCollectorMapping = new Hashtable();
    protected static final DecimalFormat formatter = new DecimalFormat("#.##");
    static final ObjectMapper objectMapper = new ObjectMapper();
    private String isJsErrorsIncludedInApdex = "true";
    private String isIncludePageTypeInTopNDD = "false";
    double requestPerMinute;
    EgDateInfo dateInfo;
    private static Hashtable countryCodeNameMapping;
    String errorCount;
    String grpUrl;
    String urlParameters;
    String totalRequestDD;
    double slowCutOff = 0.0;
    double tolerateCutOff = 0.0;
    String[] counters = new String[]{"pageType", "url", "sessionId", "ip", "os", "device", "browserDetails", "country", "region", "city", "latitude", "longitude", "timeStr", "PageLoadTime", "FirstbyteTime", "ServerConnectionTime", "ResponseAvailableTime", "FrontEndTime", "DocumentReadyTime", "DocumentDownloadTime", "DocumentProcessingTime", "PageRenderTime", "errorCount", "error", "DNSLookupTime", "TCPConnectTime", "userAgent", "country_code", "referrer", "resourceTiming", "isNav", "isRsrc", "rumParentGUID", "rumBaseGUID", "gatewayIp", "SSLHandshakeTime", "AppCacheTime", "RedirectionTime", "BrowserWaitTime", "btmGuid", "btmNodeOrder", "btmExecTime", "networkDownlink", "networkEffectiveType", "networkRTT", "pageName", "meta", "status"};
    String[] errCounters = new String[]{"eventType", "timeStr", "rumParentGUID", "rumBaseGUID", "errMessage", "errFileName", "errLineNumber", "errColumnNumber", "errStack", "errMetaData"};
    public static final Double minusFive;
    public static final Double zeroDouble;
    HashMap sessionMapping = new HashMap();

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        countryCodeNameMapping = new Hashtable();
        minusFive = new Double(-5.0);
        zeroDouble = new Double(0.0);
    }

    public EgRUMBase(String[] args) {
        super(args);
        String ipMaskChar;
        String urlParamsMask;
        String privateIPMask;
        this.fixedTestPeriod = true;
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
        this.firstTime = false;
        this.slowTransactionCutOff = this.getValueForParam("Slow_Transaction_Cutoff");
        this.tolerateCutOffINI = this.getValueForParam("Tolerating_Cutoff");
        this.url_level = this.getValueForParam("Url_level_string");
        this.ignoreErrorMsg = this.getValueForParam("Ignore_Errors");
        this.reqPerDay = this.getValueForParam("Requests_Per_Day");
        this.show_exat_requests = this.getValueForParam("Show_Exat_limit");
        this.is_trail = this.getValueForParam("Is_Trail");
        this.totalRequestDD = this.getValueForParam("is_Total_Requests_DD");
        this.isJsErrorsIncludedInApdex = this.getValueForParam("Include_JSErrors");
        this.isIncludePageTypeInTopNDD = this.getValueForParam("Include_Pagetypes_In_TopNDD");
        String publicIPMask = this.getValueForParam("Mask_Public_IP");
        if (publicIPMask != null && (publicIPMask.equalsIgnoreCase("true") || publicIPMask.equalsIgnoreCase("yes"))) {
            this.publicIPMaskFlag = true;
        }
        if ((privateIPMask = this.getValueForParam("Mask_Private_IP")) != null && (privateIPMask.equalsIgnoreCase("true") || privateIPMask.equalsIgnoreCase("yes"))) {
            this.privateIPMaskFlag = true;
        }
        if ((urlParamsMask = this.getValueForParam("Mask_URL_Params")) != null && (urlParamsMask.equalsIgnoreCase("true") || urlParamsMask.equalsIgnoreCase("yes"))) {
            this.urlParamsMaskFlag = true;
        }
        if ((ipMaskChar = this.getValueForParam("IPMaskChar")) != null && ipMaskChar.length() > 0) {
            this.ipMaskCharValue = ipMaskChar;
        }
        if (this.isIncludePageTypeInTopNDD == null) {
            this.isIncludePageTypeInTopNDD = "false";
        }
        logger.debug("[" + this.reportingName + "][" + this.entity + "] slowTransactionCutOff=" + this.slowTransactionCutOff + " \t " + "tolerateCutOffINI=" + this.tolerateCutOffINI + " \t " + "url_level=" + this.url_level + " \t " + "ignoreErrorMsg=" + this.ignoreErrorMsg + " \t " + "reqPerDay=" + this.reqPerDay + " \t " + "show_exat_requests=" + this.show_exat_requests + " \t " + "is_trail=" + this.is_trail + " \t " + "totalRequestDD=" + this.totalRequestDD + " \t " + "isJsErrorsIncludedInApdex=" + this.isJsErrorsIncludedInApdex + " \t " + "isIncludePageTypeInTopNDD=" + this.isIncludePageTypeInTopNDD + " \t ");
        this.dateInfo = new EgDateInfo();
        this.createFile(rumInfoProps);
        this.groupUrlCategoriesLimit = this.getValueForParam("max_grouped_urls");
        String slowTopNDDStr = this.getValueForParam("max_slow_dd_count");
        String errorTopNDDStr = this.getValueForParam("max_error_dd_count");
        String healthyTopNDDStr = this.getValueForParam("max_healthy_dd_count");
        int slowTopNDDDefaultVal = 0;
        int errorTopNDDDefaultVal = 0;
        int healthyTopNDDDefaultVal = 0;
        this.slowTopNDD_Limit = this.parseInt(slowTopNDDStr, slowTopNDDDefaultVal);
        this.errorTopNDD_Limit = this.parseInt(errorTopNDDStr, errorTopNDDDefaultVal);
        this.healthyTopNDD_Limit = this.parseInt(healthyTopNDDStr, healthyTopNDDDefaultVal);
        this.allFilterUrlPatterns = this.getValueForParam("Filter_Url_Patterns");
        this.proxyHost = this.getValueForParam("proxyHost");
        this.proxyPort = this.getValueForParam("proxyPort");
        this.proxyUsername = this.getValueForParam("proxyUsername");
        this.proxyPassword = this.getValueForParam("proxyPassword");
        this.requiredPageTypes = this.getValueForParam("pageTypesToBeincludedindashboard");
        logger.debug("[" + this.reportingName + "][" + this.entity + "] healthyTopNDD_Limit=" + this.healthyTopNDD_Limit + " \t " + "groupUrlCategoriesLimit=" + this.groupUrlCategoriesLimit + " \t " + "slowTopNDD_Limit=" + this.slowTopNDD_Limit + " \t " + "errorTopNDD_Limit=" + this.errorTopNDD_Limit + " \t " + "allFilterUrlPatterns=" + this.allFilterUrlPatterns + " \t " + "proxyHost=" + this.proxyHost + " \t " + "proxyPort=" + this.proxyPort + " \t " + "proxyUsername=" + this.proxyUsername + " \t ");
        if (this.proxyHost != null && !this.proxyHost.equalsIgnoreCase("none")) {
            this.useProxy = true;
        }
        if (this.proxyUsername != null && !this.proxyUsername.equalsIgnoreCase("none") && this.proxyPassword != null && !this.proxyPassword.equalsIgnoreCase("none")) {
            this.useProxyAuthentication = true;
        }
        logger.debug("[" + this.reportingName + "][" + this.entity + "] useProxy=" + this.useProxy + " \t " + "useProxyAuthentication=" + this.useProxyAuthentication);
        if (!isGeoFileRead) {
            IniFile countryInifile = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_geodetails.ini");
            String[] countryNameArr = countryInifile.getVariables("COUNTRY_NAME_TO_CODE_MAPPING");
            int c = 0;
            while (c < countryNameArr.length) {
                String countryCode = countryInifile.getValue("COUNTRY_NAME_TO_CODE_MAPPING", countryNameArr[c]);
                countryCodeNameMapping.put(countryCode, countryNameArr[c]);
                ++c;
            }
            logger.debug("[" + this.reportingName + "][" + this.entity + "] countryCodeCountryName Map has been loaded !!!");
            isGeoFileRead = true;
        }
        try {
            this.slowCutOff = Double.parseDouble(this.slowTransactionCutOff);
            this.tolerateCutOff = Double.parseDouble(this.tolerateCutOffINI);
        }
        catch (Exception e) {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Exception while parsing the slow transaction cutoff threshold, so using the default cutoff");
            this.slowCutOff = 4000.0;
            this.tolerateCutOff = 16000.0;
        }
        logger.debug("[" + this.reportingName + "][" + this.entity + "] Calculated Tolerating cutoff is : " + this.tolerateCutOff);
        IniFile inifile = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_tests.ini");
        this.propertyFileDirectory = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/logs";
        this.filterFileName = "RUM_PageVisit_Counter_";
        try {
            this.NumberOfDays = Integer.parseInt(inifile.getValue("RUM_MISC_SETTINGS", "RumPerDayPageViewDetailsFileCleanupPeriod"));
        }
        catch (Exception ex) {
            this.NumberOfDays = 7;
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in getting NumberOfDays for cleanup the perDayLimit property files " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in getting NumberOfDays for cleanup the perDayLimit property files ", (Throwable)ex);
        }
        try {
            this.rumUrlDelimiters = inifile.getValue("RUM_MISC_SETTINGS", "rumUrlDelimiters");
            if (this.rumUrlDelimiters == null) {
                this.rumUrlDelimiters = "?,;";
            }
        }
        catch (Exception e) {
            this.rumUrlDelimiters = "?,;";
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in getting RumUrlDelimiters for getting URL " + e.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in getting RumUrlDelimiters for getting URL  ", (Throwable)e);
        }
        try {
            String maxDecodeAttemptsStr = inifile.getValue("RUM_MISC_SETTINGS", "maxDecodeAttempts");
            this.maxDecodeAttempts = maxDecodeAttemptsStr != null ? Integer.parseInt(maxDecodeAttemptsStr) : 10;
        }
        catch (Exception e) {
            this.maxDecodeAttempts = 10;
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Exception in getting decodeUrlCount for decoding URL, so using default decodeUrlCount");
        }
        GeoXMLFileDir = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/GeoXmlFiles";
        logger.debug("[" + this.reportingName + "][" + this.entity + "] propertyFileDirectory=" + this.propertyFileDirectory + " \t " + "filterFileName=" + this.filterFileName + " \t " + "NumberOfDays=" + this.NumberOfDays + " \t " + "rumUrlDelimiters=" + this.rumUrlDelimiters + " \t " + "maxDecodeAttempts=" + this.maxDecodeAttempts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean computeValues() {
        logger.debug("[" + this.reportingName + "][" + this.entity + "] Start executing EgRumBase compute values for Service Name : " + this.reportingName + ", Port: " + this.portNo);
        flagTable.put(this.reportingName, "true");
        if (this.is_trail.equalsIgnoreCase("true")) {
            String dateAsString = this.getCurrentDateAsString("ddMMMyyyy");
            this.rumPerDayProps = String.valueOf(path) + dateAsString + ".properties";
            this.createFile(this.rumPerDayProps);
        }
        this.serviceName = this.reportingName;
        String targetUrl = "";
        IniFile inifile = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_tests.ini");
        String serviceNameAsGuid = inifile.getValue("RUM_ServiceName_Mapping", this.serviceName);
        if (serviceNameAsGuid == null || serviceNameAsGuid.length() <= 0) {
            serviceNameAsGuid = this.serviceName;
        }
        this.collectorName = inifile.getValue("Real_user_monitor_URL_Mapping", this.reportingName);
        targetUrl = inifile.getValue("PRIVATE_RUM_COLLECTORS", this.collectorName);
        logger.debug("[" + this.reportingName + "][" + this.entity + "] Private Collector URL is : " + targetUrl);
        if (targetUrl == null || targetUrl.length() <= 0) {
            targetUrl = inifile.getValue("PUBLIC_RUM_COLLECTORS", this.collectorName);
            logger.debug("[" + this.reportingName + "][" + this.entity + "] The Private Collector URL is not found using public collector URL !!!");
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Public Collector URL is : " + targetUrl);
        }
        if (targetUrl == null || targetUrl.length() <= 0) {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Unable get the target Collector URL for service : " + this.serviceName);
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Terminating the test execution !!!");
            return this.checkNewCollector(serviceNameAsGuid);
        }
        if (targetUrl.trim().startsWith("https")) {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Setting SSL Properties");
            this.enableSsl();
        }
        Date local_date = new Date(this.dateInfo.egetUTCDate());
        TimeZone timezone = EgDateInfo.getRealTimeZone();
        String timeZoneID = timezone.getID();
        String timeZoneIDShort = timezone.getDisplayName(timezone.inDaylightTime(local_date), 0);
        logger.debug("[" + this.reportingName + "][" + this.entity + "] timeZoneID=" + timeZoneID + " \t " + "timeZoneIDShort=" + timeZoneIDShort);
        this.urlString = targetUrl;
        String uri2 = "rumcollector/servlet/com.eg.RumMeasureData";
        String geoXmlUri = "rumcollector/servlet/com.eg.GeoXmlDownload?serviceNameAsGuid=" + serviceNameAsGuid;
        this.geoXmlUrlString = String.valueOf(targetUrl) + "/" + geoXmlUri;
        this.urlString = String.valueOf(this.urlString) + "/" + uri2;
        logger.debug("[" + this.reportingName + "][" + this.entity + "] Final Collector URL : " + this.urlString);
        if (this.totalRequestDD != null && this.totalRequestDD.equalsIgnoreCase("true")) {
            totalRequestDDTable.put(this.serviceName, new Boolean(true));
        } else {
            totalRequestDDTable.put(this.serviceName, new Boolean(false));
        }
        String string = this.reportingName;
        synchronized (string) {
            long prevTime = this.getPrevRunTime();
            long now = System.currentTimeMillis();
            long diff = now - prevTime;
            this.requestPerMinute = (double)(diff / 1000L) / 60.0;
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Request per minute: " + this.requestPerMinute + ", Measure period: " + this.measurePeriod + ".");
            logger.debug("[" + this.reportingName + "][" + this.entity + "] prevTime: " + prevTime + ", time now: " + now + " measure period is " + 0.9 * (double)this.measurePeriod);
            if ((double)diff >= 0.9 * (double)this.measurePeriod) {
                this.isDone = true;
                this.setLastRunTime(now);
                serviceDDStatusMap.put(this.serviceName, "Not-Sent");
                logger.debug("[" + this.reportingName + "][" + this.entity + "] Next measurement cycle is started !!! ");
            } else {
                this.isDone = false;
                this.firstTime = true;
                this.testDateAndTime = (String)commonTestTimeMap.get(String.valueOf(this.reportingName) + ":" + this.portNo);
                logger.debug("[" + this.reportingName + "][" + this.entity + "] Next measurement cycle is not started !!!");
            }
            EgTestInfo ti = new EgTestInfo("agent");
            if (ti.isDDDisabled(this.entity) || ti.isDDDisabled(this.reportingName, this.portNo, null, this.entity)) {
                SendDDStatusMap.put(String.valueOf(this.serviceName) + ":" + this.entity, new Boolean(true));
                logger.trace("[" + this.reportingName + "][" + this.entity + "] DD is disabled");
            } else {
                String status = (String)serviceDDStatusMap.get(this.serviceName);
                if (status != null && status.length() > 0) {
                    if (status.equalsIgnoreCase("sent")) {
                        SendDDStatusMap.put(String.valueOf(this.serviceName) + ":" + this.entity, new Boolean(true));
                    } else {
                        serviceDDStatusMap.put(this.serviceName, "sent");
                        SendDDStatusMap.put(String.valueOf(this.serviceName) + ":" + this.entity, new Boolean(false));
                    }
                } else {
                    serviceDDStatusMap.put(this.serviceName, "sent");
                    SendDDStatusMap.put(String.valueOf(this.serviceName) + ":" + this.entity, new Boolean(false));
                }
            }
            HashMap agentManagerInfo = this.getAgentMangerDetails();
            String managerIP = null;
            String managerPort = null;
            String agentIP = null;
            if (agentManagerInfo != null && agentManagerInfo.size() > 0) {
                managerIP = (String)agentManagerInfo.get("managerIP");
                managerPort = (String)agentManagerInfo.get("managerPort");
                agentIP = (String)agentManagerInfo.get("agentIP");
            }
            logger.debug("Current GUID : " + serviceNameAsGuid + ", Current GUID Agent Manger Details: " + agentManagerInfo);
            if (this.isDone) {
                System.gc();
                String filterUrlPatternsKey = String.valueOf(this.reportingName) + "-filterUrlPatterns";
                String oldFilterUrlPatterns = this.getPreviousCount(rumInfoProps, filterUrlPatternsKey);
                if (oldFilterUrlPatterns != null) {
                    if (!oldFilterUrlPatterns.equalsIgnoreCase(this.allFilterUrlPatterns)) {
                        this.setCurrentCount(this.allFilterUrlPatterns, rumInfoProps, filterUrlPatternsKey);
                        this.urlParameters = "service=" + serviceNameAsGuid + "&" + "timeZoneStr=" + timeZoneID + "&" + "filterUrlPatterns=" + this.allFilterUrlPatterns;
                    } else {
                        this.urlParameters = "service=" + serviceNameAsGuid + "&" + "timeZoneStr=" + timeZoneID;
                    }
                } else {
                    this.setCurrentCount(this.allFilterUrlPatterns, rumInfoProps, filterUrlPatternsKey);
                    this.urlParameters = "service=" + serviceNameAsGuid + "&" + "timeZoneStr=" + timeZoneID + "&" + "filterUrlPatterns=" + this.allFilterUrlPatterns;
                }
                StringBuilder builder = new StringBuilder();
                builder.append(this.urlParameters).append("&collectorName=").append(this.collectorName).append("&componentName=").append(this.serviceName).append("&agentIP=").append(agentIP);
                builder.append("&managerIP=").append(managerIP).append("&managerPort=").append(managerPort);
                if (!this.firstTime) {
                    builder.append("&collAggr=true&slowTransactionCutOff=").append(this.slowTransactionCutOff);
                    builder.append("&tolerateCutOffINI=").append(this.tolerateCutOffINI).append("&url_level=").append(this.url_level).append("&agentRestarted=true");
                }
                this.urlParameters = builder.toString();
                logger.debug("[{}][{}] Parameters for collector request : {}", new Object[]{this.reportingName, this.entity, this.urlParameters});
                commonTestTimeMap.put(String.valueOf(this.reportingName) + ":" + this.portNo, this.testDateAndTime);
                try {
                    Hashtable resultDataTable = this.getCurrentMeasurePeriodData();
                    if (this.is_trail.equalsIgnoreCase("true")) {
                        resultDataTable = this.chekForPerDayLimit(resultDataTable);
                        logger.debug("[" + this.reportingName + "][" + this.entity + "] is_perday_limit_exceeded : " + this.is_perday_limit_exceeded);
                        if (this.is_perday_limit_exceeded) {
                            logger.debug("[" + this.reportingName + "][" + this.entity + "] Daily limit has been exceeded, Terminating the test execution !!!");
                            return this.checkNewCollector(serviceNameAsGuid);
                        }
                    } else {
                        this.is_perday_limit_exceeded = false;
                        perDayLimitTable.put(this.reportingName, new Boolean(false));
                    }
                    if (resultData.containsKey(this.serviceName)) {
                        resultData.remove(this.serviceName);
                    }
                    logger.trace("[" + this.reportingName + "][" + this.entity + "] resultDataTable in EgRUMBase : " + resultDataTable.size());
                    if (resultDataTable != null && !resultDataTable.isEmpty()) {
                        if (this.dataFromNewCollector) {
                            this.formatNewCollectorData(resultDataTable);
                        } else {
                            Hashtable<String, RUMMeasureData> all = new Hashtable<String, RUMMeasureData>();
                            Hashtable<String, RumErrorData> allError = new Hashtable<String, RumErrorData>();
                            HashSet<String> ipList = new HashSet<String>();
                            GeoLocalXmlFile geoLocalXmlFile = new GeoLocalXmlFile(this.reportingName);
                            Hashtable groupHealthyDDTable = new Hashtable();
                            Hashtable groupSlowDDTable = new Hashtable();
                            Hashtable groupErrorDDTable = new Hashtable();
                            Enumeration resultDatakeys = resultDataTable.keys();
                            while (resultDatakeys.hasMoreElements()) {
                                ArrayList<Object> reqDDList;
                                String status;
                                String meta;
                                String groupUrl;
                                String networkRTT;
                                String networkEffectiveType;
                                String networkDownlink;
                                String btmExecTime;
                                String btmNodeOrder;
                                String btmGuid;
                                String gatewayIp;
                                String rumBaseGUID;
                                String rumParentGUID;
                                String isRsrc;
                                String isNav;
                                int pipe_index;
                                String key = (String)resultDatakeys.nextElement();
                                Hashtable ht = (Hashtable)resultDataTable.get(key);
                                String isErrorEvent = (String)ht.get(this.errCounters[0]);
                                if (isErrorEvent != null) {
                                    String requestTime = (String)ht.get(this.errCounters[1]);
                                    String rumParentGUID2 = (String)ht.get(this.errCounters[2]);
                                    String rumBaseGUID2 = (String)ht.get(this.errCounters[3]);
                                    String errGUID = key;
                                    String errMessage = (String)ht.get(this.errCounters[4]);
                                    String errFileName = (String)ht.get(this.errCounters[5]);
                                    String errLineNumber = (String)ht.get(this.errCounters[6]);
                                    String errColumnNumber = (String)ht.get(this.errCounters[7]);
                                    String errStack = (String)ht.get(this.errCounters[8]);
                                    String errMetaData = (String)ht.get(this.errCounters[9]);
                                    RumErrorData rumErrorObj = new RumErrorData();
                                    rumErrorObj.setErrGUID(errGUID);
                                    rumErrorObj.setRequestTime(requestTime);
                                    rumErrorObj.setTimeZoneID(timeZoneIDShort);
                                    rumErrorObj.setRumParentGUID(rumParentGUID2);
                                    rumErrorObj.setRumBaseGUID(rumBaseGUID2);
                                    rumErrorObj.setErrMessage(errMessage);
                                    rumErrorObj.setErrFileName(errFileName);
                                    rumErrorObj.setErrLineNumber(errLineNumber);
                                    rumErrorObj.setErrColumnNumber(errColumnNumber);
                                    rumErrorObj.setErrStack(errStack);
                                    rumErrorObj.setErrMetaData(errMetaData);
                                    allError.put(key, rumErrorObj);
                                    continue;
                                }
                                boolean filterUrlmatches = false;
                                String mesurl = (String)ht.get(this.counters[1]);
                                if (mesurl != null && this.isUrlEncoded(mesurl)) {
                                    int numDecodeAttempts = 0;
                                    String decodeUrl = mesurl;
                                    while (numDecodeAttempts <= this.maxDecodeAttempts) {
                                        ++numDecodeAttempts;
                                        if (!this.isUrlEncoded(decodeUrl = this.decodeUrl(decodeUrl))) break;
                                    }
                                    mesurl = decodeUrl;
                                }
                                if (!this.allFilterUrlPatterns.equalsIgnoreCase("None")) {
                                    StringTokenizer st4 = new StringTokenizer(this.allFilterUrlPatterns, ",");
                                    while (st4.hasMoreTokens()) {
                                        String filterUrl = st4.nextToken();
                                        boolean flag = this.patternMatch(mesurl, filterUrl);
                                        if (!flag) continue;
                                        filterUrlmatches = true;
                                        break;
                                    }
                                }
                                if (filterUrlmatches) {
                                    logger.debug("[" + this.reportingName + "][" + this.entity + "] mesurl " + mesurl + " matches with filter url So, we ignore this page view !!!");
                                    continue;
                                }
                                String mesURLFragment = HYPHEN;
                                try {
                                    mesURLFragment = new URI(mesurl).getFragment();
                                    if (mesURLFragment == null) {
                                        mesURLFragment = HYPHEN;
                                    }
                                }
                                catch (Exception e) {
                                    mesURLFragment = HYPHEN;
                                }
                                String userAgent = "";
                                String country_code = HYPHEN;
                                country_code = (String)ht.get(this.counters[27]);
                                if (country_code == null) {
                                    country_code = HYPHEN;
                                }
                                if ((userAgent = (String)ht.get(this.counters[26])) == null) {
                                    userAgent = "";
                                }
                                String referrer = (String)ht.get(this.counters[28]);
                                String userName = HYPHEN;
                                String pageType = (String)ht.get(this.counters[0]);
                                String sessionId = (String)ht.get(this.counters[2]);
                                if (sessionId != null && (pipe_index = sessionId.indexOf("||")) > 0) {
                                    String sessionString = sessionId.substring(0, pipe_index);
                                    String btmNodeId = sessionId.substring(pipe_index + 2);
                                    String btmSessionId = Base64Coder.decodeString(sessionString);
                                    if (btmNodeId != null) {
                                        if (btmNodeId.startsWith("[")) {
                                            btmNodeId = btmNodeId.substring(1);
                                        }
                                        if (btmNodeId.endsWith("]")) {
                                            btmNodeId = btmNodeId.substring(0, btmNodeId.length() - 1);
                                        }
                                    }
                                    if (btmSessionId.indexOf("#|#") > 0) {
                                        String btmSessionIdParsed = btmSessionId.substring(0, btmSessionId.indexOf("#|#"));
                                        userName = btmSessionId.substring(btmSessionId.lastIndexOf("#|#") + 3);
                                        btmSessionId = btmSessionIdParsed;
                                    }
                                    if (btmSessionId.length() > 43) {
                                        String sessionIDStart = btmSessionId.substring(0, 7);
                                        String sessionIDend = btmSessionId.substring(43);
                                        sessionId = String.valueOf(sessionIDStart) + sessionIDend + "||" + btmNodeId;
                                    } else {
                                        sessionId = !btmSessionId.equals(HYPHEN) ? String.valueOf(btmSessionId) + "||" + btmNodeId : "";
                                    }
                                    if (userName != null && !userName.equals(HYPHEN)) {
                                        boolean isUserNameEncoded = this.isUrlEncoded(userName);
                                        if (isUserNameEncoded) {
                                            userName = this.decodeUrl(userName);
                                        }
                                        if (this.sessionMapping != null && !this.sessionMapping.containsKey(sessionId)) {
                                            this.sessionMapping.put(sessionId, userName);
                                        }
                                    } else if (this.sessionMapping != null && this.sessionMapping.containsKey(sessionId)) {
                                        userName = (String)this.sessionMapping.get(sessionId);
                                    }
                                }
                                String ip = (String)ht.get(this.counters[3]);
                                String os = (String)ht.get(this.counters[4]);
                                String device2 = (String)ht.get(this.counters[5]);
                                String browserDetail = (String)ht.get(this.counters[6]);
                                String country = "";
                                country = countryCodeNameMapping.containsKey(country_code) ? (String)countryCodeNameMapping.get(country_code) : (String)ht.get(this.counters[7]);
                                String region = (String)ht.get(this.counters[8]);
                                String city = (String)ht.get(this.counters[9]);
                                String latitude = (String)ht.get(this.counters[10]);
                                String longitude = (String)ht.get(this.counters[11]);
                                ArrayList geoDetails = geoLocalXmlFile.getLocation(ip);
                                logger.debug("[" + this.reportingName + "][" + this.entity + "] Geo Location Details from Local XML File IP :" + ip + " ,Geo Location :" + geoDetails);
                                boolean isDefaultGeo = geoLocalXmlFile.isDefault(geoDetails);
                                if (geoDetails != null && geoDetails.size() >= 6) {
                                    boolean isIPExist;
                                    country = (String)geoDetails.get(0);
                                    country_code = (String)geoDetails.get(1);
                                    if (countryCodeNameMapping.containsKey(country_code)) {
                                        country = (String)countryCodeNameMapping.get(country_code);
                                    }
                                    String tempRegion = (String)geoDetails.get(2);
                                    String tempCity = (String)geoDetails.get(3);
                                    ByteBuffer byteBufferRegion = StandardCharsets.UTF_8.encode(tempRegion);
                                    region = new String(byteBufferRegion.array(), StandardCharsets.UTF_8);
                                    ByteBuffer byteBufferCity = StandardCharsets.UTF_8.encode(tempCity);
                                    city = new String(byteBufferCity.array(), StandardCharsets.UTF_8);
                                    latitude = (String)geoDetails.get(4);
                                    longitude = (String)geoDetails.get(5);
                                    if (isDefaultGeo && !(isIPExist = geoMMDBTable.containsKey(ip))) {
                                        ipList.add(ip);
                                    }
                                } else {
                                    boolean isIPExist = geoMMDBTable.containsKey(ip);
                                    if (!isIPExist) {
                                        ipList.add(ip);
                                    }
                                }
                                String timeStr = (String)ht.get(this.counters[12]);
                                String PageLoadTime = (String)ht.get(this.counters[13]);
                                String FirstbyteTime = (String)ht.get(this.counters[14]);
                                String ServerConnectionTime = (String)ht.get(this.counters[15]);
                                String ResponseAvailableTime = (String)ht.get(this.counters[16]);
                                String FrontEndTime = (String)ht.get(this.counters[17]);
                                String DocumentReadyTime = (String)ht.get(this.counters[18]);
                                String DocumentDownloadTime = (String)ht.get(this.counters[19]);
                                String DocumentProcessingTime = (String)ht.get(this.counters[20]);
                                String PageRenderTime = (String)ht.get(this.counters[21]);
                                String error = (String)ht.get(this.counters[23]);
                                String resourceTimingDetails = (String)ht.get(this.counters[29]);
                                if (resourceTimingDetails == null || resourceTimingDetails.length() <= 0 || resourceTimingDetails.equals("{}")) {
                                    resourceTimingDetails = HYPHEN;
                                }
                                if ((isNav = (String)ht.get(this.counters[30])) == null) {
                                    isNav = MINUS_FIVE;
                                }
                                if ((isRsrc = (String)ht.get(this.counters[31])) == null) {
                                    isRsrc = MINUS_FIVE;
                                }
                                if ((rumParentGUID = (String)ht.get(this.counters[32])) == null) {
                                    rumParentGUID = HYPHEN;
                                }
                                if ((rumBaseGUID = (String)ht.get(this.counters[33])) == null) {
                                    rumBaseGUID = HYPHEN;
                                }
                                if ((gatewayIp = (String)ht.get(this.counters[34])) == null) {
                                    gatewayIp = HYPHEN;
                                }
                                long browserInitiReqValue = 0L;
                                String appCacheTime = (String)ht.get(this.counters[36]);
                                if (appCacheTime == null || appCacheTime.length() <= 0 || appCacheTime.equals(MINUS_FIVE)) {
                                    appCacheTime = MINUS_FIVE;
                                } else {
                                    browserInitiReqValue += this.parseLong(appCacheTime, 0L);
                                }
                                String redirectionTime = (String)ht.get(this.counters[37]);
                                if (redirectionTime == null || redirectionTime.length() <= 0 || redirectionTime.equals(MINUS_FIVE)) {
                                    redirectionTime = MINUS_FIVE;
                                } else {
                                    browserInitiReqValue += this.parseLong(redirectionTime, 0L);
                                }
                                String browserWaitTime = (String)ht.get(this.counters[38]);
                                if (browserWaitTime == null || browserWaitTime.length() <= 0 || browserWaitTime.equals(MINUS_FIVE)) {
                                    browserWaitTime = MINUS_FIVE;
                                } else {
                                    browserInitiReqValue += this.parseLong(browserWaitTime, 0L);
                                }
                                if (appCacheTime.equals(MINUS_FIVE) && redirectionTime.equals(MINUS_FIVE) && browserWaitTime.equals(MINUS_FIVE)) {
                                    browserInitiReqValue = -5L;
                                }
                                if ((btmGuid = (String)ht.get(this.counters[39])) == null || btmGuid.length() <= 0) {
                                    btmGuid = HYPHEN;
                                }
                                if ((btmNodeOrder = (String)ht.get(this.counters[40])) == null || btmNodeOrder.length() <= 0) {
                                    btmNodeOrder = HYPHEN;
                                }
                                if ((btmExecTime = (String)ht.get(this.counters[41])) == null || btmExecTime.length() <= 0 || btmExecTime.equals(HYPHEN)) {
                                    btmExecTime = "0.0";
                                }
                                if ((networkDownlink = (String)ht.get(this.counters[42])) == null || networkDownlink.length() <= 0) {
                                    networkDownlink = MINUS_FIVE;
                                }
                                if ((networkEffectiveType = (String)ht.get(this.counters[43])) == null || networkEffectiveType.length() <= 0) {
                                    networkEffectiveType = HYPHEN;
                                }
                                if ((networkRTT = (String)ht.get(this.counters[44])) == null || networkRTT.length() <= 0) {
                                    networkRTT = MINUS_FIVE;
                                }
                                if ((groupUrl = this.getGroupUrl(mesurl, this.url_level)) == null) {
                                    groupUrl = HYPHEN;
                                }
                                StringTokenizer tokenizer = new StringTokenizer(this.rumUrlDelimiters, ",");
                                String mesURLParams = null;
                                ArrayList<Integer> delimiterIndexList = new ArrayList<Integer>();
                                while (tokenizer.hasMoreTokens()) {
                                    String delimiter = tokenizer.nextToken();
                                    if (mesurl.indexOf(delimiter) <= -1) continue;
                                    delimiterIndexList.add(mesurl.indexOf(delimiter));
                                }
                                Collections.sort(delimiterIndexList);
                                if (delimiterIndexList.size() > 0) {
                                    int delimiterIdx = (Integer)delimiterIndexList.get(0);
                                    mesURLParams = mesurl.substring(delimiterIdx + 1);
                                    mesurl = mesurl.substring(0, delimiterIdx);
                                }
                                if (mesURLParams != null) {
                                    int hashIndex = mesURLParams.indexOf("#");
                                    if (hashIndex > -1) {
                                        mesURLParams = mesURLParams.substring(0, hashIndex);
                                    }
                                } else {
                                    mesURLParams = HYPHEN;
                                }
                                if (mesURLParams.length() > 2000) {
                                    mesURLParams = String.valueOf(mesURLParams.substring(0, 1995)) + "...";
                                }
                                if (PageLoadTime == null || PageLoadTime.length() == 0) {
                                    PageLoadTime = new Double(Double.parseDouble(FrontEndTime) + Double.parseDouble(FirstbyteTime)).toString();
                                }
                                if (latitude.equals("") || longitude.equals("")) {
                                    latitude = "0.00";
                                    longitude = "0.00";
                                }
                                double loadTime = Double.parseDouble(PageLoadTime);
                                boolean isSlow = false;
                                boolean isError = false;
                                RUMMeasureData rumPojo = new RUMMeasureData();
                                String pageName = (String)ht.get(this.counters[45]);
                                if (pageName == null || pageName.length() <= 0) {
                                    pageName = HYPHEN;
                                }
                                if ((meta = (String)ht.get(this.counters[46])) == null || meta.length() <= 0) {
                                    meta = HYPHEN;
                                }
                                if ((status = (String)ht.get(this.counters[47])) == null || status.length() <= 0) {
                                    status = HYPHEN;
                                }
                                isError = this.hasJSError(error, this.ignoreErrorMsg);
                                if (status.equalsIgnoreCase("error")) {
                                    isError = true;
                                    rumPojo.setErrorRequest(isError);
                                }
                                isSlow = this.isSlowPageView(loadTime, this.slowCutOff);
                                if (!isError && isSlow) {
                                    rumPojo.setSlowRequest(true);
                                }
                                this.computeAndUpdateUserExperienceStatus(loadTime, this.slowCutOff, this.tolerateCutOff, isError, rumPojo);
                                rumPojo.setErrorMessage(error);
                                rumPojo.setKey(key);
                                rumPojo.setRequestTime(timeStr);
                                String mesURLProtocol = HYPHEN;
                                String mesURLDomain = HYPHEN;
                                String mesURLPort = HYPHEN;
                                try {
                                    URL mesUrlObj = new URL(mesurl);
                                    mesURLProtocol = mesUrlObj.getProtocol();
                                    mesURLDomain = mesUrlObj.getHost();
                                    int port = mesUrlObj.getPort();
                                    mesURLPort = port == -1 ? HYPHEN : String.valueOf(port);
                                    mesurl = mesUrlObj.getPath();
                                }
                                catch (Exception e) {
                                    mesURLProtocol = HYPHEN;
                                    mesURLDomain = HYPHEN;
                                    mesURLPort = HYPHEN;
                                }
                                long networktime = 0L;
                                String DNSLookupTime = (String)ht.get(this.counters[24]);
                                String TCPConnectTime = (String)ht.get(this.counters[25]);
                                String sslHandshakeTime = (String)ht.get(this.counters[35]);
                                if (DNSLookupTime == null || DNSLookupTime.length() <= 0 || DNSLookupTime.equals(MINUS_FIVE)) {
                                    DNSLookupTime = MINUS_FIVE;
                                } else {
                                    networktime += this.parseLong(DNSLookupTime, 0L);
                                }
                                if (TCPConnectTime == null || TCPConnectTime.length() <= 0 || TCPConnectTime.equals(MINUS_FIVE)) {
                                    TCPConnectTime = MINUS_FIVE;
                                } else {
                                    networktime += this.parseLong(TCPConnectTime, 0L);
                                }
                                if (sslHandshakeTime == null || sslHandshakeTime.length() <= 0 || mesURLProtocol.equalsIgnoreCase("http")) {
                                    sslHandshakeTime = MINUS_FIVE;
                                } else {
                                    networktime += this.parseLong(sslHandshakeTime, 0L);
                                }
                                if (DNSLookupTime.equals(MINUS_FIVE) && TCPConnectTime.equals(MINUS_FIVE) && sslHandshakeTime.equals(MINUS_FIVE)) {
                                    networktime = -5L;
                                }
                                int isNavInt = this.changeStringToIntegerVal(isNav, -5);
                                rumPojo.setUrlProtocol(mesURLProtocol);
                                rumPojo.setUrlDomain(mesURLDomain);
                                rumPojo.setUrlPort(mesURLPort);
                                rumPojo.setUrlParams(mesURLParams);
                                rumPojo.setUrlString(mesurl);
                                rumPojo.setApplicationName(this.serviceName);
                                rumPojo.setGroupName(groupUrl);
                                rumPojo.setPageType(pageType);
                                rumPojo.setUserSession(sessionId);
                                rumPojo.setRequestPerMinute(this.changedoubleToDoubleVal(this.requestPerMinute));
                                rumPojo.setIpAddress(ip);
                                rumPojo.setGatewayIpAddress(gatewayIp);
                                rumPojo.setDevice(device2);
                                rumPojo.setBrowser(browserDetail);
                                rumPojo.setOs(os);
                                rumPojo.setCountry(country);
                                rumPojo.setCountryCode(country_code);
                                rumPojo.setRegion(region);
                                rumPojo.setCity(city);
                                rumPojo.setUserAgent(userAgent);
                                rumPojo.setTimeZone(timeZoneIDShort);
                                rumPojo.setIgnoreErrorMessage(this.ignoreErrorMsg);
                                rumPojo.setReferrer(referrer);
                                rumPojo.setResourceTimingDetails(resourceTimingDetails);
                                rumPojo.setSlowTime(this.changedoubleToDoubleVal(this.slowCutOff));
                                rumPojo.setToleratedTime(this.changedoubleToDoubleVal(this.tolerateCutOff));
                                rumPojo.setPageLoadTime(this.changeStringToDoubleVal(PageLoadTime));
                                rumPojo.setFrontEndtime(this.changeStringToDoubleVal(FrontEndTime));
                                rumPojo.setPageRenderTime(this.changeStringToDoubleVal(PageRenderTime));
                                rumPojo.setDocumentReadyTime(this.changeStringToDoubleVal(DocumentReadyTime));
                                rumPojo.setDocumentDownloadTime(this.changeStringToDoubleVal(DocumentDownloadTime));
                                rumPojo.setDocumentProcessingTime(this.changeStringToDoubleVal(DocumentProcessingTime));
                                rumPojo.setFirstByteTime(this.changeStringToDoubleVal(FirstbyteTime));
                                rumPojo.setResponseAvailableTime(this.changeStringToDoubleVal(ResponseAvailableTime));
                                rumPojo.setServerConnectionTime(this.changeStringToDoubleVal(ServerConnectionTime));
                                rumPojo.setDNSLookUpTime(this.changeStringToDoubleVal(DNSLookupTime));
                                rumPojo.setTCPConnectionTime(this.changeStringToDoubleVal(TCPConnectTime));
                                rumPojo.setLatitude(this.changeStringToDoubleVal(latitude));
                                rumPojo.setLongitude(this.changeStringToDoubleVal(longitude));
                                rumPojo.setIsNavigationSupport(isNavInt);
                                rumPojo.setIsResourceSupport(this.changeStringToIntegerVal(isRsrc, -5));
                                rumPojo.setRumParentGUID(rumParentGUID);
                                rumPojo.setRumBaseGUID(rumBaseGUID);
                                rumPojo.setSslHandshakeTime(this.changeStringToDoubleVal(sslHandshakeTime));
                                rumPojo.setAppCacheTime(this.changeStringToDoubleVal(appCacheTime));
                                rumPojo.setRedirectionTime(this.changeStringToDoubleVal(redirectionTime));
                                rumPojo.setBrowserWaitTime(this.changeStringToDoubleVal(browserWaitTime));
                                rumPojo.setBrowserInitialReqTime(browserInitiReqValue);
                                rumPojo.setBtmGuid(btmGuid);
                                rumPojo.setBtmNodeOrder(btmNodeOrder);
                                rumPojo.setBtmExecTime(this.changeStringToDoubleVal(btmExecTime));
                                rumPojo.setNetworkDownlink(this.changeStringToDoubleVal(networkDownlink));
                                rumPojo.setNetworkEffectiveType(networkEffectiveType);
                                rumPojo.setNetworkRTT(this.changeStringToDoubleVal(networkRTT));
                                if (pageType.equals("Page") || pageType.equals("IFrame")) {
                                    if (isNavInt == 0) {
                                        rumPojo.setNetworkTime(-5.0);
                                        rumPojo.setServerTime(this.changeStringToDoubleVal(FirstbyteTime));
                                        rumPojo.setContentDownloadTime(this.changeStringToDoubleVal(DocumentReadyTime));
                                        rumPojo.setBrowserRenderingTime(this.changeStringToDoubleVal(PageRenderTime));
                                    } else if (isNavInt == 1) {
                                        rumPojo.setNetworkTime(networktime);
                                        rumPojo.setServerTime(this.changeStringToDoubleVal(ResponseAvailableTime));
                                        rumPojo.setContentDownloadTime(this.changeStringToDoubleVal(DocumentReadyTime));
                                        rumPojo.setBrowserRenderingTime(this.changeStringToDoubleVal(PageRenderTime));
                                    } else {
                                        double dptDouble;
                                        double ddtDouble;
                                        double fbtDouble;
                                        double pltDouble = this.changeStringToDoubleVal(PageLoadTime);
                                        if (pltDouble == (fbtDouble = this.changeStringToDoubleVal(FirstbyteTime).doubleValue()) + (ddtDouble = this.changeStringToDoubleVal(DocumentDownloadTime).doubleValue()) + (dptDouble = this.changeStringToDoubleVal(DocumentProcessingTime).doubleValue())) {
                                            rumPojo.setNetworkTime(-5.0);
                                            rumPojo.setServerTime(this.changeStringToDoubleVal(FirstbyteTime));
                                            rumPojo.setContentDownloadTime(this.changeStringToDoubleVal(DocumentReadyTime));
                                            rumPojo.setBrowserRenderingTime(this.changeStringToDoubleVal(PageRenderTime));
                                        } else {
                                            rumPojo.setNetworkTime(networktime);
                                            rumPojo.setServerTime(this.changeStringToDoubleVal(ResponseAvailableTime));
                                            rumPojo.setContentDownloadTime(this.changeStringToDoubleVal(DocumentReadyTime));
                                            rumPojo.setBrowserRenderingTime(this.changeStringToDoubleVal(PageRenderTime));
                                        }
                                    }
                                } else if (pageType.equals("Ajax")) {
                                    if (TCPConnectTime.equals(MINUS_FIVE)) {
                                        rumPojo.setNetworkTime(-5.0);
                                        rumPojo.setServerTime(this.changeStringToDoubleVal(FirstbyteTime));
                                        rumPojo.setResponseAvailableTime(this.changeStringToDoubleVal(FirstbyteTime));
                                        rumPojo.setContentDownloadTime(this.changeStringToDoubleVal(DocumentDownloadTime));
                                        rumPojo.setDocumentReadyTime(this.changeStringToDoubleVal(DocumentDownloadTime));
                                        rumPojo.setBrowserRenderingTime(this.changeStringToDoubleVal(DocumentProcessingTime));
                                        rumPojo.setPageRenderTime(this.changeStringToDoubleVal(DocumentProcessingTime));
                                        rumPojo.setDocumentProcessingTime(0.0);
                                    } else {
                                        rumPojo.setNetworkTime(networktime);
                                        rumPojo.setServerTime(this.changeStringToDoubleVal(ResponseAvailableTime));
                                        rumPojo.setContentDownloadTime(this.changeStringToDoubleVal(DocumentReadyTime));
                                        rumPojo.setBrowserRenderingTime(this.changeStringToDoubleVal(PageRenderTime));
                                    }
                                } else if (pageType.equals("Virtual Page")) {
                                    rumPojo.setNetworkTime(-5.0);
                                    rumPojo.setServerTime(-5.0);
                                    rumPojo.setContentDownloadTime(-5.0);
                                    rumPojo.setBrowserRenderingTime(-5.0);
                                }
                                rumPojo.setUserName(userName);
                                rumPojo.setPageName(pageName);
                                rumPojo.setMeta(meta);
                                rumPojo.setStatus(status);
                                rumPojo.setURLFragment(mesURLFragment);
                                String pageTypeKey = pageType;
                                if (this.isIncludePageTypeInTopNDD != null && this.isIncludePageTypeInTopNDD.equalsIgnoreCase("false")) {
                                    pageTypeKey = "excludePageTypeInTopNDD";
                                }
                                if (isSlow) {
                                    reqDDList = new ArrayList<Object>();
                                    reqDDList.add(new Double(PageLoadTime));
                                    reqDDList.add(key);
                                    this.updateDDTablesForTopNDD(groupSlowDDTable, groupUrl, reqDDList, pageTypeKey);
                                }
                                if (isError) {
                                    String reqTime = this.getEgSorterDate(timeStr, this.collectorDateFormat, this.egSorterDateFormat);
                                    ArrayList<String> reqDDList2 = new ArrayList<String>();
                                    reqDDList2.add(reqTime);
                                    reqDDList2.add(key);
                                    this.updateDDTablesForTopNDD(groupErrorDDTable, groupUrl, reqDDList2, pageTypeKey);
                                }
                                if (this.healthyTopNDD_Limit != 0 && !isSlow && !isError) {
                                    reqDDList = new ArrayList();
                                    reqDDList.add(new Double(PageLoadTime));
                                    reqDDList.add(key);
                                    this.updateDDTablesForTopNDD(groupHealthyDDTable, groupUrl, reqDDList, pageTypeKey);
                                }
                                logger.info(" RUM Measure Data Pojo : " + rumPojo);
                                all.put(key, rumPojo);
                            }
                            Hashtable ipGeoTable = new Hashtable();
                            if (ipList != null && ipList.size() > 0) {
                                GeoLocationInfoMgrThread geoMgrThread = new GeoLocationInfoMgrThread(new ArrayList(ipList));
                                ipGeoTable = geoMgrThread.getGeoDetails();
                            }
                            geoMMDBTable.putAll(ipGeoTable);
                            logger.debug("[" + this.reportingName + "][" + this.entity + "] Ip's and Geo Location Details from MMDB :" + geoMMDBTable);
                            for (Map.Entry entry : all.entrySet()) {
                                String contryCode;
                                String guidKey = (String)entry.getKey();
                                RUMMeasureData pojoValue = (RUMMeasureData)entry.getValue();
                                String ip = pojoValue.getIpAddress();
                                ArrayList geoDetails = (ArrayList)geoMMDBTable.get(ip);
                                if (geoDetails != null && geoDetails.size() > 5) {
                                    String country = (String)geoDetails.get(0);
                                    String country_code = (String)geoDetails.get(1);
                                    if (countryCodeNameMapping.containsKey(country_code)) {
                                        country = (String)countryCodeNameMapping.get(country_code);
                                    }
                                    String region = (String)geoDetails.get(2);
                                    String city = (String)geoDetails.get(3);
                                    String latitude = (String)geoDetails.get(4);
                                    String longitude = (String)geoDetails.get(5);
                                    if (!country.equalsIgnoreCase(UNKNOWN_STRING)) {
                                        pojoValue.setCountry(country);
                                        pojoValue.setCountryCode(country_code);
                                        pojoValue.setRegion(region);
                                        pojoValue.setCity(city);
                                        pojoValue.setLatitude(Double.valueOf(latitude));
                                        pojoValue.setLongitude(Double.valueOf(longitude));
                                    }
                                }
                                if ((contryCode = pojoValue.getCountryCode()) == null || !contryCode.equalsIgnoreCase("NIL")) continue;
                                pojoValue.setCountryCode(UNKNOWN_STRING);
                            }
                            RUMMeasureCategory cat = new RUMMeasureCategory();
                            Hashtable summarizedData = new Hashtable();
                            ArrayList<String> requiredPageTypesList = new ArrayList<String>();
                            requiredPageTypesList.add("Page");
                            Hashtable topNSlowErrorHealthyDDKeyTable = new Hashtable();
                            HashSet topNSlowErrorHealthyDDKeySet = new HashSet();
                            topNSlowErrorHealthyDDKeySet.addAll(this.getTopRequestDD(groupSlowDDTable, "Double", this.slowTopNDD_Limit));
                            topNSlowErrorHealthyDDKeySet.addAll(this.getTopRequestDD(groupErrorDDTable, "Date", this.errorTopNDD_Limit));
                            topNSlowErrorHealthyDDKeySet.addAll(this.getTopRequestDD(groupHealthyDDTable, "Double", this.healthyTopNDD_Limit));
                            topNSlowErrorHealthyDDKeyTable.put("topNDDKeys", topNSlowErrorHealthyDDKeySet);
                            StringTokenizer pageTypeTokens = new StringTokenizer(this.requiredPageTypes, "~#~");
                            while (pageTypeTokens.hasMoreTokens()) {
                                requiredPageTypesList.add(pageTypeTokens.nextToken());
                            }
                            if (requiredPageTypesList.contains("Virtual_Page")) {
                                requiredPageTypesList.add("Virtual Page");
                            }
                            if ((summarizedData = cat.computeSummarizedData(all, topNSlowErrorHealthyDDKeyTable, this.reportingName, requiredPageTypesList, allError)) != null) {
                                resultData.put(this.serviceName, summarizedData);
                            }
                        }
                    } else {
                        resultData.remove(this.serviceName);
                    }
                    resultDataTable = null;
                }
                catch (Exception e) {
                    logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in EgRUMBase " + e.getMessage());
                    logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in EgRUMBase ", (Throwable)e);
                }
                logger.debug("[" + this.reportingName + "][" + this.entity + "] Setting last run time to the properties file.");
                this.setLastRunTime(System.currentTimeMillis());
            }
        }
        return this.checkNewCollector(serviceNameAsGuid);
    }

    public void collectData(Hashtable testDDTable, String key, String guid) {
        try {
            if (testDDTable.containsKey(key)) {
                ArrayList list = (ArrayList)testDDTable.get(key);
                list.add(guid);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(guid);
                testDDTable.put(key, list);
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in collectData " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in collectData ...", (Throwable)ex);
        }
    }

    public Set collectKey(Hashtable ht) {
        ArrayList keyList = new ArrayList();
        HashSet<String> set = new HashSet<String>();
        try {
            if (ht.isEmpty()) {
                return set;
            }
            Enumeration enumerator = ht.keys();
            while (enumerator.hasMoreElements()) {
                String key = (String)enumerator.nextElement();
                keyList = (ArrayList)ht.get(key);
                int m = 0;
                while (m < keyList.size()) {
                    String guid = (String)keyList.get(m);
                    set.add(guid);
                    ++m;
                }
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured in collectKey()..." + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured in collectKey()...", (Throwable)ex);
        }
        return set;
    }

    public void updateDDTablesForTopNDD(Hashtable allDDTable, String key, ArrayList innerList, String pageType) {
        try {
            if (allDDTable.containsKey(key)) {
                Hashtable pageTypeTable = (Hashtable)allDDTable.get(key);
                if (pageTypeTable.containsKey(pageType)) {
                    ArrayList list = (ArrayList)pageTypeTable.get(pageType);
                    list.add(innerList);
                    pageTypeTable.put(pageType, list);
                    allDDTable.put(key, pageTypeTable);
                } else {
                    ArrayList<ArrayList> list = new ArrayList<ArrayList>();
                    list.add(innerList);
                    pageTypeTable.put(pageType, list);
                    allDDTable.put(key, pageTypeTable);
                }
            } else {
                Hashtable pageTypeTable = new Hashtable();
                ArrayList<ArrayList> list = new ArrayList<ArrayList>();
                list.add(innerList);
                pageTypeTable.put(pageType, list);
                allDDTable.put(key, pageTypeTable);
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured while collecting the all requests in allDDTable() in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured while collecting the all requests in allDDTable() in EgRUMBase : ", (Throwable)ex);
        }
    }

    private Set getTopRequestDD(Hashtable allDDTable, String columnType, int topN_DD_Limit) {
        ArrayList dummyList = new ArrayList();
        HashSet<String> topNDDSet = new HashSet<String>();
        Hashtable pageTypeTable = new Hashtable();
        try {
            if (allDDTable.isEmpty()) {
                return topNDDSet;
            }
            Enumeration allGrpUrl = allDDTable.keys();
            while (allGrpUrl.hasMoreElements()) {
                String grpUrl = (String)allGrpUrl.nextElement();
                pageTypeTable = (Hashtable)allDDTable.get(grpUrl);
                Enumeration pageTypeKey = pageTypeTable.keys();
                block3: while (pageTypeKey.hasMoreElements()) {
                    String pageType = (String)pageTypeKey.nextElement();
                    dummyList = (ArrayList)pageTypeTable.get(pageType);
                    EgSorter egSort = new EgSorter((List)dummyList, 2);
                    dummyList = (ArrayList)egSort.sort(1, columnType, "desc");
                    int m = 0;
                    while (m < dummyList.size()) {
                        if (topN_DD_Limit != -1 && m >= topN_DD_Limit) continue block3;
                        ArrayList arrList = (ArrayList)dummyList.get(m);
                        String healthyGuid = (String)arrList.get(1);
                        topNDDSet.add(healthyGuid);
                        ++m;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured in getTopRequestDD() in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured in getTopRequestDD() in EgRUMBase : ", (Throwable)ex);
        }
        return topNDDSet;
    }

    private String getGroupUrl(String mesurl, String url_level) {
        String groupUrl = null;
        try {
            Object[] segIndex = url_level.split(",");
            Arrays.sort(segIndex);
            URL url = new URL(mesurl);
            String path = url.getPath();
            String[] segments = path.split("/");
            int numOfSeg = segments.length;
            int numOfSegIndx = segIndex.length;
            StringBuilder strBuild = new StringBuilder("/");
            int lastSegIndx = 0;
            int i = 0;
            while (i < numOfSegIndx) {
                int nextIndex = Integer.parseInt(((String)segIndex[i]).trim());
                if (nextIndex < numOfSeg && nextIndex > 0) {
                    lastSegIndx = nextIndex;
                    strBuild.append(segments[nextIndex]);
                    strBuild.append('/');
                }
                ++i;
            }
            if (strBuild.length() == 1 && numOfSeg != 0) {
                lastSegIndx = numOfSeg - 1;
                strBuild.append(segments[numOfSeg - 1]);
                strBuild.append('/');
            }
            groupUrl = lastSegIndx != 0 && segments[lastSegIndx].contains(".") ? strBuild.substring(0, strBuild.length() - 1) : strBuild.toString();
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured in parsing group URL in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured in parsing group URL in EgRUMBase : ", (Throwable)ex);
        }
        return groupUrl;
    }

    public Double changedoubleToDoubleVal(double value) {
        Double dObj = new Double(0.0);
        try {
            dObj = new Double(value);
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured while parsing the double value in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured while parsing the double value in EgRUMBase : ", (Throwable)ex);
        }
        return dObj;
    }

    public Double changeStringToDoubleVal(String value) {
        double dbl = 0.0;
        Double dObj = new Double(0.0);
        try {
            dbl = Double.parseDouble(value);
            dObj = new Double(dbl);
        }
        catch (Exception ex) {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Exception occured while parsing the String value in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured while parsing the String value in EgRUMBase : ", (Throwable)ex);
        }
        return dObj;
    }

    private int changeStringToIntegerVal(String value, int defaultValue) {
        int output = defaultValue;
        try {
            output = Integer.parseInt(value);
        }
        catch (Exception ex) {
            output = defaultValue;
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Exception occured while parsing the String value to Integer  : " + value);
        }
        return output;
    }

    public String getEgSorterDate(String dateStr, String oldDateFormat, String newDateFormat) {
        String date = "";
        try {
            SimpleDateFormat collectorSDF = new SimpleDateFormat(oldDateFormat);
            SimpleDateFormat egSorterSDF = new SimpleDateFormat(newDateFormat);
            Date dat = collectorSDF.parse(dateStr);
            date = egSorterSDF.format(dat);
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured while using egSorter in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured while using egSorter in EgRUMBase : ", (Throwable)ex);
        }
        return date;
    }

    public static int getLineNumber() {
        return Thread.currentThread().getStackTrace()[2].getLineNumber();
    }

    public boolean isDDSent(String entity) {
        return (Boolean)SendDDStatusMap.get(String.valueOf(this.serviceName) + ":" + entity);
    }

    public boolean isTotalRequestDDNeed() {
        return (Boolean)totalRequestDDTable.get(this.serviceName);
    }

    public Hashtable getApplicatonStatistics() {
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        if (resultTable != null && resultTable.get("application") instanceof Hashtable) {
            Hashtable table = (Hashtable)resultTable.get("application");
            if (!table.isEmpty()) {
                return table;
            }
            Hashtable<String, RUMSummaryData> ht = new Hashtable<String, RUMSummaryData>();
            ht.put(this.reportingName, new RUMSummaryData());
            return ht;
        }
        Hashtable<String, RUMSummaryData> ht = new Hashtable<String, RUMSummaryData>();
        ht.put(this.reportingName, new RUMSummaryData());
        return ht;
    }

    private void formatNewCollectorData(Hashtable resultDataTable) {
        Enumeration resultDatakeys = resultDataTable.keys();
        while (resultDatakeys.hasMoreElements()) {
            String key = (String)resultDatakeys.nextElement();
            ArrayList all = (ArrayList)resultDataTable.get(key);
            Hashtable summarizedData = new Hashtable();
            summarizedData.put("pageType", all.get(7));
            summarizedData.put("browser", all.get(1));
            summarizedData.put("device", all.get(2));
            summarizedData.put("country", all.get(3));
            summarizedData.put("entireLocation", all.get(4));
            summarizedData.put("region", all.get(5));
            summarizedData.put("group", all.get(6));
            summarizedData.put("application", all.get(0));
            resultData.put(this.serviceName, summarizedData);
        }
    }

    private boolean checkNewCollector(String serviceNameAsGuid) {
        Boolean resultObj = serviceNameNewCollectorMapping.get(serviceNameAsGuid);
        if (resultObj != null) {
            logger.debug("[{}][{}] checkNewCollector() serviceNameAsGuid {} serviceNameNewCollectorMapping : {}", new Object[]{this.reportingName, this.entity, serviceNameAsGuid, serviceNameNewCollectorMapping});
            return resultObj;
        }
        return false;
    }

    public Map getApplicationStatisticsMap() {
        Map finalMap = new HashMap();
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        try {
            if (resultTable != null) {
                finalMap = (Map)resultTable.get("application");
                if (!finalMap.isEmpty()) {
                    return finalMap;
                }
                return finalMap;
            }
            return finalMap;
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while categorizing the application in EgRUMBase :{}", new Object[]{this.reportingName, this.entity, e.getMessage()});
            return finalMap;
        }
    }

    public Map getGroupStatisticsMap() {
        Map finalMap = new HashMap();
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        try {
            if (resultTable != null) {
                finalMap = (Map)resultTable.get("group");
                if (!finalMap.isEmpty()) {
                    return finalMap;
                }
                return finalMap;
            }
            return finalMap;
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while categorizing the Group url in EgRUMBase :{}", new Object[]{this.reportingName, this.entity, e.getMessage()});
            return finalMap;
        }
    }

    public Map getBrowserStatisticsMap() {
        Map finalMap = new HashMap();
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        try {
            if (resultTable != null) {
                finalMap = (Map)resultTable.get("browser");
                if (!finalMap.isEmpty()) {
                    return finalMap;
                }
                return finalMap;
            }
            return finalMap;
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while categorizing the Browser in EgRUMBase :{}", new Object[]{this.reportingName, this.entity, e.getMessage()});
            return finalMap;
        }
    }

    public Map getDeviceStatisticsMap() {
        Map finalMap = new HashMap();
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        try {
            if (resultTable != null) {
                finalMap = (Map)resultTable.get("device");
                if (!finalMap.isEmpty()) {
                    return finalMap;
                }
                return finalMap;
            }
            return finalMap;
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while categorizing the Device in EgRUMBase :{}", new Object[]{this.reportingName, this.entity, e.getMessage()});
            return finalMap;
        }
    }

    public Map getPageTypeStatisticsMap() {
        Map finalMap = new HashMap();
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        try {
            if (resultTable != null) {
                finalMap = (Map)resultTable.get("pageType");
                if (!finalMap.isEmpty()) {
                    return finalMap;
                }
                return finalMap;
            }
            return finalMap;
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while categorizing the Page in EgRUMBase :{}", new Object[]{this.reportingName, this.entity, e.getMessage()});
            return finalMap;
        }
    }

    public Map getLocationStatisticsMap() {
        Map finalMap = new HashMap();
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        try {
            if (resultTable != null) {
                finalMap = (Map)resultTable.get("entireLocation");
                if (!finalMap.isEmpty()) {
                    return finalMap;
                }
                return finalMap;
            }
            return finalMap;
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while categorizing the Location in EgRUMBase :{}", new Object[]{this.reportingName, this.entity, e.getMessage()});
            return finalMap;
        }
    }

    public Map getCountryStatisticsMap() {
        Map finalMap = new HashMap();
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        try {
            if (resultTable != null) {
                finalMap = (Map)resultTable.get("country");
                if (!finalMap.isEmpty()) {
                    return finalMap;
                }
                return finalMap;
            }
            return finalMap;
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while categorizing the Country in EgRUMBase :{}", new Object[]{this.reportingName, this.entity, e.getMessage()});
            return finalMap;
        }
    }

    public Map getRegionStatisticsMap() {
        Map finalMap = new HashMap();
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        try {
            if (resultTable != null) {
                finalMap = (Map)resultTable.get("region");
                if (!finalMap.isEmpty()) {
                    return finalMap;
                }
                return finalMap;
            }
            return finalMap;
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while categorizing the Region in EgRUMBase :{}", new Object[]{this.reportingName, this.entity, e.getMessage()});
            return finalMap;
        }
    }

    private RUMAggregateStats convertJsonNode(JsonNode rumStatJson) {
        RUMAggregateStats rumStat = null;
        try {
            rumStat = (RUMAggregateStats)objectMapper.convertValue((Object)rumStatJson, RUMAggregateStats.class);
        }
        catch (Exception e) {
            logger.error("[{}][{}] JsonNode conversion failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e});
        }
        return rumStat;
    }

    private void convertDDAndResourceDetails(String serviceNameAsGuid, List dataList, ArrayList dList) {
        if (dList != null) {
            String isSendConfig;
            ArrayList jsErrorList;
            Map testStatsJson = (Map)dList.get(0);
            for (Map.Entry entry : testStatsJson.entrySet()) {
                JsonNode rumStatJson = (JsonNode)entry.getValue();
                RUMAggregateStats rumStat = this.convertJsonNode(rumStatJson);
                if (rumStat == null) continue;
                logger.debug("[{}] Total Beacons={} Normal={} Slow={} and Error={}", new Object[]{this.reportingName, rumStat.getPageViews(), rumStat.getPageViews() - rumStat.getSlowPageViews() - rumStat.getErrorPageViews(), rumStat.getSlowPageViews(), rumStat.getErrorPageViews()});
                serviceNameNewCollectorMapping.put(serviceNameAsGuid, true);
            }
            ArrayList ddList = (ArrayList)dataList.get(1);
            HashMap<String, String> resourceDetailsMap = new HashMap<String, String>();
            ArrayList<Cloneable> detailsList = new ArrayList<Cloneable>();
            ArrayList healthyDDList = new ArrayList();
            if (ddList != null && ddList.size() > 0) {
                int healthyDDCounter = 0;
                int slowDDCounter = 0;
                int errorDDCounter = 0;
                healthyDDList = (ArrayList)ddList.get(2);
                ArrayList slowDDList = (ArrayList)ddList.get(1);
                ArrayList errorDDList = (ArrayList)ddList.get(0);
                if (healthyDDList != null) {
                    healthyDDCounter = healthyDDList.size();
                }
                if (slowDDList != null) {
                    slowDDCounter = slowDDList.size();
                }
                if (errorDDList != null) {
                    errorDDCounter = errorDDList.size();
                }
                int i = 0;
                while (i < ddList.size()) {
                    ArrayList tempArr = (ArrayList)ddList.get(i);
                    int j = 0;
                    while (j < tempArr.size()) {
                        try {
                            JsonNode jsonNode = (JsonNode)tempArr.get(j);
                            RUMBeacon RUMBeacon2 = (RUMBeacon)objectMapper.convertValue((Object)jsonNode, RUMBeacon.class);
                            String resourceDetails = RUMBeacon2.getRt();
                            if (resourceDetails != null && resourceDetails.length() > 0) {
                                int index = resourceDetails.lastIndexOf("\"");
                                if (index > 0) {
                                    resourceDetails = resourceDetails.substring(1, resourceDetails.lastIndexOf("\""));
                                }
                                resourceDetails = resourceDetails.replaceAll("\\\\", "");
                                resourceDetailsMap.put(RUMBeacon2.getRgd(), resourceDetails);
                            }
                        }
                        catch (Exception e) {
                            logger.trace("[{}][{}] Updating ResourceDetails failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e});
                            logger.error("[{}][{}] Updating ResourceDetails failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e.getMessage()});
                        }
                        ++j;
                    }
                    ++i;
                }
                healthyDDList.addAll(slowDDList);
                healthyDDList.addAll(errorDDList);
                logger.debug("[{}] Normal DDs={} Slow DDs={} Error DDs={}", new Object[]{this.reportingName, healthyDDCounter, slowDDCounter, errorDDCounter});
            }
            if ((jsErrorList = (ArrayList)dataList.get(2)) != null && jsErrorList.size() > 0) {
                jsErrorList = (ArrayList)jsErrorList.get(0);
                logger.trace("jsErrorList {}", (Object)jsErrorList);
            }
            detailsList.add(healthyDDList);
            detailsList.add(resourceDetailsMap);
            detailsList.add(jsErrorList);
            newCollectorDD.put(this.reportingName, detailsList);
            if (dataList != null && dataList.size() == 4 && (isSendConfig = (String)dataList.get(3)).equalsIgnoreCase("sendConfig")) {
                this.firstTime = false;
                logger.debug("Message recieved from eG RUM Collector to send config in the next measurement cycle for {}", (Object)this.reportingName);
            }
            logger.debug("[{}][{}] DD for new Collector = {}", new Object[]{this.reportingName, this.entity, newCollectorDD});
        }
    }

    public Hashtable getTopNGroupUrlRequest(Hashtable ht) {
        ArrayList dummyList = new ArrayList();
        ArrayList innerList = new ArrayList();
        Hashtable<String, RUMSummaryData> dummy = new Hashtable<String, RUMSummaryData>();
        Hashtable<String, RUMSummaryData> finalHT = new Hashtable<String, RUMSummaryData>();
        try {
            if (ht.isEmpty()) {
                return finalHT;
            }
            for (String grpUrl : ht.keySet()) {
                innerList = (ArrayList)ht.get(grpUrl);
                RUMSummaryData obj = (RUMSummaryData)innerList.get(1);
                dummyList.add(innerList);
                dummy.put(grpUrl, obj);
            }
            EgSorter egSort = new EgSorter(dummyList, 2);
            dummyList = (ArrayList)egSort.sort(1, "Double", "desc");
            int m = 0;
            while (m < dummyList.size()) {
                ArrayList arrList = (ArrayList)dummyList.get(m);
                RUMSummaryData obj = (RUMSummaryData)arrList.get(1);
                for (String url : dummy.keySet()) {
                    RUMSummaryData dummyObj = (RUMSummaryData)dummy.get(url);
                    if (!obj.equals(dummyObj)) continue;
                    finalHT.put(url, obj);
                }
                ++m;
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured in getTopNGroupUrlRequest() in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured in getTopNGroupUrlRequest() in EgRUMBase : ", (Throwable)ex);
        }
        return finalHT;
    }

    public Hashtable getGroupStatistics() {
        Hashtable finalTable;
        block10: {
            finalTable = new Hashtable();
            Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
            try {
                if (resultTable == null) {
                    return finalTable;
                }
                if (resultTable.get("group") instanceof Hashtable) {
                    Hashtable table = (Hashtable)resultTable.get("group");
                    if (table != null) {
                        Hashtable errPercentageTable = new Hashtable();
                        Hashtable reqCountTable = new Hashtable();
                        Hashtable avgPageLoadTimeTable = new Hashtable();
                        Iterator itr = table.keySet().iterator();
                        while (itr.hasNext()) {
                            ArrayList<Object> dummyList = null;
                            String groupUrl = (String)itr.next();
                            RUMSummaryData obj = (RUMSummaryData)table.get(groupUrl);
                            Double errorPercentage = obj.getErrorPercentage();
                            if (errorPercentage != 0.0) {
                                dummyList = new ArrayList<Object>();
                                dummyList.add(errorPercentage);
                                dummyList.add(obj);
                                errPercentageTable.put(groupUrl, dummyList);
                            }
                            Double requestCount = obj.getRequestCount();
                            dummyList = new ArrayList();
                            dummyList.add(requestCount);
                            dummyList.add(obj);
                            reqCountTable.put(groupUrl, dummyList);
                            Double avgPageLoadTime = obj.getAveragePageLoadTime();
                            dummyList = new ArrayList();
                            dummyList.add(avgPageLoadTime);
                            dummyList.add(obj);
                            avgPageLoadTimeTable.put(groupUrl, dummyList);
                        }
                        Hashtable hitCountTbl = new Hashtable();
                        Hashtable pageLoadTbl = new Hashtable();
                        Hashtable errorPercentageTbl = new Hashtable();
                        if (!reqCountTable.isEmpty()) {
                            hitCountTbl = this.getTopNGroupUrlRequest(reqCountTable);
                        }
                        if (!avgPageLoadTimeTable.isEmpty()) {
                            pageLoadTbl = this.getTopNGroupUrlRequest(avgPageLoadTimeTable);
                        }
                        if (!errPercentageTable.isEmpty()) {
                            errorPercentageTbl = this.getTopNGroupUrlRequest(errPercentageTable);
                        }
                        finalTable = this.finalDDForGroupUrlTest(hitCountTbl, pageLoadTbl, errorPercentageTbl);
                    }
                    break block10;
                }
                return null;
            }
            catch (Exception ex) {
                logger.error("[" + this.reportingName + "][" + this.entity + "] Exception while categorizing the Group url in EgRUMBase : " + ex.getMessage());
                logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception while categorizing the Group url in EgRUMBase : ", (Throwable)ex);
            }
        }
        return finalTable;
    }

    public Hashtable finalDDForGroupUrlTest(Hashtable hitTable, Hashtable pgLoadTable, Hashtable errTable) {
        Hashtable ht = new Hashtable();
        HashSet set = new HashSet();
        try {
            ArrayList dummyList = Collections.list(hitTable.keys());
            set.addAll(dummyList);
            dummyList = Collections.list(pgLoadTable.keys());
            set.addAll(dummyList);
            dummyList = Collections.list(errTable.keys());
            set.addAll(dummyList);
            ArrayList list = new ArrayList(set);
            int i = 0;
            while (i < list.size()) {
                ArrayList<Object> al = null;
                String value = "";
                String url = (String)list.get(i);
                StringBuffer sbf = new StringBuffer();
                if (hitTable.containsKey(url)) {
                    RUMSummaryData obj1 = (RUMSummaryData)hitTable.get(url);
                    sbf.append("1");
                    value = sbf.toString();
                    al = new ArrayList<Object>();
                    al.add(obj1);
                    al.add(value);
                    ht.put(url, al);
                }
                if (pgLoadTable.containsKey(url)) {
                    RUMSummaryData obj2 = (RUMSummaryData)pgLoadTable.get(url);
                    sbf.append("2");
                    value = sbf.toString();
                    al = new ArrayList();
                    al.add(obj2);
                    al.add(value);
                    ht.put(url, al);
                }
                if (errTable.containsKey(url)) {
                    RUMSummaryData obj3 = (RUMSummaryData)errTable.get(url);
                    sbf.append("3");
                    value = sbf.toString();
                    al = new ArrayList();
                    al.add(obj3);
                    al.add(value);
                    ht.put(url, al);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured in finalDDForGroupUrlTest() in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured in finalDDForGroupUrlTest() in EgRUMBase : ", (Throwable)ex);
        }
        return ht;
    }

    public Hashtable getBrowserStatistics() {
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        if (resultTable != null && resultTable.get("browser") instanceof Hashtable) {
            Hashtable table = (Hashtable)resultTable.get("browser");
            return table;
        }
        return null;
    }

    public Hashtable getDeviceStatistics() {
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        if (resultTable != null && resultTable.get("device") instanceof Hashtable) {
            Hashtable table = (Hashtable)resultTable.get("device");
            return table;
        }
        return null;
    }

    public Hashtable getPageStatistics() {
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        if (resultTable != null && resultTable.get("pageType") instanceof Hashtable) {
            Hashtable table = (Hashtable)resultTable.get("pageType");
            return table;
        }
        return null;
    }

    public Hashtable getLocationStatistics() {
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        if (resultTable != null && resultTable.get("entireLocation") instanceof Hashtable) {
            Hashtable table = (Hashtable)resultTable.get("entireLocation");
            return table;
        }
        return null;
    }

    public Hashtable getRegionStatistics() {
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        if (resultTable != null && resultTable.get("region") instanceof Hashtable) {
            Hashtable table = (Hashtable)resultTable.get("region");
            return table;
        }
        return null;
    }

    public Hashtable getCountryStatistics() {
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        if (resultTable != null && resultTable.get("country") instanceof Hashtable) {
            Hashtable table = (Hashtable)resultTable.get("country");
            return table;
        }
        return null;
    }

    public Hashtable getKeyTransactionStatistics() {
        Hashtable resultTable = (Hashtable)resultData.get(this.serviceName);
        if (resultTable != null) {
            Hashtable table = (Hashtable)resultTable.get("keyTransaction");
            return table;
        }
        Hashtable<String, RUMSummaryData> ht = new Hashtable<String, RUMSummaryData>();
        String dscName = "";
        if (keyTransactionPatterns.containsKey(this.reportingName)) {
            ArrayList patternList = (ArrayList)keyTransactionPatterns.get(this.reportingName);
            int pl = 0;
            while (pl < patternList.size()) {
                String urlPattern = (String)patternList.get(pl);
                if (urlPattern != null) {
                    if (urlPattern.indexOf(":") > -1) {
                        dscName = urlPattern.substring(0, urlPattern.indexOf(":"));
                    } else if (urlPattern.indexOf("=") > -1) {
                        dscName = urlPattern.substring(0, urlPattern.indexOf("="));
                    }
                }
                ht.put(dscName, new RUMSummaryData());
                ++pl;
            }
        }
        return ht;
    }

    private long getPrevRunTime() {
        String lastRunTimeObj = this.getPreviousCount(rumInfoProps, this.reportingName);
        long lastRunTime = 0L;
        if (lastRunTimeObj != null) {
            lastRunTime = Long.parseLong(lastRunTimeObj);
        }
        return lastRunTime;
    }

    private void setLastRunTime(long time) {
        String timeAsString = String.valueOf(time);
        this.setCurrentCount(timeAsString, rumInfoProps, this.reportingName);
    }

    private ArrayList getDataFromUrlConnection() {
        ArrayList data;
        block35: {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] inside getDataFromUrlConnection : ");
            flagTable.put(this.reportingName, "true");
            HttpURLConnection connection = null;
            HttpURLConnection geoXMLConnection = null;
            ConnectionThread connThread = null;
            ConnectionThread geoXMLConnThread = null;
            data = new ArrayList();
            int i_proxyPort = 0;
            try {
                try {
                    URL postUrl;
                    block34: {
                        postUrl = new URL(this.urlString);
                        if (this.useProxy) {
                            logger.debug("[" + this.reportingName + "][" + this.entity + "] useProxy is enabled ");
                            if (this.useProxyAuthentication) {
                                logger.debug("[" + this.reportingName + "][" + this.entity + "] Setting proxy authentication properties !!!");
                                Authenticator.setDefault(new Authenticator(){

                                    protected PasswordAuthentication getPasswordAuthentication() {
                                        return new PasswordAuthentication(EgRUMBase.this.proxyUsername, EgRUMBase.this.proxyPassword.toCharArray());
                                    }
                                });
                            }
                            if (this.proxyPort != null) {
                                i_proxyPort = Integer.parseInt(this.proxyPort.trim());
                            }
                            InetSocketAddress addr = new InetSocketAddress(this.proxyHost, i_proxyPort);
                            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                            logger.debug("[" + this.reportingName + "][" + this.entity + "] Creating connection to collector with proxy !!!");
                            connection = (HttpURLConnection)postUrl.openConnection(proxy);
                        } else {
                            logger.debug("[" + this.reportingName + "][" + this.entity + "] Creating connection to collector without proxy !!!");
                            connection = (HttpURLConnection)postUrl.openConnection();
                        }
                        String geoXMLFile = this.geoXmlFileName(this.serviceName);
                        if ((!this.firstTime || this.checkLastModifiedTime(geoXMLFile, this.serviceName)) && geoXMLFile != null && geoXMLFile.length() > 0) {
                            block32: {
                                String geoXmlFileLocation = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/GeoXmlFiles/" + geoXMLFile;
                                File myFile = new File(geoXmlFileLocation);
                                URL geoXML = new URL(this.geoXmlUrlString);
                                geoXMLConnection = (HttpURLConnection)geoXML.openConnection();
                                geoXMLConnection.setRequestMethod("POST");
                                geoXMLConnection.setRequestProperty("Content-Type", "application/xml");
                                geoXMLConnection.setRequestProperty("Content-Length", "" + (int)myFile.length());
                                geoXMLConnection.setRequestProperty("Content-Language", "en-US");
                                geoXMLConnection.setUseCaches(false);
                                geoXMLConnection.setDoInput(true);
                                geoXMLConnection.setDoOutput(true);
                                geoXMLConnection.setConnectTimeout(5000);
                                geoXMLConnection.setReadTimeout(60000);
                                FilterOutputStream os = null;
                                InputStream in = null;
                                try {
                                    try {
                                        int count;
                                        os = new DataOutputStream(new ObjectOutputStream(geoXMLConnection.getOutputStream()));
                                        byte[] bytes = new byte[2048];
                                        in = new FileInputStream(geoXmlFileLocation);
                                        while ((count = in.read(bytes)) > 0) {
                                            ((DataOutputStream)os).write(bytes, 0, count);
                                        }
                                        ((DataOutputStream)os).flush();
                                    }
                                    catch (Exception e) {
                                        logger.error("Exception occured while sending the geoXML data {}", (Throwable)e);
                                        if (os != null) {
                                            os.close();
                                        }
                                        if (in != null) {
                                            in.close();
                                        }
                                        break block32;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (os != null) {
                                        os.close();
                                    }
                                    if (in != null) {
                                        in.close();
                                    }
                                    throw throwable;
                                }
                                if (os != null) {
                                    os.close();
                                }
                                if (in != null) {
                                    in.close();
                                }
                            }
                            geoXMLConnection.connect();
                            geoXMLConnThread = new ConnectionThread(geoXMLConnection, true, true);
                            int geoXMLCode = 0;
                            boolean geoXMLFlag = this.checkForTimeout(geoXMLConnThread);
                            if (geoXMLFlag && (geoXMLCode = geoXMLConnThread.code) != 200) {
                                logger.error("[" + this.reportingName + "][" + this.entity + "] Error opening connection to collector, status code is : " + geoXMLCode + " URL is : " + this.geoXmlUrlString);
                            }
                        }
                        if (geoXMLFile == null || geoXMLFile.length() <= 0) {
                            this.urlParameters = String.valueOf(this.urlParameters) + "&clearXmlFile=true";
                            geoXmlFileLastModifedTime.remove(this.serviceName);
                        }
                        connection.setRequestMethod("POST");
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        connection.setRequestProperty("Content-Length", Integer.toString(this.urlParameters.getBytes("UTF-8").length));
                        connection.setRequestProperty("Content-Language", "en-US");
                        connection.setUseCaches(false);
                        connection.setDoInput(true);
                        connection.setDoOutput(true);
                        connection.setConnectTimeout(5000);
                        connection.setReadTimeout(60000);
                        FilterOutputStream wr = null;
                        try {
                            try {
                                wr = new DataOutputStream(connection.getOutputStream());
                                ((DataOutputStream)wr).write(this.urlParameters.getBytes("UTF-8"), 0, this.urlParameters.getBytes("UTF-8").length);
                                ((DataOutputStream)wr).flush();
                            }
                            catch (Exception e) {
                                logger.error("Exception occured while writing the URL Parameters {}", (Throwable)e);
                                if (wr != null) {
                                    wr.close();
                                }
                                break block34;
                            }
                        }
                        catch (Throwable geoXML) {
                            if (wr != null) {
                                wr.close();
                            }
                            throw geoXML;
                        }
                        if (wr != null) {
                            wr.close();
                        }
                    }
                    logger.debug("[{}] Contacting RUM Collector, URL is {}", (Object)this.reportingName, (Object)postUrl);
                    connection.connect();
                    connThread = new ConnectionThread(connection, true, true);
                    int code = 0;
                    boolean flag = this.checkForTimeout(connThread);
                    if (!flag) break block35;
                    code = connThread.code;
                    if (code != 200) {
                        logger.error("[" + this.reportingName + "][" + this.entity + "] Error opening connection to collector, status code is : " + code + " URL is : " + this.urlString);
                        this.firstTime = false;
                        break block35;
                    }
                    data = connThread.data;
                    this.firstTime = true;
                }
                catch (Exception ee) {
                    flagTable.put(this.reportingName, "false");
                    logger.error("[" + this.reportingName + "][" + this.entity + "] Exception while connecting to collector : " + ee.getMessage());
                    logger.trace("Exception while connecting to collector ...", (Throwable)ee);
                    connThread = null;
                    geoXMLConnThread = null;
                }
            }
            finally {
                connThread = null;
                geoXMLConnThread = null;
            }
        }
        return data;
    }

    private void enableSsl() {
        EgSSL e = EgSSL.getInstance();
        EgSSL.enableSSL();
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object sock = null;
        try {
            MyX509TrustManager tm = new MyX509TrustManager();
            KeyManager[] km = null;
            TrustManager[] tma = new TrustManager[]{tm};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(km, tma, new SecureRandom());
            SSLSocketFactory sf1 = sc.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sf1);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception ee) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in EgRUMBase of enableSsl ... " + ee.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in EgRUMBase of enableSsl ... ", (Throwable)ee);
        }
    }

    private boolean checkForTimeout(ConnectionThread ct) {
        long nextSleepTime;
        EgConfigInfo configInfo = new EgConfigInfo("agent");
        long timeout = EgConfigInfo.getResponseCodeTimeout * 10L;
        long totalSleepTime = 0L;
        long sleepTime = 250L;
        long minSleep = 50L;
        do {
            long curTime = System.currentTimeMillis();
            if (sleepTime < EgAgentCommon.minimumSleep) {
                sleepTime = EgAgentCommon.minimumSleep;
            } else if (sleepTime > EgAgentCommon.maxSleep) {
                sleepTime = EgAgentCommon.maxSleep;
            }
            try {
                Thread.currentThread();
                Thread.sleep(sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ct.done) {
                return true;
            }
            long now = System.currentTimeMillis();
            long actualSleep = now - curTime;
            if ((totalSleepTime += actualSleep) >= timeout || actualSleep < 0L) {
                ct.interrupt();
                try {
                    Thread.currentThread();
                    Thread.sleep(minSleep);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ct.stop();
                return false;
            }
            nextSleepTime = sleepTime;
            if (timeout - totalSleepTime >= nextSleepTime) continue;
            nextSleepTime = timeout - totalSleepTime;
        } while ((sleepTime = nextSleepTime) > 0L);
        ct.interrupt();
        try {
            Thread.currentThread();
            Thread.sleep(minSleep);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ct.stop();
        return false;
    }

    private void suspendForPeriod(long sleepPeriod) {
        long nextMeasureTime = System.currentTimeMillis() + sleepPeriod;
        while (sleepPeriod > 0L) {
            try {
                Thread.sleep(sleepPeriod);
            }
            catch (Exception e) {
                logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured while putting thread to sleep in EgRUMBase : " + e.getMessage());
                logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured while putting thread to sleep in EgRUMBase : ", (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            sleepPeriod = nextMeasureTime - currentTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentCount(String ss, String fileName, String key) {
        block15: {
            Properties RUMProps = new Properties();
            InputStream fis = null;
            try {
                try {
                    String string = Sync;
                    synchronized (string) {
                        fis = new FileInputStream(fileName);
                        RUMProps.load(new BufferedInputStream(fis));
                        RUMProps.setProperty(key, ss);
                        RUMProps.store(new BufferedOutputStream(new FileOutputStream(fileName)), "eG RUM Monitor Information file <P> PLEASE DO NOT DELETE <P>");
                    }
                }
                catch (IOException e) {
                    logger.error("[" + this.reportingName + "][" + this.entity + "] Exception occured while while reading the " + fileName + " file in EgRUMBase : " + e.getMessage());
                    logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception occured while while reading the " + fileName + " file in EgRUMBase : ", (Throwable)e);
                    if (fis == null) break block15;
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        logger.error("[" + this.reportingName + "][" + this.entity + "] Error while closing the FileInputStream while reading " + fileName + " files in EgRUMBase : " + e2.getMessage());
                        logger.trace("[" + this.reportingName + "][" + this.entity + "] Error while closing the FileInputStream while reading " + fileName + " files in EgRUMBase : ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        logger.error("[" + this.reportingName + "][" + this.entity + "] Error while closing the FileInputStream while reading " + fileName + " files in EgRUMBase : " + e.getMessage());
                        logger.trace("[" + this.reportingName + "][" + this.entity + "] Error while closing the FileInputStream while reading " + fileName + " files in EgRUMBase : ", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPreviousCount(String fileName, String key) {
        String s;
        block15: {
            s = null;
            Properties RUMProps = new Properties();
            InputStream fis = null;
            try {
                try {
                    String string = Sync;
                    synchronized (string) {
                        fis = new FileInputStream(fileName);
                        RUMProps.load(new BufferedInputStream(fis));
                        s = RUMProps.getProperty(key);
                    }
                }
                catch (IOException e) {
                    logger.error("[" + this.reportingName + "][" + this.entity + "] Error while reading " + fileName + " files in EgRUMBase : " + e.getMessage());
                    logger.trace("[" + this.reportingName + "][" + this.entity + "] Error while reading " + fileName + " files in EgRUMBase : ", (Throwable)e);
                    if (fis == null) break block15;
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        logger.error("[" + this.reportingName + "][" + this.entity + "] Error while closing the FileInputStream while reading " + fileName + " files in EgRUMBase : " + e2.getMessage());
                        logger.trace("[" + this.reportingName + "][" + this.entity + "] Error while closing the FileInputStream while reading " + fileName + " files in EgRUMBase : ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        logger.error("[" + this.reportingName + "][" + this.entity + "] Error while closing the FileInputStream while reading " + fileName + " files in EgRUMBase : " + e.getMessage());
                        logger.trace("[" + this.reportingName + "][" + this.entity + "] Error while closing the FileInputStream while reading " + fileName + " files in EgRUMBase : ", (Throwable)e);
                    }
                }
            }
        }
        return s;
    }

    private String getCurrentDateAsString(String format) {
        String dateString = null;
        try {
            Date curDate = this.dateInfo.egetRealDate();
            SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.US);
            dateString = formatter.format(curDate);
        }
        catch (Exception e) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Error occured while getting the Date as String in EgRUMBase : " + e.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Error occured while getting the Date as String in EgRUMBase : ", (Throwable)e);
        }
        return dateString;
    }

    private void createFile(String fileName) {
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                if (fileName.indexOf("RUM_PageVisit_Counter_") > -1) {
                    this.deleteLastNDaysFiles(this.filterFileName, this.propertyFileDirectory, this.NumberOfDays);
                }
                f.createNewFile();
                logger.debug("[" + this.reportingName + "][" + this.entity + "] Creating a new Properties file with Name : " + fileName);
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Error while creating property file " + fileName + " files in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Error while creating property file " + fileName + " files in EgRUMBase : ", (Throwable)ex);
        }
    }

    public Hashtable getCurrentMeasurePeriodData() {
        Hashtable currentMesurePeriodDataTable = null;
        try {
            TimeZone timeZone = EgDateInfo.getRealTimeZone();
            String timeZoneID = timeZone.getID();
            this.present_request_count = 0;
            ArrayList dataList = new ArrayList();
            currentMesurePeriodDataTable = new Hashtable();
            String isNeedRequest = "true";
            while (isNeedRequest.equals("true")) {
                IniFile inifile = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_tests.ini");
                ArrayList data = this.getDataFromUrlConnection();
                if (data != null && data.isEmpty()) {
                    logger.debug("Data received from Rum Collector is empty for serviceName {}", (Object)this.serviceName);
                } else {
                    logger.debug("Data received from Rum Collector for serviceName {} has size: {}", (Object)this.serviceName, (Object)data.size());
                }
                logger.debug("[{}] Response received from RUM Collector ", (Object)this.reportingName);
                String serviceNameAsGuid = inifile.getValue("RUM_ServiceName_Mapping", this.serviceName);
                if (serviceNameAsGuid == null || serviceNameAsGuid.length() <= 0) {
                    serviceNameAsGuid = this.serviceName;
                }
                if (data != null && data.size() > 0) {
                    dataList = (ArrayList)data.get(0);
                    Hashtable ht = (Hashtable)dataList.get(0);
                    try {
                        Object dataObject = ht.get(serviceNameAsGuid);
                        if (dataObject != null) {
                            if (dataObject instanceof ArrayList) {
                                ArrayList dList = (ArrayList)dataObject;
                                this.convertDDAndResourceDetails(serviceNameAsGuid, dataList, dList);
                                this.dataFromNewCollector = true;
                            } else {
                                this.dataFromNewCollector = false;
                            }
                        }
                    }
                    catch (Exception ee) {
                        logger.error("[{}][{}] error while checking HashTable data {}", new Object[]{this.reportingName, this.entity, ee});
                        this.dataFromNewCollector = false;
                    }
                    if (this.dataFromNewCollector) {
                        currentMesurePeriodDataTable.putAll(ht);
                        isNeedRequest = "false";
                        continue;
                    }
                    currentMesurePeriodDataTable.putAll(ht);
                    this.present_request_count += ht.size();
                    isNeedRequest = (String)dataList.get(1);
                    logger.debug("[" + this.reportingName + "][" + this.entity + "] From the current response isNeedRequest : " + isNeedRequest + " & Current Response Data Size : " + ht.size() + "  & Total Data Size received so far : " + this.present_request_count);
                    if (isNeedRequest == null || !isNeedRequest.equals("true")) {
                        String isSendConfig;
                        isNeedRequest = "false";
                        this.urlParameters = "service=" + serviceNameAsGuid + "&" + "timeZoneStr=" + timeZoneID;
                        logger.debug("[" + this.reportingName + "][" + this.entity + "] Agent has received all the data from collector for this measurement period !!!");
                        logger.debug("[" + this.reportingName + "][" + this.entity + "] Total data size for this measurement period is : " + this.present_request_count);
                        if (dataList == null || dataList.size() != 3 || !(isSendConfig = (String)dataList.get(2)).equalsIgnoreCase("sendConfig")) continue;
                        this.firstTime = false;
                        logger.debug("Message recieved from eG RUM Collector to send config in the next measurement cycle for {}", (Object)this.reportingName);
                        continue;
                    }
                    isNeedRequest = "true";
                    logger.debug("[" + this.reportingName + "][" + this.entity + "] There are some more data available in collector for this measurement period, so the agent is requesting collector again.");
                    this.urlParameters = "service=" + serviceNameAsGuid + "&" + "timeZoneStr=" + timeZoneID + "&" + "isConsecutiveRequest=yes";
                    continue;
                }
                logger.debug("[" + this.reportingName + "][" + this.entity + "] The response data from collector is NULL. ie. No more data available in collector.");
                isNeedRequest = "false";
                this.urlParameters = "service=" + serviceNameAsGuid + "&" + "timeZoneStr=" + timeZoneID;
            }
        }
        catch (Exception e) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Error occured while getting the current measure period data from collector in EgRUMBase : " + e.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Error occured while getting the current measure period data from collector in EgRUMBase : ", (Throwable)e);
        }
        return currentMesurePeriodDataTable;
    }

    private Hashtable chekForPerDayLimit(Hashtable dataTable) {
        this.req_per_day_count = Integer.parseInt(this.reqPerDay);
        this.prv_request_count = 0;
        this.total_request_count = 0;
        String prvCount = this.getPreviousCount(this.rumPerDayProps, this.reportingName);
        Hashtable resultTable = null;
        try {
            if (prvCount != null) {
                this.prv_request_count = Integer.parseInt(prvCount);
            }
            logger.debug("[" + this.reportingName + "][" + this.entity + "]  requests per day count : " + this.req_per_day_count);
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Prv requests count : " + prvCount);
            this.total_request_count = this.prv_request_count + this.present_request_count;
            this.setCurrentCount(String.valueOf(this.total_request_count), this.rumPerDayProps, this.reportingName);
            if (this.prv_request_count < this.req_per_day_count) {
                if (this.show_exat_requests.equalsIgnoreCase("true")) {
                    logger.debug("[" + this.reportingName + "][" + this.entity + "] it is show exat requests ");
                    if (this.total_request_count > this.req_per_day_count) {
                        resultTable = this.getExatPerDayLimitRequests(dataTable);
                    }
                }
                this.is_perday_limit_exceeded = false;
                perDayLimitTable.put(this.reportingName, new Boolean(false));
            } else {
                this.is_perday_limit_exceeded = true;
                perDayLimitTable.put(this.reportingName, new Boolean(true));
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in chekForPerDayLimit() in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in chekForPerDayLimit() in EgRUMBase : ", (Throwable)ex);
        }
        if (resultTable == null) {
            return dataTable;
        }
        return resultTable;
    }

    private Hashtable getExatPerDayLimitRequests(Hashtable resultDataTable) {
        int remaing_request_count = this.req_per_day_count - this.prv_request_count;
        logger.debug("[" + this.reportingName + "][" + this.entity + "] remaing_request_count : " + remaing_request_count);
        Hashtable<String, Hashtable> resultTable = new Hashtable<String, Hashtable>();
        try {
            int i = 0;
            Enumeration allKeys = resultDataTable.keys();
            while (allKeys.hasMoreElements() && i < remaing_request_count) {
                String key = (String)allKeys.nextElement();
                resultTable.put(key, (Hashtable)resultDataTable.get(key));
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in getExatPerDayLimitRequests() in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in getExatPerDayLimitRequests() in EgRUMBase : ", (Throwable)ex);
        }
        return resultTable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean patternMatch(String outString, String searchString) {
        if (searchString.equals("*")) {
            return true;
        }
        int ir = searchString.indexOf("*");
        if (ir < 0) {
            return outString.equalsIgnoreCase(searchString);
        }
        boolean flag = false;
        boolean startsWithCond = false;
        boolean endsWithCond = false;
        try {
            int index;
            StringTokenizer st;
            int count;
            if (!searchString.startsWith("*")) {
                startsWithCond = true;
            }
            if (!searchString.endsWith("*")) {
                endsWithCond = true;
            }
            if ((count = (st = new StringTokenizer(searchString, "*")).countTokens()) <= 0) {
                return false;
            }
            String newString = new String(outString);
            String[] patterns = new String[count];
            int i = 0;
            while (true) {
                if (i >= count) {
                    index = 0;
                    if (!startsWithCond || newString.startsWith(patterns[0])) break;
                    return false;
                }
                patterns[i] = st.nextToken();
                ++i;
            }
            if (endsWithCond && !newString.endsWith(patterns[count - 1])) {
                return false;
            }
            String s1 = null;
            int j = 0;
            while (true) {
                if (j >= count) {
                    return flag;
                }
                s1 = patterns[j];
                index = newString.indexOf(s1);
                if (index == -1) return false;
                flag = true;
                newString = new String(newString.substring(index += s1.length()));
                ++j;
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in patternMatch() in EgRUMBase : " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in patternMatch() in EgRUMBase : ", (Throwable)ex);
        }
        return flag;
    }

    public boolean isPerDayLimitExceeded() {
        if (perDayLimitTable.containsKey(this.reportingName)) {
            Boolean bb = (Boolean)perDayLimitTable.get(this.reportingName);
            return bb;
        }
        return false;
    }

    private void deleteLastNDaysFiles(final String filterFileName, String fileDirectoryPath, int NumberOfDaysToRemoveFile) {
        try {
            FilenameFilter filter;
            File[] fList;
            Date todayDate = this.dateInfo.egetRealDate();
            SimpleDateFormat formatter = new SimpleDateFormat("ddMMMyyyy");
            File fileDirectory = new File(fileDirectoryPath);
            if (fileDirectory != null && fileDirectory.exists() && (fList = fileDirectory.listFiles(filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(filterFileName);
                }
            })) != null) {
                int i = 0;
                while (i < fList.length) {
                    File file = fList[i];
                    String fileName = file.getName();
                    String tempDate = fileName.substring(fileName.lastIndexOf("_") + 1, fileName.lastIndexOf("."));
                    if (fileName != null && tempDate != null) {
                        Date fileCreatedDate = formatter.parse(tempDate);
                        int diffInDays = (int)((todayDate.getTime() - fileCreatedDate.getTime()) / 86400000L);
                        if (diffInDays >= NumberOfDaysToRemoveFile) {
                            logger.debug("[" + this.reportingName + "][" + this.entity + "] Deleting file is : " + file);
                            if (file.delete()) {
                                logger.debug("[" + this.reportingName + "][" + this.entity + "] File deletion is successful : " + file);
                            } else {
                                logger.debug("[" + this.reportingName + "][" + this.entity + "] File deletion is failed : " + file);
                            }
                        }
                    } else {
                        logger.debug("[" + this.reportingName + "][" + this.entity + "] The fileName or tempDate is NULL !!!");
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Exception in deleteLastNDaysFiles!!! " + ex.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Exception in deleteLastNDaysFiles!!! ", (Throwable)ex);
        }
    }

    protected void isAppTestFinishedExecution() {
        try {
            long testStartTime = System.currentTimeMillis();
            long lastMetricComputeTime = 0L;
            long lastRunTime = 0L;
            long sleepTime = 100L;
            int kk = 0;
            Long lastTestRunTime = (Long)siteRumTimeMap.get(String.valueOf(this.entity) + ":" + this.reportingName);
            lastRunTime = lastTestRunTime != null ? lastTestRunTime : 0L;
            while (true) {
                long diff;
                long timeNow = System.currentTimeMillis();
                Long lastComputeTime = (Long)siteRumTimeMap.get(this.reportingName);
                lastMetricComputeTime = lastComputeTime != null ? lastComputeTime : 0L;
                logger.trace("[" + this.reportingName + "][" + this.entity + "] testStartTime=" + testStartTime + " \t " + "lastMetricComputeTime=" + lastMetricComputeTime + " \t " + "lastRunTime=" + lastRunTime + "\t" + "timeNow=" + timeNow);
                if (lastMetricComputeTime == 0L) {
                    try {
                        if (kk == 0) {
                            logger.debug("[" + this.reportingName + "][" + this.entity + "] AppTest did not started yet, so sleeping for " + sleepTime + " milliseconds ...");
                        }
                        Thread.sleep(sleepTime);
                    }
                    catch (Exception e) {
                        logger.error("[" + this.reportingName + "][" + this.entity + "] Error in Thread.sleep() when AppTest did not started yet  : " + e.getMessage());
                        logger.trace("[" + this.reportingName + "][" + this.entity + "] EError in Thread.sleep() when AppTest did not started yet : ", (Throwable)e);
                    }
                    diff = timeNow - testStartTime;
                    if ((double)diff >= 0.7 * (double)this.measurePeriod) {
                        logger.debug("[" + this.reportingName + "][" + this.entity + "] slept for more than 70% of measure period, coming out of sleep ...");
                        break;
                    }
                } else {
                    if (lastMetricComputeTime != 0L && lastRunTime == 0L) {
                        logger.debug("[" + this.reportingName + "][" + this.entity + "] App Test has finished its execution for the first time, so not going to sleep ...");
                        break;
                    }
                    if (lastMetricComputeTime < lastRunTime) {
                        try {
                            if (kk == 0) {
                                logger.debug("[" + this.reportingName + "][" + this.entity + "] App Test did not run yet for this msmt period, so sleeping for " + sleepTime + " milliseconds ...");
                            }
                            Thread.sleep(sleepTime);
                        }
                        catch (Exception e) {
                            logger.error("[" + this.reportingName + "][" + this.entity + "] Error in Thread.sleep() when AppTest did not run yet for this msmt period  : " + e.getMessage());
                            logger.trace("[" + this.reportingName + "][" + this.entity + "] EError in Thread.sleep() when AppTest did not run yet for this msmt period : ", (Throwable)e);
                        }
                        diff = timeNow - testStartTime;
                        if ((double)diff >= 0.7 * (double)this.measurePeriod) {
                            logger.debug("[" + this.reportingName + "][" + this.entity + "] slept for more than 70% of measure period, coming out of sleep ...");
                            break;
                        }
                    } else {
                        logger.debug("[" + this.reportingName + "][" + this.entity + "] App Test has finished its execution for this msmt period so not going to sleep ...");
                        break;
                    }
                }
                if (kk != 0) continue;
                ++kk;
            }
        }
        catch (Exception e) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Error in isAppTestFinishedExecution  : " + e.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Error in isAppTestFinishedExecution  : ", (Throwable)e);
        }
    }

    public int parseInt(String intStr, int defaultVal) {
        int value = defaultVal;
        try {
            value = intStr != null ? (intStr.equalsIgnoreCase("all") ? -1 : Integer.parseInt(intStr)) : defaultVal;
        }
        catch (Exception ex) {
            value = defaultVal;
        }
        return value;
    }

    public long parseLong(String intStr, long defaultVal) {
        long value = defaultVal;
        try {
            value = intStr != null ? Long.parseLong(intStr) : defaultVal;
        }
        catch (Exception ex) {
            value = defaultVal;
        }
        return value;
    }

    private boolean isIgnoredErrorMsg(String errorMessage, String ignoreErrorMessage) {
        boolean flag = false;
        if (ignoreErrorMessage != null && !ignoreErrorMessage.equals("None")) {
            StringTokenizer st = new StringTokenizer(errorMessage, "[]");
            block0: while (st.hasMoreTokens()) {
                String errorMsg = st.nextToken();
                if (errorMsg.equals(",")) continue;
                StringTokenizer st1 = new StringTokenizer(ignoreErrorMessage, ",");
                while (st1.hasMoreTokens()) {
                    String ignoreErrorMsg = st1.nextToken();
                    String ignoreErrorName = ignoreErrorMsg.substring(0, ignoreErrorMsg.indexOf(":"));
                    String ignoreErrorUrl = ignoreErrorMsg.substring(ignoreErrorMsg.indexOf(":") + 1);
                    if (!errorMsg.startsWith(ignoreErrorName)) continue;
                    if (!ignoreErrorUrl.equals("All") && errorMsg.indexOf(ignoreErrorUrl) <= -1) continue block0;
                    flag = true;
                    continue block0;
                }
            }
        }
        return flag;
    }

    private boolean isUrlEncoded(String url) {
        boolean isEncodedUrl = false;
        if (url == null) {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Given url is null, returning default value as false.");
            return isEncodedUrl;
        }
        try {
            if (url.indexOf("%") > -1) {
                isEncodedUrl = true;
            }
        }
        catch (Exception e) {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Exception occurred while identifying URL [" + url + "] is encoded or not  , returning false ");
            isEncodedUrl = false;
        }
        return isEncodedUrl;
    }

    private String decodeUrl(String mesurl) {
        String decodeURL = mesurl;
        if (decodeURL == null) {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Given url is null, returning default value as false.");
            return null;
        }
        try {
            decodeURL = URLDecoder.decode(decodeURL, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            decodeURL = mesurl;
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Character encoding needs to be consulted, but named character encoding is not supported , returning mesurl: ");
        }
        catch (Exception e) {
            decodeURL = mesurl;
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Exception occured while decoding the URL [" + decodeURL + "] , returning mesurl: ");
        }
        return decodeURL;
    }

    private boolean hasJSError(String error, String ignoreErrorMsg) {
        return error != null && error.length() > 0 && !this.isIgnoredErrorMsg(error, ignoreErrorMsg);
    }

    private void computeAndUpdateUserExperienceStatus(double loadTime, double slowCutOff2, double tolerateCutOff2, boolean isError, RUMMeasureData rumPojo) {
        if (isError) {
            if (this.isJsErrorsIncludedInApdex != null && this.isJsErrorsIncludedInApdex.equalsIgnoreCase("true")) {
                rumPojo.setFrustrated(true);
            } else if (loadTime > this.slowCutOff) {
                if (loadTime > this.tolerateCutOff) {
                    rumPojo.setFrustrated(true);
                } else {
                    rumPojo.setTolerating(true);
                }
            } else {
                rumPojo.setSatisfied(true);
            }
        } else if (loadTime > this.slowCutOff) {
            if (loadTime > this.tolerateCutOff) {
                rumPojo.setFrustrated(true);
            } else {
                rumPojo.setTolerating(true);
            }
        } else {
            rumPojo.setSatisfied(true);
        }
    }

    private boolean isSlowPageView(double loadTime, double slowCutOff2) {
        return loadTime > slowCutOff2;
    }

    public static Double getDoubleValue(String str, double defaultValue) {
        String str1 = new String(str);
        Double result = defaultValue;
        try {
            result = Double.valueOf(str);
        }
        catch (Exception e) {
            str = str.replaceAll(",", ".");
            try {
                result = Double.valueOf(str);
            }
            catch (Exception ex) {
                logger.debug("Unable to convert to Double value for  " + str1, (Throwable)ex);
            }
        }
        return result;
    }

    public HashMap getUNameSessionMap() {
        return this.sessionMapping;
    }

    public void clearUNameSessionMap() {
        if (this.sessionMapping != null) {
            this.sessionMapping.clear();
            this.sessionMapping = null;
        }
    }

    public static ArrayList removeExtraMeasure(int measureCount, ArrayList measureList) {
        try {
            if (measureList != null) {
                int size = measureList.size();
                if (measureCount == size) {
                    return measureList;
                }
                if (size > 0) {
                    int i = size - 1;
                    while (i >= measureCount) {
                        measureList.remove(i);
                        --i;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Error while removing extra measures. measureCount: " + measureCount, (Throwable)ex);
        }
        return measureList;
    }

    private HashMap getAgentMangerDetails() {
        HashMap<String, String> agentManagerDetails = new HashMap<String, String>();
        try {
            String eGAgentDirectory = String.valueOf(EgInstallInfo.getInstallDir()) + File.separator + "agent" + File.separator + "config";
            IniFile managerInfo = new IniFile(String.valueOf(eGAgentDirectory) + File.separator + "eg_setup.ini");
            String[] subjects = managerInfo.getSubjects();
            String managerIP = null;
            String managerPort = null;
            int i = 0;
            while (i < subjects.length) {
                String sub = subjects[i];
                managerIP = managerInfo.getValue(sub, "manager");
                managerPort = managerInfo.getValue(sub, "port");
                ++i;
            }
            Properties prop = new Properties();
            FileInputStream agentInfo = new FileInputStream(String.valueOf(eGAgentDirectory) + File.separator + "eg_counter.ini");
            prop.load(agentInfo);
            String agentId = prop.getProperty("AgentID");
            String agentIP = agentId.substring(agentId.indexOf("#") + 1, agentId.indexOf("^"));
            agentManagerDetails.put("managerIP", managerIP);
            agentManagerDetails.put("managerPort", managerPort);
            agentManagerDetails.put("agentIP", agentIP);
        }
        catch (Exception e1) {
            logger.error("[EgRUMBase][getAgentMangerDetails] Exception occured while getting manager and agent information: ", (Throwable)e1);
        }
        return agentManagerDetails;
    }

    private String getSlowTransactionCutOff() {
        return this.slowTransactionCutOff;
    }

    protected boolean isDataFromNewCollector() {
        return this.dataFromNewCollector;
    }

    private void updateDeviceCountForAppTest(ArrayList measuresList, Hashtable measureDDAvailabilityMap) {
        Map deviceStats = this.getDeviceStatisticsMap();
        if (deviceStats != null) {
            JsonNode tabletDataJson;
            RUMAggregateStats tabletData;
            JsonNode mobileDataJson;
            RUMAggregateStats mobileData;
            JsonNode desktopDataJson = (JsonNode)deviceStats.get("Desktop");
            RUMAggregateStats desktopData = (RUMAggregateStats)objectMapper.convertValue((Object)desktopDataJson, RUMAggregateStats.class);
            if (desktopData != null) {
                measuresList.add(Double.valueOf(desktopData.getPageViews()));
                if (desktopData.getPageViews() > 0L) {
                    measureDDAvailabilityMap.put("Desktop:" + this.serviceName, new Boolean(true));
                }
            } else {
                measuresList.add(zeroDouble);
            }
            if ((mobileData = (RUMAggregateStats)objectMapper.convertValue((Object)(mobileDataJson = (JsonNode)deviceStats.get("Mobile")), RUMAggregateStats.class)) != null) {
                measuresList.add(Double.valueOf(mobileData.getPageViews()));
                if (mobileData.getPageViews() > 0L) {
                    measureDDAvailabilityMap.put("Mobile:" + this.serviceName, new Boolean(true));
                }
            } else {
                measuresList.add(zeroDouble);
            }
            if ((tabletData = (RUMAggregateStats)objectMapper.convertValue((Object)(tabletDataJson = (JsonNode)deviceStats.get("Tablet")), RUMAggregateStats.class)) != null) {
                measuresList.add(Double.valueOf(tabletData.getPageViews()));
                if (tabletData.getPageViews() > 0L) {
                    measureDDAvailabilityMap.put("Tablet:" + this.serviceName, new Boolean(true));
                }
            } else {
                measuresList.add(zeroDouble);
            }
        } else {
            measuresList.add(zeroDouble);
            measuresList.add(zeroDouble);
            measuresList.add(zeroDouble);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateRumAppDataFromNewCollector(Map<String, JsonNode> applicationStatsMap, Hashtable measureDDAvailabilityMap, int mCount) {
        block27: {
            measuresList = null;
            try {
                if (applicationStatsMap != null && applicationStatsMap.size() > 0) {
                    for (String key : applicationStatsMap.keySet()) {
                        block26: {
                            rumJsonNode = applicationStatsMap.get(key);
                            rum = null;
                            try {
                                rum = (RUMAggregateStats)EgRUMBase.objectMapper.convertValue((Object)rumJsonNode, RUMAggregateStats.class);
                                break block26;
                            }
                            catch (Exception e) {
                                EgRUMBase.logger.error("[{}][{}] JsonNode conversion failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e.getMessage()});
                                EgRUMBase.logger.trace("[{}][{}] JsonNode conversion failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e});
                                measuresList = new ArrayList<E>();
                                i = 0;
                                ** while (i < this.measureCount)
                            }
lbl-1000:
                            // 1 sources

                            {
                                measuresList.add(EgRUMBase.zeroDouble);
                                ++i;
                                continue;
                            }
lbl20:
                            // 1 sources

                            measuresList.set(18, EgRUMBase.minusFive);
                            measuresList.set(22, EgRUMBase.minusFive);
                            measuresList = EgRUMBase.removeExtraMeasure(this.measureCount, measuresList);
                            this.addNewMeasure(this.serviceName, measuresList);
                            break block27;
                        }
                        measuresList = new ArrayList();
                        if (rum == null) continue;
                        apdex = -5.0;
                        pageViews = rum.getPageViews();
                        if (pageViews != 0.0) {
                            totalapdex = ((double)rum.getNormalPageViews() + (double)rum.getToleratingPageViews() / 2.0) / pageViews;
                            EgRUMBase.logger.debug("[{}][{}] Total Apdex = {}", new Object[]{this.reportingName, this.entity, totalapdex});
                            apdex = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(totalapdex), apdex);
                        }
                        measuresList.add(pageViews);
                        measuresList.add(Double.valueOf(rum.getSlowPageViews()));
                        measuresList.add(Double.valueOf(rum.getErrorPageViews()));
                        if (pageViews > 0.0) {
                            avgPageLoadTime = (double)rum.getPageLoadTime() / pageViews;
                            avgPageLoadTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgPageLoadTime), 0.0);
                            measuresList.add(avgPageLoadTime);
                            avgFrontEndTime = (double)rum.getFrontEndTime() / pageViews;
                            avgFrontEndTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgFrontEndTime), 0.0);
                            measuresList.add(avgFrontEndTime);
                            pageRenderTime = (double)rum.getPageRenderTime() / pageViews;
                            pageRenderTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(pageRenderTime), 0.0);
                            measuresList.add(pageRenderTime);
                            avgDocumentReadTime = (double)rum.getDocumentReadyTime() / pageViews;
                            avgDocumentReadTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgDocumentReadTime), 0.0);
                            measuresList.add(avgDocumentReadTime);
                            avgDocumentDownloadTime = (double)rum.getDocumentDownloadTime() / pageViews;
                            avgDocumentDownloadTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgDocumentDownloadTime), 0.0);
                            measuresList.add(avgDocumentDownloadTime);
                            avgDocumentProcessTime = (double)rum.getDocumentProcessingTime() / pageViews;
                            avgDocumentProcessTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgDocumentProcessTime), 0.0);
                            measuresList.add(avgDocumentProcessTime);
                            avgFirstByteTime = (double)rum.getFirstbyteTime() / pageViews;
                            avgFirstByteTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgFirstByteTime), 0.0);
                            measuresList.add(avgFirstByteTime);
                            avgResponseAvailableTime = (double)rum.getResponseAvailableTime() / pageViews;
                            avgResponseAvailableTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgResponseAvailableTime), 0.0);
                            measuresList.add(avgResponseAvailableTime);
                            avgNetworkTime = (double)rum.getServerConnectionTime() / pageViews;
                            avgNetworkTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgNetworkTime), 0.0);
                            measuresList.add(avgNetworkTime);
                            avgDNSLookupTime = (double)rum.getDnsLookupTime() / pageViews;
                            avgDNSLookupTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgDNSLookupTime), 0.0);
                            measuresList.add(avgDNSLookupTime);
                            avgTCPConnectionTime = (double)rum.getTcpConnectTime() / pageViews;
                            avgTCPConnectionTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgTCPConnectionTime), 0.0);
                            measuresList.add(avgTCPConnectionTime);
                            requestPerMinute = pageViews / ((double)this.measurePeriod / 60000.0);
                            requestPerMinute = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(requestPerMinute), 0.0);
                            measuresList.add(requestPerMinute);
                            avgNormalPercentage = (double)rum.getNormalPageViews() / pageViews * 100.0;
                            avgNormalPercentage = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgNormalPercentage), 0.0);
                            measuresList.add(avgNormalPercentage);
                            avgSlowPercentage = (double)rum.getSlowPageViews() / pageViews * 100.0;
                            avgSlowPercentage = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgSlowPercentage), 0.0);
                            measuresList.add(avgSlowPercentage);
                            avgErrorPercentage = (double)rum.getErrorPageViews() / pageViews * 100.0;
                            avgErrorPercentage = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgErrorPercentage), 0.0);
                            measuresList.add(avgErrorPercentage);
                        } else {
                            i = 0;
                            while (i < 15) {
                                measuresList.add(EgRUMBase.zeroDouble);
                                ++i;
                            }
                        }
                        measuresList.add(new Double(Double.parseDouble(rum.getUserSession())));
                        measuresList.add(Double.valueOf(rum.getSatisfiedPageViews()));
                        measuresList.add(Double.valueOf(rum.getToleratingPageViews()));
                        measuresList.add(Double.valueOf(rum.getFrustratedPageViews()));
                        measuresList.add(new Double(apdex));
                        this.updateDeviceCountForAppTest(measuresList, measureDDAvailabilityMap);
                        if (rum.getSslRequestCount() > 0L) {
                            averageSslHandshakeTime = (double)rum.getSslHandshakeTime() / (double)rum.getSslRequestCount();
                            averageSslHandshakeTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(averageSslHandshakeTime), 0.0);
                            measuresList.add(averageSslHandshakeTime);
                        } else {
                            measuresList.add(EgRUMBase.zeroDouble);
                        }
                        if (rum.getPageViews() > 0L) {
                            avgAppCacheTime = (double)rum.getAppCacheTime() / pageViews;
                            avgAppCacheTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgAppCacheTime), 0.0);
                            measuresList.add(avgAppCacheTime);
                            avgRedirectionTime = (double)rum.getRedirectionTime() / pageViews;
                            avgRedirectionTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgRedirectionTime), 0.0);
                            measuresList.add(avgRedirectionTime);
                            avgBrowserWaitTime = (double)rum.getBrowserWaitTime() / pageViews;
                            avgBrowserWaitTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgBrowserWaitTime), 0.0);
                            measuresList.add(avgBrowserWaitTime);
                            avgBrowserInitialReqTime = (rum.getAppCacheTime() + rum.getRedirectionTime() + rum.getBrowserWaitTime()) / rum.getPageViews();
                            avgBrowserInitialReqTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgBrowserInitialReqTime), 0.0);
                            measuresList.add(avgBrowserInitialReqTime);
                        } else {
                            measuresList.add(EgRUMBase.zeroDouble);
                            measuresList.add(EgRUMBase.zeroDouble);
                            measuresList.add(EgRUMBase.zeroDouble);
                            measuresList.add(EgRUMBase.zeroDouble);
                        }
                        measuresList.add(new Double(Double.parseDouble(rum.getUniqueIPCount())));
                        if (pageViews > 0.0 && this.numOutputFields >= mCount) {
                            avgUnLoadTime = (double)rum.getUnLoadTime() / pageViews;
                            avgUnLoadTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgUnLoadTime), 0.0);
                            measuresList.add(avgUnLoadTime);
                            avgProcessingTime = (double)rum.getProcessingTime() / pageViews;
                            avgProcessingTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgProcessingTime), 0.0);
                            measuresList.add(avgProcessingTime);
                            avgOnLoadEventDuration = (double)rum.getOnLoadEventDuration() / pageViews;
                            avgOnLoadEventDuration = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgOnLoadEventDuration), 0.0);
                            measuresList.add(avgOnLoadEventDuration);
                            avgChildrenTime = (double)rum.getChildrenTime() / pageViews;
                            avgChildrenTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgChildrenTime), 0.0);
                            measuresList.add(avgChildrenTime);
                            firstPaint = rum.getFp() / pageViews;
                            firstPaint = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(firstPaint), 0.0);
                            measuresList.add(firstPaint);
                            firstContentfulPaint = rum.getFcp() / pageViews;
                            firstContentfulPaint = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(firstContentfulPaint), 0.0);
                            measuresList.add(firstContentfulPaint);
                        } else if (this.numOutputFields >= mCount) {
                            i = 0;
                            while (i < 6) {
                                measuresList.add(EgRUMBase.zeroDouble);
                                ++i;
                            }
                        }
                        if (this.healthyTopNDD_Limit != 0 && pageViews > 0.0) {
                            measureDDAvailabilityMap.put("All:" + this.serviceName, new Boolean(true));
                        }
                        if ((double)rum.getSlowPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Slow:" + this.serviceName, new Boolean(true));
                        }
                        if ((double)rum.getErrorPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Error:" + this.serviceName, new Boolean(true));
                        }
                        if ((double)rum.getSatisfiedPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Satisfied:" + this.serviceName, new Boolean(true));
                        }
                        if ((double)rum.getToleratingPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Tolerating:" + this.serviceName, new Boolean(true));
                        }
                        if ((double)rum.getFrustratedPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Frustrated:" + this.serviceName, new Boolean(true));
                        }
                        measuresList = EgRUMBase.removeExtraMeasure(this.measureCount, measuresList);
                        this.addNewMeasure(this.serviceName, measuresList);
                    }
                    break block27;
                }
                measuresList = new ArrayList();
                i = 0;
                while (i < this.measureCount) {
                    measuresList.add(EgRUMBase.zeroDouble);
                    ++i;
                }
                measuresList.set(18, EgRUMBase.minusFive);
                measuresList.set(22, EgRUMBase.minusFive);
                measuresList = EgRUMBase.removeExtraMeasure(this.measureCount, measuresList);
                this.addNewMeasure(this.serviceName, measuresList);
            }
            catch (Exception ee) {
                EgRUMBase.logger.error("[{}][{}] Iteration of specified hashMap failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, ee.getMessage()});
                EgRUMBase.logger.trace("[{}][{}] Iteration of specified hashMap failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, ee});
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateDataFromNewCollector(Map<String, JsonNode> rumAggregateStatsMap, Hashtable measureDDAvailabilityMap, int counts, HashSet infoSet, int mCount) {
        block31: {
            measuresList = null;
            try {
                if (rumAggregateStatsMap != null && rumAggregateStatsMap.size() > 0) {
                    for (String key : rumAggregateStatsMap.keySet()) {
                        block30: {
                            rumJsonNode = rumAggregateStatsMap.get(key);
                            rum = null;
                            try {
                                rum = (RUMAggregateStats)EgRUMBase.objectMapper.convertValue((Object)rumJsonNode, RUMAggregateStats.class);
                                break block30;
                            }
                            catch (Exception e) {
                                EgRUMBase.logger.error("[{}][{}] JsonNode conversion failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e.getMessage()});
                                EgRUMBase.logger.trace("[{}][{}] JsonNode conversion failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e});
                                measuresList = new ArrayList<E>();
                                i = 0;
                                ** while (i < this.measureCount)
                            }
lbl-1000:
                            // 1 sources

                            {
                                measuresList.add(EgRUMBase.minusFive);
                                ++i;
                                continue;
                            }
lbl20:
                            // 1 sources

                            if (this.entity.equals("RUMDeviceTest")) {
                                measuresList.add(EgRUMBase.minusFive);
                            }
                            measuresList = EgRUMBase.removeExtraMeasure(this.measureCount, measuresList);
                            this.addNewMeasure(this.serviceName, measuresList);
                            break block31;
                        }
                        measuresList = new ArrayList();
                        apdex = -5.0;
                        pageViews = rum.getPageViews();
                        if (pageViews != 0.0) {
                            totalapdex = ((double)rum.getNormalPageViews() + (double)rum.getToleratingPageViews() / 2.0) / pageViews;
                            EgRUMBase.logger.debug("[{}][{}] Total Apdex = {}", new Object[]{this.reportingName, this.entity, totalapdex});
                            apdex = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(totalapdex), apdex);
                        }
                        measuresList.add(pageViews);
                        measuresList.add(Double.valueOf(rum.getSlowPageViews()));
                        measuresList.add(Double.valueOf(rum.getErrorPageViews()));
                        if (pageViews > 0.0) {
                            avgPageLoadTime = (double)rum.getPageLoadTime() / pageViews;
                            avgPageLoadTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgPageLoadTime), 0.0);
                            measuresList.add(avgPageLoadTime);
                            avgFrontEndTime = (double)rum.getFrontEndTime() / pageViews;
                            avgFrontEndTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgFrontEndTime), 0.0);
                            measuresList.add(avgFrontEndTime);
                            pageRenderTime = (double)rum.getPageRenderTime() / pageViews;
                            pageRenderTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(pageRenderTime), 0.0);
                            measuresList.add(pageRenderTime);
                            avgDocumentReadTime = (double)rum.getDocumentReadyTime() / pageViews;
                            avgDocumentReadTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgDocumentReadTime), 0.0);
                            measuresList.add(avgDocumentReadTime);
                            avgDocumentDownloadTime = (double)rum.getDocumentDownloadTime() / pageViews;
                            avgDocumentDownloadTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgDocumentDownloadTime), 0.0);
                            measuresList.add(avgDocumentDownloadTime);
                            avgDocumentProcessTime = (double)rum.getDocumentProcessingTime() / pageViews;
                            avgDocumentProcessTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgDocumentProcessTime), 0.0);
                            measuresList.add(avgDocumentProcessTime);
                            avgFirstByteTime = (double)rum.getFirstbyteTime() / pageViews;
                            avgFirstByteTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgFirstByteTime), 0.0);
                            measuresList.add(avgFirstByteTime);
                            avgResponseAvailableTime = (double)rum.getResponseAvailableTime() / pageViews;
                            avgResponseAvailableTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgResponseAvailableTime), 0.0);
                            measuresList.add(avgResponseAvailableTime);
                            avgNetworkTime = (double)rum.getServerConnectionTime() / pageViews;
                            avgNetworkTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgNetworkTime), 0.0);
                            measuresList.add(avgNetworkTime);
                            avgDNSLookupTime = (double)rum.getDnsLookupTime() / pageViews;
                            avgDNSLookupTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgDNSLookupTime), 0.0);
                            measuresList.add(avgDNSLookupTime);
                            avgTCPConnectionTime = (double)rum.getTcpConnectTime() / pageViews;
                            avgTCPConnectionTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgTCPConnectionTime), 0.0);
                            measuresList.add(avgTCPConnectionTime);
                            requestPerMinute = pageViews / ((double)this.measurePeriod / 60000.0);
                            requestPerMinute = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(requestPerMinute), 0.0);
                            measuresList.add(requestPerMinute);
                            avgNormalPercentage = (double)rum.getNormalPageViews() / pageViews * 100.0;
                            avgNormalPercentage = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgNormalPercentage), 0.0);
                            measuresList.add(avgNormalPercentage);
                            avgSlowPercentage = (double)rum.getSlowPageViews() / pageViews * 100.0;
                            avgSlowPercentage = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgSlowPercentage), 0.0);
                            measuresList.add(avgSlowPercentage);
                            avgErrorPercentage = (double)rum.getErrorPageViews() / pageViews * 100.0;
                            avgErrorPercentage = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgErrorPercentage), 0.0);
                            measuresList.add(avgErrorPercentage);
                        } else {
                            i = 0;
                            while (i < counts) {
                                measuresList.add(EgRUMBase.zeroDouble);
                                ++i;
                            }
                        }
                        measuresList.add(new Double(Double.parseDouble(rum.getUserSession())));
                        measuresList.add(Double.valueOf(rum.getSatisfiedPageViews()));
                        measuresList.add(Double.valueOf(rum.getToleratingPageViews()));
                        measuresList.add(Double.valueOf(rum.getFrustratedPageViews()));
                        measuresList.add(new Double(apdex));
                        if (this.entity.equals("RUMGrpTest")) {
                            measuresList.add(12.0);
                        }
                        if (rum.getSslRequestCount() > 0L) {
                            averageSslHandshakeTime = (double)rum.getSslHandshakeTime() / (double)rum.getSslRequestCount();
                            averageSslHandshakeTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(averageSslHandshakeTime), 0.0);
                            measuresList.add(averageSslHandshakeTime);
                        } else {
                            measuresList.add(EgRUMBase.zeroDouble);
                        }
                        if (rum.getPageViews() > 0L) {
                            avgAppCacheTime = (double)rum.getAppCacheTime() / pageViews;
                            avgAppCacheTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgAppCacheTime), 0.0);
                            measuresList.add(avgAppCacheTime);
                            avgRedirectionTime = (double)rum.getRedirectionTime() / pageViews;
                            avgRedirectionTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgRedirectionTime), 0.0);
                            measuresList.add(avgRedirectionTime);
                            avgBrowserWaitTime = (double)rum.getBrowserWaitTime() / pageViews;
                            avgBrowserWaitTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgBrowserWaitTime), 0.0);
                            measuresList.add(avgBrowserWaitTime);
                            avgBrowserInitialReqTime = (rum.getAppCacheTime() + rum.getRedirectionTime() + rum.getBrowserWaitTime()) / rum.getPageViews();
                            avgBrowserInitialReqTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgBrowserInitialReqTime), 0.0);
                            measuresList.add(avgBrowserInitialReqTime);
                        } else {
                            measuresList.add(EgRUMBase.zeroDouble);
                            measuresList.add(EgRUMBase.zeroDouble);
                            measuresList.add(EgRUMBase.zeroDouble);
                            measuresList.add(EgRUMBase.zeroDouble);
                        }
                        if (pageViews > 0.0 && this.numOutputFields >= mCount) {
                            avgUnLoadTime = (double)rum.getUnLoadTime() / pageViews;
                            avgUnLoadTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgUnLoadTime), 0.0);
                            measuresList.add(avgUnLoadTime);
                            avgProcessingTime = (double)rum.getProcessingTime() / pageViews;
                            avgProcessingTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgProcessingTime), 0.0);
                            measuresList.add(avgProcessingTime);
                            avgOnLoadEventDuration = (double)rum.getOnLoadEventDuration() / pageViews;
                            avgOnLoadEventDuration = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgOnLoadEventDuration), 0.0);
                            measuresList.add(avgOnLoadEventDuration);
                            avgChildrenTime = (double)rum.getChildrenTime() / pageViews;
                            avgChildrenTime = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(avgChildrenTime), 0.0);
                            measuresList.add(avgChildrenTime);
                            firstPaint = rum.getFp() / pageViews;
                            firstPaint = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(firstPaint), 0.0);
                            measuresList.add(firstPaint);
                            firstContentfulPaint = rum.getFcp() / pageViews;
                            firstContentfulPaint = EgRUMBase.getDoubleValue(EgRUMBase.formatter.format(firstContentfulPaint), 0.0);
                            measuresList.add(firstContentfulPaint);
                        } else if (this.numOutputFields >= mCount) {
                            i = 0;
                            while (i < 6) {
                                measuresList.add(EgRUMBase.zeroDouble);
                                ++i;
                            }
                        }
                        if (this.entity.equals("RUMDeviceTest")) {
                            measuresList.add(new Double(Double.parseDouble(rum.getUniqueIPCount())));
                        }
                        info = this.getInfo(key);
                        infoSet.add(info);
                        if (this.healthyTopNDD_Limit != 0 && pageViews > 0.0) {
                            measureDDAvailabilityMap.put("All:" + info, new Boolean(true));
                        }
                        if ((double)rum.getSlowPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Slow:" + info, new Boolean(true));
                        }
                        if ((double)rum.getErrorPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Error:" + info, new Boolean(true));
                        }
                        if ((double)rum.getSatisfiedPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Satisfied:" + info, new Boolean(true));
                        }
                        if ((double)rum.getToleratingPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Tolerating:" + info, new Boolean(true));
                        }
                        if ((double)rum.getFrustratedPageViews() > 0.0) {
                            measureDDAvailabilityMap.put("Frustrated:" + info, new Boolean(true));
                        }
                        measuresList = EgRUMBase.removeExtraMeasure(this.measureCount, measuresList);
                        this.addNewMeasure(info, measuresList);
                    }
                    break block31;
                }
                measuresList = new ArrayList();
                i = 0;
                while (i < this.measureCount) {
                    measuresList.add(EgRUMBase.minusFive);
                    ++i;
                }
                if (this.entity.equals("RUMDeviceTest")) {
                    measuresList.add(EgRUMBase.minusFive);
                }
                measuresList = EgRUMBase.removeExtraMeasure(this.measureCount, measuresList);
                this.addNewMeasure(this.serviceName, measuresList);
            }
            catch (Exception ee) {
                EgRUMBase.logger.error("[{}][{}] Iteration of specified hashMap failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, ee.getMessage()});
                EgRUMBase.logger.trace("[{}][{}] Iteration of specified hashMap failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, ee});
            }
        }
    }

    private String getCityInfo(String key) {
        String city = key;
        String region = "";
        String country = "";
        String info = key;
        int index = key.indexOf(":");
        if (index > -1) {
            country = key.substring(0, index);
            region = key.substring(index + 1, key.lastIndexOf(":"));
            city = key.substring(key.lastIndexOf(":") + 1);
            if (region.trim().equals(HYPHEN)) {
                region = UNKNOWN_STRING;
            }
            if (city.trim().equals(HYPHEN)) {
                city = UNKNOWN_STRING;
            }
            region = region.trim();
            country = country.trim();
            info = region.equals("null") || region.equals("") ? (country.equals("null") || country.equals("") ? city : String.valueOf(city) + " (" + country + ")") : (country.equals("null") || country.equals("") ? String.valueOf(city) + " (" + region + ")" : String.valueOf(city) + " (" + region + " - " + country + ")");
        }
        return info;
    }

    protected String getInfo(String key) {
        if (this.entity.equals("RUMCityTest")) {
            return this.getCityInfo(key);
        }
        if (this.entity.equals("RUMCountryTest") && key.trim().equals(HYPHEN)) {
            key = UNKNOWN_STRING;
        }
        if (this.entity.equals("RUMRegionTest")) {
            return this.getRegionInfo(key);
        }
        return key;
    }

    private String getRegionInfo(String key) {
        String region = key;
        String country = "";
        String info = key;
        int index = key.indexOf(":");
        if (index > -1) {
            country = key.substring(0, index);
            region = key.substring(index + 1);
            if (region.trim().equals(HYPHEN)) {
                region = UNKNOWN_STRING;
            }
            info = country.equals("null") || country.trim().equals("") ? region : String.valueOf(region) + " (" + country + ")";
        }
        return info;
    }

    public ArrayList newDDData(String reportingName) {
        ArrayList ddData = null;
        try {
            ArrayList ddListCopy;
            if (newCollectorDD.containsKey(reportingName) && (ddListCopy = newCollectorDD.get(reportingName)) != null && ddListCopy.size() > 0) {
                ddData = (ArrayList)ddListCopy.get(0);
                ddListCopy.set(0, new ArrayList());
            }
        }
        catch (Exception ee) {
            logger.error("[{}][{}]failed when getting DD: {}", new Object[]{reportingName, this.entity, ee.getMessage()});
            logger.trace("[{}][{}]failed when getting DD: {}", new Object[]{reportingName, this.entity, ee});
        }
        return ddData;
    }

    public HashMap newDDResourceData(String reportingName) {
        HashMap resourceMap = null;
        try {
            ArrayList DDListCopy;
            if (newCollectorDD.containsKey(reportingName) && (DDListCopy = newCollectorDD.get(reportingName)) != null && DDListCopy.size() == 3) {
                resourceMap = (HashMap)DDListCopy.remove(1);
            }
        }
        catch (Exception ee) {
            logger.error("[{}][{}]failed when getting ResourceDataDD: {}", new Object[]{reportingName, this.entity, ee.getMessage()});
            logger.trace("[{}][{}]failed when getting ResourceDataDD: {}", new Object[]{reportingName, this.entity, ee});
        }
        return resourceMap;
    }

    public ArrayList newJSErrorData(String reportingName) {
        ArrayList jsErrorList = null;
        try {
            ArrayList jsErrorListCopy;
            if (newCollectorDD.containsKey(reportingName) && (jsErrorListCopy = newCollectorDD.get(reportingName)) != null && jsErrorListCopy.size() > 0) {
                jsErrorList = (ArrayList)jsErrorListCopy.get(1);
                jsErrorListCopy.set(1, new ArrayList());
            }
        }
        catch (Exception ee) {
            logger.error("[{}][{}]failed when getting DD: {}", new Object[]{reportingName, this.entity, ee.getMessage()});
            logger.trace("[{}][{}]failed when getting DD: {}", new Object[]{reportingName, this.entity, ee});
        }
        return jsErrorList;
    }

    private String[] getBrowserVersion(String browserDetails) {
        String browserVersion = null;
        String browser = null;
        if (browserDetails != null) {
            if (browserDetails.indexOf("Internet Explorer") == -1 && browserDetails.indexOf("Opera") == -1 && browserDetails.indexOf("Chrome") == -1 && browserDetails.indexOf("iOS Mobile") == -1 && browserDetails.indexOf("Firefox") == -1 && browserDetails.indexOf("Android Mobile") == -1 && browserDetails.indexOf("Safari") == -1 && browserDetails.indexOf("Microsoft Edge") == -1 && browserDetails.indexOf("Others") == -1) {
                browser = "Others";
                browserVersion = UNKNOWN_STRING;
            } else if (browserDetails.lastIndexOf(" ") > 0) {
                browser = browserDetails.substring(0, browserDetails.lastIndexOf(" "));
                if (browserDetails.indexOf("Others") > -1) {
                    browserVersion = UNKNOWN_STRING;
                }
                browserVersion = browserDetails.substring(browserDetails.lastIndexOf(" ") + 1);
            } else {
                browser = browserDetails;
                browserVersion = UNKNOWN_STRING;
            }
        } else {
            browserVersion = UNKNOWN_STRING;
            browser = UNKNOWN_STRING;
        }
        String[] result = new String[]{browser, browserVersion};
        return result;
    }

    protected StringBuffer getRumData(RUMBeacon rumBeacon, String pageName, String reportingName, String fieldSep, int mCount) {
        int pipe_index;
        StringBuffer buffer = new StringBuffer();
        String browserDetails = rumBeacon.getBdt();
        String[] resultArr = this.getBrowserVersion(browserDetails);
        String browser = resultArr[0];
        String browserVersion = resultArr[1];
        boolean isAjax = false;
        if (rumBeacon.isIsaj() || rumBeacon.isFetch()) {
            isAjax = true;
        }
        buffer.append(reportingName).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkVarcharColumnLimit(121, rumBeacon.getPageGroup())).append(fieldSep);
        buffer.append(rumBeacon.getPageType()).append(fieldSep);
        buffer.append(rumBeacon.getDvdt()).append(fieldSep);
        buffer.append(rumBeacon.getOsd()).append(fieldSep);
        buffer.append(browser).append(fieldSep);
        buffer.append(rumBeacon.getCountry()).append(fieldSep);
        buffer.append(rumBeacon.getRegion()).append(fieldSep);
        buffer.append(rumBeacon.getCity()).append(fieldSep);
        String timeStr = rumBeacon.getTimeStr();
        String finalDate = HYPHEN;
        try {
            Date firstDate = mySDF.parse(timeStr);
            finalDate = finalFormat.format(firstDate);
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while Parsing Date in Percentage slow DD for Time String {} ", new Object[]{reportingName, String.valueOf(this.entity) + "_DD", timeStr});
        }
        buffer.append(finalDate).append(fieldSep);
        buffer.append(rumBeacon.getRgd()).append(fieldSep);
        if (rumBeacon.getErrorPageViews() >= 1) {
            buffer.append("Error").append(fieldSep);
        }
        if (rumBeacon.getSlowPageViews() >= 1 && rumBeacon.getErrorPageViews() == 0) {
            buffer.append("Slow").append(fieldSep);
        }
        if (rumBeacon.getSlowPageViews() == 0 && rumBeacon.getErrorPageViews() == 0 && rumBeacon.getNormalPageViews() >= 1) {
            buffer.append("Healthy").append(fieldSep);
        }
        Date local_date = new Date(this.dateInfo.egetUTCDate());
        TimeZone timezone = EgDateInfo.getRealTimeZone();
        String timeZoneIDShort = timezone.getDisplayName(timezone.inDaylightTime(local_date), 0);
        buffer.append(timeZoneIDShort).append(fieldSep);
        String url = null;
        url = isAjax ? rumBeacon.getAju() : rumBeacon.getUrl();
        try {
            URL mesUrlObj = new URL(url);
            url = mesUrlObj.getPath();
        }
        catch (Exception ee) {
            logger.error("[{}][{}] Exception while separating URL string {} from param {}", new Object[]{reportingName, String.valueOf(this.entity) + "_DD", url, ee.getMessage()});
            logger.trace("[{}][{}] Exception while separating URL string {} from param {}", new Object[]{reportingName, String.valueOf(this.entity) + "_DD", url, ee});
        }
        if (url != null && url.length() > 512) {
            url = url.substring(0, 509).concat("...");
        }
        buffer.append(url).append(fieldSep);
        buffer.append(rumBeacon.getRef()).append(fieldSep);
        buffer.append(rumBeacon.getSid()).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getPageLoadTime())))).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getFrontEndTime())))).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getPageRenderTime())))).append(fieldSep);
        if (isAjax) {
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getDocumentDownloadTime())))).append(fieldSep);
        } else {
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getDocumentReadyTime())))).append(fieldSep);
        }
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getDocumentDownloadTime())))).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getDocumentProcessingTime())))).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getFirstbyteTime())))).append(fieldSep);
        if (isAjax) {
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getFirstbyteTime())))).append(fieldSep);
        } else {
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getResponseAvailableTime())))).append(fieldSep);
        }
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getServerConnectionTime())))).append(fieldSep);
        if (isAjax) {
            buffer.append(MINUS_FIVE).append(fieldSep);
            buffer.append(MINUS_FIVE).append(fieldSep);
        } else {
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getDnsLookupTime())))).append(fieldSep);
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getTcpConnectTime())))).append(fieldSep);
        }
        String clientIp = rumBeacon.getIp();
        String gatewayIp = rumBeacon.getGatewayIp();
        if (this.publicIPMaskFlag || this.privateIPMaskFlag) {
            String tempIP = clientIp;
            if (!this.checkIsIpLocalhost(clientIp)) {
                clientIp = this.getMaskedIP(clientIp, this.ipMaskCharValue);
            }
            if (!this.checkIsIpLocalhost(gatewayIp)) {
                gatewayIp = tempIP.equals(gatewayIp) ? clientIp : this.getMaskedIP(gatewayIp, this.ipMaskCharValue);
            }
        }
        buffer.append(clientIp).append(fieldSep);
        buffer.append(browserVersion).append(fieldSep);
        buffer.append(rumBeacon.getCountry_code()).append(fieldSep);
        buffer.append(rumBeacon.getLatitude()).append(fieldSep);
        buffer.append(rumBeacon.getLongitude()).append(fieldSep);
        buffer.append(rumBeacon.getAgt()).append(fieldSep);
        buffer.append(this.getSlowTransactionCutOff()).append(fieldSep);
        if (rumBeacon.getSlowPageViews() >= 1 && rumBeacon.getErrorPageViews() == 0) {
            buffer.append(rumBeacon.getSlowPageViews()).append(fieldSep);
        } else {
            buffer.append(0).append(fieldSep);
        }
        if (rumBeacon.getStatus().equalsIgnoreCase("error")) {
            rumBeacon.setErrorPageViews(1);
        }
        buffer.append(rumBeacon.getErrorPageViews()).append(fieldSep);
        buffer.append(rumBeacon.getSatisfiedPageViews()).append(fieldSep);
        buffer.append(rumBeacon.getToleratingPageViews()).append(fieldSep);
        buffer.append(rumBeacon.getFrustratedPageViews()).append(fieldSep);
        buffer.append(rumBeacon.getErr()).append(fieldSep);
        String isNav = String.valueOf(rumBeacon.getIsNav());
        if (isNav.equalsIgnoreCase("true")) {
            buffer.append("1").append(fieldSep);
        } else {
            buffer.append("0").append(fieldSep);
        }
        String isRsrc = String.valueOf(rumBeacon.getIsRsrc());
        if (isRsrc.equalsIgnoreCase("true")) {
            buffer.append("1").append(fieldSep);
        } else {
            buffer.append("0").append(fieldSep);
        }
        buffer.append(String.valueOf(rumBeacon.getRpgd())).append(fieldSep);
        buffer.append(String.valueOf(rumBeacon.getRbgd())).append(fieldSep);
        buffer.append(gatewayIp).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getSslHandshakeTime())))).append(fieldSep);
        if (isAjax) {
            buffer.append(MINUS_FIVE).append(fieldSep);
            buffer.append(MINUS_FIVE).append(fieldSep);
            buffer.append(MINUS_FIVE).append(fieldSep);
        } else {
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getAppCacheTime())))).append(fieldSep);
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getRedirectionTime())))).append(fieldSep);
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getBrowserWaitTime())))).append(fieldSep);
        }
        buffer.append(rumBeacon.getBtgd()).append(fieldSep);
        buffer.append(rumBeacon.getBtno()).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getBtet())))).append(fieldSep);
        String sessionId = rumBeacon.getSid();
        String userName = HYPHEN;
        if (sessionId != null && (pipe_index = sessionId.indexOf("||")) > 0) {
            String sessionString = sessionId.substring(0, pipe_index);
            String btmNodeId = sessionId.substring(pipe_index + 2);
            String btmSessionId = Base64Coder.decodeString(sessionString);
            if (btmNodeId != null) {
                if (btmNodeId.startsWith("[")) {
                    btmNodeId = btmNodeId.substring(1);
                }
                if (btmNodeId.endsWith("]")) {
                    btmNodeId = btmNodeId.substring(0, btmNodeId.length() - 1);
                }
            }
            if (btmSessionId.indexOf("#|#") > 0) {
                String btmSessionIdParsed = btmSessionId.substring(0, btmSessionId.indexOf("#|#"));
                userName = btmSessionId.substring(btmSessionId.lastIndexOf("#|#") + 3);
                btmSessionId = btmSessionIdParsed;
            }
            if (btmSessionId.length() > 43) {
                String sessionIDStart = btmSessionId.substring(0, 7);
                String sessionIDend = btmSessionId.substring(43);
                sessionId = String.valueOf(sessionIDStart) + sessionIDend + "||" + btmNodeId;
            } else {
                sessionId = !btmSessionId.equals(HYPHEN) ? String.valueOf(btmSessionId) + "||" + btmNodeId : "";
            }
            if (userName != null && !userName.equals(HYPHEN)) {
                boolean isUserNameEncoded = this.isUrlEncoded(userName);
                if (isUserNameEncoded) {
                    userName = this.decodeUrl(userName);
                }
                if (this.sessionMapping != null && !this.sessionMapping.containsKey(sessionId)) {
                    this.sessionMapping.put(sessionId, userName);
                }
            } else if (this.sessionMapping != null && this.sessionMapping.containsKey(sessionId)) {
                userName = (String)this.sessionMapping.get(sessionId);
            }
        }
        buffer.append(userName).append(fieldSep);
        String measURL = rumBeacon.getUrl();
        if (isAjax) {
            measURL = rumBeacon.getAju();
        }
        String mesURLProtocol = null;
        String mesURLDomain = null;
        String mesURLPort = null;
        String mesURLFragment = null;
        try {
            URL mesUrlObj = new URL(measURL);
            mesURLProtocol = mesUrlObj.getProtocol();
            mesURLDomain = mesUrlObj.getHost();
            int port = mesUrlObj.getPort();
            mesURLPort = port == -1 ? HYPHEN : String.valueOf(port);
            mesURLFragment = new URI(measURL).getFragment();
            if (mesURLFragment == null) {
                mesURLFragment = HYPHEN;
            }
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception in getting URL related measures {}", new Object[]{reportingName, String.valueOf(this.entity) + "_DD", e.getMessage()});
            logger.trace("[{}][{}] Exception in getting URL related measures {}", new Object[]{reportingName, String.valueOf(this.entity) + "_DD", e});
            mesURLProtocol = HYPHEN;
            mesURLDomain = HYPHEN;
            mesURLPort = HYPHEN;
            mesURLFragment = HYPHEN;
        }
        String rumUrlDelimiters = null;
        try {
            IniFile inifile = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_tests.ini");
            rumUrlDelimiters = inifile.getValue("RUM_MISC_SETTINGS", "rumUrlDelimiters");
            if (rumUrlDelimiters == null) {
                rumUrlDelimiters = "?,;";
            }
        }
        catch (Exception e) {
            rumUrlDelimiters = "?,;";
            logger.error("[{}][{}] Exception in getting RumUrlDelimiters for getting URL {}", new Object[]{reportingName, String.valueOf(this.entity) + "_DD", e.getMessage()});
            logger.trace("[{}][{}] Exception in getting RumUrlDelimiters for getting URL {}", new Object[]{reportingName, String.valueOf(this.entity) + "_DD", e});
        }
        StringTokenizer tokenizer = new StringTokenizer(rumUrlDelimiters, ",");
        String mesURLParams = null;
        measURL = isAjax ? rumBeacon.getAju() : rumBeacon.getUrl();
        ArrayList<Integer> delimiterIndexList = new ArrayList<Integer>();
        while (tokenizer.hasMoreTokens()) {
            String delimiter = tokenizer.nextToken();
            if (measURL.indexOf(delimiter) <= -1) continue;
            delimiterIndexList.add(measURL.indexOf(delimiter));
        }
        Collections.sort(delimiterIndexList);
        if (delimiterIndexList.size() > 0) {
            int delimiterIdx = (Integer)delimiterIndexList.get(0);
            mesURLParams = measURL.substring(delimiterIdx + 1);
            measURL = measURL.substring(0, delimiterIdx);
        }
        if (mesURLParams != null) {
            int hashIndex = mesURLParams.indexOf("#");
            if (hashIndex > -1) {
                mesURLParams = mesURLParams.substring(0, hashIndex);
            }
        } else {
            mesURLParams = HYPHEN;
        }
        if (this.urlParamsMaskFlag && mesURLParams != null && !mesURLParams.equalsIgnoreCase(HYPHEN)) {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append("?");
            urlBuilder.append(mesURLParams);
            mesURLParams = urlBuilder.toString();
            mesURLParams = UrlParamMaskHelper.maskURLParams(mesURLParams);
            int queryStringIndex = mesURLParams.indexOf("?");
            if (queryStringIndex > -1) {
                mesURLParams = mesURLParams.substring(queryStringIndex + 1);
            }
        }
        if (mesURLParams.length() > 2000) {
            mesURLParams = String.valueOf(mesURLParams.substring(0, 1995)) + "...";
        }
        buffer.append(mesURLProtocol).append(fieldSep);
        buffer.append(mesURLDomain).append(fieldSep);
        buffer.append(mesURLPort).append(fieldSep);
        buffer.append(mesURLParams).append(fieldSep);
        if (isAjax) {
            buffer.append(MINUS_FIVE).append(fieldSep);
        } else {
            double avgBrowserInitialReqTime = (rumBeacon.getAppCacheTime() + rumBeacon.getRedirectionTime() + rumBeacon.getBrowserWaitTime()) / 1L;
            buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(avgBrowserInitialReqTime)))).append(fieldSep);
        }
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getNwDownlink())))).append(fieldSep);
        buffer.append(rumBeacon.getNwEffectiveType()).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getNwRTT())))).append(fieldSep);
        long networkTime = 0L;
        if (rumBeacon.getDnsLookupTime() > 0L && rumBeacon.getTcpConnectTime() > 0L && rumBeacon.getSslHandshakeTime() > 0L) {
            networkTime = rumBeacon.getDnsLookupTime() + rumBeacon.getTcpConnectTime() + rumBeacon.getSslHandshakeTime();
        }
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(networkTime)))).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getFirstbyteTime())))).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getDocumentDownloadTime())))).append(fieldSep);
        buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getPageRenderTime())))).append(fieldSep);
        String meta = rumBeacon.getMeta();
        if (meta != null && meta.equalsIgnoreCase("null")) {
            meta = HYPHEN;
        }
        if (meta != null && meta.length() > 512) {
            meta = meta.substring(0, 509).concat("...");
        }
        if (mesURLFragment != null && mesURLFragment.length() > 512) {
            mesURLFragment = mesURLFragment.substring(0, 509).concat("...");
        }
        buffer.append(pageName).append(fieldSep);
        buffer.append(meta).append(fieldSep);
        buffer.append(rumBeacon.getStatus()).append(fieldSep);
        buffer.append(mesURLFragment).append(fieldSep);
        if (this.numOutputFields >= mCount) {
            if (isAjax || rumBeacon.isVpg()) {
                buffer.append(MINUS_FIVE).append(fieldSep);
                buffer.append(MINUS_FIVE).append(fieldSep);
                buffer.append(MINUS_FIVE).append(fieldSep);
                buffer.append(MINUS_FIVE).append(fieldSep);
                buffer.append(MINUS_FIVE).append(fieldSep);
                buffer.append(MINUS_FIVE).append(fieldSep);
            } else {
                buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getUnLoadTime())))).append(fieldSep);
                buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getProcessingTime())))).append(fieldSep);
                buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getOnLoadEventDuration())))).append(fieldSep);
                buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getChildrenTime())))).append(fieldSep);
                buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getFp())))).append(fieldSep);
                buffer.append(RUMMeasureCategory.checkStrColumnLimit(16, 4, String.format(Locale.US, "%.2f", new Double(rumBeacon.getFcp())))).append(fieldSep);
            }
            String linkID = rumBeacon.getLinkId();
            if (linkID != null && linkID.equalsIgnoreCase("null")) {
                linkID = HYPHEN;
            }
            buffer.append(linkID);
        }
        return buffer;
    }

    protected StringBuffer getJSErrorData(RUMBeacon rumBeacon, String errMessage, String errFileName, String errMetaData, String reportingName, String fieldSep) {
        StringBuffer buffer = new StringBuffer();
        String timeStr = rumBeacon.getTimeStr();
        String finalDate = HYPHEN;
        try {
            Date firstDate = mySDF.parse(timeStr);
            finalDate = finalFormat.format(firstDate);
        }
        catch (Exception e) {
            logger.error("[{}][{}] Exception while Parsing Date in JS Error DD for Time String {} ", new Object[]{reportingName, String.valueOf(this.entity) + "_DD", timeStr});
        }
        buffer.append(finalDate).append(fieldSep);
        Date local_date = new Date(this.dateInfo.egetUTCDate());
        TimeZone timezone = EgDateInfo.getRealTimeZone();
        String timeZoneIDShort = timezone.getDisplayName(timezone.inDaylightTime(local_date), 0);
        buffer.append(timeZoneIDShort).append(fieldSep);
        buffer.append(rumBeacon.getErrgd()).append(fieldSep);
        buffer.append(rumBeacon.getRpgd()).append(fieldSep);
        buffer.append(rumBeacon.getRbgd()).append(fieldSep);
        buffer.append(errMessage).append(fieldSep);
        buffer.append(errFileName).append(fieldSep);
        buffer.append(rumBeacon.getErrln()).append(fieldSep);
        buffer.append(rumBeacon.getErrcol()).append(fieldSep);
        buffer.append(rumBeacon.getErrstack()).append(fieldSep);
        buffer.append(errMetaData).append(fieldSep);
        return buffer;
    }

    private String getMaskedIP(String cliectOrGatewayIP, String ipMaskChar) {
        boolean isPublicOrPrivateIP;
        if (cliectOrGatewayIP != null && ((isPublicOrPrivateIP = IPAddressUtils.isValidPublicIp((String)cliectOrGatewayIP, (boolean)false)) && this.publicIPMaskFlag || !isPublicOrPrivateIP && this.privateIPMaskFlag)) {
            cliectOrGatewayIP = IPAddressMaskHelper.maskIPAddress(cliectOrGatewayIP, !isPublicOrPrivateIP, isPublicOrPrivateIP, ipMaskChar);
        }
        return cliectOrGatewayIP;
    }

    private boolean checkIsIpLocalhost(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        return ipAddress.equalsIgnoreCase("localhost") || ipAddress.startsWith("127.") || ipAddress.equals("0:0:0:0:0:0:0:1") || ipAddress.equals(HYPHEN);
    }

    public RUMBeacon convertToRumBeacon(JsonNode rumBeaconJson) {
        RUMBeacon rumBeacon = null;
        try {
            rumBeacon = (RUMBeacon)objectMapper.convertValue((Object)rumBeaconJson, RUMBeacon.class);
        }
        catch (Exception e) {
            logger.error("[{}][{}] JsonNode conversion failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e.getMessage()});
            logger.trace("[{}][{}] JsonNode conversion failed for serviceName {} :{}", new Object[]{this.reportingName, this.entity, this.serviceName, e});
        }
        return rumBeacon;
    }

    private String geoXmlFileName(String serviceName) {
        IniFile geoXMLDetails = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_geomapxml.ini");
        String networkMappingToComponent = geoXMLDetails.getValue("NetworkMappingToComponents", serviceName);
        String geoXMLFileName = null;
        if (networkMappingToComponent != null && (geoXMLFileName = geoXMLDetails.getValue("XMLs", networkMappingToComponent = networkMappingToComponent.trim())) != null && geoXMLFileName.contains(",")) {
            geoXMLFileName = geoXMLFileName.substring(0, geoXMLFileName.indexOf(","));
        }
        return geoXMLFileName;
    }

    private boolean checkLastModifiedTime(String geoXmlFileName, String serviceName) {
        File geoXMLDir = new File(GeoXMLFileDir);
        File[] geoXMLFileList = geoXMLDir.listFiles();
        int i = 0;
        while (i < geoXMLFileList.length) {
            String fileName = geoXMLFileList[i].getName();
            if (geoXmlFileName != null && fileName.equalsIgnoreCase(geoXmlFileName)) {
                File file = new File(String.valueOf(GeoXMLFileDir) + File.separator + fileName);
                long lastModifiedTime = file.lastModified();
                if (geoXmlFileLastModifedTime != null && geoXmlFileLastModifedTime.containsKey(serviceName)) {
                    long lastModifiedTimeInMap = geoXmlFileLastModifedTime.get(serviceName);
                    if (lastModifiedTime - lastModifiedTimeInMap > 0L) {
                        geoXmlFileLastModifedTime.put(serviceName, lastModifiedTime);
                        return true;
                    }
                } else {
                    geoXmlFileLastModifedTime.put(serviceName, lastModifiedTime);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

