/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class EgSolaceLogCredential {
    String hostIP = "";
    String username = "";
    String password = "";
    String messagevpn = "";
    String solaceStr = EgInstallInfo.getInstallDir() + "/agent/config/eg_agentSolace.ini";
    File solaceFile = null;
    IniFile solaceIni = null;
    Vector userVars = new Vector();
    Vector userVals = new Vector();

    EgSolaceLogCredential() {
        this.iniFileCheck();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void iniFileCheck() {
        try {
            if (this.solaceFile != null && this.solaceFile.exists()) return;
            String string = "SOLACE_USER_CREDENTIALS";
            this.solaceFile = new File(this.solaceStr);
            this.solaceIni = new IniFile(this.solaceStr, true);
            Vector vector = this.solaceIni.getLines();
            if (vector != null && vector.size() > 0) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.println("");
                System.out.print("The following credentials are already configured!!!");
                System.out.println("");
                System.out.print("*************************************************\n");
                System.out.println(vector.get(1));
                System.out.println(vector.get(2));
                System.out.println(vector.get(3));
                System.out.println(vector.get(4));
                System.out.print("*************************************************\n");
                System.out.print("Do you want to change this (y/n) :");
                String string2 = bufferedReader.readLine();
                if (!string2.trim().toLowerCase().equals("y")) return;
                this.collectInputs();
                System.out.println("\n");
                System.out.println("Credentails are updated successfully... Please recreate the solace service to reflect this change!!!");
                return;
            } else {
                this.userVars.add("HostIP");
                this.userVars.add("Username");
                this.userVars.add("Password");
                this.userVars.add("Message_VPN");
                this.userVals.add("");
                this.userVals.add("");
                this.userVals.add("");
                this.userVals.add("");
                this.solaceIni.addSubject(string, this.userVars, this.userVals);
                this.collectInputs();
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void collectInputs() {
        try {
            System.out.print("Please enter Host IP :");
            this.hostIP = EgSolaceLogCredential.getInput(System.in);
            System.out.print("Please enter Message VPN :");
            this.messagevpn = EgSolaceLogCredential.getInput(System.in);
            System.out.print("Please enter Username :");
            this.username = EgSolaceLogCredential.getInput(System.in);
            System.out.print("Please enter Password :");
            this.password = EgSolaceLogCredential.getPassword();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.saveInifile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInifile() {
        try {
            this.solaceIni.setValue("SOLACE_USER_CREDENTIALS", "HostIP", this.hostIP);
            this.solaceIni.setValue("SOLACE_USER_CREDENTIALS", "Username", this.username);
            this.solaceIni.setValue("SOLACE_USER_CREDENTIALS", "Password", this.password);
            this.solaceIni.setValue("SOLACE_USER_CREDENTIALS", "Message_VPN", this.messagevpn);
            String string = this.solaceIni.getValue("SOLACE_LOG_FILE", "Size_In_MB");
            if (string == null || string.trim().length() == 0) {
                this.solaceIni.setValue("SOLACE_LOG_FILE", "Size_In_MB", "1024");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.solaceIni.saveFile();
        }
    }

    private static String getInput(InputStream inputStream) {
        String string = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println("Error trying to read your name!");
            System.exit(1);
        }
        return string;
    }

    private static String getPassword() {
        String string = "";
        ConsoleEraser consoleEraser = new ConsoleEraser();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        consoleEraser.start();
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println("Error trying to read your password!");
            System.exit(1);
        }
        consoleEraser.halt();
        System.out.print("\b");
        return string;
    }

    public static void main(String[] stringArray) {
        new EgSolaceLogCredential();
    }

    private static class ConsoleEraser
    extends Thread {
        private boolean running = true;

        private ConsoleEraser() {
        }

        public void run() {
            while (this.running) {
                System.out.print("\b*");
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }

        public synchronized void halt() {
            this.running = false;
        }
    }
}

