/*
 * Decompiled with CFR 0.152.
 */
import com.eg.ConnectionThread;
import com.eg.EgSSL;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class HadoopBase
extends GenericTest {
    protected String nameNodePortNo = "";
    protected String nameNodeWebPortNo = "";
    protected String resourceMgrIp = "";
    protected String resourceMgrWebPortNo = "";
    protected String userNameRM = "";
    protected String userNameNN = "";
    protected boolean isSSL = false;
    private static final Object sync = new Object();
    private long lastTime = 0L;
    private static Hashtable lastTimeHash = new Hashtable();
    public static Hashtable hadoopMetricHash = new Hashtable();
    private boolean ssl_enabled = false;
    protected String baseURL = "";
    protected String logMessage = null;
    protected static final String RETURNING_INFO_MESSAGE = ",So test returning";
    private static final String COULD_NOT_PROCEED_FURTHER_INFO_MESSAGE = ",Could not proceed further ,So test returning";
    protected static final String RESPONSE_ERROR_MESSAGE = "Response for method is null or empty ,Could not proceed further ,So test returning";
    protected static final String OUTPUT_PARSING_EXCEPTION_MESSAGE = "Exception happened while  parsing the outputs :";
    protected static final String METHOD_GET = "GET";
    protected static final String AUTHORIZATION_KEY = "user.name";
    protected static final String CONTENT_TYPE_KEY = "Content-Type";
    protected static final String CONTENT_TYPE_VALUE = "application/json";
    protected static final String CACHE_CONTROL_KEY = "Cache-Control";
    protected static final String CACHE_CONTROL_VALUE = "no-cache";
    protected static final double BYTES_TO_MB = 1048576.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double GB_TO_TB = 1024.0;
    protected static final int SEC_TO_MINS = 60;
    protected static final double MILLISEC_TO_SEC = 1000.0;
    protected static final double MILLISEC_TO_MINS = 60000.0;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    protected static final double DEFAULT_MINUS_ONE = -1.0;
    protected static final String EG_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss";
    protected static final SimpleDateFormat EG_SDF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private Hashtable metricDetHash = new Hashtable();
    private Hashtable jobHistServAddrHash = new Hashtable();
    private static HashMap syncHash = new HashMap();

    public HadoopBase(String[] stringArray) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        this.nameNodeWebPortNo = this.getValueForParam("Name_node_web_port");
        this.userNameNN = this.getValueForParam("Name_node_username");
        this.resourceMgrIp = this.getValueForParam("Resource_manager_ip");
        this.resourceMgrWebPortNo = this.getValueForParam("Resource_manager_web_port");
        this.userNameRM = this.getValueForParam("Resource_manager_username");
        String string2 = this.getValueForParam("ssl");
        if (this.nameNodeWebPortNo == null || this.nameNodeWebPortNo.equalsIgnoreCase("NULL") || this.nameNodeWebPortNo.equalsIgnoreCase("none")) {
            this.nameNodeWebPortNo = "50070";
        }
        if (this.userNameNN == null || this.userNameNN.equalsIgnoreCase("NULL") || this.nameNodePortNo.equalsIgnoreCase("none")) {
            this.userNameNN = "";
        }
        if (this.resourceMgrIp == null || this.resourceMgrIp.equalsIgnoreCase("NULL") || this.resourceMgrIp.equalsIgnoreCase("none")) {
            this.resourceMgrIp = "";
        }
        if (this.resourceMgrWebPortNo == null || this.resourceMgrWebPortNo.equalsIgnoreCase("NULL") || this.resourceMgrWebPortNo.equalsIgnoreCase("none")) {
            this.resourceMgrWebPortNo = "8088";
        }
        if (this.userNameRM == null || this.userNameRM.equalsIgnoreCase("NULL") || this.userNameRM.equalsIgnoreCase("none")) {
            this.userNameRM = "";
        }
        if (string2 != null && (string2.trim().equalsIgnoreCase("true") || string2.trim().equalsIgnoreCase("y") || string2.trim().equalsIgnoreCase("yes"))) {
            this.isSSL = true;
        }
        this.printOut(string + " targetHost : " + this.targetHost + " portNo : " + this.portNo);
        this.printOut(string + " Name node web port : " + this.nameNodeWebPortNo + " Name node user name : " + this.userNameNN);
        this.printOut(string + " Resource manager IP : " + this.resourceMgrIp + " Resource manager web port no: : " + this.resourceMgrWebPortNo + " Resource manager user name : " + this.userNameRM);
        this.setLastExectionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectHadoopMetrics() {
        Object object;
        String string = this.reportingName + ":" + this.portNo;
        String string2 = "";
        string2 = (String)syncHash.get(string);
        if (string2 == null) {
            object = sync;
            synchronized (object) {
                string2 = (String)syncHash.get(string);
                if (string2 == null) {
                    string2 = new String(string);
                    syncHash.put(string, string);
                }
            }
        }
        object = string2;
        synchronized (object) {
            this.getLastExectionTime();
            long l = System.currentTimeMillis();
            long l2 = l - this.lastTime;
            long l3 = (long)(0.9 * (double)this.measurePeriod);
            boolean bl = false;
            if (l2 >= l3) {
                bl = true;
                this.lastTime = l;
                this.setLastExectionTime();
            } else {
                bl = false;
            }
            if (bl) {
                this.clearObjects();
                this.executeAndCollectMetrics();
                this.lastTime = System.currentTimeMillis();
                this.setLastExectionTime();
            }
        }
    }

    private void executeAndCollectMetrics() {
        try {
            this.collectHistServData();
            hadoopMetricHash.put(this.reportingName, this.metricDetHash);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void collectHistServData() {
        String string = "[collectHistServData] : ";
        String string2 = "";
        String string3 = "";
        if (this.jobHistServAddrHash == null || this.jobHistServAddrHash.size() == 0) {
            string3 = this.getJSONDataFromURL("conf", this.targetHost, this.nameNodeWebPortNo, this.userNameNN);
            System.out.println("responseString::" + string3);
            if (string3 == null || string3.trim().length() == 0) {
                this.logMessage = string + RESPONSE_ERROR_MESSAGE;
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return;
            }
            string2 = this.getJobHistServAddr(string3);
            this.jobHistServAddrHash.put(this.reportingName, string2);
            this.metricDetHash.put("JobHistServAddress", string2);
        } else if (this.jobHistServAddrHash.containsKey(this.reportingName)) {
            string2 = (String)this.jobHistServAddrHash.get(this.reportingName);
            this.metricDetHash.put("JobHistServAddress", string2);
        } else {
            string3 = this.getJSONDataFromURL("conf", this.targetHost, this.nameNodeWebPortNo, this.userNameNN);
            System.out.println("responseString::" + string3);
            if (string3 == null || string3.trim().length() == 0) {
                this.logMessage = string + RESPONSE_ERROR_MESSAGE;
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return;
            }
            string2 = this.getJobHistServAddr(string3);
            this.jobHistServAddrHash.put(this.reportingName, string2);
            this.metricDetHash.put("JobHistServAddress", string2);
        }
        System.out.println(this.entity + " histServAddress::" + string2);
        ArrayList arrayList = new ArrayList();
        if (string2 == null || string2.length() == 0) {
            this.metricDetHash.put("JobHistServerResponse", "");
        } else {
            String string4 = this.getJSONDataFromURL("ws/v1/history/mapreduce/jobs", string2, this.userNameNN);
            System.out.println(this.entity + " histServRespString::" + string4);
            if (string4 == null || string4.trim().length() == 0) {
                this.logMessage = string + RESPONSE_ERROR_MESSAGE;
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
            } else {
                this.metricDetHash.put("JobHistServerResponse", string4);
            }
        }
    }

    private String getJobHistServAddr(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String string2 = "[getJobHistServAddr] : ";
        String string3 = "";
        try {
            this.printOut(string2 + " jsonString :" + string);
            if (this.isSSL) {
                if (string.indexOf("mapreduce.jobhistory.webapp.https.address") > -1) {
                    int n = string.indexOf("mapreduce.jobhistory.webapp.https.address");
                    String string4 = string.substring(n);
                    string4 = string4.substring(0, string4.indexOf("</value>") + 8);
                    this.printOut(string2 + " job :" + string4);
                    string3 = string4.substring(string4.indexOf("<value>") + 7, string4.indexOf("</value>"));
                    this.printOut(string2 + " histServAddres :" + string3);
                    String string5 = string3.substring(0, string3.indexOf(":"));
                    this.printOut(string2 + " ip :" + string5);
                    if (string5.equalsIgnoreCase("0.0.0.0")) {
                        String string6 = string3.substring(string3.indexOf(":") + 1, string3.length());
                        string3 = this.targetHost + ":" + string6;
                    }
                }
            } else if (string.indexOf("mapreduce.jobhistory.webapp.address") > -1) {
                int n = string.indexOf("mapreduce.jobhistory.webapp.address");
                String string7 = string.substring(n);
                string7 = string7.substring(0, string7.indexOf("</value>") + 8);
                this.printOut(string2 + " job :" + string7);
                string3 = string7.substring(string7.indexOf("<value>") + 7, string7.indexOf("</value>"));
                this.printOut(string2 + " histServAddres :" + string3);
                String string8 = string3.substring(0, string3.indexOf(":"));
                this.printOut(string2 + " ip :" + string8);
                if (string8.equalsIgnoreCase("0.0.0.0")) {
                    String string9 = string3.substring(string3.indexOf(":") + 1, string3.length());
                    string3 = this.targetHost + ":" + string9;
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + OUTPUT_PARSING_EXCEPTION_MESSAGE;
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string2 + "  histServAddres :" + string3);
        return string3;
    }

    public String getJSONDataFromURL(String string, String string2, String string3, String string4) {
        HttpURLConnection httpURLConnection = null;
        String string5 = null;
        String string6 = "[getJSONDataFromURL] :";
        this.baseURL = this.isSSL ? "https://" + string2 + ":" + string3 : "http://" + string2 + ":" + string3;
        this.enableSSLForHadoopRESTAPI();
        URL uRL = null;
        try {
            uRL = new URL(null, this.baseURL + "/" + string);
            this.printOut(string6 + " Endpoint URL  :" + uRL);
        }
        catch (MalformedURLException malformedURLException) {
            this.logMessage = string6 + " MalformedURLException ";
            this.printOutStackTrace(this.logMessage, malformedURLException);
            this.logMessage = "";
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            this.logMessage = string6 + " HttpURLConnection  error ";
            this.printOutStackTrace(this.logMessage, iOException);
            this.logMessage = "";
            iOException.printStackTrace();
            return null;
        }
        try {
            httpURLConnection.setRequestMethod(METHOD_GET);
        }
        catch (ProtocolException protocolException) {
            this.logMessage = string6 + " Your HTTP connection does not support  setRequestMethod ";
            this.printOutStackTrace(this.logMessage, protocolException);
            this.logMessage = "";
            protocolException.printStackTrace();
            return null;
        }
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.addRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
        if (!string4.equalsIgnoreCase("none")) {
            httpURLConnection.setRequestProperty(AUTHORIZATION_KEY, string4);
        }
        httpURLConnection.setRequestProperty(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
        ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
        int n = 0;
        boolean bl = this.checkForTimeout(connectionThread);
        if (bl) {
            n = connectionThread.code;
            StringBuilder stringBuilder = new StringBuilder();
            if (n != 200) {
                this.logMessage = string6 + " Error in REST URL connection " + uRL + " and Response code :" + n;
                this.putErrorMessageToLogfile(this.logMessage);
                this.printOut(this.logMessage);
                this.logMessage = "";
            }
            ArrayList arrayList = connectionThread.data;
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuilder.append((String)arrayList.get(i));
            }
            string5 = stringBuilder.toString();
        }
        if (!bl || n != 200) {
            this.logMessage = string6 + " Timing out or invalid response code:" + n;
            this.putWarningMessageToLogfile(this.logMessage);
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        httpURLConnection.disconnect();
        return string5;
    }

    public String getJSONDataFromURL(String string, String string2, String string3) {
        HttpURLConnection httpURLConnection = null;
        String string4 = null;
        String string5 = "[getJSONDataFromURL] :";
        this.baseURL = this.isSSL ? "https://" + string2 : "http://" + string2;
        this.enableSSLForHadoopRESTAPI();
        URL uRL = null;
        try {
            uRL = new URL(null, this.baseURL + "/" + string);
            this.printOut(string5 + " Endpoint URL  :" + uRL);
        }
        catch (MalformedURLException malformedURLException) {
            this.logMessage = string5 + " MalformedURLException ";
            this.printOutStackTrace(this.logMessage, malformedURLException);
            this.logMessage = "";
            malformedURLException.printStackTrace();
            return null;
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            this.printOut(string5 + " Connection opened  ");
        }
        catch (IOException iOException) {
            this.logMessage = string5 + " HttpURLConnection  error ";
            this.printOutStackTrace(this.logMessage, iOException);
            this.logMessage = "";
            iOException.printStackTrace();
            return null;
        }
        try {
            httpURLConnection.setRequestMethod(METHOD_GET);
        }
        catch (ProtocolException protocolException) {
            this.logMessage = string5 + " Your HTTP connection does not support  setRequestMethod ";
            this.printOutStackTrace(this.logMessage, protocolException);
            this.logMessage = "";
            protocolException.printStackTrace();
            return null;
        }
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.addRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
        if (!string3.equalsIgnoreCase("none")) {
            httpURLConnection.setRequestProperty(AUTHORIZATION_KEY, string3);
        }
        httpURLConnection.setRequestProperty(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
        ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
        int n = 0;
        boolean bl = this.checkForTimeout(connectionThread);
        if (bl) {
            n = connectionThread.code;
            StringBuilder stringBuilder = new StringBuilder();
            if (n != 200) {
                this.logMessage = string5 + " Error in REST URL connection " + uRL + " and Response code :" + n;
                this.putErrorMessageToLogfile(this.logMessage);
                this.printOut(this.logMessage);
                this.logMessage = "";
            }
            ArrayList arrayList = connectionThread.data;
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuilder.append((String)arrayList.get(i));
            }
            string4 = stringBuilder.toString();
        }
        if (!bl || n != 200) {
            this.logMessage = string5 + " Timing out or invalid response code:" + n;
            this.putWarningMessageToLogfile(this.logMessage);
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        httpURLConnection.disconnect();
        return string4;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = "-";
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut(string3 + "jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get((Object)string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase("null") || string4.equalsIgnoreCase("none") ? "-" : string4.trim();
        }
        catch (Exception exception) {
            string2 = "-";
            this.logMessage = string3 + " [Error] Object " + string + " not found assing default values";
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
        }
        this.printOut(string3 + " value :" + string2);
        return string2;
    }

    protected JSONObject getJSONObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = null;
        String string2 = "[getJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut("jsonObject is  null or empty for the parameter :" + string);
                return jSONObject2;
            }
            jSONObject2 = (JSONObject)jSONObject.get((Object)string);
        }
        catch (Exception exception) {
            this.logMessage = string2 + " [Error] Object " + string + " not found return null value JSONObject";
            this.printOut(this.logMessage);
            this.putErrorMessageToLogfile(this.logMessage);
            this.logMessage = "";
        }
        return jSONObject2;
    }

    void enableSSLForHadoopRESTAPI() {
        if (this.isSSL && !this.ssl_enabled) {
            String string = null;
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var4_4 = null;
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = null;
            try {
                sSLContext = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string = "[enableSSLForHadoopRESTAPI]";
                this.printOutStackTrace(string, noSuchAlgorithmException);
            }
            try {
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            }
            catch (KeyManagementException keyManagementException) {
                string = "[enableSSLForHadoopRESTAPI]";
                this.printOutStackTrace(string, keyManagementException);
            }
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            this.ssl_enabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getData() {
        Object object = sync;
        synchronized (object) {
            return (Hashtable)hadoopMetricHash.get(this.reportingName);
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private void clearObjects() {
        if (this.metricDetHash != null) {
            this.metricDetHash.clear();
        }
    }

    private void setLastExectionTime() {
        lastTimeHash.put(this.reportingName, new Long(this.lastTime));
    }

    private void getLastExectionTime() {
        Long l = (Long)lastTimeHash.get(this.reportingName);
        this.lastTime = l;
    }

    protected Hashtable getNameNodeData(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "[getNameNodeData] : ";
        String string3 = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"beans");
            this.printOut(string2 + " jsonArray :" + jSONArray + " Size of Array :" + jSONArray.size());
            JSONObject jSONObject2 = null;
            String string4 = "";
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject2 = (JSONObject)jSONArray.get(i);
                string3 = this.getValueFromJSONObject(jSONObject2, "name");
                this.printOut(string2 + " name :" + string3);
                if (!string3.equalsIgnoreCase("Hadoop:service=NameNode,name=NameNodeInfo")) continue;
                string4 = this.getValueFromJSONObject(jSONObject2, "LiveNodes");
                string4 = string4.trim();
                this.printOut(string2 + " liveDataNodes :" + string4);
                JSONObject jSONObject3 = null;
                jSONObject3 = (JSONObject)jSONParser.parse(string4);
                Set set = jSONObject3.keySet();
                this.printOut(string2 + " KEY::" + set);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string5;
                    String string6 = (String)iterator.next();
                    JSONObject jSONObject4 = (JSONObject)jSONObject3.get((Object)string6);
                    if (this.isSSL) {
                        string5 = this.getValueFromJSONObject(jSONObject4, "infoSecureAddr");
                        this.printOut(string2 + " infoSecureAddr::" + string5);
                        hashtable.put(string6, string5);
                        continue;
                    }
                    string5 = this.getValueFromJSONObject(jSONObject4, "infoAddr");
                    this.printOut(string2 + " infoAddr::" + string5);
                    hashtable.put(string6, string5);
                }
                break;
            }
            this.printOut(string2 + " outDataHash :" + hashtable);
        }
        catch (Exception exception) {
            this.logMessage = string2 + OUTPUT_PARSING_EXCEPTION_MESSAGE;
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string2 + "  Output Hashtable :" + hashtable);
        return hashtable;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + EG_SDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + EG_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ ERROR ] : >> " + string);
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + EG_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ INFO ] : >> " + string);
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + EG_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ WARNING ] : >> " + string);
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    protected double getDoubleValue(String string) {
        double d = -5.0;
        if (!string.equalsIgnoreCase("-")) {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return d;
    }

    protected long getLongValue(String string) {
        long l = -5L;
        if (!string.equalsIgnoreCase("-")) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return l;
    }

    protected double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (d2 >= 0.0 && d >= d2 && (d3 = d - d2) < 0.0) {
            d3 = -5.0;
        }
        return d3;
    }

    protected String getValue(String string) {
        string = string == null || string.trim().length() == 0 ? "-" : string.trim();
        return string;
    }

    public static void main(String[] stringArray) {
    }
}

