/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class HanaHostCpuTest
extends GenericTest {
    private static final int HOST_CPU_MEASURE_COUNT = 5;
    private String userName = "";
    private String password = "";
    public Hashtable prevhash = new Hashtable();
    private static final String dateFormat = "yyyy/MM/dd hh:mm:ss.SSS";
    private boolean checkCpuCount = true;
    private int cpuCount = 1;
    private String hostNameToFilter = "";
    private boolean checkHostName = true;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private boolean isTenantDB = false;
    private int msgLogCounter = 0;

    public HanaHostCpuTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.needAgentlessDD = true;
        this.userName = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.dfs.setDecimalSeparator('.');
        this.df.applyPattern("#.##");
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block35: {
            Statement statement;
            ResultSet resultSet;
            Connection connection;
            block34: {
                Object object;
                Hashtable<String, Object> hashtable2;
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                String string6;
                String string7;
                block33: {
                    Serializable serializable;
                    connection = null;
                    resultSet = null;
                    statement = null;
                    if (this.checkHostName) {
                        ConnectionManager.collectHanaHostDetails(this.reportingName, this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                        serializable = ConnectionManager.getHanaDbDetails(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
                        if (serializable != null && ((ArrayList)serializable).size() > 0) {
                            this.hostNameToFilter = (String)((ArrayList)serializable).get(0);
                            string7 = (String)((ArrayList)serializable).get(1);
                            if (string7 != null && string7.trim().length() > 0 && string7.trim().equalsIgnoreCase("true")) {
                                this.isTenantDB = true;
                            }
                            this.hostNameToFilter = this.hostNameToFilter.toLowerCase().trim();
                            this.checkHostName = false;
                        } else {
                            this.logToErrorFile("INFO :", this.entity, "Failed to find the Hana Host details for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                            return;
                        }
                    }
                    System.out.println(this.entity + " ::hostNameToFilter==>" + this.hostNameToFilter + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    System.out.println(this.entity + " ::isTenantDB==>" + this.isTenantDB + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    if (this.isTenantDB) {
                        this.isNewDynamicInfoTest = true;
                        if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                            this.logToErrorFile("INFO", this.entity + " doesnot run for TENANT database : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                            this.msgLogCounter = 0;
                        }
                        ++this.msgLogCounter;
                        return;
                    }
                    if (this.checkCpuCount) {
                        boolean bl = false;
                        bl = this.getCpuCount();
                        if (!bl) {
                            this.logToErrorFile("INFO :", this.entity, "Failed to find the CPU count for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                            return;
                        }
                        System.out.println(this.entity + " cpuCount::" + this.cpuCount);
                        this.checkCpuCount = false;
                    }
                    serializable = new StringBuffer();
                    ((StringBuffer)serializable).append("select host, total_cpu_system_time, total_cpu_user_time,  total_cpu_wio_time,");
                    ((StringBuffer)serializable).append(" total_cpu_idle_time  ,to_char(current_timestamp,'YYYY/MM/DD HH24:MI:SS.FF3')    now_system_time from m_host_resource_utilization where lower(host)='" + this.hostNameToFilter + "'");
                    string7 = ((StringBuffer)serializable).toString();
                    System.out.println(this.entity + "==>Query:" + string7 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    string6 = "";
                    d6 = 0.0;
                    d5 = 0.0;
                    d4 = 0.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                    string5 = "";
                    string4 = "";
                    string3 = "";
                    string2 = "";
                    string = "";
                    hashtable2 = new Hashtable<String, Object>();
                    connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                    if (connection != null) break block33;
                    this.logToErrorFile("ERROR :", this.entity, "Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    try {
                        this.closeRs(resultSet);
                        this.closeSt(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return;
                }
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                    this.closeSt(statement);
                    this.closeConn(connection);
                    exception.printStackTrace();
                    try {
                        this.closeRs(resultSet);
                        this.closeSt(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    return;
                }
                resultSet = statement.executeQuery(string7);
                while (resultSet.next()) {
                    string6 = resultSet.getString(1);
                    string5 = resultSet.getString(2);
                    d5 = this.getDoubleValue(string5);
                    string4 = resultSet.getString(3);
                    d4 = this.getDoubleValue(string4);
                    string3 = resultSet.getString(4);
                    d3 = this.getDoubleValue(string3);
                    string2 = resultSet.getString(5);
                    d2 = this.getDoubleValue(string2);
                    string = resultSet.getString(6);
                    string = this.checkStringValue(string);
                    d = this.timeInMillis(string);
                    object = new ArrayList();
                    d6 = d5 + d4 + d3;
                    ((ArrayList)object).add(new Double(d6));
                    ((ArrayList)object).add(new Double(d5));
                    ((ArrayList)object).add(new Double(d4));
                    ((ArrayList)object).add(new Double(d3));
                    ((ArrayList)object).add(new Double(d2));
                    ((ArrayList)object).add(new Double(d));
                    hashtable2.put(string6, object);
                }
                if (hashtable2 == null) break block34;
                object = hashtable2.keys();
                while (object.hasMoreElements()) {
                    ArrayList arrayList;
                    String string8 = (String)object.nextElement();
                    if (this.prevhash != null && this.prevhash.size() > 0) {
                        arrayList = (ArrayList)this.prevhash.get(string8);
                        ArrayList arrayList2 = (ArrayList)hashtable2.get(string8);
                        if (arrayList == null || arrayList2 == null) continue;
                        double d7 = (Double)arrayList2.get(0);
                        double d8 = (Double)arrayList2.get(1);
                        double d9 = (Double)arrayList2.get(2);
                        double d10 = (Double)arrayList2.get(3);
                        double d11 = (Double)arrayList2.get(4);
                        double d12 = (Double)arrayList2.get(5);
                        double d13 = (Double)arrayList.get(0);
                        double d14 = (Double)arrayList.get(1);
                        double d15 = (Double)arrayList.get(2);
                        double d16 = (Double)arrayList.get(3);
                        double d17 = (Double)arrayList.get(4);
                        double d18 = (Double)arrayList.get(5);
                        double d19 = d7 - d13;
                        double d20 = d8 - d14;
                        double d21 = d9 - d15;
                        double d22 = d10 - d16;
                        double d23 = d11 - d17;
                        double d24 = d12 - d18;
                        double d25 = d19 / d24 * 100.0;
                        d25 = this.roundDouble(d25);
                        d25 /= (double)this.cpuCount;
                        double d26 = d20 / d24 * 100.0;
                        d26 = this.roundDouble(d26);
                        d26 /= (double)this.cpuCount;
                        double d27 = d21 / d24 * 100.0;
                        d27 = this.roundDouble(d27);
                        d27 /= (double)this.cpuCount;
                        double d28 = d22 / d24 * 100.0;
                        d28 = this.roundDouble(d28);
                        d28 /= (double)this.cpuCount;
                        double d29 = d23 / d24 * 100.0;
                        d29 = this.roundDouble(d29);
                        d29 /= (double)this.cpuCount;
                        System.out.println("[" + this.entity + "]Diff Total CPU  Time======>" + d19);
                        System.out.println("[" + this.entity + "]Diff Total CPU System Time======>" + d20);
                        System.out.println("[" + this.entity + "]Diff CPU User Time======>" + d21);
                        System.out.println("[" + this.entity + "]Diff Total CPU Wait IO Time======>" + d22);
                        System.out.println("[" + this.entity + "]Diff Total CPU Idle Time======>" + d23);
                        System.out.println("[" + this.entity + "]Diff Total System Time ======>" + d24);
                        System.out.println("[" + this.entity + "]Total CPU   Percent======>" + d25);
                        System.out.println("[" + this.entity + "]Total CPU System   Percent======>" + d26);
                        System.out.println("[" + this.entity + "]CPU User  Percent======>" + d27);
                        System.out.println("[" + this.entity + "]Total CPU Wait IO   Percent======>" + d28);
                        System.out.println("[" + this.entity + "]Total CPU Idle  Percent======>" + d29);
                        d25 = this.checkExceedsCentum(d25);
                        d26 = this.checkExceedsCentum(d26);
                        d27 = this.checkExceedsCentum(d27);
                        d28 = this.checkExceedsCentum(d28);
                        d29 = this.checkExceedsCentum(d29);
                        ArrayList<Double> arrayList3 = new ArrayList<Double>();
                        arrayList3.add(new Double(d25));
                        arrayList3.add(new Double(d26));
                        arrayList3.add(new Double(d27));
                        arrayList3.add(new Double(d28));
                        arrayList3.add(new Double(d29));
                        System.out.println("[" + this.entity + "] key1====>" + string8 + " value1===>" + arrayList3);
                        this.addNewMeasure(arrayList3);
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    arrayList.add(new Double(-5.0));
                    System.out.println("[" + this.entity + "]NotAvaliablevalue key==>" + string8 + " value===>" + arrayList);
                    this.addNewMeasure(arrayList);
                }
                this.prevhash = (Hashtable)hashtable2.clone();
                System.out.println("[" + this.entity + "]previoushash======>" + this.prevhash);
            }
            try {
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block35;
            catch (SQLException sQLException) {
                this.logToErrorFile("ERROR :", this.entity + " SQL Error in computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, sQLException.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + sQLException.toString());
                sQLException.printStackTrace();
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block35;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", this.entity + " computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + exception.toString());
                exception.printStackTrace();
                {
                    catch (Throwable throwable) {
                        try {
                            this.closeRs(resultSet);
                            this.closeSt(statement);
                            this.closeConn(connection);
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    private String checkStringValue(String string) {
        String string2 = "";
        string2 = string == null || string.length() == 0 || string.equalsIgnoreCase("none") ? "-".toString() : string;
        return string2;
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
            d = 0.0;
        } else {
            try {
                string = string.trim();
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = 0.0;
            }
        }
        return d;
    }

    private double timeInMillis(String string) {
        Date date = null;
        long l = 0L;
        string = string.substring(0, dateFormat.length());
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            this.logToErrorFile("ERROR  :", this.entity, parseException.toString());
        }
        l = date.getTime();
        if (debug) {
            System.out.println("Current Time  " + string);
            System.out.println("Current  Time in Millis   " + l);
        }
        return l;
    }

    private double roundDouble(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        String string = this.df.format(bigDecimal);
        return Double.parseDouble(string);
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        HanaHostCpuTest hanaHostCpuTest = new HanaHostCpuTest(stringArray);
        try {
            while (true) {
                hanaHostCpuTest.computeMeasures(new Hashtable());
                Thread.sleep(30000L);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
    }

    public int getNoOfCPUs(String string, String string2, int n, String string3, String string4) {
        String string5 = string;
        String string6 = string2;
        int n2 = n;
        String string7 = string3;
        String string8 = string4;
        boolean bl = false;
        boolean bl2 = false;
        if (string5.equalsIgnoreCase("ssh")) {
            bl = true;
        } else if (string5.equalsIgnoreCase("rexec")) {
            bl2 = true;
        }
        int n3 = 1;
        String string9 = "";
        String string10 = "cat /proc/cpuinfo | grep processor | wc -l";
        ArrayList arrayList = null;
        try {
            if (bl) {
                if (EgMainAgent.bUseJavaSshForRemoteAgent) {
                    EgJavaSSH egJavaSSH = new EgJavaSSH(string6, n2, string7, string8, this.alencrypt, this.alkeyfile, EgMainAgent.TIME_OUT_JavaSsh);
                    ArrayList arrayList2 = egJavaSSH.executeCommand(string10);
                    if (arrayList2 != null && arrayList2.size() == 2) {
                        arrayList = (ArrayList)arrayList2.get(0);
                    }
                } else {
                    arrayList = EgSSHUtil.getExecResults(string6, n2, string7, string8, string10);
                }
            } else if (bl2) {
                arrayList = EgRexecUtil.getExecResults(string6, n2, string7, string8, string10);
            }
            int n4 = 0;
            if (arrayList != null) {
                n4 = arrayList.size();
            }
            if (n4 <= 0) {
                System.out.println("Problem while executing the command " + string10 + " for " + string6);
                this.logToErrorFile("ERROR  :", this.entity, "Problem while executing the command " + string10 + " for " + string6);
                arrayList = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem while executing the command " + string10 + " for " + string6);
            this.logToErrorFile("ERROR  :", this.entity, "Problem while executing the command " + string10 + " for " + string6);
            arrayList = null;
        }
        ArrayList arrayList3 = arrayList;
        System.out.println(this.entity + " getNoOfCPUs() outdata:" + arrayList3);
        if (arrayList3 == null) {
            return n3;
        }
        int n5 = arrayList3.size();
        if (debug) {
            System.out.println("Num of CPU's ArrayList Size  = " + n5 + "  Datas are  " + arrayList3);
        }
        if (n5 == 1) {
            string9 = (String)arrayList3.get(0);
            try {
                n3 = Integer.parseInt(string9);
                if (n3 < 1) {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                return n3;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getCpuCount() {
        String string;
        boolean bl;
        String string2;
        Statement statement;
        ResultSet resultSet;
        Connection connection;
        block11: {
            connection = null;
            resultSet = null;
            statement = null;
            string2 = "SELECT value FROM M_HOST_INFORMATION where lower(key)='cpu_cores' and lower(host)='" + this.hostNameToFilter + "'";
            System.out.println(this.entity + " cpuCountQuery::" + string2);
            bl = false;
            string = "";
            connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
            if (connection != null) break block11;
            this.logToErrorFile("ERROR :", this.entity, "Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            boolean bl2 = bl;
            this.closeRs(resultSet);
            this.closeSt(statement);
            this.closeConn(connection);
            return bl2;
        }
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
            this.closeSt(statement);
            this.closeConn(connection);
            exception.printStackTrace();
            boolean bl3 = bl;
            this.closeRs(resultSet);
            this.closeSt(statement);
            this.closeConn(connection);
            return bl3;
        }
        try {
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                string = resultSet.getString(1);
            }
            System.out.println(this.entity + " noOfCpu::" + string);
            try {
                this.cpuCount = Integer.parseInt(string);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closeRs(resultSet);
            this.closeSt(statement);
            this.closeConn(connection);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                this.logToErrorFile("ERROR :", this.entity + " getCpuCount() targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn(connection);
            }
            catch (Throwable throwable) {
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn(connection);
                throw throwable;
            }
        }
        return bl;
    }

    private double checkExceedsCentum(double d) {
        if (d > 0.0 && d > 100.0) {
            d = 100.0;
        }
        return d;
    }
}

