/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class HanaHostMemTest
extends GenericTest {
    private String userName = "";
    private String password = "";
    private String hostNameToFilter = "";
    private boolean checkHostName = true;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private boolean isTenantDB = false;
    private int msgLogCounter = 0;

    public HanaHostMemTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.needAgentlessDD = true;
        this.userName = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.dfs.setDecimalSeparator('.');
        this.df.applyPattern("#.##");
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block30: {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            String string8;
            Statement statement;
            Object object;
            Object object2;
            block29: {
                if (this.checkHostName) {
                    ConnectionManager.collectHanaHostDetails(this.reportingName, this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                    object2 = ConnectionManager.getHanaDbDetails(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
                    if (object2 != null && ((ArrayList)object2).size() > 0) {
                        this.hostNameToFilter = (String)((ArrayList)object2).get(0);
                        object = (String)((ArrayList)object2).get(1);
                        if (object != null && ((String)object).trim().length() > 0 && ((String)object).trim().equalsIgnoreCase("true")) {
                            this.isTenantDB = true;
                        }
                        this.hostNameToFilter = this.hostNameToFilter.toLowerCase().trim();
                        this.checkHostName = false;
                    } else {
                        this.logToErrorFile("INFO :", this.entity, "Failed to find the Hana Host details for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                        return;
                    }
                }
                System.out.println(this.entity + " ::hostNameToFilter==>" + this.hostNameToFilter + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                System.out.println(this.entity + " ::isTenantDB==>" + this.isTenantDB + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                if (this.isTenantDB) {
                    this.isNewDynamicInfoTest = true;
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", this.entity + " doesnot run for TENANT database : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                object2 = null;
                object = null;
                statement = null;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("select host, (used_physical_memory+free_physical_memory)/1024/1024 total_physical_memory_mb, free_physical_memory/1024/1024 free_physical_memory_mb, used_physical_memory/1024/1024 used_physical_memory_mb, ");
                stringBuffer.append("(used_swap_space+free_swap_space)/1024/1024  total_swap_space_mb, free_swap_space/1024/1024 free_swap_space_mb,");
                stringBuffer.append("used_swap_space/1024/1024 used_swap_space_mb from m_host_resource_utilization where lower(host)='" + this.hostNameToFilter + "'");
                string8 = stringBuffer.toString();
                System.out.println(this.entity + "==>Query:" + string8 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                d8 = 0.0;
                d7 = 0.0;
                d6 = 0.0;
                d5 = 0.0;
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
                string7 = "";
                string6 = "";
                string5 = "";
                string4 = "";
                string3 = "";
                string2 = "";
                string = "";
                object2 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                if (object2 != null) break block29;
                this.logToErrorFile("ERROR :", this.entity, "Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                statement = object2.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                this.closeSt(statement);
                this.closeConn((Connection)object2);
                exception.printStackTrace();
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
            object = statement.executeQuery(string8);
            while (object.next()) {
                string7 = object.getString(1);
                string6 = object.getString(2);
                string5 = object.getString(3);
                string4 = object.getString(4);
                string3 = object.getString(5);
                string2 = object.getString(6);
                string = object.getString(7);
                System.out.println(this.entity + " strHostName \t   :" + string7);
                System.out.println(this.entity + " strTotalPhyMem     :" + string6);
                System.out.println(this.entity + " strFreePhyMem  \t   :" + string5);
                System.out.println(this.entity + " strUsedPhyMem      :" + string4);
                System.out.println(this.entity + " strTotalSwapSpace  :" + string3);
                System.out.println(this.entity + " strFreeSwapSpace   :" + string2);
                System.out.println(this.entity + " strUsedSwapSpace   :" + string);
                d8 = this.getDoubleValue(string6);
                d7 = this.getDoubleValue(string5);
                d6 = this.getDoubleValue(string4);
                d5 = this.getDoubleValue(string3);
                d4 = this.getDoubleValue(string2);
                d3 = this.getDoubleValue(string);
                System.out.println(this.entity + " totalPhysicalMemory :" + d8);
                System.out.println(this.entity + " freePhysicalMemory  :" + d7);
                System.out.println(this.entity + " usedPhysicalMemory  :" + d6);
                System.out.println(this.entity + " totalSwapSpace      :" + d5);
                System.out.println(this.entity + " freeSwapSpace       :" + d4);
                System.out.println(this.entity + " usedSwapSpace       :" + d3);
                d8 = this.roundDouble(d8);
                d7 = this.roundDouble(d7);
                d6 = this.roundDouble(d6);
                d5 = this.roundDouble(d5);
                d4 = this.roundDouble(d4);
                d3 = this.roundDouble(d3);
                d2 = d8 > 0.0 && d8 > d7 ? d7 / d8 * 100.0 : -5.0;
                d2 = this.roundDouble(d2);
                d = d5 > 0.0 && d5 > d4 ? d4 / d5 * 100.0 : -5.0;
                d = this.roundDouble(d);
                System.out.println(this.entity + " freePhysicalMemoryPercent   " + d2);
                System.out.println(this.entity + " freeSwapSpacePercent        " + d);
            }
            this.closeRs((ResultSet)object);
            this.closeSt(statement);
            this.closeConn((Connection)object2);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d6));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d));
            System.out.println(this.entity + " measureArrayList :" + arrayList + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
            this.addNewMeasure(arrayList);
            try {
                this.closeRs((ResultSet)object);
                this.closeSt(statement);
                this.closeConn((Connection)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block30;
            catch (SQLException sQLException) {
                this.logToErrorFile("ERROR :", this.entity + " SQL Error in computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, sQLException.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + sQLException.toString());
                sQLException.printStackTrace();
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block30;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", this.entity + " computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + exception.toString());
                exception.printStackTrace();
                {
                    catch (Throwable throwable) {
                        try {
                            this.closeRs((ResultSet)object);
                            this.closeSt(statement);
                            this.closeConn((Connection)object2);
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    this.closeRs((ResultSet)object);
                    this.closeSt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("none")) {
            d = 0.0;
        } else {
            try {
                string = string.trim();
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = 0.0;
            }
        }
        return d;
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double roundDouble(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        String string = this.df.format(bigDecimal);
        return Double.parseDouble(string);
    }

    public static void main(String[] stringArray) {
        HanaHostMemTest hanaHostMemTest = new HanaHostMemTest(stringArray);
        hanaHostMemTest.computeMeasures(new Hashtable());
    }
}

