/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import com.egurkha.util.EgUtilities;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HanaXsValidator
extends EgServerValidator {
    private SapControlBase sapControlBase = null;
    private String sys_OS = "";
    private SapWasGenericTest sapWasGenericTest = null;
    private String path = "";
    private String searchPattern = "";
    private String serverIDs = "";
    private boolean isWSDLPortFailed = false;
    private boolean isWSDLorCWSDLPortFailed = false;
    private boolean isFaultCode = false;
    private boolean isSSL = false;
    private boolean isInstanceBased = true;
    private boolean sslFlag = false;
    private boolean isFromManager = false;
    private String wsdlUrl = "";
    private Hashtable validationErrorMap = new Hashtable();
    private ArrayList validationMsgs = null;
    private String[] params = null;
    private boolean isHanaXs = false;
    private boolean isDevRout = false;
    private boolean isSapDirParam = false;
    private boolean isSapRoutDir = false;
    private boolean isSearchPattern = false;
    String host = "";
    String osuser = "";
    String ospassword = "";
    String cliuser = "";
    String clipassword = "";
    String organization_name = "";
    String space_name = "";
    String timeout = "";
    String cliExecType = "";
    String cliEndPoint = "";
    String strSSHPort = "";
    String xs_path = "";
    String privateKeyFile = "";
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private final SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private long timeOut = 60L;
    int sshPortNo = 22;
    private EgUtilities egUtilities = EgUtilities.createInstance();
    ArrayList arrSpaceList = new ArrayList();

    public HanaXsValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        this.sys_OS = System.getProperty("os.name").toUpperCase();
        if (stringArray != null && stringArray.length > 0) {
            String string;
            this.params = new String[stringArray.length * 2];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-organization")) {
                    this.organization_name = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-spaces")) {
                    this.space_name = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-xs_path")) {
                    this.xs_path = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-cli_location")) {
                    if (string3 != null && string3.length() > 0 && string3.equals("false")) {
                        this.cliExecType = "local";
                    } else if (string3 != null && string3.length() > 0 && string3.equals("true")) {
                        this.cliExecType = "remote";
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-cli_user")) {
                    this.cliuser = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-cli_password")) {
                    this.clipassword = EgCrypt.decrypt(string3);
                    if (this.clipassword != null && this.clipassword.length() > 0 && this.clipassword.endsWith("~EG~")) {
                        this.clipassword = this.clipassword.substring(0, this.clipassword.indexOf("~EG~"));
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-cli_endpoint")) {
                    this.cliEndPoint = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-aluser") && string3 != null && !string3.equalsIgnoreCase("none") && !string3.equalsIgnoreCase("null")) {
                    this.osuser = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-alkeyfile") && string3 != null && !string3.equalsIgnoreCase("none") && !string3.equalsIgnoreCase("null")) {
                    this.privateKeyFile = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-alpassword") && string3 != null && !string3.equalsIgnoreCase("none") && !string3.equalsIgnoreCase("null")) {
                    this.ospassword = EgCrypt.decrypt(string3);
                    if (this.ospassword != null && this.ospassword.length() > 0 && this.ospassword.endsWith("~EG~")) {
                        this.ospassword = this.ospassword.substring(0, this.ospassword.indexOf("~EG~"));
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-sshPort")) {
                    this.sshPortNo = Integer.parseInt(string3);
                } else {
                    this.params[n] = string2;
                    this.params[++n] = string3;
                }
                this.validationMsgs = new ArrayList();
                ++n;
            }
            if (this.privateKeyFile != null && this.privateKeyFile.length() > 0 && (this.privateKeyFile.equalsIgnoreCase("none") || this.privateKeyFile.equalsIgnoreCase("null"))) {
                this.privateKeyFile = "";
            }
            this.printOut("host:" + this.host);
            this.printOut("xs_path:" + this.xs_path);
            this.printOut("organization_name:" + this.organization_name);
            this.printOut("space_name:" + this.space_name);
            this.printOut("cli_location:" + this.cliExecType);
            this.printOut("cliuser:" + this.cliuser);
            this.printOut("cliEndPoint:" + this.cliEndPoint);
            this.printOut("osuser:" + this.osuser);
            this.printOut("sshPortNo:" + this.sshPortNo);
            this.printOut("privateKeyFile:" + this.privateKeyFile);
            if (this.space_name != null && this.space_name.trim().length() > 0 && !this.space_name.equalsIgnoreCase("null") && !this.space_name.equalsIgnoreCase("none")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.space_name, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string == null || this.arrSpaceList.equals("")) continue;
                    this.arrSpaceList.add(string);
                }
            }
            this.printOut("space_name arrSpaceList:" + this.arrSpaceList);
        }
        this.validate();
        this.isFromManager = bl;
    }

    public void printOut(String string) {
        System.out.println(" >> HanaXsValidator: [ " + this.mySDF.format(new Date()) + " ] : >> " + string);
    }

    public void validate() {
        try {
            if (!this.checkHanaXsValidator()) {
                this.printOut("validationErrorMap:" + this.validationErrorMap);
                String string = (String)this.validationErrorMap.get("HanaXs_Connectivity");
                if (string != null && string.contains("Bad credentials")) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Organization$#$OK");
                    this.validationMsgs.add("Spaces$#$OK");
                    this.validationMsgs.add("XS_Path$#$OK");
                    this.validationMsgs.add("CLI User/Password$#$Failed");
                    this.validationMsgs.add("CLI Endpoint$#$OK");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$OK");
                        this.validationMsgs.add("SSH Port No$#$OK");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$" + string);
                } else if (string != null && string.contains("Org") && string.contains("does not exist")) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Organization$#$Failed");
                    this.validationMsgs.add("Spaces$#$NA");
                    this.validationMsgs.add("XS_Path$#$OK");
                    this.validationMsgs.add("CLI User/Password$#$NA");
                    this.validationMsgs.add("CLI Endpoint$#$OK");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$OK");
                        this.validationMsgs.add("SSH Port No$#$OK");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$" + string);
                } else if (string != null && string.contains("Space") && string.contains("does not exist")) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Organization$#$OK");
                    this.validationMsgs.add("Spaces$#$Failed");
                    this.validationMsgs.add("XS_Path$#$OK");
                    this.validationMsgs.add("CLI User/Password$#$NA");
                    this.validationMsgs.add("CLI Endpoint$#$OK");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$OK");
                        this.validationMsgs.add("SSH Port No$#$OK");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$" + string);
                } else if (string != null && string.contains("Authentication fail")) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Organization$#$NA");
                    this.validationMsgs.add("Spaces$#$NA");
                    this.validationMsgs.add("XS_Path$#$NA");
                    this.validationMsgs.add("CLI User/Password$#$NA");
                    this.validationMsgs.add("CLI Endpoint$#$NA");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$Failed");
                        this.validationMsgs.add("SSH Port No$#$NA");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$" + string);
                } else if (string != null && string.contains("Connection timed out")) {
                    this.validationMsgs.add("Host IP/Name$#$Failed");
                    this.validationMsgs.add("Organization$#$NA");
                    this.validationMsgs.add("Spaces$#$NA");
                    this.validationMsgs.add("XS_Path$#$NA");
                    this.validationMsgs.add("CLI User/Password$#$NA");
                    this.validationMsgs.add("CLI Endpoint$#$NA");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$NA");
                        this.validationMsgs.add("SSH Port No$#$Failed");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$" + string);
                } else if (string != null && string.contains("Login Command Execution Failed")) {
                    this.validationMsgs.add("Host IP/Name$#$Failed");
                    this.validationMsgs.add("Organization$#$NA");
                    this.validationMsgs.add("Spaces$#$NA");
                    this.validationMsgs.add("XS_Path$#$NA");
                    this.validationMsgs.add("CLI User/Password$#$NA");
                    this.validationMsgs.add("CLI Endpoint$#$NA");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$NA");
                        this.validationMsgs.add("SSH Port No$#$NA");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$Could not execute the command, Please verify the network");
                } else if (string != null && string.contains("Could not connect to controller on http")) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Organization$#$NA");
                    this.validationMsgs.add("Spaces$#$NA");
                    this.validationMsgs.add("XS_Path$#$OK");
                    this.validationMsgs.add("CLI User/Password$#$NA");
                    this.validationMsgs.add("CLI Endpoint$#$Failed");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$OK");
                        this.validationMsgs.add("SSH Port No$#$OK");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$" + string);
                } else if (string != null && string.contains("No such file or directory")) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Organization$#$NA");
                    this.validationMsgs.add("Spaces$#$NA");
                    this.validationMsgs.add("XS_Path$#$Failed");
                    this.validationMsgs.add("CLI User/Password$#$NA");
                    this.validationMsgs.add("CLI Endpoint$#$NA");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$OK");
                        this.validationMsgs.add("SSH Port No$#$OK");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$" + string);
                } else {
                    this.validationMsgs.add("Host IP/Name$#$Failed");
                    this.validationMsgs.add("Organization$#$NA");
                    this.validationMsgs.add("Spaces$#$NA");
                    this.validationMsgs.add("XS_Path$#$NA");
                    this.validationMsgs.add("CLI User/Password$#$NA");
                    this.validationMsgs.add("CLI Endpoint$#$NA");
                    if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                        this.validationMsgs.add("OS User/password$#$NA");
                        this.validationMsgs.add("SSH Port No$#$NA");
                    }
                    this.validationMsgs.add("Hana Xs Connectivity$#$Could not execute the command, Please verify the network");
                }
            } else {
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Organization$#$OK");
                this.validationMsgs.add("Spaces$#$OK");
                this.validationMsgs.add("XS_Path$#$OK");
                this.validationMsgs.add("CLI User/Password$#$OK");
                this.validationMsgs.add("CLI Endpoint$#$OK");
                if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                    this.validationMsgs.add("OS User/password$#$OK");
                    this.validationMsgs.add("SSH Port No$#$OK");
                }
                this.validationMsgs.add("Hana Xs Connectivity$#$OK");
            }
            if (!this.isFromManager) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean executeLoginCommand(String string) {
        try {
            String string2 = this.xs_path + "xs login -a " + this.cliEndPoint + " -u " + this.cliuser + " -p " + this.clipassword + " -o " + this.organization_name + " -s " + string + " --skip-ssl-validation;" + this.xs_path + "xs logout";
            ArrayList arrayList = null;
            if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("local")) {
                arrayList = this.getLocalExec(string2);
                this.printOut("executeLoginCommand local aList:" + arrayList);
            } else if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                arrayList = this.cmdExecToHanaXSCli("ssh", this.host, this.sshPortNo, this.osuser, this.ospassword, string2);
                this.printOut("executeLoginCommand Remote aList:" + arrayList);
            }
            ArrayList arrayList2 = arrayList;
            String string3 = "";
            String string4 = "";
            boolean bl = false;
            if (arrayList2 != null && arrayList2.size() > 0) {
                String string5 = "";
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string6 = (String)arrayList2.get(i);
                    if (string6 == null || string6 != null && string6.trim().equals("")) continue;
                    if (string6.contains("API endpoint:")) {
                        bl = true;
                        string4 = "login successful";
                        this.printOut("login successful");
                    }
                    if (string6.contains("Authenticating...")) {
                        string3 = string6;
                        continue;
                    }
                    if (string6.contains("Logging out...")) {
                        string5 = string6;
                    }
                    if (string6.contains("OK") && string5.contains("Logging out...")) {
                        this.printOut("logout successful");
                        break;
                    }
                    if (string3.equalsIgnoreCase("Authenticating...") && !string6.contains("ORG:") && !string6.contains("SPACE:")) {
                        string3 = "";
                        this.printOut("strVal:" + string6);
                        string4 = string6;
                    }
                    if (!string3.equalsIgnoreCase("API_URL:") || string6.contains("FAILED:") || string6.contains("FAILED:")) continue;
                    this.printOut("strVal FAILED:" + string6);
                    string4 = string4 == null || string4.length() == 0 ? string6 : string4 + " " + string6;
                }
                if (bl) {
                    return true;
                }
                this.printOut("login failed:" + string4);
                if (this.validationErrorMap != null && this.validationErrorMap.get("HanaXs_Exe_Failed") != null) {
                    String string7 = (String)this.validationErrorMap.get("HanaXs_Exe_Failed");
                    if (string7.equalsIgnoreCase("java.io.IOException: Authentication failed.")) {
                        this.validationErrorMap.put("HanaXs_Connectivity", "Authentication fail");
                    } else if (string7.equalsIgnoreCase("com.jcraft.jsch.JSchException: java.net.ConnectException: Connection timed out: connect")) {
                        this.validationErrorMap.put("HanaXs_Connectivity", "Connection timed out");
                    } else {
                        this.validationErrorMap.put("HanaXs_Connectivity", string7);
                    }
                    this.printOut("validationErrorMap: " + this.validationErrorMap);
                } else {
                    this.validationErrorMap.put("HanaXs_Connectivity", string4);
                }
                return false;
            }
            if (this.validationErrorMap != null && this.validationErrorMap.get("HanaXs_Exe_Failed") != null) {
                String string8 = (String)this.validationErrorMap.get("HanaXs_Exe_Failed");
                if (string8.equalsIgnoreCase("java.io.IOException: Authentication failed.")) {
                    this.validationErrorMap.put("HanaXs_Connectivity", "Authentication fail");
                } else if (string8.equalsIgnoreCase("com.jcraft.jsch.JSchException: java.net.ConnectException: Connection timed out: connect")) {
                    this.validationErrorMap.put("HanaXs_Connectivity", "Connection timed out");
                } else {
                    this.validationErrorMap.put("HanaXs_Connectivity", string8);
                }
            } else {
                this.validationErrorMap.put("HanaXs_Connectivity", "Login Command Execution Failed");
            }
            this.printOut("else validationErrorMap: " + this.validationErrorMap);
        }
        catch (Exception exception) {
            String string9;
            String string10 = "";
            this.printOut("Error executeLoginCommand : " + exception.getMessage());
            string10 = string9 = this.getStackTraceAsString(exception);
            this.validationErrorMap.put("HanaXs_Connectivity", string10);
            return false;
        }
        this.printOut("login failed");
        return false;
    }

    public boolean executeLogoutCommand() {
        Object var1_1 = null;
        try {
            String string = this.xs_path + "xs logout";
            ArrayList arrayList = null;
            if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("local")) {
                arrayList = this.getLocalExec(string);
                this.printOut("executeLogoutCommand Local aList:" + arrayList);
            } else if (this.cliExecType != null && this.cliExecType.length() > 0 && this.cliExecType.equalsIgnoreCase("remote")) {
                arrayList = this.cmdExecToHanaXSCli("ssh", this.host, this.sshPortNo, this.osuser, this.ospassword, string);
                this.printOut("executeLogoutCommand Remote aList:" + arrayList);
            }
            ArrayList arrayList2 = arrayList;
            if (arrayList2 != null && arrayList2.size() > 0) {
                String string2 = "";
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string3 = (String)arrayList2.get(i);
                    if (string3 == null || string3 != null && string3.trim().equals("")) continue;
                    if (string3.contains("Logging out...")) {
                        string2 = string3;
                    }
                    if (!string3.contains("OK") || !string2.contains("Logging out...")) continue;
                    this.printOut("logout successful");
                    return true;
                }
            }
        }
        catch (Exception exception) {
            this.printOut("Error executeLogoutCommand : " + exception.getMessage());
            return false;
        }
        this.printOut("logout failed");
        return false;
    }

    ArrayList covertArrayofArrListToArrayList(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList arrayList3 = (ArrayList)arrayList.get(0);
            ArrayList arrayList4 = (ArrayList)arrayList.get(1);
            this.printOut("al_StatusCont:" + arrayList3);
            this.printOut("al_errMsg:" + arrayList4);
            arrayList2 = arrayList3;
        }
        return arrayList2;
    }

    String[] converttoStringArray(String string) {
        String[] stringArray = new String[]{"sh", "-c", string};
        this.printOut("strArray :" + stringArray[2]);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList getLocalExec(String string) {
        ArrayList arrayList = null;
        String[] stringArray = this.converttoStringArray(string);
        String string2 = "SAP";
        synchronized ("SAP") {
            arrayList = this.egUtilities.getExecOutputLines(stringArray);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            arrayList = this.covertArrayofArrListToArrayList(arrayList);
            return arrayList;
        }
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList cmdExecToHanaXSCli(String string, String string2, int n, String string3, String string4, String string5) {
        long l = System.currentTimeMillis();
        String string6 = "cmdExecToHanaXSCli";
        string6 = this.methodNameTemplate(string6);
        String string7 = string6 + "Command \"" + string5 + "\"  execution starts for the Host :" + string2 + " , Port :" + n + " with User :" + string3;
        this.printOut(string7);
        string7 = "";
        ArrayList arrayList = null;
        try {
            if (string.equalsIgnoreCase("ssh")) {
                EgJavaSSH egJavaSSH = null;
                ArrayList arrayList2 = null;
                Object object = "SAP";
                synchronized ("SAP") {
                    if (this.privateKeyFile != null && this.privateKeyFile.length() > 0) {
                        egJavaSSH = new EgJavaSSH(string2, n, string3, string4, "keybased", this.privateKeyFile, this.timeOut);
                        arrayList2 = egJavaSSH.executeCommand(string5);
                    } else {
                        egJavaSSH = new EgJavaSSH(string2, n, string3, string4, this.timeOut);
                        arrayList2 = egJavaSSH.executeCommandWithHighSecure(string5);
                    }
                    // ** MonitorExit[var14_15] (shouldn't be in output)
                    object = new ArrayList();
                    if (arrayList2 != null) {
                        arrayList = (ArrayList)arrayList2.get(0);
                        object = (ArrayList)arrayList2.get(1);
                        String string8 = "";
                        if (object != null && ((ArrayList)object).size() > 0) {
                            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                                String string9 = (String)((ArrayList)object).get(i);
                                string8 = string8.equals("") ? string9 : string8 + " " + string9;
                            }
                            this.validationErrorMap.put("HanaXs_Exe_Failed", string8);
                            string7 = string6 + "errorArrayList value greator than zero, so printing Error Message :" + string8 + ",And All output :" + arrayList;
                            this.printOut(string7);
                            string7 = "";
                        }
                    }
                }
            } else if (string.equalsIgnoreCase("rexec")) {
                arrayList = EgRexecUtil.getExecResults(string2, n, string3, string4, string5);
            }
            {
                if (arrayList == null) {
                    string7 = string6 + "Could not execute the command, Please verify the username/password or network ";
                    this.printOut(string7);
                    string7 = "";
                    return null;
                }
                if (arrayList.size() == 0) {
                    string7 = string6 + " ArrayList size is  less than zero   " + string5 + " for " + string2;
                    this.printOut(string7);
                    return null;
                }
            }
        }
        catch (Exception exception) {
            string7 = string6 + "Problem while executing the command " + string5 + " for " + string2 + ",exception:" + exception.toString();
            this.printOut(string7);
            arrayList = null;
        }
        {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            string7 = string6 + "Command \"" + string5 + "\"  execution ends for the Host :" + string2 + " , Port :" + n + " with User :" + string3;
            this.printOut(string7);
            string7 = "";
            string7 = string6 + " Total time(millis) took to execute " + l3 + "  for the command  " + string5;
            return arrayList;
        }
    }

    protected String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string2.length();
        int n2 = string.length();
        while ((n2 = string.lastIndexOf(string2, n2 - 1)) > -1) {
            stringBuffer.replace(n2, n2 + n, string3);
        }
        return stringBuffer.toString();
    }

    public boolean checkHanaXsValidator() {
        try {
            for (int i = 0; i < this.arrSpaceList.size(); ++i) {
                String string = (String)this.arrSpaceList.get(i);
                boolean bl = false;
                if (this.executeLoginCommand(string)) {
                    bl = true;
                }
                if (bl && this.arrSpaceList.size() - 1 == i) {
                    return true;
                }
                if (bl && this.arrSpaceList.size() - 1 > i) continue;
                return false;
            }
        }
        catch (Exception exception) {
            String string;
            String string2 = "";
            string2 = string = this.getStackTraceAsString(exception);
            this.validationErrorMap.put("HanaXs_Connectivity", string2);
            return false;
        }
        return false;
    }

    public ArrayList getValidationMsgs() {
        System.out.println("validationMsgs : " + this.validationMsgs);
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        try {
            HanaXsValidator hanaXsValidator = new HanaXsValidator(stringArray, new Boolean(false));
            hanaXsValidator.getValidationMsgs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

